#ifndef AXATTRIBUTECONSTANTS_H
#define AXATTRIBUTECONSTANTS_H

/*kAXSizeAttribute

#define kAXSizeAttribute CFSTR(
    "AXSize") 
Discussion 

The vertical and horizontal dimensions of the element. 

Required for all elements that are visible on the screen, which is virtually all elements. 

Writable: 

Generally no. However, some elements that can be resized by the user through direct manipulation (like windows) should offer a writable size attribute.

Value: 

An AXValueRef with type kAXValueCGSizeType. Units are pixels.*/
#define kAXSizeAttribute CFSTR( "AXSize") 


/*kAXPositionAttribute

#define kAXPositionAttribute CFSTR(
    "AXPosition") 
Discussion 

The global screen position of the top-left corner of an element. 

Required for all elements that are visible on the screen, which is virtually all elements. 

Writable: 

Generally no. However, some elements that can be moved by the user through direct manipulation (like windows) should offer a writable position attribute.

Value: 

An AXValueRef with type kAXValueCGPointType. 0,0 is the top-left corner of the screen that displays the menu bar. The value of the horizontal axis increases to the right. The value of the vertical axis increases downward. Units are pixels.*/

#define kAXPositionAttribute CFSTR( "AXPosition") 

/*kAXParentAttribute

#define kAXParentAttribute CFSTR(
    "AXParent") 
Discussion 

Indicates the element's container element in the visual element hierarchy. A push button's kAXParentElement might be a window element or a group. A sheet's kAXParentElement will be a window element. A window's kAXParentElement will be the application element. A menu item's kAXParentElement will be a menu element. 

Required for every element except the application. Everything else in the visual element hierarchy must have a parent. 

Writable: 

No

Value: 

An AXUIElementRef*/
#define kAXParentAttribute CFSTR("AXParent") 

/*kAXRoleAttribute


Identifies the basic type of an element.
#define kAXRoleAttribute CFSTR(
    "AXRole") 
Discussion 

Required for all elements. Even in the worst case scenario where an element cannot figure out what its basic type is, it can still supply the value kAXUnknownRole. 

Writable: 

No 


Value: 

A CFStringRef of one of the role strings defined in this header, or a new role string of your own invention. The string should not be localized, and it does not need to be human-readable. Instead of inventing new role strings, see if a custom element can be identified by an existing role string and a new subrole. See kAXSubroleAttribute. 


Carbon Accessorization Notes: 

If your HIObjectClass or Carbon Event handler provides the kAXRoleAttribute, it must also provide the kAXRoleDescriptionAttribute.*/
#define kAXRoleAttribute CFSTR( \
    "AXRole") 

/*kAXTitleAttribute

#define kAXTitleAttribute CFSTR(
    "AXTitle") 
Discussion 

The localized, human-readable string that is displayed as part of the element's normal visual interface. For example, an OK button's kAXTitleElement is the string "OK", and a menu item's kAXTitleElement is the text of the menu item. 

Required if the element draws a string as part of its normal visual interface. 

Writable: 

No 


Value: 

A localized, human-readable CFStringRef*/
#define kAXTitleAttribute CFSTR(    "AXTitle") 

/*Attributes

Define the attributes available for accessibility objects. 

//General attributes 
#define kAXRoleAttribute                    CFSTR("AXRole")
#define kAXSubroleAttribute                 CFSTR("AXSubrole")
#define kAXRoleDescriptionAttribute         CFSTR("AXRoleDescription")
#define kAXHelpAttribute                    CFSTR("AXHelp")
#define kAXTitleAttribute                   CFSTR("AXTitle")
#define kAXValueAttribute                   CFSTR("AXValue")
#define kAXMinValueAttribute                CFSTR("AXMinValue")
#define kAXMaxValueAttribute                CFSTR("AXMaxValue")
#define kAXValueIncrementAttribute          CFSTR("AXValueIncrement")
#define kAXAllowedValuesAttribute           CFSTR("AXAllowedValues")
#define kAXEnabledAttribute                 CFSTR("AXEnabled")
#define kAXFocusedAttribute                 CFSTR("AXFocused")
#define kAXParentAttribute                  CFSTR("AXParent")
#define kAXChildrenAttribute                CFSTR("AXChildren")
#define kAXSelectedChildrenAttribute        CFSTR("AXSelectedChildren")
#define kAXVisibleChildrenAttribute         CFSTR("AXVisibleChildren")
#define kAXWindowAttribute                  CFSTR("AXWindow")
#define kAXTopLevelUIElementAttribute       CFSTR("AXTopLevelUIElement")
#define kAXPositionAttribute                CFSTR("AXPosition")
#define kAXSizeAttribute                    CFSTR("AXSize")
#define kAXOrientationAttribute             CFSTR("AXOrientation")
#define kAXDescriptionAttribute             CFSTR("AXDescription")
   
// Text-specific attributes 
#define kAXSelectedTextAttribute            CFSTR("AXSelectedText")
#define kAXVisibleCharacterRangeAttribute CFSTR("AXVisibleCharacterRange")
#define kAXSelectedTextRangeAttribute       CFSTR("AXSelectedTextRange")
#define kAXNumberOfCharactersAttribute      CFSTR("AXNumberOfCharacters")
#define kAXSharedTextUIElementsAttribute    CFSTR("AXSharedTextUIElements")
#define kAXSharedCharacterRangeAttribute    CFSTR("AXSharedCharacterRange")
   
// Window-specific attributes 
#define kAXMainAttribute                    CFSTR("AXMain")
#define kAXMinimizedAttribute               CFSTR("AXMinimized")
#define kAXCloseButtonAttribute             CFSTR("AXCloseButton")
#define kAXZoomButtonAttribute              CFSTR("AXZoomButton")
#define kAXMinimizeButtonAttribute          CFSTR("AXMinimizeButton")
#define kAXToolbarButtonAttribute           CFSTR("AXToolbarButton")
#define kAXGrowAreaAttribute                CFSTR("AXGrowArea")
#define kAXProxyAttribute                   CFSTR("AXProxy")
#define kAXModalAttribute                   CFSTR("AXModal")
#define kAXDefaultButtonAttribute           CFSTR("AXDefaultButton")
#define kAXCancelButtonAttribute            CFSTR("AXCancelButton")
   
// Menu-specific attributes 
#define kAXMenuItemCmdCharAttribute         CFSTR("AXMenuItemCmdChar")
#define kAXMenuItemCmdVirtualKeyAttribute
   CFSTR("AXMenuItemCmdVirtualKey")
#define kAXMenuItemCmdGlyphAttribute        CFSTR("AXMenuItemCmdGlyph")
#define kAXMenuItemCmdModifiersAttribute
   CFSTR("AXMenuItemCmdModifiers")
#define kAXMenuItemMarkCharAttribute    CFSTR("AXMenuItemMarkChar")
#define kAXMenuItemPrimaryUIElementAttribute CFSTR("AXMenuItemPrimaryUIElement")
   
// Application-specific attributes
 #define kAXMenuBarAttribute                     CFSTR("AXMenuBar")
#define kAXWindowsAttribute                     CFSTR("AXWindows")
#define kAXFrontmostAttribute                   CFSTR("AXFrontmost")
#define kAXHiddenAttribute                      CFSTR("AXHidden")
#define kAXMainWindowAttribute                  CFSTR("AXMainWindow")
#define kAXFocusedWindowAttribute               CFSTR("AXFocusedWindow")
#define kAXFocusedUIElementAttribute        CFSTR("AXFocusedUIElement")
   
// Miscellaneous attributes 
#define kAXHeaderAttribute                  CFSTR("AXHeader")
#define kAXEditedAttribute                  CFSTR("AXEdited")
#define kAXValueWrapsAttribute              CFSTR("AXValueWraps")
#define kAXTabsAttribute                    CFSTR("AXTabs")
#define kAXTitleUIElementAttribute          CFSTR("AXTitleUIElement")
#define kAXHorizontalScrollBarAttribute     CFSTR("AXHorizontalScrollBar")
#define kAXVerticalScrollBarAttribute       CFSTR("AXVerticalScrollBar")
#define kAXOverflowButtonAttribute          CFSTR("AXOverflowButton")
#define kAXFilenameAttribute                CFSTR("AXFilename")
#define kAXExpandedAttribute                CFSTR("AXExpanded")
#define kAXSelectedAttribute                CFSTR("AXSelected")
#define kAXSplittersAttribute               CFSTR("AXSplitters")
#define kAXNextContentsAttribute            CFSTR("AXNextContents")
#define kAXDocumentAttribute                CFSTR("AXDocument")
#define kAXDecrementButtonAttribute         CFSTR("AXDecrementButton")
#define kAXIncrementButtonAttribute         CFSTR("AXIncrementButton")
#define kAXPreviousContentsAttribute        CFSTR("AXPreviousContents")
#define kAXContentsAttribute                CFSTR("AXContents")
#define kAXIncrementorAttribute             CFSTR("AXIncrementor")
#define kAXHourFieldAttribute               CFSTR("AXHourField")
#define kAXMinuteFieldAttribute             CFSTR("AXMinuteField")
#define kAXSecondFieldAttribute             CFSTR("AXSecondField")
#define kAXAMPMFieldAttribute               CFSTR("AXAMPMField")
#define kAXDayFieldAttribute                CFSTR("AXDayField")
#define kAXMonthFieldAttribute              CFSTR("AXMonthField")
#define kAXYearFieldAttribute               CFSTR("AXYearField")
#define kAXColumnTitleAttribute             CFSTR("AXColumnTitles")
#define kAXURLAttribute                     CFSTR("AXURL")
#define kAXLabelUIElementsAttribute         CFSTR("AXLabelUIElements")
#define kAXLabelValueAttribute              CFSTR("AXLabelValue")
#define kAXShownMenuUIElementAttribute      CFSTR("AXShownMenuUIElement")
#define kAXServesAsTitleForUIElementsAttribute           CFSTR("AXServesAsTitleForUIElements")
#define kAXLinkedUIElementsAttribute CFSTR("AXLinkedUIElements")
   
// Table and outline view attributes 
#define kAXRowsAttribute                    CFSTR("AXRows")
#define kAXVisibleRowsAttribute             CFSTR("AXVisibleRows")
#define kAXSelectedRowsAttribute            CFSTR("AXSelectedRows")
#define kAXColumnsAttribute                 CFSTR("AXColumns")
#define kAXVisibleColumnsAttribute          CFSTR("AXVisibleColumns")
#define kAXSelectedColumnsAttribute         CFSTR("AXSelectedColumns")
#define kAXSortDirectionAttribute           CFSTR("AXSortDirection")
#define kAXColumnHeaderUIElementsAttribute CFSTR("AXColumnHeaderUIElements")
#define kAXIndexAttribute                   CFSTR("AXIndex")
#define kAXDisclosingAttribute              CFSTR("AXDisclosing")
#define kAXDisclosedRowsAttribute           CFSTR("AXDisclosedRows")
#define kAXDisclosedByRowAttribute          CFSTR("AXDisclosedByRow")
   
// Matte attributes 
#define kAXMatteHoleAttribute               CFSTR("AXMatteHole")
#define kAXMatteContentUIElementAttribute CFSTR("AXMatteContentUIElement")
   
   
// Dock attributes 
#define kAXIsApplicationRunningAttribute CFSTR("AXIsApplicationRunning")
   
// System-wide attributes 
#define kAXFocusedApplicationAttribute      CFSTR("AXFocusedApplication")
Constants
kAXRoleAttribute

The role, or type, of this accessibility object (for example, AXButton). This string is for identification purposes only and does not need to be localized. All accessibility objects must include this attribute.
kAXSubroleAttribute

The subrole of this accessibility object (for example, AXCloseButton). The subrole provides additional information about the accessibility object to an assistive application. This string is for identification purposes only and does not need to be localized. This attribute is necessary only for an accessibility object whose AXRole attribute does not adequately describe its meaning.

Available in Mac OS X v10.2 and later.
kAXRoleDescriptionAttribute

A localized string describing the role (for example, “button”). This string must be readable by (or speakable to) the user. All accessibility objects must include this attribute. To get the system-defined role description string for a given role, use the HICopyAccessibilityRoleDescription function.
kAXHelpAttribute

A localized string containing help text for this accessibility object. An accessibility object that provides help information should include this attribute.
kAXTitleAttribute

The title associated with this accessibility object. A title is text that the object displays as part of its visual interface, such as the text “OK” on an OK button. This string must be localizable and human-intelligible. This attribute is required for all accessibility objects that display a string in their visual interfaces.
kAXValueAttribute

The value associated with this accessibility object (for example, a scroller value). The value of an accessibility object is user-modifiable and represents the setting of the associated user interface element, such as the contents of an editable text field or the position of a scroller. This attribute is required if an accessibility object’s value state conveys information to the user or if the user can define the value of the object.
kAXMinValueAttribute

The minimum value this accessibility object can display (for example, the minimum value of a scroller control). This attribute is used only in conjunction with the AXValue attribute. 
kAXMaxValueAttribute

The maximum value this accessibility object can display (for example, the maximum value of a scroller control). This attribute is used only in conjunction with the AXValue attribute.
kAXValueIncrementAttribute

The amount an accessibility object’s value changes as the result of a single action (for example, how far a scroller travels with one mouse click). This attribute is used only in conjunction with the AXValue attribute.
kAXAllowedValuesAttribute

An array of the allowed values for an accessibility object. This attribute indicates the subset of values to which an accessibility object can be set. For example, a slider control displays a large range of values, but the accessibility object representing the slider can be set to only a few specific values within that range. This attribute is used only in conjunction with the AXValue attribute.

Available in Mac OS X v10.4 and later.
kAXEnabledAttribute

Indicates whether the user can interact with the accessibility object. For example, the AXEnabled attribute of a disabled button is false. This attribute is required for accessibility objects that represent views, menus, and menu items. This attribute is not required for accessibility objects that represent windows.
kAXFocusedAttribute

Indicates whether the accessibility object currently has the keyboard focus. Note that you can set the value of the AXFocused attribute to true to accept keyboard focus. This attribute is required for all accessibility objects representing elements that can receive keyboard focus.
kAXParentAttribute

This accessibility object’s parent object in the accessibility hierarchy. This attribute is required for all accessibility objects except the application-level accessibility object.
kAXChildrenAttribute

An array of the first-order accessibility objects contained by this accessibility object. An accessibility object may be a member of only one AXChildren array. This attribute is required for all accessibility objects that contain accessible child objects.
kAXSelectedChildrenAttribute

An array of selected first-order accessibility objects contained by this accessibility object. For example, the selected subelements of a list view are contained in the AXSelectedChildren array of the list view’s accessibility object. The members of the AXSelectedChildren array are a subset of the members of this accessibility object’s AXChildren array. This attribute is required for accessibility objects that contain selectable child objects.
kAXVisibleChildrenAttribute

An array of first-order accessibility objects contained by this accessibility object that are visible to a sighted user. For example, a list view’s AXVisibleChildren array would contain the list’s subelements that are currently scrolled into view. The members of the AXVisibleChildren array are a subset of the members of this accessibility object’s AXChildren array. This attribute is recommended for accessibility objects whose child objects can be scrolled out of view or otherwise obscured.
kAXWindowAttribute

The window element that contains this accessibility object. An accessibility object that is contained in a window includes this attribute so an assistive application easily can find the window without having to step through all intervening objects in the accessibility hierarchy. Note that the value of the AXWindow attribute must be an accessibility object that represents a window, not a sheet or drawer. For a similar attribute that is less restrictive, see kAXTopLevelUIElementAttribute. The AXWindow attribute is required for all accessibility elements whose parent or more distant ancestor represents a window.
kAXPositionAttribute

The global screen coordinates of the top-left corner of this accessibility object. Note that the coordinates 0,0 represent the top-left corner of the screen that displays the menu bar. All accessibility objects that have a screen position (in other words, are visible on the screen) should include this attribute.
kAXTopLevelUIElementAttribute

The window, sheet, or drawer element that contains this accessibility object. An accessibility object that is contained in a window, sheet, or drawer includes this attribute so an assistive application easily can find that element without having to step through all intervening objects in the accessibility hierarchy. This attribute is required for all accessibility objects whose parent or more distant ancestor represents a window, drawer, or sheet.

Available in Mac OS X v10.4 and later.
kAXSizeAttribute

The vertical and horizontal dimensions of this accessibility object. This attribute is required for all accessibility objects that are visible on the screen.
kAXOrientationAttribute

Indicates whether this accessibility object is displayed or interacted with in a vertical or a horizontal manner. The interpretation of an element, such as a slider, can change depending on whether it is oriented vertically or horizontally. Using the value of this attribute, an assistive application can communicate this information to the user. This attribute is required for any accessibility object, such as a scroller or slider, whose semantic meaning varies with the object’s orientation.
kAXDescriptionAttribute

The purpose of this accessibility object. The description string must be localizable and human-intelligible and it must be all lower case and include no punctuation. The string should briefly describe this accessibility object’s purpose, without including the object’s role description. This attribute is required for all accessibility objects that do not provide enough descriptive information in the title attribute.

Available in Mac OS X v10.4 and later.
kAXSelectedTextAttribute

The currently selected text within this accessibility object. This attribute is required for all accessibility objects that represent editable text elements. 
kAXSelectedTextRangeAttribute

Indicates the range of characters (not bytes) that defines the currently selected text within this accessibility object. This attribute is required for all accessibility objects that represent editable text elements. 
kAXVisibleCharacterRangeAttribute

Indicates the range of characters (not bytes) that are scrolled into view within this accessibility object. This attribute is required only for accessibility objects that represent an editable text area (objects of role AXTextArea), not for any other text-related accessibility objects.

Available in Mac OS X v10.3 and later.
kAXNumberOfCharactersAttribute

The total number of characters (not bytes) in the editable text element represented by this accessibility object. This attribute is required for all accessibility objects that represent editable text elements. 

Available in Mac OS X v10.3 and later.
kAXSharedTextUIElementsAttribute

An array of accessibility objects with which the text of this accessibility object is shared. In a multi-column document, for example, each column may be represented by a separate accessibility object. However, the text in the document may flow from one column to the other. You get the value of this attribute if you need to know with which accessibility object this accessibility object shares its text. This attribute is recommended for sets of accessibility objects that share text in a single window. (See kAXSharedCharacterRange for a related attribute.)

Available in Mac OS X v10.4 and later.
kAXSharedCharacterRangeAttribute

The portion of shared text this accessibility object currently displays. In a multi-column document, for example, each column may be represented by a separate accessibility object. However, the text in the document may flow from one column to the other. Get the value of this attribute if you need to know the specific range of characters this accessibility object currently displays. This attribute is recommended for sets of accessibility objects that share text in a single window. (See kAXSharedTextUIElementsAttribute for a related attribute.)

Available in Mac OS X v10.4 and later.
kAXMainAttribute

Indicates whether the window represented by this accessibility object is the main application window. Note that a window can be main even though it does not have keyboard focus. This attribute is recommended for all accessibility objects that represent windows.
kAXMinimizedAttribute

Indicates whether the window represented by this accessibility object is currently minimized in the Dock. This attribute is recommended for all accessibility objects that represent windows that can be minimized.

Available in Mac OS X v10.2 and later.
kAXCloseButtonAttribute

The close button of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s close button, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a close button.

Available in Mac OS X v10.2 and later.
kAXZoomButtonAttribute

The zoom button of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s zoom button, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a zoom button.

Available in Mac OS X v10.2 and later.
kAXMinimizeButtonAttribute

The minimize button of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s minimize button, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a minimize button.

Available in Mac OS X v10.2 and later.
kAXToolbarButtonAttribute

The toolbar button of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s toolbar button, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a toolbar button.

Available in Mac OS X v10.2 and later.
kAXGrowAreaAttribute

The grow area of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s grow area, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a grow area.

Available in Mac OS X v10.2 and later.
kAXProxyAttribute

The document proxy of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s document proxy, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that display a document proxy.

Available in Mac OS X v10.2 and later.
kAXModalAttribute

Indicates whether the window represented by this accessibility object is modal. This attribute is recommended for all accessibility objects that represent windows.

Available in Mac OS X v10.3 and later.
kAXDefaultButtonAttribute

The default button of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s default button, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a default button.

Available in Mac OS X v10.3 and later.
kAXCancelButtonAttribute

The cancel button of the window represented by this accessibility object. An accessibility object includes this attribute to help an assistive application easily find a window’s cancel button, without having to traverse the accessibility hierarchy. This attribute is recommended for all accessibility objects that represent windows that contain a cancel button.

Available in Mac OS X v10.3 and later.
kAXMenuItemCmdCharAttribute

The primary key in the keyboard shortcut for the command represented by this accessibility object. For example, “O” is the primary key in the keyboard shortcut for the Open command.

Available in Mac OS X v10.2 and later.
kAXMenuItemCmdVirtualKeyAttribute

The key code associated with the physical key in the keyboard shortcut for the command represented by this accessibility object. For example, Return and Enter are different physical keys that can produce the same character. If an assistive application needs to be able to distinguish between them, it can view the virtual key codes.

Available in Mac OS X v10.2 and later.
kAXMenuItemCmdGlyphAttribute

The glyph displayed for a physical key in the keyboard shortcut for the command represented by this accessibility object, if it is different from the visible result of pressing the key. The Delete key, for example, produces an invisible character, but it is associated with a visible glyph.

Available in Mac OS X v10.2 and later.
kAXMenuItemCmdModifiersAttribute

An integer mask that represents the modifier keys held down in the keyboard shortcut for the command represented by this accessibility object.

Available in Mac OS X v10.2 and later.
kAXMenuItemMarkCharAttribute

The symbol displayed to the left of the menu item represented by this accessibility object. For example, in the Window menu, a checkmark appears next to the active document’s name. For more information on the standard symbols that can appear next to menu items, see Apple Human Interface Guidelines.

Available in Mac OS X v10.2 and later.
kAXMenuItemPrimaryUIElementAttribute

The accessibility object representing the primary menu item in a group of dynamic menu items. Dynamic menu item are commands that change when the user presses a modifier key, such as Minimize Window and Minimize All Windows. Within each group, each dynamic menu item’s accessibility object includes this attribute and in each case the attribute’s value is the accessibility object representing the primary menu item.

Available in Mac OS X v10.4 and later.
kAXMenuBarAttribute

The accessibility object representing the menu bar of this application. The application-level accessibility object includes this attribute to help an assistive application easily find the menu bar. This attribute is recommended for all application-level accessibility objects.
kAXWindowsAttribute

An array of accessibility objects representing this application’s windows. This attribute is recommended for all application-level accessibility objects.
kAXFrontmostAttribute

Indicates whether the application represented by this accessibility object is active. This attribute is recommended for all application-level accessibility objects.

Available in Mac OS X v10.2 and later.
kAXHiddenAttribute

Indicates whether the application represented by this accessibility object is hidden. This attribute is recommended for all application-level accessibility objects.
kAXMainWindowAttribute

The accessibility object representing this application’s main window. This attribute is recommended for all application-level accessibility objects.
kAXFocusedWindowAttribute

The accessibility object that represents the currently focused window of this application. This attribute is recommended for all application-level accessibility objects.

Available in Mac OS X v10.2 and later.
kAXFocusedUIElemenAttribute

The accessibility object that represents the currently focused user interface element in this application. This attribute is recommended for all application-level accessibility objects.
kAXHeaderAttribute

The accessibility object representing the header element of this accessibility object. For example, a table or an outline view can have a header element that displays column or row headers. An accessibility object includes this attribute to help an assistive application easily find embedded header information. This attribute is recommended for all accessibility objects that represent elements that display header information.

Available in Mac OS X v10.2 and later.
kAXEditedAttribute

Indicates whether the user interface element represented by this accessibility object has been edited. For example, a document window indicates it has been edited by displaying a black dot in its close button. This attribute is recommended for all accessibility objects that represent editable user interface elements.
kAXTitleUIElementAttribute

An accessibility object that represents a static text title associated with another accessibility object.
kAXValueWrapsAttribute

Indicates whether the value displayed in the user interface element represented by this accessibility object wraps around.
kAXTabsAttribute

An array of accessibility objects representing the tabs this accessibility object displays. An accessibility object includes this attribute to help an assistive application easily distinguish a tab view’s tabs from its other children. This attribute is recommended for all accessibility objects that represent tab views.
kAXHorizontalScrollBarAttribute

The horizontal scroll bar displayed by the user interface element this accessibility object represents. This is a convenience attribute an assistive application can use easily to find the scroll bar without traversing the accessibility hierarchy. This attribute is recommended for all accessibility objects that display a horizontal scroll bar.

Available in Mac OS X v10.2 and later.
kAXVerticalScrollBarAttribute

The vertical scroll bar displayed by the user interface element this accessibility object represents. This is a convenience attribute an assistive application can use easily to find the scroll bar without traversing the accessibility hierarchy. This attribute is recommended for all accessibility objects that display a vertical scroll bar.

Available in Mac OS X v10.2 and later.
kAXOverflowButtonAttribute

Identifies which child of an accessibility object representing a toolbar is the overflow button (if any). This attribute is optional.

Available in Mac OS X v10.2 and later.
kAXFilenameAttribute

The filename associated with this accessibility object. This attribute is optional.
kAXExpandedAttribute

Indicates whether the menu displayed by the combo box or pop-up menu represented by this accessibility object is currently expanded. This attribute is recommended for all accessibility objects that display a pop-up menu.
kAXSelectedAttribute

Indicates whether the row or column element represented by this accessibility object is selected. This attribute is recommended for all accessibility objects that represent selectable rows or columns.
kAXSplittersAttribute

An array of views and splitter bar elements displayed by the split view represented by this accessibility object. This is a convenience attribute that helps an assistive application easily find these elements.

Available in Mac OS X v10.2 and later.
kAXNextContentsAttribute

The group of accessibility objects representing the elements on one side of a splitter bar. (Which side of the splitter bar is considered “next” is determined by the value of the splitter bar’s orientation attribute.) This attribute is recommended for an accessibility object that represents the splitter bar in a split view.

Available in Mac OS X v10.2 and later.
kAXPreviousContentsAttribute

The group of accessibility objects representing the elements on one side of a splitter bar. (Which side of the splitter bar is considered “previous” is determined by the value of the splitter bar’s orientation attribute.) This attribute is recommended for an accessibility object that represents the splitter bar in a split view.

Available in Mac OS X v10.2 and later.
kAXDocumentAttribute

The URL of the open document represented by this accessibility object. This attribute represents the URL as a string object.

Available in Mac OS X v10.2 and later.
kAXIncrementButtonAttribute

The increment element associated with the user interface object this accessibility object represents. This attribute can be used to provide convenient access to the increment area of a custom user interface object. To refer to the increment button associated with a date or time field, see kAXIncrementorAttribute.

Available in Mac OS X v10.2 and later.
kAXDecrementButtonAttribute

The decrement element associated with the user interface object this accessibility object represents. This attribute can be used to provide convenient access to the decrement area of a custom user interface object.

Available in Mac OS X v10.2 and later.
kAXContentsAttribute

Content-containing accessibility objects that are children of this accessibility object. For example, a tab view contains children that represent both the tab controls and the content displayed for each tab. The accessibility object representing a tab view can include only the content-display children in its AXContents attribute to help an assistive application provide more targeted information to the user. This attribute is recommended for any accessibility object whose children represent both content and control elements.

Available in Mac OS X v10.2 and later.
kAXIncrementorAttribute

The incrementor of a time or date field represented by this accessibility object. This attribute is required for accessibility objects that represent time or date field elements that display an incrementor.

Available in Mac OS X v10.3 and later.
kAXHourFieldAttribute

The hour field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display hours.

Available in Mac OS X v10.3 and later.
kAXMinuteFieldAttribute

The minute field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display minutes.

Available in Mac OS X v10.3 and later.
kAXSecondFieldAttribute

The second field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display seconds.

Available in Mac OS X v10.3 and later.
kAXAMPMFieldAttribute

The AM/PM field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display AM/PM settings.

Available in Mac OS X v10.3 and later.
kAXDayFieldAttribute

The day field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display days.

Available in Mac OS X v10.3 and later.
kAXMonthFieldAttribute

The month field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display months.

Available in Mac OS X v10.3 and later.
kAXYearFieldAttribute

The year field of a time field represented by this accessibility object. This attribute is required for accessibility objects that represent time fields that display years.

Available in Mac OS X v10.3 and later.
kAXColumnTitleAttribute

The title of the column element represented by this accessibility object. Note that, because column titles are sometimes the children of a separate header element, the value of this attribute can refer to an element that is not a child of the column accessibility object.

Available in Mac OS X v10.4 and later.
kAXURLAttribute

The URL that describes the location of the document or application represented by this accessibility object.

Available in Mac OS X v10.3 and later.
kAXLabelUIElementsAttribute

An array of accessibility objects representing the labels displayed near the control represented by this accessibility object. For example, a slider control might display labels that indicate the range of values the slider can represent. Because these labels are not displayed as part of the slider’s visual interface, an assistive application does not know they are associated with the slider. By including accessibility objects representing the labels in this attribute, you make this association explicit.

Available in Mac OS X v10.4 and later.
kAXLabelValueAttribute

The value of the label represented by this accessibility object. This attribute is required for all accessibility objects that represent labels.

Available in Mac OS X v10.4 and later.
kAXShownMenuUIElementAttribute

An array of accessibility objects that represent the contextual or Dock menus provided by this accessibility object.

Available in Mac OS X v10.4 and later.
kAXServesAsTitleForUIElementsAttribute

An array of accessibility objects for which this accessibility object serves as the title. For example, a piece of static text can serve as a title for one or more user interface elements. Because this static text string is not displayed as part of any user interface element’s visual interface, an assistive application does not know the title is associated with user interface elements. By including this attribute in the accessibility object representing the title, you specify the accessibility objects with which this title is associated.

Available in Mac OS X v10.4 and later.
kAXLinkedUIElementsAttribute

An array of accessibility objects with which this accessibility object is related. For example, the contents of a list item can be displayed in another pane or window. The list item and the separately displayed contents are related, but this relationship may not be apparent to an assistive application. To make such a relationship explicit, you include this attribute in the accessibility objects representing the related user interface elements.

Available in Mac OS X v10.4 and later.
kAXRowsAttribute

An array of the accessibility objects representing the rows in this table or outline view.
kAXVisibleRowsAttribute

An array of the accessibility objects representing the currently visible rows in this table or outline view.
kAXSelectedRowsAttribute

An array of the accessibility objects representing the currently selected rows in this table or outline view.
kAXColumnsAttribute

An array of the accessibility objects representing the columns in this browser view.
kAXVisibleColumnsAttribute

An array of the accessibility objects representing the currently visible columns in this browser view.
kAXSelectedColumnsAttribute

An array of the accessibility objects representing the currently selected columns in this browser view.
kAXSortDirectionAttribute

The sort direction of this accessibility object’s contents. For example, a list view’s contents may be sorted in ascending or descending order.
kAXColumnHeaderUIElementsAttribute

An array of accessibility objects representing the column headers of this table or browser view.

Available in Mac OS X v10.4 and later.
kAXIndexAttribute

The index of the row or column represented by this accessibility object.

Available in Mac OS X v10.4 and later.
kAXDisclosingAttribute

Indicates whether a row in an outline view represented by this accessibility object has an open or closed disclosure triangle. true indicates an open disclosure triangle; false indicates a closed disclosure triangle.

Available in Mac OS X v10.2 and later.
kAXDisclosedRowsAttribute

An array of accessibility objects representing the disclosed rows of this user interface element.
kAXDisclosedByRowAttribute

The accessibility object representing the disclosing row.

Available in Mac OS X v10.2 and later.
kAXMatteHoleAttribute

The accessibility object that represents the area available to the user through the matte hole.

Available in Mac OS X v10.4 and later.
kAXMatteContentUIElementAttribute

The accessibility object clipped by the matte.

Available in Mac OS X v10.4 and later.
kAXIsApplicationRunningAttribute

Indicates if the application represented by the Dock icon this accessibility object represents is currently running.

Available in Mac OS X v10.4 and later.
kAXFocusedApplicationAttribute

Indicates the application element that is currently accepting keyboard input. This attribute is supported by the system-wide accessibility object to help an assistive application quickly determine the application that is accepting keyboard input. After the assistive application gets the accessibility object representing this application, it can send a message to the application asking for its focused accessibility object.
kAXInsertionPointLineNumberAttribute

The line number of the insertion point in the text associated with this accessibility object.

Available in Mac OS X v10.4 and later.
Discussion

See the “Roles and Associated Attributes” appendix in Accessibility Overview for more information on which attributes are associated with a specific role.*/

//General attributes 
#define kAXRoleAttribute                    CFSTR("AXRole")
#define kAXSubroleAttribute                 CFSTR("AXSubrole")
#define kAXRoleDescriptionAttribute         CFSTR("AXRoleDescription")
#define kAXHelpAttribute                    CFSTR("AXHelp")
#define kAXTitleAttribute                   CFSTR("AXTitle")
#define kAXValueAttribute                   CFSTR("AXValue")
#define kAXMinValueAttribute                CFSTR("AXMinValue")
#define kAXMaxValueAttribute                CFSTR("AXMaxValue")
#define kAXValueIncrementAttribute          CFSTR("AXValueIncrement")
#define kAXAllowedValuesAttribute           CFSTR("AXAllowedValues")
#define kAXEnabledAttribute                 CFSTR("AXEnabled")
#define kAXFocusedAttribute                 CFSTR("AXFocused")
#define kAXParentAttribute                  CFSTR("AXParent")
#define kAXChildrenAttribute                CFSTR("AXChildren")
#define kAXSelectedChildrenAttribute        CFSTR("AXSelectedChildren")
#define kAXVisibleChildrenAttribute         CFSTR("AXVisibleChildren")
#define kAXWindowAttribute                  CFSTR("AXWindow")
#define kAXTopLevelUIElementAttribute       CFSTR("AXTopLevelUIElement")
#define kAXPositionAttribute                CFSTR("AXPosition")
#define kAXSizeAttribute                    CFSTR("AXSize")
#define kAXOrientationAttribute             CFSTR("AXOrientation")
#define kAXDescriptionAttribute             CFSTR("AXDescription")
   
// Text-specific attributes 
#define kAXSelectedTextAttribute            CFSTR("AXSelectedText")
#define kAXVisibleCharacterRangeAttribute CFSTR("AXVisibleCharacterRange")
#define kAXSelectedTextRangeAttribute       CFSTR("AXSelectedTextRange")
#define kAXNumberOfCharactersAttribute      CFSTR("AXNumberOfCharacters")
#define kAXSharedTextUIElementsAttribute    CFSTR("AXSharedTextUIElements")
#define kAXSharedCharacterRangeAttribute    CFSTR("AXSharedCharacterRange")
   
// Window-specific attributes 
#define kAXMainAttribute                    CFSTR("AXMain")
#define kAXMinimizedAttribute               CFSTR("AXMinimized")
#define kAXCloseButtonAttribute             CFSTR("AXCloseButton")
#define kAXZoomButtonAttribute              CFSTR("AXZoomButton")
#define kAXMinimizeButtonAttribute          CFSTR("AXMinimizeButton")
#define kAXToolbarButtonAttribute           CFSTR("AXToolbarButton")
#define kAXGrowAreaAttribute                CFSTR("AXGrowArea")
#define kAXProxyAttribute                   CFSTR("AXProxy")
#define kAXModalAttribute                   CFSTR("AXModal")
#define kAXDefaultButtonAttribute           CFSTR("AXDefaultButton")
#define kAXCancelButtonAttribute            CFSTR("AXCancelButton")
   
// Menu-specific attributes 
#define kAXMenuItemCmdCharAttribute         CFSTR("AXMenuItemCmdChar")
#define kAXMenuItemCmdVirtualKeyAttribute  CFSTR("AXMenuItemCmdVirtualKey")
#define kAXMenuItemCmdGlyphAttribute        CFSTR("AXMenuItemCmdGlyph")
#define kAXMenuItemCmdModifiersAttribute   CFSTR("AXMenuItemCmdModifiers")
#define kAXMenuItemMarkCharAttribute    CFSTR("AXMenuItemMarkChar")
#define kAXMenuItemPrimaryUIElementAttribute CFSTR("AXMenuItemPrimaryUIElement")
   
// Application-specific attributes
 #define kAXMenuBarAttribute                     CFSTR("AXMenuBar")
#define kAXWindowsAttribute                     CFSTR("AXWindows")
#define kAXFrontmostAttribute                   CFSTR("AXFrontmost")
#define kAXHiddenAttribute                      CFSTR("AXHidden")
#define kAXMainWindowAttribute                  CFSTR("AXMainWindow")
#define kAXFocusedWindowAttribute               CFSTR("AXFocusedWindow")
#define kAXFocusedUIElementAttribute        CFSTR("AXFocusedUIElement")
   
// Miscellaneous attributes 
#define kAXHeaderAttribute                  CFSTR("AXHeader")
#define kAXEditedAttribute                  CFSTR("AXEdited")
#define kAXValueWrapsAttribute              CFSTR("AXValueWraps")
#define kAXTabsAttribute                    CFSTR("AXTabs")
#define kAXTitleUIElementAttribute          CFSTR("AXTitleUIElement")
#define kAXHorizontalScrollBarAttribute     CFSTR("AXHorizontalScrollBar")
#define kAXVerticalScrollBarAttribute       CFSTR("AXVerticalScrollBar")
#define kAXOverflowButtonAttribute          CFSTR("AXOverflowButton")
#define kAXFilenameAttribute                CFSTR("AXFilename")
#define kAXExpandedAttribute                CFSTR("AXExpanded")
#define kAXSelectedAttribute                CFSTR("AXSelected")
#define kAXSplittersAttribute               CFSTR("AXSplitters")
#define kAXNextContentsAttribute            CFSTR("AXNextContents")
#define kAXDocumentAttribute                CFSTR("AXDocument")
#define kAXDecrementButtonAttribute         CFSTR("AXDecrementButton")
#define kAXIncrementButtonAttribute         CFSTR("AXIncrementButton")
#define kAXPreviousContentsAttribute        CFSTR("AXPreviousContents")
#define kAXContentsAttribute                CFSTR("AXContents")
#define kAXIncrementorAttribute             CFSTR("AXIncrementor")
#define kAXHourFieldAttribute               CFSTR("AXHourField")
#define kAXMinuteFieldAttribute             CFSTR("AXMinuteField")
#define kAXSecondFieldAttribute             CFSTR("AXSecondField")
#define kAXAMPMFieldAttribute               CFSTR("AXAMPMField")
#define kAXDayFieldAttribute                CFSTR("AXDayField")
#define kAXMonthFieldAttribute              CFSTR("AXMonthField")
#define kAXYearFieldAttribute               CFSTR("AXYearField")
#define kAXColumnTitleAttribute             CFSTR("AXColumnTitles")
#define kAXURLAttribute                     CFSTR("AXURL")
#define kAXLabelUIElementsAttribute         CFSTR("AXLabelUIElements")
#define kAXLabelValueAttribute              CFSTR("AXLabelValue")
#define kAXShownMenuUIElementAttribute      CFSTR("AXShownMenuUIElement")
#define kAXServesAsTitleForUIElementsAttribute           CFSTR("AXServesAsTitleForUIElements")
#define kAXLinkedUIElementsAttribute CFSTR("AXLinkedUIElements")
   
// Table and outline view attributes 
#define kAXRowsAttribute                    CFSTR("AXRows")
#define kAXVisibleRowsAttribute             CFSTR("AXVisibleRows")
#define kAXSelectedRowsAttribute            CFSTR("AXSelectedRows")
#define kAXColumnsAttribute                 CFSTR("AXColumns")
#define kAXVisibleColumnsAttribute          CFSTR("AXVisibleColumns")
#define kAXSelectedColumnsAttribute         CFSTR("AXSelectedColumns")
#define kAXSortDirectionAttribute           CFSTR("AXSortDirection")
#define kAXColumnHeaderUIElementsAttribute CFSTR("AXColumnHeaderUIElements")
#define kAXIndexAttribute                   CFSTR("AXIndex")
#define kAXDisclosingAttribute              CFSTR("AXDisclosing")
#define kAXDisclosedRowsAttribute           CFSTR("AXDisclosedRows")
#define kAXDisclosedByRowAttribute          CFSTR("AXDisclosedByRow")
   
// Matte attributes 
#define kAXMatteHoleAttribute               CFSTR("AXMatteHole")
#define kAXMatteContentUIElementAttribute CFSTR("AXMatteContentUIElement")
   
   
// Dock attributes 
#define kAXIsApplicationRunningAttribute CFSTR("AXIsApplicationRunning")
   
// System-wide attributes 
#define kAXFocusedApplicationAttribute      CFSTR("AXFocusedApplication")



#endif