#import <Foundation/NSObject.h>

@class NSAppleEventDescriptor, NSDictionary, NSMutableDictionary, NSScriptObjectSpecifier, NSScriptCommandDescription, NSString;


@interface NSScriptCommand : NSObject <NSCoding> 

/*directParameter

Returns the object that corresponds to the keyDirectObject parameter of the Apple event from which the receiver derives, or nil if the event doesn’t contain a direct parameter.

- (id)directParameter
Discussion

For example, the direct parameter of a print documents Apple event contains a list of documents. This method may return the same object or objects returned by receiversSpecifier.
Availability
Available in Mac OS X v10.0 and later.
See Also
– setDirectParameter:*/
- (id)directParameter;

/*evaluatedArguments

Returns a dictionary containing the arguments of the command, evaluated from object specifiers to objects if necessary. The keys in the dictionary are the argument names.

- (NSDictionary *)evaluatedArguments
Discussion

Arguments initially can be either a normal object or an object specifier such as word 5 (represented as an instance of an NSScriptObjectSpecifier subclass). If arguments are object specifiers, the receiver evaluates them before using the referenced objects. Returns nil if the command is not well formed. Also returns nil if an object specifier does not evaluate to an object or if there is no type defined for the argument in the command description. 
Availability
Available in Mac OS X v10.0 and later.
See Also
– isWellFormed
– arguments
– setArguments:*/
- (NSDictionary *)evaluatedArguments;

/*setScriptErrorNumber:

Sets a script error number to errorNumber that is associated with the execution of the command.

- (void)setScriptErrorNumber:(int)errorNumber
Discussion

If you override performDefaultImplementation and an error occurs, you should call this method to supply an appropriate error number. In fact, any script handler should call this method when an error occurs. The error number you supply is returned in the reply Apple event.
Availability
Available in Mac OS X v10.0 and later.
See Also
– scriptErrorNumber*/
- (void)setScriptErrorNumber:(int)errorNumber;

@end
