#import <Foundation/NSObject.h>
#import <ApplicationServices/ApplicationServices.h>

@class NSData;

@interface NSAppleEventDescriptor : NSObject<NSCopying>

/*appleEventWithEventClass:eventID:targetDescriptor:returnID:transactionID:

Returns a descriptor that represents an Apple event, initialized according to the specified information.

+ (NSAppleEventDescriptor *)appleEventWithEventClass:(AEEventClass)eventClass eventID:(AEEventID)eventID targetDescriptor:(NSAppleEventDescriptor *)addressDescriptor returnID:(AEReturnID)returnID transactionID:(AETransactionID)transactionID
Parameters
eventClass

The event class to be set in the returned descriptor.
eventID

The event ID to be set in the returned descriptor.
addressDescriptor

A pointer to a descriptor that identifies the target application for the Apple event. Passing nil results in an Apple event descriptor that has no keyAddressAttr attribute (it is valid for an Apple event to have no target address attribute).
returnID

The return ID to be set in the returned descriptor. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID.
transactionID

The transaction ID to be set in the returned descriptor. A transaction is a sequence of Apple events that are sent back and forth between client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify kAnyTransactionID if the Apple event is not one of a series of interdependent Apple events.
Return Value

A descriptor for an Apple event, initialized according to the specified parameter values, or nil if an error occurs.
Discussion

Constants such as kAutoGenerateReturnID and kAnyTransactionID are defined in AE.framework, a subframework of ApplicationServices.framework.
Availability
Available in Mac OS X v10.0 and later.*/
+ (NSAppleEventDescriptor *)appleEventWithEventClass:(AEEventClass)eventClass eventID:(AEEventID)eventID targetDescriptor:(NSAppleEventDescriptor *)addressDescriptor returnID:(AEReturnID)returnID transactionID:(AETransactionID)transactionID;

/*descriptorWithString:

Returns a descriptor of type typeUnicodeText that stores the text from the specified string.

+ (NSAppleEventDescriptor *)descriptorWithString:(NSString *)string
Parameters
string

A string that specifies the text to be stored in the returned descriptor.
Return Value

A descriptor that contains the text from the specified string, or nil if an error occurs.
Availability
Available in Mac OS X v10.2 and later.*/
+ (NSAppleEventDescriptor *)descriptorWithString:(NSString *)string;

/*setDescriptor:forKeyword:

Adds a descriptor, identified by a keyword, to the receiver.

- (void)setDescriptor:(NSAppleEventDescriptor *)descriptor forKeyword:(AEKeyword)keyword
Parameters
descriptor

The descriptor to add to the receiver.
keyword

A keyword (a four-character code) that identifies the descriptor to add. If a descriptor with that keyword already exists in the receiver, it is replaced.
Discussion

The receiver must be an Apple event or Apple event record. Currently provides no indication if an error occurs.
Availability
Available in Mac OS X v10.0 and later.*/
- (void)setDescriptor:(NSAppleEventDescriptor *)descriptor forKeyword:(AEKeyword)keyword;

/*descriptorWithDescriptorType:bytes:length:

Returns a descriptor with the specified event type that stores the specified data (from a series of bytes).

+ (NSAppleEventDescriptor *)descriptorWithDescriptorType:(DescType)descriptorType bytes:(const void *)bytes length:(unsigned int)byteCount
Parameters
descriptorType

The descriptor type to be set in the returned descriptor.
bytes

The data, as a sequence of bytes, to be set in the returned descriptor.
byteCount

The length, in bytes, of the data to be set in the returned descriptor.
Return Value

A descriptor with the specified type and data, or nil if an error occurs.
Availability
Available in Mac OS X v10.2 and later.*/
+ (NSAppleEventDescriptor *)descriptorWithDescriptorType:(DescType)descriptorType bytes:(const void *)bytes;

/*ilstDescriptor

Returns an empty list descriptor.

+ (NSAppleEventDescriptor *)listDescriptor
Return Value

An empty list descriptor, or nil if an error occurs.
Discussion

A list descriptor is a descriptor whose data consists of one or more descriptors. You can add items to the list by calling insertDescriptor:atIndex: or remove them with removeDescriptorAtIndex:.
Availability
Available in Mac OS X v10.0 and later.*/
+ (NSAppleEventDescriptor *)listDescriptor;

/*descriptorWithInt32:

Returns a descriptor with Apple event type typeSInt32 that stores the specified integer value.

+ (NSAppleEventDescriptor *)descriptorWithInt32:(SInt32)signedInt
Parameters
signedInt

The integer value to be stored in the returned descriptor.
Return Value

A descriptor containing the specified integer value, or nil if an error occurs.
Availability
Available in Mac OS X v10.2 and later.*/
+ (NSAppleEventDescriptor *)descriptorWithInt32:(SInt32)signedInt;

/*insertDescriptor:atIndex:

Inserts a descriptor at the specified (one-based) position in the receiving descriptor list, replacing the existing descriptor, if any, at that position.

- (void)insertDescriptor:(NSAppleEventDescriptor *)descriptor atIndex:(long int)anIndex
Parameters
descriptor

The descriptor to insert in the receiver. Specifying an index of 0 or count + 1 causes appending to the end of the list.
anIndex

The one-based descriptor list position at which to insert the descriptor.
Discussion

Because it actually replaces the descriptor, if any, at the specified position, this method might better be called replaceDescriptor. The receiver must be a list descriptor. The indices are one-based. Currently provides no indication if an error occurs.
Availability
Available in Mac OS X v10.0 and later.
See Also
– descriptorAtIndex:
– removeDescriptorAtIndex:*/
- (void)insertDescriptor:(NSAppleEventDescriptor *)descriptor atIndex:(long int)anIndex;

/*descriptorWithDescriptorType:bytes:length:

Returns a descriptor with the specified event type that stores the specified data (from a series of bytes).

+ (NSAppleEventDescriptor *)descriptorWithDescriptorType:(DescType)descriptorType bytes:(const void *)bytes length:(unsigned int)byteCount
Parameters
descriptorType

The descriptor type to be set in the returned descriptor.
bytes

The data, as a sequence of bytes, to be set in the returned descriptor.
byteCount

The length, in bytes, of the data to be set in the returned descriptor.
Return Value

A descriptor with the specified type and data, or nil if an error occurs.
Availability
Available in Mac OS X v10.2 and later.*/
+ (NSAppleEventDescriptor *)descriptorWithDescriptorType:(DescType)descriptorType bytes:(const void *)bytes length:(unsigned int)byteCount;

/*int32Value

Returns the contents of the receiver as an integer, coercing (to typeSInt32) if necessary.

- (SInt32)int32Value
Return Value

The contents of the descriptor, as an integer value, or 0 if an error occurs.
Availability
Available in Mac OS X v10.2 and later.*/
- (SInt32)int32Value;

/*descriptorAtIndex:

Returns the descriptor at the specified (one-based) position in the receiving descriptor list.

- (NSAppleEventDescriptor *)descriptorAtIndex:(long int)anIndex
Parameters
anIndex

The one-based descriptor list position of the descriptor to return.
Return Value

The descriptor from the specified position (one-based) in the descriptor list, or nil if the specified descriptor cannot be obtained.
Availability
Available in Mac OS X v10.0 and later.
See Also
– insertDescriptor:atIndex:
– removeDescriptorAtIndex:*/
- (NSAppleEventDescriptor *)descriptorAtIndex:(long int)anIndex;

/*stringValue

Returns the contents of the receiver as a Unicode text string, coercing (to typeUnicodeText) if necessary.

- (NSString *)stringValue
Return Value

The contents of the descriptor, as a string, or nil if an error occurs.
Availability
Available in Mac OS X v10.2 and later.*/
- (NSString *)stringValue;

/*numberOfItems

Returns the number of descriptors in the receiver’s descriptor list.

- (int)numberOfItems
Return Value

The number of descriptors in the receiver’s descriptor list (possibly 0); returns 0 if an error occurs.
Availability
Available in Mac OS X v10.0 and later.*/
- (int)numberOfItems;

/*paramDescriptorForKeyword:

Returns a descriptor for the receiver’s Apple event parameter identified by the specified keyword.

- (NSAppleEventDescriptor *)paramDescriptorForKeyword:(AEKeyword)keyword
Parameters
keyword

A keyword (a four-character code) that identifies the parameter descriptor to obtain.
Return Value

A descriptor for the specified keyword, or nil if an error occurs.
Discussion

The receiver must be an Apple event.
Availability
Available in Mac OS X v10.0 and later.*/
- (NSAppleEventDescriptor *)paramDescriptorForKeyword:(AEKeyword)keyword;



@end

