#ifndef  DRCOREERASE_H
#define DRCOREERASE_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef DRCOREOBJECT_HJ
#include <DiscRecordingEngine/DRCoreObject.h>
#endif

#ifndef DRCOREDEVICE_H
#include <DiscRecordingEngine/DRCoreDevice.h>
#endif

#ifndef AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DREraseRef

typedef struct __DRErase* DREraseRef;  
Discussion 

This is the type of a reference to DRErases.*/
typedef struct __DRErase* DREraseRef;  

/*kDREraseStatusChangedNotification

extern const CFStringRef kDREraseStatusChangedNotification ;  
Discussion 

The notification sent when a DRErase object has updated status. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDREraseStatusChangedNotification ;  

/*kDREraseTypeKey

extern const CFStringRef kDREraseTypeKey ;  
Discussion 

This key points to a CFString object describing the type of erase to be performed. If this key is not present, a kDREraseTypeQuick erase type is assumed. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDREraseTypeKey ;  

/*kDREraseTypeComplete

extern const CFStringRef kDREraseTypeComplete ;  
Discussion 

A CFString object indicating the erase operation should erase every byte on the disc. This operation is slow, taking on the order of 30 minutes. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDREraseTypeComplete ;  

/*kDREraseTypeQuick

extern const CFStringRef kDREraseTypeQuick ;  
Discussion 

A CFString object indicating the erase operation should do the minimal amount of work to make the disc appear blank. This operation typically takes only a minute or two. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDREraseTypeQuick ;  

//func

/*DREraseCreate


Creates a new eraser. 
extern DREraseRef DREraseCreate(
    DRDeviceRef device) ;  
Parameters
device
A reference to the device to erase. If this parameter is not a valid DRDevice, the behavior is undefined.
Return Value

Returns a reference to a new DRErase opaque type. 
Availability
Introduced in Mac OS X v10.2*/
extern DREraseRef DREraseCreate(
    DRDeviceRef device) ;  

/*DREraseSetProperties


Sets the properties of the erase process. 
extern void DREraseSetProperties(
    DREraseRef erase,
    CFDictionaryRef properties) ;  
Parameters
erase
The erase process to set the properties of. If this parameter is not a valid DRErase object, the behavior is undefined.
properties
A CFDictionary object containing the erase properties. If this parameter is not a valid CFDictionary object the behavior is undefined.
Availability
Introduced in Mac OS X v10.2*/
extern void DREraseSetProperties(
    DREraseRef erase,
    CFDictionaryRef properties) ;  

/*DREraseStart


Begin the erase process. 
extern OSStatus DREraseStart(
    DREraseRef erase) ;  
Parameters
erase
The eraser object that should be started. If this parameter is not a valid DRErase oject, the behavior is undefined.
Return Value

An error code indicating if the erase could be started. 
Availability
Introduced in Mac OS X v10.2*/
extern OSStatus DREraseStart(
    DREraseRef erase) ;  


#ifdef __cplusplus
}
#endif

#endif
