#ifndef  DRCONTENTOBJECT_H
#define DRCONTENTOBJECT_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef  COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef DRCOREOBJECT_H
#include <DiscRecordingEngine/DRCoreObject.h>
#endif

#ifndef AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DRFilesystemMask contants

enum { 
    kDRFilesystemMaskISO9660 = (
        1<<0), 
    kDRFilesystemMaskJoliet = (
        1<<1), 
    kDRFilesystemMaskUDF = (
        1<<2), 
    kDRFilesystemMaskHFSPlus = (
        1<<3), 
    kDRFilesystemMaskDefault = 0xFFFFFFFF 
};  
Constants
kDRFilesystemMaskISO9660
The mask specifying the ISO-9660 file system.
kDRFilesystemMaskJoliet
The mask specifying the Joliet file system, an extension to the ISO-9660 file system.
kDRFilesystemMaskUDF
The mask specifying the UDF file system.
kDRFilesystemMaskHFSPlus
The mask specifying the HFS+ file system.
kDRFilesystemMaskDefault
The default, unrestricted mask for newly-created file or folder objects.*/
enum { 
    kDRFilesystemMaskISO9660 = (
        1<<0), 
    kDRFilesystemMaskJoliet = (
        1<<1), 
    kDRFilesystemMaskUDF = (
        1<<2), 
    kDRFilesystemMaskHFSPlus = (
        1<<3), 
    kDRFilesystemMaskDefault = 0xFFFFFFFF 
};  


/*DRFilesystemMask


A mask of values indicating in which filesystems a particular filesystem object should be included. 
typedef UInt32 DRFilesystemMask;  */
typedef UInt32 DRFilesystemMask; 

/*DRFolderRef


The type of a reference to a DRFolder object. 
typedef struct __DRFolder* DRFolderRef;  */
typedef struct __DRFolder* DRFolderRef; 

/*DRFSObjectRef


A polymorphic type used for file and folder objects. 
typedef DRTypeRef DRFSObjectRef;  */
typedef DRTypeRef DRFSObjectRef;  


//func

/*DRFSObjectSetFilesystemMask


Sets the explicit mask for a file or folder object, indicating in which file systems this object should appear. 
extern void DRFSObjectSetFilesystemMask( 
    DRFSObjectRef object, 
    DRFilesystemMask newMask) ;  
Parameters
object
A reference to the file or folder object to modify.
newMask
The new explicit mask to use.
Discussion 

Refer to the discussion for DRFSObjectGetFilesystemMask for an explanation of explicit and effective masks. 
Availability
Introduced in Mac OS X v10.2*/
extern void DRFSObjectSetFilesystemMask( 
    DRFSObjectRef object, 
    DRFilesystemMask newMask) ;  

#ifdef __cplusplus
}
#endif

#endif 
