#ifndef CGDIRECT_DISPLAY_H
#define CGDIRECT_DISPLAY_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGGeometry.h>
#include <CoreGraphics/CGError.h>
#include <CoreGraphics/CGContext.h>
#include <CoreFoundation/CoreFoundation.h>
#include <stdint.h>
#include <AvailabilityMacros.h>
#include <mach/boolean.h>

//#include <HYS/CoreGraphics/CGDirectDisplay.h>
#include <APPLE/CoreGraphics/CGDirectDisplay.h>
/*Display Mode Optional Properties

Specify keys for optional properties in a display mode dictionary.

#define kCGDisplayModeIsSafeForHardware CFSTR ("kCGDisplayModeIsSafeForHardware")
#define kCGDisplayModeIsInterlaced CFSTR("kCGDisplayModeIsInterlaced")
#define kCGDisplayModeIsStretched CFSTR("kCGDisplayModeIsStretched")
#define kCGDisplayModeIsTelevisionOutput CFSTR ("kCGDisplayModeIsTelevisionOutput")
Constants
kCGDisplayModeIsSafeForHardware

Specifies a CFBoolean value indicating that the display mode doesn't need a confirmation dialog to be set.

Available in Mac OS X v10.2 and later.
kCGDisplayModeIsInterlaced

Specifies a CFBoolean value indicating that the I/O Kit interlace mode flag is set.

Available in Mac OS X v10.2 and later.
kCGDisplayModeIsStretched

Specifies a CFBoolean value indicating that the I/O Kit stretched mode flag is set.

Available in Mac OS X v10.2 and later.
kCGDisplayModeIsTelevisionOutput

Specifies a CFBoolean value indicating that the I/O Kit television output mode flag is set.

Available in Mac OS X v10.2 and later.
Discussion

A given key is present in a display mode dictionary only if the property applies, and is always associated with a value of kCFBooleanTrue. Keys not relevant to a particular display mode will not appear in the mode dictionary.*/
#define kCGDisplayModeIsSafeForHardware CFSTR ("kCGDisplayModeIsSafeForHardware")
#define kCGDisplayModeIsInterlaced CFSTR("kCGDisplayModeIsInterlaced")
#define kCGDisplayModeIsStretched CFSTR("kCGDisplayModeIsStretched")
#define kCGDisplayModeIsTelevisionOutput CFSTR ("kCGDisplayModeIsTelevisionOutput")


/*Display Mode Standard Properties

Specify keys for the standard properties in a display mode dictionary.

#define kCGDisplayWidth CFSTR("Width")
#define kCGDisplayHeight CFSTR("Height")
#define kCGDisplayMode CFSTR("Mode")
#define kCGDisplayBitsPerPixel CFSTR("BitsPerPixel")
#define kCGDisplayBitsPerSample CFSTR("BitsPerSample")
#define kCGDisplaySamplesPerPixel CFSTR("SamplesPerPixel")
#define kCGDisplayRefreshRate CFSTR("RefreshRate")
#define kCGDisplayModeUsableForDesktopGUICFSTR("UsableForDesktopGUI")
#define kCGDisplayIOFlags CFSTR("IOFlags")
#define kCGDisplayBytesPerRow CFSTR("kCGDisplayBytesPerRow")
Constants
kCGDisplayWidth

Specifies a CFNumber integer value that represents the width of the display in pixels.

Available in Mac OS X v10.2 and later.
kCGDisplayHeight

Specifies a CFNumber integer value that represents the height of the display in pixels.

Available in Mac OS X v10.2 and later.
kCGDisplayMode

Specifies a CFNumber integer value that represents the I/O Kit display mode number. 

Available in Mac OS X v10.2 and later.
kCGDisplayBitsPerPixel

Specifies a CFNumber integer value that represents the number of bits in a pixel.

Available in Mac OS X v10.2 and later.
kCGDisplayBitsPerSample

Specifies a CFNumber integer value that represents the number of bits in an individual sample (for example, a color value in an RGB pixel).

Available in Mac OS X v10.2 and later.
kCGDisplaySamplesPerPixel

Specifies a CFNumber integer value that represents the number of samples in a pixel.

Available in Mac OS X v10.2 and later.
kCGDisplayRefreshRate

Specifies a CFNumber double-precision floating point value that represents the refresh rate of a CRT display. Some displays may not use conventional video vertical and horizontal sweep in painting the screen; these displays report a refresh rate of 0. 

Available in Mac OS X v10.2 and later.
kCGDisplayModeUsableForDesktopGUI

Specifies a CFBoolean value that indicates whether the display is suitable for use with the Mac OS X graphical user interface. The criteria include factors such as sufficient width and height and adequate pixel depth.

Available in Mac OS X v10.2 and later.
kCGDisplayIOFlags

Specifies a CFNumber integer value that contains the I/O Kit display mode flags. For more information, see the header file IOKit/IOGraphicsTypes.h.

Available in Mac OS X v10.2 and later.
kCGDisplayBytesPerRow

Specifies a CFNumber integer value that represents the number of bytes in a row on the display.

Available in Mac OS X v10.2 and later.
Discussion

To learn how to use these keys to access the values in a display mode dictionary, see CFDictionary Reference.*/
#define kCGDisplayWidth CFSTR("Width")
#define kCGDisplayHeight CFSTR("Height")
#define kCGDisplayMode CFSTR("Mode")
#define kCGDisplayBitsPerPixel CFSTR("BitsPerPixel")
#define kCGDisplayBitsPerSample CFSTR("BitsPerSample")
#define kCGDisplaySamplesPerPixel CFSTR("SamplesPerPixel")
#define kCGDisplayRefreshRate CFSTR("RefreshRate")
#define kCGDisplayModeUsableForDesktopGUI CFSTR("UsableForDesktopGUI")
#define kCGDisplayIOFlags CFSTR("IOFlags")
#define kCGDisplayBytesPerRow CFSTR("kCGDisplayBytesPerRow")



/*CGDisplayCount

Represents the number of displays in various lists.

typedef uint32_t CGDisplayCount;
Discussion

Quartz uses CGDisplayCount to represent a count of either the current or the maximum number of displays in a display list. For example, see the function CGGetActiveDisplayList.
Availability
Available in Mac OS X v10.0 and later.*/
typedef uint32_t CGDisplayCount;



/*CGTableCount

Defines a uniform type to represent the number of entries in a table.

typedef uint32_t CGTableCount;
Availability
Available in Mac OS X v10.0 and later.*/
typedef uint32_t CGTableCount;

/*CGGammaValue

Represents information used to map a color generated in software to a color supported by the display hardware.

typedef float CGGammaValue;
Discussion

In Mac OS X, the Display panel in System Preferences is used to set the default gamma for a display. Quartz also allows an application to provide its own custom gamma information, using functions such as CGSetDisplayTransferByTable and CGSetDisplayTransferByFormula.

These functions take CGGammaValue arguments that specify
a set of gamma table entries ranging from 0 to 1
the positive real coefficients in a gamma equation
Availability
Available in Mac OS X v10.0 and later.*/
typedef float CGGammaValue;



/*CGDirectDisplayID

Represents a unique identifier for an attached display.

typedef struct _CGDirectDisplayID * CGDirectDisplayID;
Discussion

In Quartz, the term display refers to a graphics hardware system consisting of a framebuffer, a color correction (gamma) table or color palette, and possibly an attached monitor. If no monitor is attached, a display is characterized as offline.

When a monitor is attached, Quartz assigns a unique display identifier (ID). A display ID can persist across processes and system reboot, and typically remains constant as long as certain display parameters do not change.

When assigning a display ID, Quartz considers the following parameters:
vendor
model
serial number
position in the I/O Kit registry

For information about how to obtain a display ID, see “Finding Displays”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct _CGDirectDisplayID * CGDirectDisplayID;



/*Display ID Defaults

Default values for a display ID.

#define kCGDirectMainDisplay (CGMainDisplayID())
#define kCGNullDirectDisplay ((CGDirectDisplayID)0)
Constants
kCGDirectMainDisplay

Specifies the current main display ID.

Available in Mac OS X v10.0 and later.
kCGNullDirectDisplay

Specifies a value that will never correspond to actual hardware.

Available in Mac OS X v10.2 and later.*/
#define kCGDirectMainDisplay (CGMainDisplayID())
#define kCGNullDirectDisplay ((CGDirectDisplayID)0)


/*CGOpenGLDisplayMask

Defines a bitmask used in OpenGL to specify a set of attached displays.

typedef uint32_t CGOpenGLDisplayMask;
Discussion

In Mac OS X, OpenGL can provide information about the capabilities of the hardware renderers driving a specified set of displays. A 32-bit mask is used to specify the displays—each bit in the mask represents a single display.

To learn how to find the mask bit that corresponds to a given display, see the function CGDisplayIDToOpenGLDisplayMask.
Availability
Available in Mac OS X v10.0 and later.*/
typedef uint32_t CGOpenGLDisplayMask;

/*CGDirectDisplayID

Represents a unique identifier for an attached display.

typedef struct _CGDirectDisplayID * CGDirectDisplayID;
Discussion

In Quartz, the term display refers to a graphics hardware system consisting of a framebuffer, a color correction (gamma) table or color palette, and possibly an attached monitor. If no monitor is attached, a display is characterized as offline.

When a monitor is attached, Quartz assigns a unique display identifier (ID). A display ID can persist across processes and system reboot, and typically remains constant as long as certain display parameters do not change.

When assigning a display ID, Quartz considers the following parameters:
vendor
model
serial number
position in the I/O Kit registry

For information about how to obtain a display ID, see “Finding Displays”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct _CGDirectDisplayID * CGDirectDisplayID;

/*CGDisplayErr

Defines a uniform type for result codes returned by functions in Quartz Display Services.

typedef CGError CGDisplayErr;
Availability
Available in Mac OS X v10.0 and later.*/

typedef CGError CGDisplayErr;


//function


/*CGMainDisplayID

Returns the display ID of the main display. 

CGDirectDisplayID CGMainDisplayID (void);
Return Value

The display ID assigned to the main display. For more information about this data type, see CGDirectDisplayID.
Discussion

The main display is the display with its screen location at (0,0) in global coordinates. In a system without display mirroring, the display with the menu bar is typically the main display.

If mirroring is enabled, and the menu bar appears on more than one display, this function provides a reliable way to find the main display. 

In case of hardware mirroring, the drawable display becomes the main display. In case of software mirroring, the display with the highest resolution and deepest pixel depth typically becomes the main display.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDirectDisplay.h*/
CGDirectDisplayID CGMainDisplayID (void);

/*CGDisplayCapture

Captures a display for exclusive use by an application. 

CGDisplayErr CGDisplayCapture (
   CGDirectDisplayID display
);
Parameters
display

The display to capture.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Discussion

When an application captures a display, Quartz does not allow other applications and system services to use the display or change its configuration. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplayCapture (
   CGDirectDisplayID display
);

/*CGDisplayRelease

Releases a captured display.

CGDisplayErr CGDisplayRelease (
   CGDirectDisplayID display
);
Parameters
display

The display to release.
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplayRelease (
   CGDirectDisplayID display
);

/*CGSetDisplayTransferByTable

Sets the color gamma function for a display, by specifying the values in the RGB gamma tables. 

CGDisplayErr CGSetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount tableSize,
   const CGGammaValue * redTable,
   const CGGammaValue * greenTable,
   const CGGammaValue * blueTable
);
Parameters
display

The display to access.
tableSize

The number of entries in each table.
redTable

An array of size tableSize containing the values of the red channel in the display’s gamma table. The values should be in the range 0.0 to 1.0.
greenTable

An array of size tableSize containing the values of the green channel in the display’s gamma table. The values should be in the range 0.0 to 1.0.
blueTable

An array of size tableSize containing the values of the blue channel in the display’s gamma table. The values should be in the range 0.0 to 1.0.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Discussion

The same table may be passed in for the red, green, and blue channels. The tables are interpolated as needed to generate the number of samples required by the graphics hardware.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGSetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount tableSize,
   const CGGammaValue * redTable,
   const CGGammaValue * greenTable,
   const CGGammaValue * blueTable
);

/*CGGetDisplayTransferByTable

Gets the values in the RGB gamma tables for a display.

CGDisplayErr CGGetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount capacity,
   CGGammaValue * redTable,
   CGGammaValue * greenTable,
   CGGammaValue * blueTable,
   CGTableCount * sampleCount
);
Parameters
display

The display to access.
capacity

The number of entries each table can hold.
redTable

A pointer to an array of type CGGammaValue with size capacity. On return, the array contains the values of the red channel in the display’s gamma table.
greenTable

A pointer to an array of type CGGammaValue with size capacity. On return, the array contains the values of the green channel in the display’s gamma table.
blueTable

A pointer to an array of type CGGammaValue with size capacity. On return, the array contains the values of the blue channel in the display’s gamma table.
sampleCount

The number of samples actually copied into each array.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGGetDisplayTransferByTable (
   CGDirectDisplayID display,
   CGTableCount capacity,
   CGGammaValue * redTable,
   CGGammaValue * greenTable,
   CGGammaValue * blueTable,
   CGTableCount * sampleCount
);

/*CGDisplayBaseAddress

Returns the base address in frame buffer memory of an online display.

void * CGDisplayBaseAddress (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The base address in frame buffer memory of the specified display. If the display ID is invalid, the return value is NULL.
Discussion

If the display has not been captured, the returned address may refer to read-only memory.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

void * CGDisplayBaseAddress (
   CGDirectDisplayID display
);

/*CGDisplayBytesPerRow

Returns the number of bytes per row in a display.

size_t CGDisplayBytesPerRow (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The number of bytes per row in the display. This number also represents the stride between pixels in the same column of the display. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

size_t CGDisplayBytesPerRow (
   CGDirectDisplayID display
);

/*CGDisplayPixelsHigh

Returns the display height in pixel units.

size_t CGDisplayPixelsHigh (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The display height in pixel units.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

size_t CGDisplayPixelsHigh (
   CGDirectDisplayID display
);

/*CGDisplayPixelsWide

Returns the display width in pixel units.

size_t CGDisplayPixelsWide (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The display width in pixel units.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
size_t CGDisplayPixelsWide (
   CGDirectDisplayID display
);

/*CGDisplayShowCursor

Decrements the hide cursor count, and shows the mouse cursor if the count is zero.

CGDisplayErr CGDisplayShowCursor (
   CGDirectDisplayID display
);
Parameters
display

This parameter is not used. By default, you may pass kCGDirectMainDisplay. 
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

If the hide cursor count is zero, this function shows the cursor regardless of its current location; the display parameter is ignored. In most cases, the caller must be the foreground application to affect the cursor.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGDisplayShowCursor (
   CGDirectDisplayID display
);

/*CGDisplayHideCursor

Hides the mouse cursor, and increments the hide cursor count.

CGDisplayErr CGDisplayHideCursor (
   CGDirectDisplayID display
);
Parameters
display

This parameter is not used. By default, you may pass kCGDirectMainDisplay. 
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

This function hides the cursor regardless of its current location; the display parameter is ignored. In most cases, the caller must be the foreground application to affect the cursor.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplayHideCursor (
   CGDirectDisplayID display
);

/*CGDisplaySwitchToMode

Switches a display to a different mode.

CGDisplayErr CGDisplaySwitchToMode (
   CGDirectDisplayID display,
   CFDictionaryRef mode
);
Parameters
display

The display to access.
mode

A display mode dictionary that contains information about the display mode to set. The dictionary passed in must be a dictionary returned by another Quartz display function such as CGDisplayAvailableModes or CGDisplayBestModeForParameters. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

This function switches the display mode of the specified display. The operation is always synchronous; the function does not return until the mode switch is complete. Note that after switching, display parameters and addresses may change. 

The selected display mode persists for the life of the calling program. When the program terminates, the display mode automatically reverts to the permanent setting in the Displays panel of System Preferences.

When changing the display mode of a display in a mirroring set, other displays in the mirroring set will be assigned a mode that's capable of mirroring the bounds of the display being adjusted. To avoid this automatic behavior, you can use the following procedure: call CGBeginDisplayConfiguration, call CGConfigureDisplayMode for each display to explicitly set the mode, and finally call CGCompleteDisplayConfiguration.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CGDisplayErr CGDisplaySwitchToMode (
   CGDirectDisplayID display,
   CFDictionaryRef mode
);

/*CGDisplayBestModeForParameters

Returns information about the display mode closest to a specified depth and screen size.

CFDictionaryRef CGDisplayBestModeForParameters (
   CGDirectDisplayID display,
   size_t bitsPerPixel,
   size_t width,
   size_t height,
   boolean_t * exactMatch
);
Parameters
display

The display to optimize.
bitsPerPixel

Optimal display depth in bits per pixel. Note that this value is not the same as pixel depth, which is the number of bits per channel or component. 
width

Optimal display width in pixel units.
height

Optimal display height in pixel units.
exactMatch

A pointer to a Boolean variable. On return, its value is true if an exact match in display depth, width, and height is found; otherwise, false. If this information is not needed, pass NULL.
Return Value

A display mode dictionary, or NULL if the display is invalid. The dictionary is owned by the system and you should not release it. The dictionary contains information about the display mode closest to the specified depth and screen size. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Discussion

This function tries to find an optimal display mode for the specified display. The function first tries to find a mode with the specified pixel depth and dimensions equal to or greater than the specified width and height. If no depth match is found, it tries to find a mode with greater depth and the same or greater dimensions. If a suitable display mode is not found, this function simply returns the current display mode.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CFDictionaryRef CGDisplayBestModeForParameters (
   CGDirectDisplayID display,
   size_t bitsPerPixel,
   size_t width,
   size_t height,
   boolean_t * exactMatch
);

/*CGDisplayCurrentMode

Returns information about the current display mode.

CFDictionaryRef CGDisplayCurrentMode (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

A display mode dictionary, or NULL if the display is invalid. The dictionary is owned by the system and you should not release it. The dictionary contains information about the current display mode. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CFDictionaryRef CGDisplayCurrentMode (
   CGDirectDisplayID display
);

/*CGGetActiveDisplayList

Provides a list of displays that are active (or drawable).

CGDisplayErr CGGetActiveDisplayList (
   CGDisplayCount maxDisplays,
   CGDirectDisplayID * displays,
   CGDisplayCount * displayCount
);
Parameters
maxDisplays

The size of the displays array. This value determines the maximum number of displays that can be returned.
displays

A pointer to storage provided by the caller for an array of display IDs. On return, this storage contains a list of active displays.
displayCount

A pointer to a CGDisplayCount variable provided by the caller. On return, the variable contains the actual number of displays returned in the displays array. If displays is NULL, this variable contains the total number of active displays.
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

The first entry in the list of active displays is the main display. In case of mirroring, the first entry is the largest drawable display or, if all are the same size, the display with the greatest pixel depth.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGGetActiveDisplayList (
   CGDisplayCount maxDisplays,
   CGDirectDisplayID * displays,
   CGDisplayCount * displayCount
);

/*CGDisplayIDToOpenGLDisplayMask

Maps a display ID to an OpenGL display mask.

CGOpenGLDisplayMask CGDisplayIDToOpenGLDisplayMask (
   CGDirectDisplayID display
);
Parameters
display

The display ID to be converted.
Return Value

The OpenGL display mask that corresponds to the specified display.
Discussion

OpenGL sometimes identifies a display using a bitmask with one bit set. This function maps a display ID to the corresponding OpenGL display mask.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGOpenGLDisplayMask CGDisplayIDToOpenGLDisplayMask (
   CGDirectDisplayID display
);

/*CGDisplayBounds

Returns the bounds of a display in global display space.

CGRect CGDisplayBounds (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The bounds of the display, expressed as a rectangle in the global display coordinate space (relative to the upper left corner of the main display).
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGRect CGDisplayBounds (
   CGDirectDisplayID display
);

/*CGDisplayAvailableModes

Returns information about the currently available display modes.

CFArrayRef CGDisplayAvailableModes (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

An array of dictionaries with display mode information, or NULL if the display is invalid. The array is owned by the system and you should not release it. Each dictionary in the array contains information about a mode that the display supports. For a list of the properties in a display mode dictionary, see “Display Mode Standard Properties” and “Display Mode Optional Properties”. For general information about using dictionaries, see CFDictionary Reference. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/

CFArrayRef CGDisplayAvailableModes (
   CGDirectDisplayID display
);

/*CGCaptureAllDisplays

Captures all attached displays. 

CGDisplayErr CGCaptureAllDisplays (void);
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

This function captures all attached displays in a single operation. This operation provides an immersive environment for your application, and it prevents other applications from trying to adjust to display changes.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h
See Also
CGDisplayCapture*/
CGDisplayErr CGCaptureAllDisplays (void);

/*CGReleaseAllDisplays

Releases all captured displays.

CGDisplayErr CGReleaseAllDisplays (void);
Return Value

A result code. See “Quartz Display Services Result Codes”. 
Discussion

This function releases all captured displays and restores the display modes to the user's preferences. It may be used in conjunction with any of the functions that capture displays, such as CGCaptureAllDisplays.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGReleaseAllDisplays (void);

/*CGDisplayIsCaptured

Returns a Boolean value indicating whether a display is captured.

boolean_t CGDisplayIsCaptured (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

If true, the specified display is captured; otherwise, false. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CGDirectDisplay.h*/
boolean_t CGDisplayIsCaptured (
   CGDirectDisplayID display
);

/*CGGetOnlineDisplayList

Provides a list of displays that are online (active, mirrored, or sleeping).

CGDisplayErr CGGetOnlineDisplayList (
   CGDisplayCount maxDisplays,
   CGDirectDisplayID * onlineDisplays,
   CGDisplayCount * displayCount
);
Parameters
maxDisplays

The size of the onlineDisplays array. This value determines the maximum number of display IDs that can be returned.
onlineDisplays

A pointer to storage provided by the caller for an array of display IDs. On return, this storage contains a list of the online displays.
displayCount

A pointer to storage provided by the caller for the count of display IDs returned in the onlineDisplays array. This value is at most maxDisplays. If maxDisplays is 0 and onlineDisplays is NULL , displayCount is filled in with the total number of online displays.
Return Value

A result code. See “Quartz Display Services Result Codes”.
Discussion

If the frame buffer hardware is connected, a display is considered connected or online.

When hardware mirroring is used, a display can be online but not active or drawable. Programs which manipulate display settings such as the palette or gamma tables need access to all displays, including hardware mirrors which are not drawable.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDirectDisplay.h*/
CGDisplayErr CGGetOnlineDisplayList (
   CGDisplayCount maxDisplays,
   CGDirectDisplayID * onlineDisplays,
   CGDisplayCount * displayCount
);

#endif