#ifndef COREFOUNDATION_CFUUID_H
#define COREFOUNDATION_CFUUID_H

#include <CoreFoundation/CFBase.h>
#include <CoreFoundation/CFString.h>
#include <APPLE/CoreFoundation/CFUUID.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFUUIDRef

A reference to a CFUUID object.

typedef const struct __CFUUID *CFUUIDRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFUUID *CFUUIDRef;

/*CFUUIDBytes

A 128-bit struct that represents a UUID as raw bytes.

struct CFUUIDBytes {
   UInt8 byte0;
   UInt8 byte1;
   UInt8 byte2;
   UInt8 byte3;
   UInt8 byte4;
   UInt8 byte5;
   UInt8 byte6;
   UInt8 byte7;
   UInt8 byte8;
   UInt8 byte9;
   UInt8 byte10;
   UInt8 byte11;
   UInt8 byte12;
   UInt8 byte13;
   UInt8 byte14;
   UInt8 byte15;
};
typedef struct CFUUIDBytes CFUUIDBytes;
Discussion

This structure can be obtained from a CFUUID object using the CFUUIDGetUUIDBytes function. This structure is can be passed to functions that expect a raw UUID.*/
struct CFUUIDBytes {
   UInt8 byte0;
   UInt8 byte1;
   UInt8 byte2;
   UInt8 byte3;
   UInt8 byte4;
   UInt8 byte5;
   UInt8 byte6;
   UInt8 byte7;
   UInt8 byte8;
   UInt8 byte9;
   UInt8 byte10;
   UInt8 byte11;
   UInt8 byte12;
   UInt8 byte13;
   UInt8 byte14;
   UInt8 byte15;
};
typedef struct CFUUIDBytes CFUUIDBytes;

//function

/*CFUUIDGetUUIDBytes

Returns the value of a UUID object as raw bytes.

CFUUIDBytes CFUUIDGetUUIDBytes (
   CFUUIDRef uuid
);
Parameters
uuid

The CFUUID object to examine. 
Return Value

The value of uuid represented as raw bytes. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDBytes CFUUIDGetUUIDBytes (
   CFUUIDRef uuid
);

/*CFUUIDGetConstantUUIDWithBytes

Returns a CFUUID object from raw UUID bytes.

CFUUIDRef CFUUIDGetConstantUUIDWithBytes (
   CFAllocatorRef alloc,
   UInt8 byte0,
   UInt8 byte1,
   UInt8 byte2,
   UInt8 byte3,
   UInt8 byte4,
   UInt8 byte5,
   UInt8 byte6,
   UInt8 byte7,
   UInt8 byte8,
   UInt8 byte9,
   UInt8 byte10,
   UInt8 byte11,
   UInt8 byte12,
   UInt8 byte13,
   UInt8 byte14,
   UInt8 byte15
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
byte0

Raw byte number 0.
byte1

Raw byte number 1.
byte2

Raw byte number 2.
byte3

Raw byte number 3.
byte4

Raw byte number 4.
byte5

Raw byte number 5.
byte6

Raw byte number 6.
byte7

Raw byte number 7.
byte8

Raw byte number 8.
byte9

Raw byte number 9.
byte10

Raw byte number 10.
byte11

Raw byte number 11.
byte12

Raw byte number 12.
byte13

Raw byte number 13.
byte14

Raw byte number 14.
byte15

Raw byte number 15.
Return Value

A CFUUID object. Ownership follows the Get Rule.
Discussion

This function can be used in headers to declare a UUID constant with #define. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDGetConstantUUIDWithBytes (
   CFAllocatorRef alloc,
   UInt8 byte0,
   UInt8 byte1,
   UInt8 byte2,
   UInt8 byte3,
   UInt8 byte4,
   UInt8 byte5,
   UInt8 byte6,
   UInt8 byte7,
   UInt8 byte8,
   UInt8 byte9,
   UInt8 byte10,
   UInt8 byte11,
   UInt8 byte12,
   UInt8 byte13,
   UInt8 byte14,
   UInt8 byte15
);

/*CFUUIDCreateFromUUIDBytes

Creates a CFUUID object from raw UUID bytes.

CFUUIDRef CFUUIDCreateFromUUIDBytes (
   CFAllocatorRef alloc,
   CFUUIDBytes bytes
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
bytes

Raw UUID bytes to use to create the CFUUID object. 
Return Value

A new CFUUID object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDCreateFromUUIDBytes (
   CFAllocatorRef alloc,
   CFUUIDBytes bytes
);

/*CFUUIDCreateFromString

Creates a CFUUID object for a specified string.

CFUUIDRef CFUUIDCreateFromString (
   CFAllocatorRef alloc,
   CFStringRef uuidStr
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
uuidStr

A string containing a UUID. The standard format for UUIDs represented in ASCII is a string punctuated by hyphens, for example 68753A44-4D6F-1226-9C60-0050E4C00067.
Return Value

A new CFUUID object, or if a CFUUID object of the same value already exists, the existing instance with its reference count incremented. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDCreateFromString (
   CFAllocatorRef alloc,
   CFStringRef uuidStr
);

/*CFUUIDCreateString

Returns the string representation of a specified CFUUID object.

CFStringRef CFUUIDCreateString (
   CFAllocatorRef alloc,
   CFUUIDRef uuid
);
Parameters
alloc

The allocator to use to allocate memory for the new string. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
uuid

The CFUUID object whose string representation to obtain. 
Return Value

The string representation of uuid. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFUUIDCreateString (
   CFAllocatorRef alloc,
   CFUUIDRef uuid
);

/*CFUUIDCreate

Creates a Universally Unique Identifier (UUID) object.

CFUUIDRef CFUUIDCreate (
   CFAllocatorRef alloc
);
Parameters
alloc

The allocator to use to allocate memory for the new CFUUID object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
Return Value

A new CFUUID object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFUUIDRef CFUUIDCreate (
   CFAllocatorRef alloc
);


#ifdef __cplusplus
}
#endif

#endif
