#ifndef SCRIPT_H
#define SCRIPT_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef INTLRESOURCES_H
#include <CarbonCore/IntlResources.h>
#endif

//#include <HYS/CarbonCore/Script.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Script Constants

Specify constants used to get and set script variables.

enum {
   smScriptNumDate = 30,
   smScriptKeys = 32,
   smScriptIcon = 34,
   smScriptPrint = 36,
   smScriptTrap = 38,
   smScriptCreator = 40,
   smScriptFile = 42,
   smScriptName = 44,
   smScriptMonoFondSize = 78,
   smScriptPrefFondSize = 80,
   smScriptSmallFondSize = 82,
   smScriptSysFondSize = 84,
   smScriptAppFondSize = 86,
   smScriptHelpFondSize = 88,
   smScriptValidStyles = 90,
   smScriptAliasStyle = 92
};
Constants
smScriptNumDate

(2 bytes) The numeral code and calendar code for the script. The numeral code specifies the kind of numerals the script uses, and is in the high-order byte of the word the calendar code specifies the type of calendar it uses and is in the low-order byte of the word. The value of this variable is initialized from the script system’s international bundle resource. It may be changed during execution when the user selects, for example, a new calendar from a script system’s control panel. See “Numeral Codes” and “Calendar Codes” for the different codes.

Available in Mac OS X v10.0 and later.
smScriptKeys

(2 bytes) The resource ID of the script’s current keyboard-layout ('KCHR') resource. The keyboard-layout resource is used to map virtual key codes into the correct character codes for the script. The value of this variable is initialized from the script system’s international bundle resource. It is updated when the user selects a new keyboard layout, or when the application calls the KeyScript function. You can force a particular keyboard layout to be used with your application by setting the value of this variable and then calling KeyScript.

Available in Mac OS X v10.0 and later.
smScriptIcon

(2 bytes) The resource ID of the script’s keyboard icon family (resource types 'kcs#', 'kcs4', and 'kcs8'). The keyboard icon family consists of the keyboard icons displayed in the keyboard menu. The value of this variable is initialized from the script system’s international bundle resource. Note that, unlike smScriptKeys, the value of this variable is not automatically updated when the keyboard layout changes. (System software assumes that the icon family has an identical ID to the keyboard-layout resource, and usually ignores this variable.)

Available in Mac OS X v10.0 and later.
smScriptPrint

(4 bytes) The print action function vector, set up by the script system (or by the Script Manager if the smsfAutoInit bit is set) when the script is initialized. 

Available in Mac OS X v10.0 and later.
smScriptTrap

(4 bytes) A pointer to the script’s script-structure dispatch function (for internal use only). 

Available in Mac OS X v10.0 and later.
smScriptCreator

(4 bytes) The 4-character creator type for the script system’s file, that is, the file containing the script system. For the Roman script system, it is 'ZSYS', for WorldScript I it is 'univ', and for World Script II it is 'doub'.

Available in Mac OS X v10.0 and later.
smScriptFile

(4 bytes) A pointer to the Pascal string that contains the name of the script system’s file, that is, the file containing the script system. For the Roman script system, the string is 'System'.

Available in Mac OS X v10.0 and later.
smScriptName

(4 bytes) A pointer to a Pascal string that contains the script system’s name. For the Roman script system and single-byte simple script systems, the string is 'Roman'. For single-byte complex script systems, this name is taken from the encoding/rendering ('itl5') resource. For double-byte script systems, it is taken from the WorldScript II extension and is 'WorldScript II'.

Available in Mac OS X v10.0 and later.
smScriptMonoFondSize

(4 bytes) The default font family ID and size (in points) for monospaced text. The ID is stored in the high-order word, and the size is stored in the low-order word. The value of this variable is taken from the script system’s international bundle resource. Note that not all script systems have a monospaced font.

Available in Mac OS X v10.0 and later.
smScriptPrefFondSize

(4 bytes) Currently not used.

Available in Mac OS X v10.0 and later.
smScriptSmallFondSize

(4 bytes) The default font family ID and size (in points) for small text, generally the smallest font and size combination that is legible on screen. The ID is stored in the high-order word, and the size is stored in the low-order word. Sizes are important for example, a 9-point font may be too small in Chinese. The value of this variable is taken from the script system’s international bundle resource.

Available in Mac OS X v10.0 and later.
smScriptSysFondSize

(4 bytes) The default font family ID and size (in points) for this script system’s preferred system font. The ID is stored in the high-order word, and the size is stored in the low-order word. The value of this variable is taken from the script system’s international bundle resource. 

This variable holds similar information to the variable accessed through the smScriptSysFond selector. If you need font family ID only and don’t want size information, it is simpler to use smScriptSysFond. Note, however, that changing the value of this variable has no effect on the value accessed through smScriptSysFond.

Available in Mac OS X v10.0 and later.
smScriptAppFondSize

(4 bytes) The default font family ID and size (in points) for this script system’s preferred application font. The ID is stored in the high-order word, and the size is stored in the low-order word. The value of this variable is taken from the script system’s international bundle resource. 

This variable holds similar information to the variable accessed through the smScriptAppFond selector. If you need font family ID only and don’t want size information, it is simpler to use smScriptAppFond. Note, however, that changing the value of this variable has no effect on the value accessed through smScriptAppFond.

Available in Mac OS X v10.0 and later.
smScriptHelpFondSize

(4 bytes) The default font family ID and size (in points) for Balloon Help. The ID is stored in the high-order word, and the size is stored in the low-order word. Sizes are important for example, a 9-point font may be too small in Chinese. The value of this variable is taken from the script system’s international bundle resource. 

Available in Mac OS X v10.0 and later.
smScriptValidStyles

(1 byte) The set of all valid styles for the script. For example, the Extended style is not valid in the Arabic script. When the GetScriptVariable function is called with the smScriptValidStyles selector, the low-order byte of the returned value is a style code that includes all of the valid styles for the script (that is, the bit corresponding to each QuickDraw style is set if that style is valid for the specified script). The value of this variable is taken from the script system’s international bundle resource.

Available in Mac OS X v10.0 and later.
smScriptAliasStyle

(1 byte) The style to use for indicating aliases. When the GetScriptVariable function is called with smScriptAliasStyle, the low-order byte of the returned value is the style code that should be used in that script for indicating alias names (for example, in the Roman script system, alias names are indicated in italics). The value of this variable is taken from the script system’s international bundle resource. 

Some script systems, such as Arabic and Hebrew, have private script-system selectors that are unique to those scripts. Those private selectors are negative, whereas selectors that extend across script systems are positive.

Available in Mac OS X v10.0 and later.*/
enum {
   smScriptNumDate = 30,
   smScriptKeys = 32,
   smScriptIcon = 34,
   smScriptPrint = 36,
   smScriptTrap = 38,
   smScriptCreator = 40,
   smScriptFile = 42,
   smScriptName = 44,
   smScriptMonoFondSize = 78,
   smScriptPrefFondSize = 80,
   smScriptSmallFondSize = 82,
   smScriptSysFondSize = 84,
   smScriptAppFondSize = 86,
   smScriptHelpFondSize = 88,
   smScriptValidStyles = 90,
   smScriptAliasStyle = 92
};


/*Character Byte Types

Specify character byte types.

enum {
   smSingleByte = 0,
   smFirstByte = -1,
   smLastByte = 1,
   smMiddleByte = 2
};
Constants
smSingleByte

Specifes a single byte.

Available in Mac OS X v10.0 and later.
smFirstByte

Specifies the first byte.

Available in Mac OS X v10.0 and later.
smLastByte

Specifies the last byte.

Available in Mac OS X v10.0 and later.
smMiddleByte

Specifies the middle byte.

Available in Mac OS X v10.0 and later.*/
enum {
   smSingleByte = 0,
   smFirstByte = -1,
   smLastByte = 1,
   smMiddleByte = 2
};

/*Table Selectors

Specify selectors for the international table

enum {
   smWordSelectTable = 0,
   smWordWrapTable = 1,
   smNumberPartsTable = 2,
   smUnTokenTable = 3,
   smWhiteSpaceList = 4,
   iuWordSelectTable = 0,
   iuWordWrapTable = 1,
   iuNumberPartsTable = 2,
   iuUnTokenTable = 3,
   iuWhiteSpaceList = 4
};
Constants
smWordSelectTable

Specifies to get the word select break table from 'itl2'.

Available in Mac OS X v10.0 and later.
smWordWrapTable

Specifies to get the word wrap break table from 'itl2' .

Available in Mac OS X v10.0 and later.
smNumberPartsTable

Specifies to get the default number parts table from 'itl4'.

Available in Mac OS X v10.0 and later.
smUnTokenTable

Specifies to get the unToken table from 'itl4' .

Available in Mac OS X v10.0 and later.
smWhiteSpaceList

Specifies to get the white space list from 'itl4' .

Available in Mac OS X v10.0 and later.
iuWordSelectTable

Obsolete; specifies to get the word select break table from 'itl2' .

Available in Mac OS X v10.0 and later.
iuWordWrapTable

Obsolete; specifies to get the word wrap break table from 'itl2' .

Available in Mac OS X v10.0 and later.
iuNumberPartsTable

Obsolete; specifies to get the default number parts table from ''itl4'.

Available in Mac OS X v10.0 and later.
iuUnTokenTable

Obsolete; specifies to get the unToken table from 'itl4'.

Available in Mac OS X v10.0 and later.
iuWhiteSpaceList

Obsolete; specifies to get the white space list from 'itl4'.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be used as the value of the tableCode variable, passed as a parameter to the GetIntlResourceTable function.*/

enum {
   smWordSelectTable = 0,
   smWordWrapTable = 1,
   smNumberPartsTable = 2,
   smUnTokenTable = 3,
   smWhiteSpaceList = 4,
   iuWordSelectTable = 0,
   iuWordWrapTable = 1,
   iuNumberPartsTable = 2,
   iuUnTokenTable = 3,
   iuWhiteSpaceList = 4
};

/*Meta Script Codes

Specify implicit script codes.

enum {
   smSystemScript = -1,
   smCurrentScript = -2,
   smAllScripts = -3
};
Constants
smSystemScript

Specifies the system script.

Available in Mac OS X v10.0 and later.
smCurrentScript

Specifies the font script.

Available in Mac OS X v10.0 and later.
smAllScripts

Specfies any script.

Available in Mac OS X v10.0 and later.
Discussion

You can specify script systems with implicit and explicit script code constants in the script parameter of the GetScriptVariable and SetScriptVariable functions. The implicit script codes smSystemScript and smCurrentScript are special negative values for the system script and the font script, respectively.*/
enum {
   smSystemScript = -1,
   smCurrentScript = -2,
   smAllScripts = -3
};


/*Script Manager Selectors

Specify selectors you can use with the functions GetScriptManagerVariable and SetScriptManagerVariable.

enum {
   smVersion = 0,
   smMunged = 2,
   smEnabled = 4,
   smBidirect = 6,
   smFontForce = 8,
   smIntlForce = 10,
   smForced = 12,
   smDefault = 14,
   smPrint = 16,
   smSysScript = 18,
   smLastScript = 20,
   smKeyScript = 22,
   smSysRef = 24,
   smKeyCache = 26,
   smKeySwap = 28,
   smGenFlags = 30,
   smOverride = 32,
   smCharPortion = 34,
   smDoubleByte = 36,
   smKCHRCache = 38,
   smRegionCode = 40,
   smKeyDisableState = 42
};
Constants
smVersion

The Script Manager version number (2 bytes) . This variable has the same format as the version number obtained from calling the Gestalt function with the Gestalt selector gestaltScriptMgrVersion. The high-order byte contains the major version number, and the low-order byte contains the minor version number.

Available in Mac OS X v10.0 and later.
smMunged

The modification count for Script Manager variables (2 bytes) . At startup, smMunged is initialized to 0, and it is incremented when the KeyScript function changes the current keyboard script and updates the variables accessed via smKeyScript and smLastScript. The smMunged selector is also incremented when the SetScriptManagerVariable function is used to change a Script Manager variable. You can check this variable at any time to see whether any of your own data structures that may depend on Script Manager variables need to be updated.

Available in Mac OS X v10.0 and later.
smEnabled

The script count (1 byte) ; the number of currently enabled script systems. At startup time, the Script Manager initializes the script count to 0, then increments it for each installed and enabled script system (including Roman). You can use smEnabled to determine whether more than one script system is installed—that is, whether your application needs to handle non-Roman text.

Never call SetScriptManagerVariable with the smEnabled selector. It could result in inconsistency with other script system values.

Available in Mac OS X v10.0 and later.
smBidirect

The bidirectional flag, which indicates when at least one bidirectional script system is enabled. This flag is set to TRUE ($FF) if the Arabic or Hebrew script system is enabled.

Available in Mac OS X v10.0 and later.
smFontForce

The font force flag (1 byte). At startup, the Script Manager sets its value from the system script’s international configuration ('itlc') resource. The flag returns 0 for FALSE and $FF for TRUE. If the system script is non-Roman, the font force flag controls whether a font with ID in the Roman script range is interpreted as belonging to the Roman script or to the system script.

When you call SetScriptManagerVariable with the smFontForce selector, be sure to pass only the value 0 or $FF, or a later call to GetScriptManagerVariable may return an unrecognized value. 

Available in Mac OS X v10.0 and later.
smIntlForce

The international resources selection flag (1 byte). At startup, the Script Manager sets its value from the system script’s international configuration ('itlc') resource. The flag returns 0 for FALSE and $FF for TRUE. This flag controls whether international resources of the font script or the system script are used for string manipulation.

When you call SetScriptManagerVariable with the smIntlForce selector, be sure to pass only the value 0 or $FF, or a later call to GetScriptManagerVariable may return an unrecognized value.

Available in Mac OS X v10.0 and later.
smForced

The script-forced result flag (1 byte). If the current script has been forced to the system script, this flag is set to TRUE. Use the smForced selector to obtain reports of the actions of the FontScript, FontToScript, and IntlScript functions. This variable is for information only; never set its value with SetScriptManagerVariable.

Available in Mac OS X v10.0 and later.
smDefault

The script-defaulted result flag (1 byte). If the script system corresponding to a specified font is not available, this flag is set to TRUE. Use this selector to obtain reports of the actions of the FontScript, FontToScript, and IntlScript functions. This variable is for information only; never set its value with SetScriptManagerVariable.

Available in Mac OS X v10.0 and later.
smPrint

The print action function vector, set up by the Script Manager at startup (4 bytes).

Available in Mac OS X v10.0 and later.
smSysScript

The system script code (2 bytes) . At startup, the Script Manager initializes this variable from the system script’s international configuration ('itlc') resource. This variable is for information only; never set its value with SetScriptManagerVariable. Constants for all defined script codes are listed in “Region Codes A”.

Available in Mac OS X v10.0 and later.
smLastScript

The previously used keyboard script (2 bytes). When you change keyboard scripts with the KeyScript function, the Script Manager moves the old value of smKeyScript into smLastScript. KeyScript can also swap the current keyboard script with the previous keyboard script, in which case the contents of smLastScript and smKeyScript are swapped. Constants for all defined script codes are listed in “Region Codes A”. Never set the value of this variable with SetScriptManagerVariable.

Available in Mac OS X v10.0 and later.
smKeyScript

The current keyboard script (2 bytes) . The KeyScript function tests and updates this variable. When you change keyboard scripts with the KeyScript function, the Script Manager moves the old value of smKeyScript into smLastScript. KeyScript can also swap the current keyboard script with the previous keyboard script, in which case the contents of smLastScript and smKeyScript are swapped. The Script Manager also uses this variable to get the proper keyboard icon and to retrieve the proper keyboard-layout ('KCHR') resource. Constants for all defined script codes are listed in “Region Codes A”. Never set the value of this variable directly with SetScriptManagerVariable; call KeyScript to change keyboard scripts.

Available in Mac OS X v10.0 and later.
smSysRef

The System Folder volume reference number (2 bytes) . Its value is initialized from the system global variable BootDrive at startup.

Available in Mac OS X v10.0 and later.
smKeyCache

An obsolete variable (4 bytes). This variable at one time held a pointer to the keyboard cache. The value it provided was not correct and should not be used.

Available in Mac OS X v10.0 and later.
smKeySwap

A handle to the keyboard-swap ('KSWP') resource (4 bytes). The Script Manager initializes the handle at startup. The keyboard-swap resource controls the key combinations with which the user can invoke various actions with the KeyScript function, such as switching among script systems.

Available in Mac OS X v10.0 and later.
smGenFlags

The general flags used by the Script Manager (4 bytes). The Script Manager general flags is a long word value its high-order byte is set from the flags byte in the system script’s international configuration ('itlc') resource. These constants are available to designate bits in the variable accessed through smGenFlags:
smfNameTagEnab (a value of 29)Reserved for internal use.
smfDualCaret (a value of 30)Use a dual caret for mixed-directional text.
smfShowIcon (a value of 31)Show the keyboard menu even if only one keyboard layout or one script (Roman) is available. (This bit is checked only at system startup.)

Available in Mac OS X v10.0 and later.
smOverride

The script override flags (4 bytes). At present, these flags are not set or used by the Script Manager. They are, however, reserved for future use.

Available in Mac OS X v10.0 and later.
smCharPortion

A value used by script systems to allocate intercharacter and interword spacing when justifying text (2 bytes). It denotes the weight allocated to intercharacter space versus interword space. The value of this variable is initialized to 10 percent by the Script Manager, although it currently has no effect on text of the Roman script system. The variable is in 4.12 fixed-point format, which is a 16-bit signed number with 4 bits of integer and 12 bits of fraction. (In that format, 10 percent has the hexadecimal value $0199.)

Available in Mac OS X v10.0 and later.
smDoubleByte

The double-byte flag, a Boolean value that is TRUE if at least one double-byte script system is enabled. (1 byte) 

Available in Mac OS X v10.0 and later.
smKCHRCache

(A pointer to the cache that stores a copy of the current keyboard-layout ('KCHR') resource 4 bytes).

Available in Mac OS X v10.0 and later.
smRegionCode

The region code for this localized version of system software, obtained from the system script’s international configuration ('itlc') resource. This variable identifies the localized version of the system script. Constants for all defined region codes are listed in “Region Codes A” (2 bytes).

Available in Mac OS X v10.0 and later.
smKeyDisableState

The current disable state for keyboards (1 byte). The Script Manager disables some keyboard scripts or keyboard switching when text input must be restricted to certain script systems or when script systems are being moved into or out of the System file. These are the possible values for the variable accessed through smKeyDisableState:
0All keyboards are enabled; switching is enabled.
1Keyboard switching is disabled.
$FFKeyboards for all non-Roman secondary scripts are disabled 

The script management system maintains the keyboard disable state separately for each application. Never set the value of this variable directly with SetScriptManagerVariable; call KeyScript to change the keyboard disable state for your application.

Available in Mac OS X v10.0 and later.
Discussion

This section lists and describes the selector constants for accessing the Script Manager variables through calls to the GetScriptManagerVariable and SetScriptManagerVariable functions. In every case the variable parameter passed to or from the function is a long integer (4 bytes); the number in parentheses indicates how many of the 4 bytes are necessary to hold the input or return value for that variable. If fewer than 4 bytes are needed, the low byte or low word contains the information.*/

enum {
   smVersion = 0,
   smMunged = 2,
   smEnabled = 4,
   smBidirect = 6,
   smFontForce = 8,
   smIntlForce = 10,
   smForced = 12,
   smDefault = 14,
   smPrint = 16,
   smSysScript = 18,
   smLastScript = 20,
   smKeyScript = 22,
   smSysRef = 24,
   smKeyCache = 26,
   smKeySwap = 28,
   smGenFlags = 30,
   smOverride = 32,
   smCharPortion = 34,
   smDoubleByte = 36,
   smKCHRCache = 38,
   smRegionCode = 40,
   smKeyDisableState = 42
};


/*Script Codes

Specify Mac OS encodings that are related to a FOND ID range.

enum {
   smRoman = 0,
   smJapanese = 1,
   smTradChinese = 2,
   smKorean = 3,
   smArabic = 4,
   smHebrew = 5,
   smGreek = 6,
   smCyrillic = 7,
   smRSymbol = 8,
   smDevanagari = 9,
   smGurmukhi = 10,
   smGujarati = 11,
   smOriya = 12,
   smBengali = 13,
   smTamil = 14,
   smTelugu = 15,
   smKannada = 16,
   smMalayalam = 17,
   smSinhalese = 18,
   smBurmese = 19,
   smKhmer = 20,
   smThai = 21,
   smLao = 22,
   smGeorgian = 23,
   smArmenian = 24,
   smSimpChinese = 25,
   smTibetan = 26,
   smMongolian = 27,
   smEthiopic = 28,
   smGeez = 28,
   smCentralEuroRoman = 29,
   smVietnamese = 30,
   smExtArabic = 31,
   smUninterp = 32
};
Constants
smRoman

Specifies the Roman script system.

Available in Mac OS X v10.0 and later.
smJapanese

Specifies the Japanese script system.

Available in Mac OS X v10.0 and later.
smTradChinese

Specifies the traditional Chinese script system.

Available in Mac OS X v10.0 and later.
smKorean

Specifies the Korean script system.

Available in Mac OS X v10.0 and later.
smArabic

Specifies the Arabic script system.

Available in Mac OS X v10.0 and later.
smHebrew

Specifies the Hebrew script system.

Available in Mac OS X v10.0 and later.
smGreek

Specifies the Greek script system.

Available in Mac OS X v10.0 and later.
smCyrillic

Specifies the Cyrillic script system.

Available in Mac OS X v10.0 and later.
smRSymbol

Specifies right-to-left symbols. The script code represented by the constant smRSymbol is available as an alternative to smUninterp, for representation of special symbols that have a right-to-left line direction. Note, however, that the script management system provides no direct support for representation of text with this script code.

Available in Mac OS X v10.0 and later.
smDevanagari

Specifies the Devanagari script system.
Script Codes

Specify Mac OS encodings that are related to a FOND ID range.

enum {
   smRoman = 0,
   smJapanese = 1,
   smTradChinese = 2,
   smKorean = 3,
   smArabic = 4,
   smHebrew = 5,
   smGreek = 6,
   smCyrillic = 7,
   smRSymbol = 8,
   smDevanagari = 9,
   smGurmukhi = 10,
   smGujarati = 11,
   smOriya = 12,
   smBengali = 13,
   smTamil = 14,
   smTelugu = 15,
   smKannada = 16,
   smMalayalam = 17,
   smSinhalese = 18,
   smBurmese = 19,
   smKhmer = 20,
   smThai = 21,
   smLao = 22,
   smGeorgian = 23,
   smArmenian = 24,
   smSimpChinese = 25,
   smTibetan = 26,
   smMongolian = 27,
   smEthiopic = 28,
   smGeez = 28,
   smCentralEuroRoman = 29,
   smVietnamese = 30,
   smExtArabic = 31,
   smUninterp = 32
};
Constants
smRoman

Specifies the Roman script system.

Available in Mac OS X v10.0 and later.
smJapanese

Specifies the Japanese script system.

Available in Mac OS X v10.0 and later.
smTradChinese

Specifies the traditional Chinese script system.

Available in Mac OS X v10.0 and later.
smKorean

Specifies the Korean script system.

Available in Mac OS X v10.0 and later.
smArabic

Specifies the Arabic script system.

Available in Mac OS X v10.0 and later.
smHebrew

Specifies the Hebrew script system.

Available in Mac OS X v10.0 and later.
smGreek

Specifies the Greek script system.

Available in Mac OS X v10.0 and later.
smCyrillic

Specifies the Cyrillic script system.

Available in Mac OS X v10.0 and later.
smRSymbol

Specifies right-to-left symbols. The script code represented by the constant smRSymbol is available as an alternative to smUninterp, for representation of special symbols that have a right-to-left line direction. Note, however, that the script management system provides no direct support for representation of text with this script code.

Available in Mac OS X v10.0 and later.
smDevanagari

Specifies the Devanagari script system.

Available in Mac OS X v10.0 and later.
smGurmukhi

Specifies the Gurmukhi script system.

Available in Mac OS X v10.0 and later.
smGujarati

Specifies the Gujarati script system.

Available in Mac OS X v10.0 and later.
smOriya

Specifies the Oriya script system.

Available in Mac OS X v10.0 and later.
smBengali

Specifies the Bengali script system.

Available in Mac OS X v10.0 and later.
smTamil

Specifies the Tamil script system.

Available in Mac OS X v10.0 and later.
smTelugu

Specifies the Telugu script system.

Available in Mac OS X v10.0 and later.
smKannada

Specifies the Kannada/Kanarese script system.

Available in Mac OS X v10.0 and later.
smMalayalam

Specifies the Malayalam script system.

Available in Mac OS X v10.0 and later.
smSinhalese

Specifies the Sinhalese script system.

Available in Mac OS X v10.0 and later.
smBurmese

Specifies the Burmese script system.

Available in Mac OS X v10.0 and later.
smKhmer

Specifies the Khmer script system.

Available in Mac OS X v10.0 and later.
smThai

Specifies the Thai script system.

Available in Mac OS X v10.0 and later.
smLao

Specifies the Laotian script system.

Available in Mac OS X v10.0 and later.
smGeorgian

Specifies the Georgian script system.

Available in Mac OS X v10.0 and later.
smArmenian

Specifies the Armenian script system.

Available in Mac OS X v10.0 and later.
smSimpChinese

Specifies the simplified Chinese script system.

Available in Mac OS X v10.0 and later.
smTibetan

Specifies the Tibetan script system.

Available in Mac OS X v10.0 and later.
smMongolian

Specifies the Mongolian script system.

Available in Mac OS X v10.0 and later.
smEthiopic

Specifies the Geez/Ethiopic script system. This constant is the same as smGeez.

Available in Mac OS X v10.0 and later.
smGeez

Specifies the Geez/Ethiopic script system.

Available in Mac OS X v10.0 and later.
smCentralEuroRoman

Used for Czech, Slovak, Polish, Hungarian, Baltic languages.

Available in Mac OS X v10.0 and later.
smVietnamese

Specifies the Extended Roman script system for Vietnamese.

Available in Mac OS X v10.0 and later.
smExtArabic

Specifies the extended Arabic for Sindhi script system. 

Available in Mac OS X v10.0 and later.
smUninterp

Uninterpreted symbols. The script code represented by the constant smUninterp is available for representation of special symbols, such as items in a tool palette, that must not be considered as part of any actual script system. For manipulating and drawing such symbols, the smUninterp constant should be treated as if it indicated the Roman script system rather than the system script; that is, the default behavior of uninterpreted symbols should be Roman.

Available in Mac OS X v10.0 and later.
Available in Mac OS X v10.0 and later.
smGurmukhi

Specifies the Gurmukhi script system.

Available in Mac OS X v10.0 and later.
smGujarati

Specifies the Gujarati script system.

Available in Mac OS X v10.0 and later.
smOriya

Specifies the Oriya script system.

Available in Mac OS X v10.0 and later.
smBengali

Specifies the Bengali script system.

Available in Mac OS X v10.0 and later.
smTamil

Specifies the Tamil script system.

Available in Mac OS X v10.0 and later.
smTelugu

Specifies the Telugu script system.

Available in Mac OS X v10.0 and later.
smKannada

Specifies the Kannada/Kanarese script system.

Available in Mac OS X v10.0 and later.
smMalayalam

Specifies the Malayalam script system.

Available in Mac OS X v10.0 and later.
smSinhalese

Specifies the Sinhalese script system.

Available in Mac OS X v10.0 and later.
smBurmese

Specifies the Burmese script system.

Available in Mac OS X v10.0 and later.
smKhmer

Specifies the Khmer script system.

Available in Mac OS X v10.0 and later.
smThai

Specifies the Thai script system.

Available in Mac OS X v10.0 and later.
smLao

Specifies the Laotian script system.

Available in Mac OS X v10.0 and later.
smGeorgian

Specifies the Georgian script system.

Available in Mac OS X v10.0 and later.
smArmenian

Specifies the Armenian script system.

Available in Mac OS X v10.0 and later.
smSimpChinese

Specifies the simplified Chinese script system.

Available in Mac OS X v10.0 and later.
smTibetan

Specifies the Tibetan script system.

Available in Mac OS X v10.0 and later.
smMongolian

Specifies the Mongolian script system.

Available in Mac OS X v10.0 and later.
smEthiopic

Specifies the Geez/Ethiopic script system. This constant is the same as smGeez.

Available in Mac OS X v10.0 and later.
smGeez

Specifies the Geez/Ethiopic script system.

Available in Mac OS X v10.0 and later.
smCentralEuroRoman

Used for Czech, Slovak, Polish, Hungarian, Baltic languages.

Available in Mac OS X v10.0 and later.
smVietnamese

Specifies the Extended Roman script system for Vietnamese.

Available in Mac OS X v10.0 and later.
smExtArabic

Specifies the extended Arabic for Sindhi script system. 

Available in Mac OS X v10.0 and later.
smUninterp

Uninterpreted symbols. The script code represented by the constant smUninterp is available for representation of special symbols, such as items in a tool palette, that must not be considered as part of any actual script system. For manipulating and drawing such symbols, the smUninterp constant should be treated as if it indicated the Roman script system rather than the system script; that is, the default behavior of uninterpreted symbols should be Roman.

Available in Mac OS X v10.0 and later.*/

enum {
   smRoman = 0,
   smJapanese = 1,
   smTradChinese = 2,
   smKorean = 3,
   smArabic = 4,
   smHebrew = 5,
   smGreek = 6,
   smCyrillic = 7,
   smRSymbol = 8,
   smDevanagari = 9,
   smGurmukhi = 10,
   smGujarati = 11,
   smOriya = 12,
   smBengali = 13,
   smTamil = 14,
   smTelugu = 15,
   smKannada = 16,
   smMalayalam = 17,
   smSinhalese = 18,
   smBurmese = 19,
   smKhmer = 20,
   smThai = 21,
   smLao = 22,
   smGeorgian = 23,
   smArmenian = 24,
   smSimpChinese = 25,
   smTibetan = 26,
   smMongolian = 27,
   smEthiopic = 28,
   smGeez = 28,
   smCentralEuroRoman = 29,
   smVietnamese = 30,
   smExtArabic = 31,
   smUninterp = 32
};



/*language Codes A

Specify language codes (values 0 though 23).

enum {
   langEnglish = 0,
   langFrench = 1,
   langGerman = 2,
   langItalian = 3,
   langDutch = 4,
   langSwedish = 5,
   langSpanish = 6,
   langDanish = 7,
   langPortuguese = 8,
   langNorwegian = 9,
   langHebrew = 10,
   langJapanese = 11,
   langArabic = 12,
   langFinnish = 13,
   langGreek = 14,
   langIcelandic = 15,
   langMaltese = 16,
   langTurkish = 17,
   langCroatian = 18,
   langTradChinese = 19,
   langUrdu = 20,
   langHindi = 21,
   langThai = 22,
   langKorean = 23
};
Constants
langEnglish

Represents the English language. The associated script code is smRoman.

Available in Mac OS X v10.0 and later.
langFrench

Represents the French language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langGerman

Represents the German language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langItalian

Represents the Italian language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langDutch

Represents the Dutch language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langSwedish

Represents the Swedish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langSpanish

Represents the Spanish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langDanish

Represents the Danish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langPortuguese

Represents the Portuguese language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langNorwegian

Represents the Norwegian language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langHebrew

Represents the Hebrew language. The associated script code is smHebrew. 

Available in Mac OS X v10.0 and later.
langJapanese

Represents the Japanese language. The associated script code is smJapanese. 

Available in Mac OS X v10.0 and later.
langArabic

Represents the Arabic language. The associated script code is smArabic. 

Available in Mac OS X v10.0 and later.
langFinnish

Represents the Finnish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langGreek

Represents the Greek language. The associated script code is smGreek. 

Available in Mac OS X v10.0 and later.
langIcelandic

Represents the Icelandic language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langMaltese

Represents the Maltese language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langTurkish

Represents the Turkish language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langCroatian

Represents the Croatian language. The associated script code is smRoman. 

Available in Mac OS X v10.0 and later.
langTradChinese

Represents the Chinese (traditional chararacters) language. The associated script code is smTradChinese.

Available in Mac OS X v10.0 and later.
langUrdu

Represents the Urdu language. The associated script code is smArabic. 

Available in Mac OS X v10.0 and later.
langHindi

Represents the Hindi language. The associated script code is smDevanagari. 

Available in Mac OS X v10.0 and later.
langThai

Represents the Thai language. The associated script code is smThai. 

Available in Mac OS X v10.0 and later.
langKorean

Represents the Korean language. The associated script code is smKorean. 

Available in Mac OS X v10.0 and later.*/
enum {
   langEnglish = 0,
   langFrench = 1,
   langGerman = 2,
   langItalian = 3,
   langDutch = 4,
   langSwedish = 5,
   langSpanish = 6,
   langDanish = 7,
   langPortuguese = 8,
   langNorwegian = 9,
   langHebrew = 10,
   langJapanese = 11,
   langArabic = 12,
   langFinnish = 13,
   langGreek = 14,
   langIcelandic = 15,
   langMaltese = 16,
   langTurkish = 17,
   langCroatian = 18,
   langTradChinese = 19,
   langUrdu = 20,
   langHindi = 21,
   langThai = 22,
   langKorean = 23
};

/*GetIntlResourceTable

Obtains a specific word-selection, line-break, number-parts, untoken, or whitespace table from the appropriate international resource. (Deprecated in Mac OS X v10.4. There is no replacement because this function is no longer needed in Mac OS X.)

void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);
Parameters
script

A script code, the value that specifies a particular script system. Constants for all defined script codes are listed in “Meta Script Codes”. 
tableCode

A number that specifies which table is requested. The constants for tableCode are detailed in “Table Selectors”. 
itlHandle

On return, a handle to the string-manipulation ('itl2') or tokens ('itl4') resource containing the table specified in the tableCode parameter. If the script system whose table is requested is not available, GetIntlResourceTable returns a NULL handle. 
offset

On return, a pointer to the offset (in bytes) to the specified table from the beginning of the resource. 
length

On return, a pointer to the size of the table (in bytes).
Discussion

When you provide a script code in the script parameter, and a table code in the tableCode parameter, GetIntlResourceTable returns a handle to the string-manipulation resource or tokens resource containing that table, the offset of the specified table from the beginning of the resource, and the length of the table. 

If you wish to manipulate the contents of the table you have requested, use the size returned in the length parameter to allocate a buffer, and perform a block move of the table’s contents into that buffer. 
Special Considerations

GetIntlResourceTable may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
void GetIntlResourceTable (
   ScriptCode script,
   short tableCode,
   Handle * itlHandle,
   long * offset,
   long * length
);

/*GetScriptManagerVariable

Retrieves the value of the specified Script Manager variable.

long GetScriptManagerVariable (
   short selector
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you need, use one of the selector constants listed in “Script Manager Selectors”. 
Return Value

The current value of the specified Script Manager variable or 0 if the selector is invalid. For some valid selectors, 0 may also be a valid return value. For example, when you call GetScriptManagerVariable with a selector value of smRegionCode on a version of Macintosh system software that has been localized for the United States, it returns 0. Although GetScriptManagerVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptManagerVariable; the remaining bytes are set to 0.
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/


long GetScriptManagerVariable (
   short selector
);

/*CharacterByteType

Identifies a byte in a text buffer as a single-byte character or as the first or second byte of a double-byte character. (Deprecated in Mac OS X v10.4. You should update your application to handle Unicode text. There is no replacement function because Unicode handles encoding in a different manner.)

short CharacterByteType (
   Ptr textBuf,
   short textOffset,
   ScriptCode script
);
Parameters
textBuf

A pointer to a text buffer containing the byte to be identified. 
textOffset

The offset to the byte to be identified. The offset is measured in bytes; the first byte has an offset of 0. 
script

A value that specifies the script system of the text in the buffer. Constants for all defined script codes are listed on “Meta Script Codes”. To specify the font script, pass smCurrentScript in this parameter. 
Return Value

One of three identifications: a single-byte character, the first byte of a double-byte character, or the second byte of a double-byte character. The first byte of a double-byte character—the one at the lower offset in memory—is the high-order byte the second byte of a double-byte character—the one at the higher offset—is the low-order byte. This is the same order in which text is processed and numbers are represented. 
Discussion

The script system associated with the character you wish to examine must be enabled in order for the function to provide useful information. For example, if only the Roman script system is available and you attempt to identify a byte in a run of double-byte characters, the CharacterByteType function returns 0, indicating that the byte is a single-byte character.

For single-byte script systems, the character-type tables reside in the string-manipulation ('itl2') resource and reflect region-specific or language-specific differences in uppercase conventions.

For double-byte script systems, the character-type tables reside in the encoding/rendering ('itl5') resource, not the string-manipulation resource. Whenever you call CharacterByteType, the necessary character-set encoding information is taken from the encoding/rendering resource. You cannot use the GetIntlResource function to access double-byte character-type tables directly.

From byte value alone, it is not possible to distinguish the second byte of a double-byte character from a single-byte character. CharacterByteType differentiates the second byte of a double-byte character from a single-byte character by assuming that the byte at offset 0 is the first byte of a character. With that assumption, it then sequentially identifies the size and starting position of each character in the buffer up to textOffset. 
Special Considerations

If you specify smCurrentScript for the script parameter, the value returned by CharacterByteType can be affected by the state of the font force flag. It is unaffected by the state of the international resources selection flag.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short CharacterByteType (
   Ptr textBuf,
   short textOffset,
   ScriptCode script
);

/*GetScriptVariable

Retrieves the value of the specified script variable from the specified script system.

long GetScriptVariable (
   short script,
   short selector
);
Parameters
script

A value that specifies the script system whose variable you are accessing. Use one of the script-code constants listed in “Meta Script Codes”. 
selector

A value that specifies a particular script variable. Use one of the selector constants listed in “Script Variable Selectors”. Valid selector values are defined by each script system.
Return Value

0 if the selector value is invalid or if the specified script system is not installed. For some valid selectors, 0 may also be a valid return value. For example, calling GetScriptVariable with a selector of smScriptLang on a version of Macintosh system software that has been localized for the United States returns 0. Although GetScriptVariable always returns a long integer, the actual value may be a long integer, standard integer, or signed byte. If the value is not a long integer, it is stored in the low-order word or byte of the long integer returned by GetScriptVariable; the remaining bytes are set to 0.
Discussion

Each enabled script system maintains a set of variables that control the current settings of that script system, including the ID numbers of its international resources, its preferred fonts and font sizes, and its primary line direction. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/
long GetScriptVariable (
   short script,
   short selector
);

/*GetSysDirection

Returns the current value of SysDirection, the global variable that determines the system direction (primary line direction). (Deprecated in Mac OS X v10.4. This function does not return anything useful in Mac OS X.)

short GetSysDirection ();
Parameters
Return Value

The current value of SysDirection: 0 if the system direction is left-to-right; -1 ($FFFF) if the system direction is right-to-left. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short GetSysDirection ();

/*FontToScript

Translates a font family ID number into its corresponding script code, if that script system is currently enabled. (Deprecated in Mac OS X v10.4. Use ATSFontFamilyGetEncoding instead.)

short FontToScript (
   short fontNumber
);
Parameters
fontNumber

A font family ID number. 
Return Value

A script code. All recognized script codes and their defined constants are listed in “Meta Script Codes”. FontToScript returns only explicit script codes (≥ 0). If fontNumber is in the Roman range and the font force flag is TRUE, the script code returned is that of the system script and the script-forced result flag is set to TRUE. If fontNumber is in the non-Roman range, the state of the font force flag is ignored. If the script system corresponding to fontNumber is not enabled, the script code returned is that of the system script and the script-defaulted result flag is set to TRUE.
Discussion

The information about the script code is subject to two control flags—the font force flag and the international resources selection flag. You can test and set these flags with the GetScriptManagerVariable and SetScriptManagerVariable selectors smFontForce and smIntlForce.

The function starts by initializing two result flags, the script-forced result flag and the script-defaulted result flag, to FALSE. These flags are Script Manager variables, accessed through the GetScriptManagerVariable function selectors smForced and smDefault.

Do not use the function FontToScript to convert resource IDs to scripts codes. 
Special Considerations

FontToScript may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Script.h*/
short FontToScript (
   short fontNumber
);

/*SetScriptManagerVariable

Sets the specified Script Manager variable to the value of the input parameter.

OSErr SetScriptManagerVariable (
   short selector,
   long param
);
Parameters
selector

A value that specifies a particular Script Manager variable. To specify the Script Manager variable whose value you wish to change, use one of the selector constants listed in “Script Manager Selectors”. 
param

The new value for the specified Script Manager variable.

The actual values to be assigned may be long integers, standard integers, or signed bytes. If the value is other than a long integer, you must store it in the low-order word or byte of the param parameter and set the unused bytes to 0.
Return Value

A result code. See “Script Manager Result Codes”. The value smBadVerb if the selector is not valid. Otherwise, the function returns 0 (noErr).
Discussion

The Script Manager maintains a set of variables that control general settings of the text environment, including the identity of the system script and the keyboard script, and the settings of the font force flag and the international resources selection flag.

You may want access to the Script Manager variables in order to understand the current environment or to modify it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Script.h*/
OSErr SetScriptManagerVariable (
   short selector,
   long param
);

#ifdef __cplusplus
}
#endif

#endif