#import <ADD/AppKit/AppKit.h>
#import <AppKit/AppKitDefines.h>
#import <AppKit/NSErrors.h>
#import <Foundation/NSGeometry.h>
#import <Foundation/NSObject.h>
//#include <HYS/AppKit/NSAccessibility.h>
#include <APPLE/AppKit/NSAccessibility.h>

@class NSString, NSArray;

/*Linkage elements

These constants define link attributes.

const NSString *NSAccessibilityLinkedUIElementsAttribute;
const NSString *NSAccessibilityServesAsTitleForUIElementsAttribute;
const NSString *NSAccessibilityTitleUIElementAttribute;
Constants
NSAccessibilityLinkedUIElementsAttribute

Elements corresponding to each other (NSArray).

Available in Mac OS X v10.4 and later.
NSAccessibilityTitleUIElementAttribute

Element’s title element (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityServesAsTitleForUIElementsAttribute

Elements to which title applies (NSArray).

Available in Mac OS X v10.4 and later.
Declared In
NSAccessibility.h*/
extern const NSString *NSAccessibilityLinkedUIElementsAttribute;
extern const NSString *NSAccessibilityServesAsTitleForUIElementsAttribute;
extern const NSString *NSAccessibilityTitleUIElementAttribute;


/*Roles

These constants define standard roles that identify the type of object an accessibility object represents. One of these values is returned as the value for an object’s NSAccessibilityRoleAttribute.

const NSString *NSAccessibilityApplicationRole;
const NSString *NSAccessibilityBrowserRole;
const NSString *NSAccessibilityBusyIndicatorRole;
const NSString *NSAccessibilityButtonRole;
const NSString *NSAccessibilityCheckBoxRole;
const NSString *NSAccessibilityColorWellRole;
const NSString *NSAccessibilityColumnRole;
const NSString *NSAccessibilityComboBoxRole;
const NSString *NSAccessibilityDrawerRole;
const NSString *NSAccessibilityGroupRole;
const NSString *NSAccessibilityGrowAreaRole;
const NSString *NSAccessibilityHelpTagRole;
const NSString *NSAccessibilityImageRole;
const NSString *NSAccessibilityIncrementorRole;
const NSString *NSAccessibilityLinkRole;
const NSString *NSAccessibilityListRole;
const NSString *NSAccessibilityMatteRole;
const NSString *NSAccessibilityMenuBarRole;
const NSString *NSAccessibilityMenuButtonRole;
const NSString *NSAccessibilityMenuItemRole;
const NSString *NSAccessibilityMenuRole;
const NSString *NSAccessibilityOutlineRole;
const NSString *NSAccessibilityPopUpButtonRole;
const NSString *NSAccessibilityProgressIndicatorRole;
const NSString *NSAccessibilityRadioButtonRole;
const NSString *NSAccessibilityRadioGroupRole;
const NSString *NSAccessibilityRowRole;
const NSString *NSAccessibilityRulerMarkerRole;
const NSString *NSAccessibilityRulerRole;
const NSString *NSAccessibilityScrollAreaRole;
const NSString *NSAccessibilityScrollBarRole;
const NSString *NSAccessibilitySheetRole;
const NSString *NSAccessibilitySliderRole;
const NSString *NSAccessibilitySortButtonRole;
const NSString *NSAccessibilitySplitGroupRole;
const NSString *NSAccessibilitySplitterRole;
const NSString *NSAccessibilityStaticTextRole;
const NSString *NSAccessibilitySystemWideRole;
const NSString *NSAccessibilityTabGroupRole;
const NSString *NSAccessibilityTableRole;
const NSString *NSAccessibilityTextAreaRole;
const NSString *NSAccessibilityTextFieldRole;
const NSString *NSAccessibilityToolbarRole;
const NSString *NSAccessibilityUnknownRole;
const NSString *NSAccessibilityValueIndicatorRole;
const NSString *NSAccessibilityWindowRole;
Constants
NSAccessibilityApplicationRole

Application

Available in Mac OS X v10.2 and later.
NSAccessibilityBrowserRole

Browser

Available in Mac OS X v10.2 and later.
NSAccessibilityBusyIndicatorRole

Busy indicator

Available in Mac OS X v10.2 and later.
NSAccessibilityCheckBoxRole

Checkbox

Available in Mac OS X v10.2 and later.
NSAccessibilityColorWellRole

Color well

Available in Mac OS X v10.2 and later.
NSAccessibilityColumnRole

Column

Available in Mac OS X v10.2 and later.
NSAccessibilityComboBoxRole

Combo box

Available in Mac OS X v10.2 and later.
NSAccessibilityDrawerRole

Drawer

Available in Mac OS X v10.2 and later.
NSAccessibilityGroupRole

Group

Available in Mac OS X v10.2 and later.
NSAccessibilityGrowAreaRole

Window’s grow (resize) area

Available in Mac OS X v10.2 and later.
NSAccessibilityHelpTagRole

Help tag.

Available in Mac OS X v10.4 and later.
NSAccessibilityImageRole

Image

Available in Mac OS X v10.2 and later.
NSAccessibilityIncrementorRole

Stepper

Available in Mac OS X v10.2 and later.
NSAccessibilityLinkRole

Link.

Available in Mac OS X v10.4 and later.
NSAccessibilityListRole

List

Available in Mac OS X v10.2 and later.
NSAccessibilityMatteRole

Matte.

Available in Mac OS X v10.4 and later.
NSAccessibilityMenuBarRole

Menu bar

Available in Mac OS X v10.2 and later.
NSAccessibilityMenuButtonRole

Menu button

Available in Mac OS X v10.2 and later.
NSAccessibilityMenuItemRole

Menu item

Available in Mac OS X v10.2 and later.
NSAccessibilityMenuRole

Menu

Available in Mac OS X v10.2 and later.
NSAccessibilityOutlineRole

Outline

Available in Mac OS X v10.2 and later.
NSAccessibilityPopUpButtonRole

Pop-up button

Available in Mac OS X v10.2 and later.
NSAccessibilityProgressIndicatorRole

Progress indicator

Available in Mac OS X v10.2 and later.
NSAccessibilityButtonRole

Button

Available in Mac OS X v10.2 and later.
NSAccessibilityRadioButtonRole

Radio button

Available in Mac OS X v10.2 and later.
NSAccessibilityRadioGroupRole

Radio group

Available in Mac OS X v10.2 and later.
NSAccessibilityRowRole

Row

Available in Mac OS X v10.2 and later.
NSAccessibilityRulerRole

Ruler.

Available in Mac OS X v10.4 and later.
NSAccessibilityRulerMarkerRole

Ruler marker.

Available in Mac OS X v10.4 and later.
NSAccessibilityScrollAreaRole

Scroll view

Available in Mac OS X v10.2 and later.
NSAccessibilityScrollBarRole

Scroll bar

Available in Mac OS X v10.2 and later.
NSAccessibilitySheetRole

Sheet

Available in Mac OS X v10.2 and later.
NSAccessibilitySliderRole

Slider

Available in Mac OS X v10.2 and later.
NSAccessibilitySortButtonRole

Sort button.

Available in Mac OS X v10.4 and later.
NSAccessibilitySplitGroupRole

Split view

Available in Mac OS X v10.2 and later.
NSAccessibilitySplitterRole

Splitter bar of a split view

Available in Mac OS X v10.2 and later.
NSAccessibilityStaticTextRole

Uneditable text

Available in Mac OS X v10.2 and later.
NSAccessibilitySystemWideRole

Special system-wide element

Available in Mac OS X v10.2 and later.
NSAccessibilityTabGroupRole

Tab group

Available in Mac OS X v10.2 and later.
NSAccessibilityTableRole

Table

Available in Mac OS X v10.2 and later.
NSAccessibilityTextAreaRole

Text view

Available in Mac OS X v10.2 and later.
NSAccessibilityTextFieldRole

Text field

Available in Mac OS X v10.2 and later.
NSAccessibilityToolbarRole

Toolbar

Available in Mac OS X v10.2 and later.
NSAccessibilityUnknownRole

Unknown object type

Available in Mac OS X v10.2 and later.
NSAccessibilityValueIndicatorRole

Value indicator

Available in Mac OS X v10.2 and later.
NSAccessibilityWindowRole

Window

Available in Mac OS X v10.2 and later.
Declared In
NSAccessibility.h*/

extern const NSString *NSAccessibilityApplicationRole;
extern const NSString *NSAccessibilityBrowserRole;
extern const NSString *NSAccessibilityBusyIndicatorRole;
extern const NSString *NSAccessibilityButtonRole;
extern const NSString *NSAccessibilityCheckBoxRole;
extern const NSString *NSAccessibilityColorWellRole;
extern const NSString *NSAccessibilityColumnRole;
extern const NSString *NSAccessibilityComboBoxRole;
extern const NSString *NSAccessibilityDrawerRole;
extern const NSString *NSAccessibilityGroupRole;
extern const NSString *NSAccessibilityGrowAreaRole;
extern const NSString *NSAccessibilityHelpTagRole;
extern const NSString *NSAccessibilityImageRole;
extern const NSString *NSAccessibilityIncrementorRole;
extern const NSString *NSAccessibilityLinkRole;
extern const NSString *NSAccessibilityListRole;
extern const NSString *NSAccessibilityMatteRole;
extern const NSString *NSAccessibilityMenuBarRole;
extern const NSString *NSAccessibilityMenuButtonRole;
extern const NSString *NSAccessibilityMenuItemRole;
extern const NSString *NSAccessibilityMenuRole;
extern const NSString *NSAccessibilityOutlineRole;
extern const NSString *NSAccessibilityPopUpButtonRole;
extern const NSString *NSAccessibilityProgressIndicatorRole;
extern const NSString *NSAccessibilityRadioButtonRole;
extern const NSString *NSAccessibilityRadioGroupRole;
extern const NSString *NSAccessibilityRowRole;
extern const NSString *NSAccessibilityRulerMarkerRole;
extern const NSString *NSAccessibilityRulerRole;
extern const NSString *NSAccessibilityScrollAreaRole;
extern const NSString *NSAccessibilityScrollBarRole;
extern const NSString *NSAccessibilitySheetRole;
extern const NSString *NSAccessibilitySliderRole;
extern const NSString *NSAccessibilitySortButtonRole;
extern const NSString *NSAccessibilitySplitGroupRole;
extern const NSString *NSAccessibilitySplitterRole;
extern const NSString *NSAccessibilityStaticTextRole;
extern const NSString *NSAccessibilitySystemWideRole;
extern const NSString *NSAccessibilityTabGroupRole;
extern const NSString *NSAccessibilityTableRole;
extern const NSString *NSAccessibilityTextAreaRole;
extern const NSString *NSAccessibilityTextFieldRole;
extern const NSString *NSAccessibilityToolbarRole;
extern const NSString *NSAccessibilityUnknownRole;
extern const NSString *NSAccessibilityValueIndicatorRole;
extern const NSString *NSAccessibilityWindowRole;

/*Element notifications

NSAccessibility defines the following notifications, which are sent to observing assistive applications when certain events occur. The notifications are sent using the NSAccessibilityPostNotification function instead of an NSNotificationCenter object. 

const NSString *NSAccessibilityCreatedNotification;
const NSString *NSAccessibilityMovedNotification;
const NSString *NSAccessibilityResizedNotification;
const NSString *NSAccessibilityTitleChangedNotification;
const NSString *NSAccessibilityUIElementDestroyedNotification;
const NSString *NSAccessibilityValueChangedNotification;
Constants
NSAccessibilityTitleChangedNotification

Title has changed.

Available in Mac OS X v10.4 and later.
NSAccessibilityUIElementDestroyedNotification

Element has been destroyed

Available in Mac OS X v10.2 and later.
NSAccessibilityValueChangedNotification

Element’s value has changed

Available in Mac OS X v10.2 and later.
Declared In
NSAccessibility.h*/
 
extern const NSString *NSAccessibilityCreatedNotification;
extern const NSString *NSAccessibilityMovedNotification;
extern const NSString *NSAccessibilityResizedNotification;
extern const NSString *NSAccessibilityTitleChangedNotification;
extern const NSString *NSAccessibilityUIElementDestroyedNotification;
extern const NSString *NSAccessibilityValueChangedNotification;

/*Focus-change notifications

NSAccessibility defines the following notifications, which are sent to observing assistive applications when focus-change events occur. The notifications are sent using the NSAccessibilityPostNotification function instead of an NSNotificationCenter object. 

const NSString *NSAccessibilityMainWindowChangedNotification;
const NSString *NSAccessibilityFocusedWindowChangedNotification;
const NSString *NSAccessibilityFocusedUIElementChangedNotification;
Constants
NSAccessibilityMainWindowChangedNotification

Main window has changed

Available in Mac OS X v10.2 and later.
NSAccessibilityFocusedWindowChangedNotification

Key window has changed

Available in Mac OS X v10.2 and later.
NSAccessibilityFocusedUIElementChangedNotification

Element has gained focus

Available in Mac OS X v10.2 and later.
Declared In
NSAccessibility.h*/
extern const NSString *NSAccessibilityMainWindowChangedNotification;
extern const NSString *NSAccessibilityFocusedWindowChangedNotification;
extern const NSString *NSAccessibilityFocusedUIElementChangedNotification;

/*NSAccessibilityPostNotification

Sends a notification to any observing assistive applications.

void NSAccessibilityPostNotification(id element, NSString *notification)
Discussion

Sends notification to any assistive applications that have registered to receive the notification from the user interface object element in your application. Accessibility notifications require special handling, so they cannot be posted using NSNotificationCenter.
Availability
Available in Mac OS X v10.2 and later.*/
void NSAccessibilityPostNotification(id element, NSString *notification);

/*Standard attributes for any object

The following are the standard attributes that can be adopted by any object.

const NSString *NSAccessibilityChildrenAttribute;
const NSString *NSAccessibilityContentsAttribute;
const NSString *NSAccessibilityDescriptionAttribute;
const NSString *NSAccessibilityEnabledAttribute;
const NSString *NSAccessibilityFocusedAttribute;
const NSString *NSAccessibilityHelpAttribute;
const NSString *NSAccessibilityMaxValueAttribute;
const NSString *NSAccessibilityMinValueAttribute;
const NSString *NSAccessibilityParentAttribute;
const NSString *NSAccessibilityPositionAttribute;
const NSString *NSAccessibilityRoleAttribute;
const NSString *NSAccessibilityRoleDescriptionAttribute;
const NSString *NSAccessibilitySelectedChildrenAttribute;
const NSString *NSAccessibilityShownMenuAttribute;
const NSString *NSAccessibilitySizeAttribute;
const NSString *NSAccessibilitySubroleAttribute;
const NSString *NSAccessibilityTitleAttribute;
const NSString *NSAccessibilityTopLevelUIElementAttribute;
const NSString *NSAccessibilityValueAttribute;
const NSString *NSAccessibilityVisibleChildrenAttribute;
const NSString *NSAccessibilityWindowAttribute;
Constants
NSAccessibilityChildrenAttribute

Elements that current element contains (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilityContentsAttribute

Elements that represent the contents in the current element, such as the document view of a scroll view (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilityDescriptionAttribute

Instance description (NSString).

Available in Mac OS X v10.4 and later.
NSAccessibilityEnabledAttribute

Flag indicating enabled state of element (NSNumber)

Available in Mac OS X v10.2 and later.
NSAccessibilityFocusedAttribute

Flag indicating presence of keyboard focus (NSNumber)

Available in Mac OS X v10.2 and later.
NSAccessibilityHelpAttribute

Instance description, such as a help tag string (NSString)

Available in Mac OS X v10.2 and later.
NSAccessibilityMaxValueAttribute

Element’s maximum value (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityMinValueAttribute

Element’s minimum value (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityParentAttribute

Element containing current element (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityPositionAttribute

Screen position of element’s lower-left corner in lower-left relative screen coordinates (NSValue)

Available in Mac OS X v10.2 and later.
NSAccessibilityRoleAttribute

Element type, such as NSAccessibilityRadioButtonRole (NSString). See the role attribute table below.

Available in Mac OS X v10.2 and later.
NSAccessibilityRoleDescriptionAttribute

Localized, user-readable description of role, such as radio button (NSString)

Available in Mac OS X v10.2 and later.
NSAccessibilitySelectedChildrenAttribute

Currently selected children (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilityShownMenuAttribute

Menu currently being displayed (id).

Available in Mac OS X v10.4 and later.
NSAccessibilitySizeAttribute

Element size (NSValue)

Available in Mac OS X v10.2 and later.
NSAccessibilitySubroleAttribute

Element subrole type, such as NSAccessibilityTableRowSubrole (NSString). See the subrole attribute table below.

Available in Mac OS X v10.2 and later.
NSAccessibilityTitleAttribute

Title of element, such as button text (NSString)

Available in Mac OS X v10.2 and later.
NSAccessibilityTopLevelUIElementAttribute

User interface element for the top-level element (id).

Available in Mac OS X v10.4 and later.
NSAccessibilityValueAttribute

Element’s value (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityVisibleChildrenAttribute

Child elements that are visible (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilityWindowAttribute

Window containing current element (id)

Available in Mac OS X v10.2 and later.
Declared In
NSAccessibility.h
Text-specific attributes*/

extern const NSString *NSAccessibilityChildrenAttribute;
extern const NSString *NSAccessibilityContentsAttribute;
extern const NSString *NSAccessibilityDescriptionAttribute;
extern const NSString *NSAccessibilityEnabledAttribute;
extern const NSString *NSAccessibilityFocusedAttribute;
extern const NSString *NSAccessibilityHelpAttribute;
extern const NSString *NSAccessibilityMaxValueAttribute;
extern const NSString *NSAccessibilityMinValueAttribute;
extern const NSString *NSAccessibilityParentAttribute;
extern const NSString *NSAccessibilityPositionAttribute;
extern const NSString *NSAccessibilityRoleAttribute;
extern const NSString *NSAccessibilityRoleDescriptionAttribute;
extern const NSString *NSAccessibilitySelectedChildrenAttribute;
extern const NSString *NSAccessibilityShownMenuAttribute;
extern const NSString *NSAccessibilitySizeAttribute;
extern const NSString *NSAccessibilitySubroleAttribute;
extern const NSString *NSAccessibilityTitleAttribute;
extern const NSString *NSAccessibilityTopLevelUIElementAttribute;
extern const NSString *NSAccessibilityValueAttribute;
extern const NSString *NSAccessibilityVisibleChildrenAttribute;
extern const NSString *NSAccessibilityWindowAttribute;

/*Table view and outline view attributes

The following are attributes specific to tables and outlines.

const NSString *NSAccessibilityColumnsAttribute;
const NSString *NSAccessibilityRowsAttribute;
const NSString *NSAccessibilitySelectedColumnsAttribute;
const NSString *NSAccessibilitySelectedRowsAttribute;
const NSString *NSAccessibilitySortDirectionAttribute;
const NSString *NSAccessibilityVisibleColumnsAttribute;
const NSString *NSAccessibilityVisibleRowsAttribute;
Constants
NSAccessibilityColumnsAttribute

Table’s columns (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilityRowsAttribute

Table’s rows (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilitySelectedColumnsAttribute

Table’s selected columns (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilitySelectedRowsAttribute

Table’s selected rows (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilitySortDirectionAttribute

Column’s sort direction.

Available in Mac OS X v10.4 and later.
NSAccessibilityVisibleColumnsAttribute

Table’s visible columns (NSArray)

Available in Mac OS X v10.2 and later.
NSAccessibilityVisibleRowsAttribute

Table’s visible rows (NSArray)

Available in Mac OS X v10.2 and later.
Declared In
NSAccessibility.h*/
extern const NSString *NSAccessibilityColumnsAttribute;
extern const NSString *NSAccessibilityRowsAttribute;
extern const NSString *NSAccessibilitySelectedColumnsAttribute;
extern const NSString *NSAccessibilitySelectedRowsAttribute;
extern const NSString *NSAccessibilitySortDirectionAttribute;
extern const NSString *NSAccessibilityVisibleColumnsAttribute;
extern const NSString *NSAccessibilityVisibleRowsAttribute;

/*Action values

These constants define standard actions that accessibility objects can perform.

const NSString *NSAccessibilityCancelAction;
const NSString *NSAccessibilityConfirmAction;
const NSString *NSAccessibilityDecrementAction;
const NSString *NSAccessibilityDeleteAction;
const NSString *NSAccessibilityIncrementAction;
const NSString *NSAccessibilityPickAction;
const NSString *NSAccessibilityPressAction;
const NSString *NSAccessibilityRaiseAction;
const NSString *NSAccessibilityShowMenuAction;
Constants
NSAccessibilityConfirmAction

Simulates pressing Return in object, such as a text field

Available in Mac OS X v10.2 and later.
NSAccessibilityDecrementAction

Decrement the value of object

Available in Mac OS X v10.2 and later.
NSAccessibilityDeleteAction

Delete the value of object.

Available in Mac OS X v10.4 and later.
NSAccessibilityIncrementAction

Increment the value of object

Available in Mac OS X v10.2 and later.
NSAccessibilityPickAction

Select the object, such as a menu item

Available in Mac OS X v10.2 and later.
NSAccessibilityPressAction

Simulates clicking an object, such as a button

Available in Mac OS X v10.2 and later.
NSAccessibilityCancelAction

Cancel the operation

Available in Mac OS X v10.3 and later.
NSAccessibilityRaiseAction

Simulates bringing a window forward by clicking on its title bar

Available in Mac OS X v10.3 and later.
NSAccessibilityShowMenuAction

Simulates showing a menu by clicking on it.

Available in Mac OS X v10.4 and later.
Declared In
NSAccessibility.h*/
extern const NSString *NSAccessibilityCancelAction;
extern const NSString *NSAccessibilityConfirmAction;
extern const NSString *NSAccessibilityDecrementAction;
extern const NSString *NSAccessibilityDeleteAction;
extern const NSString *NSAccessibilityIncrementAction;
extern const NSString *NSAccessibilityPickAction;
extern const NSString *NSAccessibilityPressAction;
extern const NSString *NSAccessibilityRaiseAction;
extern const NSString *NSAccessibilityShowMenuAction;

/*Application-specific attributes

The following are attributes specific to the application object.

const NSString *NSAccessibilityClearButtonAttribute;
const NSString *NSAccessibilityColumnTitlesAttribute;
const NSString *NSAccessibilityFocusedUIElementAttribute;
const NSString *NSAccessibilityFocusedWindowAttribute;
const NSString *NSAccessibilityFrontmostAttribute;
const NSString *NSAccessibilityHiddenAttribute;
const NSString *NSAccessibilityMainWindowAttribute;
const NSString *NSAccessibilityMenuBarAttribute;
const NSString *NSAccessibilityOrientationAttribute;
const NSString *NSAccessibilitySearchButtonAttribute;
const NSString *NSAccessibilitySearchMenuAttribute;
const NSString *NSAccessibilityWindowsAttribute;
Constants
NSAccessibilityFocusedUIElementAttribute

Element with the current focus (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityFocusedWindowAttribute

Application’s window with current focus (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityFrontmostAttribute

Flag indicating whether application is in front (NSNumber)

Available in Mac OS X v10.2 and later.
NSAccessibilityHiddenAttribute

Flag indicating whether application is hidden (NSNumber)

Available in Mac OS X v10.2 and later.
NSAccessibilityMainWindowAttribute

Application’s main window (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityMenuBarAttribute

Application’s menu bar (id)

Available in Mac OS X v10.2 and later.
NSAccessibilityWindowsAttribute

Application’s windows (NSArray)

Available in Mac OS X v10.2 and later.
Declared In
NSAccessibility.h*/

extern const NSString *NSAccessibilityClearButtonAttribute;
extern const NSString *NSAccessibilityColumnTitlesAttribute;
extern const NSString *NSAccessibilityFocusedUIElementAttribute;
extern const NSString *NSAccessibilityFocusedWindowAttribute;
extern const NSString *NSAccessibilityFrontmostAttribute;
extern const NSString *NSAccessibilityHiddenAttribute;
extern const NSString *NSAccessibilityMainWindowAttribute;
extern const NSString *NSAccessibilityMenuBarAttribute;
extern const NSString *NSAccessibilityOrientationAttribute;
extern const NSString *NSAccessibilitySearchButtonAttribute;
extern const NSString *NSAccessibilitySearchMenuAttribute;
extern const NSString *NSAccessibilityWindowsAttribute;



@interface NSObject (NSAccessibility)

/*accessibilityAttributeValue:

Returns the value of the receiver’s attribute attribute.

- (id)accessibilityAttributeValue:(NSString *)attribute
Discussion

User interface classes must implement this method. Subclasses should invoke the superclass’s implementation, if it exists, if attribute is not implemented in the subclass.
Availability
Available in Mac OS X v10.2 and later.*/
- (id)accessibilityAttributeValue:(NSString *)attribute;

/*accessibilityAttributeNames

Returns an array of attribute names supported by the receiver.

- (NSArray *)accessibilityAttributeNames
Discussion

User interface classes must implement this method. Subclasses should invoke the superclass’s implementation, if it exists, and append additional attributes or remove unsupported attributes. Some attribute names are defined by Cocoa and are described in the “Constants” section.
Availability
Available in Mac OS X v10.2 and later.*/
- (NSArray *)accessibilityAttributeNames;

/*accessibilityHitTest:

Returns the deepest descendant of the accessibility hierarchy that contains the point point, which is in lower-left relative screen coordinates.

- (id)accessibilityHitTest:(NSPoint)point
Discussion

You can assume the point has already been determined to lie within the receiver. Override this method to do deeper hit-testing by identifying which child element, if any, contains the point. NSMatrix, for example, identifies which of its cells contains point and propagates the hit-test to it. If point is not contained within one of the receiver’s children, either return self or, if available, invoke the superclass’s implementation. The default NSView and NSCell implementations test whether the receiver is an ignored element and, if so, return the receiver’s first unignored parent; otherwise they return self.
Availability
Available in Mac OS X v10.2 and later.*/
- (id)accessibilityHitTest:(NSPoint)point;

/*accessibilitySetOverrideValue:forAttribute:

Overrides the receiver’s attribute attribute, or adds it if it does not exist, and sets its value to value.

- (BOOL)accessibilitySetOverrideValue:(id)value forAttribute:(NSString *)attribute
Discussion

This method is for changing the set of attributes on an instance, as an alternative to subclassing. The return value indicates if the override was successful.

This method only works on objects whose class already implements the NSAccessibility protocol. If the specified attribute is already supported by the object, the value specified by this method wins.

If the specified attribute does not exist it is created. This is done outside the NSAccessibility protocol, so accessibilityAttributeNames still returns the old list which does not contain the new attribute. Likewise, accessibilityAttributeValue does not return attributes created by the override process nor does it return their overridden values.

The values of overridden attributes are not settable by assistive applications.

If you need to undo the effect of using this method, call it again passing nil for the value.

Ensure that you invoke this method on the actual object that represents the user interface element. For example, in the case of NSButton, use the underlying NSButtonCell. The NSButton itself is ignored by accessibility.

This method works only on an object representing a single user interface element. So, for example, you cannot use it when a single object represents multiple user interface elements, as with NSSegmentedCell, which has only a single object but provides user interface elements for each segment).
Availability
Available in Mac OS X v10.4 and later.*/
- (BOOL)accessibilitySetOverrideValue:(id)value forAttribute:(NSString *)attribute;

@end
//function

/*NSAccessibilityRoleDescription

Returns a standard description for a role and subrole.

NSString *NSAccessibilityRoleDescription(NSString *role, NSString *subrole)
Discussion

You should pass nil to this function if there is no subrole. This function returns a description of a standard role. For example, if you implement a button widget that does not inherit from NSButton, you should use NSAccessibilityRoleDescription to return a localized role description matching that returned by a standard button.
Availability
Available in Mac OS X v10.4 and later.*/
NSString *NSAccessibilityRoleDescription(NSString *role, NSString *subrole);

/*NSAccessibilityPostNotification

Sends a notification to any observing assistive applications.

void NSAccessibilityPostNotification(id element, NSString *notification)
Discussion

Sends notification to any assistive applications that have registered to receive the notification from the user interface object element in your application. Accessibility notifications require special handling, so they cannot be posted using NSNotificationCenter.
Availability
Available in Mac OS X v10.2 and later.*/
void NSAccessibilityPostNotification(id element, NSString *notification);



/*NSAccessibilityRoleDescriptionForUIElement

Returns a standard role description for a user interface element.

NSString *NSAccessibilityRoleDescriptionForUIElement(id element)
Discussion

This function is like NSAccessibilityRoleDescription, but it queries element to get the role and subrole. NSAccessibilityRoleDescription is more efficient, but this function is useful for accessorizing base classes so that they properly handle derived classes, which may override the subrole or even the role.
Availability
Available in Mac OS X v10.4 and later.*/
NSString *NSAccessibilityRoleDescriptionForUIElement(id element);

/*NSAccessibilityUnignoredChildren

Returns a list of unignored accessibility objects, descending the hierarchy if necessary.

NSArray *NSAccessibilityUnignoredChildren(NSArray *originalChildren)
Discussion

Returns a copy of originalChildren with any ignored objects in the array replaced by their unignored descendants.
Availability
Available in Mac OS X v10.2 and later.*/
NSArray *NSAccessibilityUnignoredChildren(NSArray *originalChildren);

/*NSAccessibilityActionDescription

Returns a standard description for an action.

NSString *NSAccessibilityActionDescription(NSString *action)
Discussion

This function returns a standard description for action.
Availability
Available in Mac OS X v10.4 and later.*/
NSString *NSAccessibilityActionDescription(NSString *action);

/*NSAccessibilityUnignoredDescendant

Returns an unignored accessibility object, descending the hierarchy if necessary.

id NSAccessibilityUnignoredDescendant(id element)
Discussion

Tests whether element is an ignored object, returning either element, if it is not ignored, or the first unignored descendant of element. Use this function only if you know there is a linear, one-to-one, hierarchy below element. Otherwise, if element has either no unignored children or multiple unignored children, this function fails and returns nil.
Availability
Available in Mac OS X v10.2 and later.*/
id NSAccessibilityUnignoredDescendant(id element);

