#ifndef ADD_STAT_H
#define ADD_STAT_H


/*STAT(2)                     BSD System Calls Manual                    STAT(2)

NAME
     stat, lstat, fstat -- get file status

SYNOPSIS
     #include <sys/types.h>
     #include <sys/stat.h>

     int
     stat(const char /path, struct stat /sb);

     int
     lstat(const char /path, struct stat /sb);

     int
     fstat(int fd, struct stat /sb);

DESCRIPTION
     The stat() function obtains information about the file pointed to by
     path.  Read, write or execute permission of the named file is not
     required, but all directories listed in the path name leading to the file
     must be searchable.

     Lstat() is like stat() except in the case where the named file is a sym-bolic symbolic
     bolic link, in which case lstat() returns information about the link,
     while stat() returns information about the file the link references.
     Unlike other filesystem objects, symbolic links do not have an owner,
     group, access mode, times, etc.  Instead, these attributes are taken from
     the directory that contains the link.  The only attributes returned from
     an lstat() that refer to the symbolic link itself are the file type
     (S_IFLNK), size, blocks, and link count (always 1).

     The fstat() obtains the same information about an open file known by the
     file descriptor fd.

     The sb argument is a pointer to a stat() structure as defined by
     <sys/stat.h> (shown below) and into which information is placed concern-ing concerning
     ing the file.

     struct stat {
         dev_t    st_dev;    // device inode resides on //
         ino_t    st_ino;    // inode's number //
         mode_t   st_mode;   // inode protection mode //
         nlink_t  st_nlink;  // number or hard links to the file //
         uid_t    st_uid;    // user-id of owner //
         gid_t    st_gid;    // group-id of owner //
         dev_t    st_rdev;   // device type, for special file inode //
         struct timespec st_atimespec;  // time of last access //
         struct timespec st_mtimespec;  // time of last data modification //
         struct timespec st_ctimespec;  // time of last file status change //
         off_t    st_size;   // file size, in bytes //
         quad_t   st_blocks; // blocks allocated for file //
         u_long   st_blksize;// optimal file sys I/O ops blocksize //
         u_long   st_flags;  // user defined flags for file //
         u_long   st_gen;    // file generation number //
     };

     The time-related fields of struct stat are as follows:

     st_atime     Time when file data last accessed.  Changed by the mknod(2),
                  utimes(2) and read(2) system calls.

     st_mtime     Time when file data last modified.  Changed by the mknod(2),
                  utimes(2) and write(2) system calls.

     st_ctime     Time when file status was last changed (inode data modifica-tion). modification).
                  tion).  Changed by the chmod(2), chown(2), link(2),
                  mknod(2), rename(2), unlink(2), utimes(2) and write(2) sys-tem system
                  tem calls.

     The size-related fields of the struct stat are as follows:

     st_blksize     The optimal I/O block size for the file.

     st_blocks      The actual number of blocks allocated for the file in
                    512-byte units.  As short symbolic links are stored in the
                    inode, this number may be zero.

     The status information word st_mode has the following bits:

     #define S_IFMT 0170000           // type of file //
     #define        S_IFIFO  0010000  // named pipe (fifo) //
     #define        S_IFCHR  0020000  // character special //
     #define        S_IFDIR  0040000  // directory //
     #define        S_IFBLK  0060000  // block special //
     #define        S_IFREG  0100000  // regular //
     #define        S_IFLNK  0120000  // symbolic link //
     #define        S_IFSOCK 0140000  // socket //
     #define        S_IFWHT  0160000  // whiteout //
     #define S_ISUID 0004000  // set user id on execution //
     #define S_ISGID 0002000  // set group id on execution //
     #define S_ISVTX 0001000  // save swapped text even after use //
     #define S_IRUSR 0000400  // read permission, owner //
     #define S_IWUSR 0000200  // write permission, owner //
     #define S_IXUSR 0000100  // execute/search permission, owner //

     For a list of access modes, see <sys/stat.h>, access(2) and chmod(2).

RETURN VALUES
     Upon successful completion a value of 0 is returned.  Otherwise, a value
     of -1 is returned and errno is set to indicate the error.

COMPATIBILITY
     Previous versions of the system used different types for the st_dev,
     st_uid, st_gid, st_rdev, st_size, st_blksize and st_blocks fields.

ERRORS
     Stat() and lstat() will fail if:

     [ENOTDIR]          A component of the path prefix is not a directory.

     [ENAMETOOLONG]     A component of a pathname exceeded {NAME_MAX} charac-ters, characters,
                        ters, or an entire path name exceeded {PATH_MAX} char-acters. characters.
                        acters.

     [ENOENT]           The named file does not exist.

     [EACCES]           Search permission is denied for a component of the
                        path prefix.

     [ELOOP]            Too many symbolic links were encountered in translat-ing translating
                        ing the pathname.

     [EFAULT]           Sb or name points to an invalid address.

     [EIO]              An I/O error occurred while reading from or writing to
                        the file system.

     Fstat() will fail if:

     [EBADF]            fd is not a valid open file descriptor.

     [EFAULT]           Sb points to an invalid address.

     [EIO]              An I/O error occurred while reading from or writing to
                        the file system.

CAVEATS
     The file generation number, st_gen, is only available to the super-user.
     The fields in the stat structure currently marked st_spare1, st_spare2,
     and st_spare3 are present in preparation for inode time stamps expanding
     to 64 bits.  This, however, can break certain programs that depend on the
     time stamps being contiguous (in calls to utimes(2)).

SEE ALSO
     chmod(2), chown(2), utimes(2) symlink(7)

BUGS
     Applying fstat to a socket (and thus to a pipe) returns a zero'd buffer,
     except for the blocksize field, and a unique device and inode number.

STANDARDS
     The stat() and fstat() function calls are expected to conform to IEEE Std
     1003.1-1988 (``POSIX.1'').

HISTORY
     An lstat() function call appeared in 4.2BSD.

4th Berkeley Distribution       April 19, 1994       4th Berkeley Distribution*/
#define  st_atimespec st_atim
#define st_mtimespec  st_mtim
#define st_ctimespec st_ctim

#include <sys/stat.h>

#endif

