#import <AppKit/NSWindow.h>
//#import <HYS/AppKit/NSWindow.h>
#import <APPLE/AppKit/NSWindow.h>

/*NSWindowDidChangeScreenProfileNotification

Posted whenever the display profile for the screen containing the window changes.

This notification is sent only if the window returns YES from displaysWhenScreenProfileChanges. This notification may be sent when a majority of the window is moved to a different screen (whose profile is also different from the previous screen) or when the ColorSync profile for the current screen changes. 

The notification object is the NSWindow object whose profile changed. This notification does not contain a userInfo dictionary. 
Availability
Available in Mac OS X v10.4 and later.*/
extern  NSString *NSWindowDidChangeScreenProfileNotification;




@interface NSWindow (hys)


/*setDisplaysWhenScreenProfileChanges:

Sets whether the window context should be updated when the screen profile changes.

- (void)setDisplaysWhenScreenProfileChanges:(BOOL)flag
Discussion

If flag is NO, the screen profile information for the window context never changes. This is the default setting. If flag is YES, the window context may be changed in the following situations:
A majority of the window is moved to a different screen whose profile is different than the previous screen.
The ColorSync profile of the current screen changes.

After the window context is updated, the window is told to display itself. If you need to update offscreen caches for the window, you should register to receive the NSWindowDidChangeScreenProfileNotification.
Availability
Available in Mac OS X v10.4 and later.
See Also
– displaysWhenScreenProfileChanges*/
- (void)setDisplaysWhenScreenProfileChanges:(BOOL)flag;

/*setIgnoresMouseEvents:

Specifies whether the receiver is transparent to mouse clicks and other mouse events, allowing overlay windows.

- (void)setIgnoresMouseEvents:(BOOL)flag
Availability
Available in Mac OS X v10.2 and later.
See Also
– ignoresMouseEvents*/
- (void)setIgnoresMouseEvents:(BOOL)flag;

/*addChildWindow:ordered:

childWin is ordered either above (NSWindowAbove) or below (NSWindowBelow) the receiver, and maintained in that relative place for subsequent ordering operations involving either window.

- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place
Discussion

While this attachment is active, moving childWin will not cause the receiver to move (as in sliding a drawer in or out), but moving the receiver will cause childWin to move.

Note that you should not create cycles between parent and child windows. For example, you should not add window B as child of window A, then add window A as a child of window B.
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeChildWindow:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place;

/*attachedSheet

Returns the sheet attached to the receiver.

- (NSWindow *)attachedSheet
Return Value

The sheet attached to the receiver.
Discussion

If the receiver does not have a sheet attached, this method returns nil.
Availability
Available in Mac OS X v10.1 and later.*/
- (NSWindow *)attachedSheet;

/*disableScreenUpdatesUntilFlush

Disables the receiver’s screen updates until the window is flushed.

- (void)disableScreenUpdatesUntilFlush
Discussion

This method can be invoked to synchronize hardware surface flushes with the window’s flushes. The receiver immediately disables screen updates using the function NSDisableScreenUpdates and re-enables screen updates when the window flushes. Sending this message multiple times during a window update cycle has no effect.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)disableScreenUpdatesUntilFlush;

/*setMovableByWindowBackground:

Sets whether the receiver is movable by clicking and dragging anywhere in its background.

- (void)setMovableByWindowBackground:(BOOL)movableByWindowBackground
Parameters
movableByWindowBackground

YES to specify that the window is movable by background, NO to specify that the window is not movable by background.
Availability
Available in Mac OS X v10.2 and later.
See Also
– isMovableByWindowBackground*/
- (void)setMovableByWindowBackground:(BOOL)movableByWindowBackground;

@end