#ifndef MACH_O_DYLD_H
#include <mach-o/dyld.h>
#endif

#ifndef MACH_O_ARCH_H
#include <mach-o/arch.h>
#endif

/*NSCreateObjectFileImageFromMemory

Creates an image reference for a Mach-O file currently in memory.

NSObjectFileImageReturnCode NSCreateObjectFileImageFromMemory(
   const void* address,
   size_t size,
   NSObjectFileImage* objectFileImage);
Parameters
address

A pointer to the memory block containing the Mach-O file contents. 
size

The size of the memory block, in bytes.
objectFileImage

On output, a pointer to an NSObjectFileImage opaque data structure.
Return Value

See Mach-O Image Creation Return Codes.
Discussion

Given a pointer to a Mach-O file in memory, this function creates and returns an NSObjectFileImage reference. The current implementation works only with bundles, so you must build the Mach-O executable file using the -bundle linker option.

The memory block that address points to, must be allocated with vm_allocate (/usr/include/mach/vm_map.h).

See also NSDestroyObjectFileImage.
Availability
Available in Mac OS X v10.3 and later.*/
NSObjectFileImageReturnCode NSCreateObjectFileImageFromMemory(
   const void* address,
   size_t size,
   NSObjectFileImage* objectFileImage){
//TODO
};


/*NSCreateObjectFileImageFromFile

Creates an image reference for a given Mach-O file.

NSObjectFileImageReturnCode NSCreateObjectFileImageFromFile(
   const char* pathName,
   NSObjectFileImage* objectFileImage);
Parameters
pathName

A C string. Pass the pathname to a Mach-O executable file. You must have previously built this file with the -bundle linker option; otherwise, this function returns an error.
objectFileImage

On output, a pointer to an NSObjectFileImage opaque data structure.
Return Value

See Mach-O Image Creation Return Codes.
Discussion

Given a pathname to a Mach-O executable, this function creates and returns a NSObjectFileImage reference. The current implementation works only with bundles, so you must build the Mach-O executable file using the -bundle linker option.

For portability and efficiency, consider using dlopen.*/
NSObjectFileImageReturnCode NSCreateObjectFileImageFromFile(
   const char* pathName,
   NSObjectFileImage* objectFileImage){
//TODO
};


/*NSLinkModule

Links the given object file image as a module into the current program.

NSModule NSLinkModule(
   NSObjectFileImage objectFileImage,
   const char* moduleName,
   uint32_t options);
Parameters
objectFileImage

An object file image reference. Pass a reference created using the NSCreateObjectFileImageFromFile function.
moduleName

A C string. Pass the absolute path to the object file image. GDB uses this path to retrieve debug symbol information from the library. 
options

An unsigned long value. Pass one or more of the following bit masks or NSLINKMODULE_OPTION_NONE to specify no options:
NSLINKMODULE_OPTION_BINDNOW

The dynamic linker binds all undefined references immediately, rather than waiting until the references are actually used. All dependent libraries are also bound.
NSLINKMODULE_OPTION_PRIVATE

Do not add the global symbols from the module to the global symbol list. Instead, you must use the NSLookupSymbolInModule function to obtain symbols from this module.
NSLINKMODULE_OPTION_RETURN_ON_ERROR

If an error occurs while binding the module, return NULL. You can then use the function NSLinkEditError to retrieve information about the error.

Without this option, this function calls the linkEdit error handler you have installed using the NSInstallLinkEditErrorHandlers function. If you have not installed a link edit error handler, this function prints a message to the standard error stream and causes a breakpoint trap to end the program.
Return Value

A reference to the linked module.
Discussion

When you call this function, all libraries referenced by the given module are added to the library search list. Unless you pass the NSLINKMODULE_OPTION_PRIVATE, NSLinkModule adds all global symbols in the module to the global symbol list.

For portability and efficiency, consider using dlopen.

See “Building Mach-O Files” in “Mach-O Programming Topics” for more information about modules.*/
NSModule NSLinkModule(
   NSObjectFileImage objectFileImage,
   const char* moduleName,
   uint32_t options){
//TODO
};


/*NSLookupSymbolInModule

Given a module reference, returns a reference to the symbol with the given name.

NSSymbol NSLookupSymbolInModule(
   NSModule module,
   const char* symbolName);
Parameters
module

A module reference. Pass the module that contains the symbol.
symbolname

A pointer to a C string. Pass the name of the symbol to look up.
Return Value

The symbol reference or NULL if the symbol cannot be found.
Discussion

For portability and efficiency, consider using dlsym.*/

NSSymbol NSLookupSymbolInModule(
   NSModule module,
   const char* symbolName){
//TODO
};


/*NSAddressOfSymbol

Returns the address in the program’s address space of the data represented by the given symbol. The data may be a variable, a constant, or the first instruction of a function.

void* NSAddressOfSymbol(
   NSSymbol symbol);
Parameters
symbol

A symbol reference. Pass the symbol whose address you wish to obtain.
Return Value

A pointer to the data represented by the given symbol.
Discussion

For portability and efficiency, consider using dlsym.*/
void* NSAddressOfSymbol(
   NSSymbol symbol){
//TODO
};


/*NSUnLinkModule

Unlinks the given module from the current program.

bool NSUnLinkModule(
   NSModule module,
   uint32_t options);
Parameters
module

A module reference. Pass a reference to a module that you have previously linked using the NSLinkModule function.
options

An unsigned long value. You can specify one or more of the following bit masks:
NSUNLINKMODULE_OPTION_NONE

Unlink the module and deallocate the memory it occupies.
NSUNLINKMODULE_OPTION_KEEP_MEMORY_MAPPED

Unlink the module, but do not deallocate the memory it occupies. Addresses that reside within the module remain valid. You cannot unmap this memory later; it’s released when the process exits or is terminated.
NSUNLINKMODULE_OPTION_RESET_LAZY_REFERENCES

Unlink the module and reset lazy references from other modules that are bound to the module. You can then link a new module that implements the same symbols, and the function call references are bound to the new module when accessed.
Discussion

For portability and efficiency, consider using dlopen in conduction with dlclose.

See “Building Mach-O Files” in “Mach-O Programming Topics” for more information about modules.
Special Considerations

In Mac OS X v10.2 and later, NSUNLINKMODULE_OPTION_RESET_LAZY_REFERENCES can be used only with PowerPC CPU executables.*/

bool NSUnLinkModule(
   NSModule module,
   uint32_t options){
//TODO
};


/*NSDestroyObjectFileImage

Releases the given object file image.

bool NSDestroyObjectFileImage(
   NSObjectFileImage objectFileImage);
Parameters
objectFileImage

A reference to the object file image to destroy.
Return Value

TRUE if the image was successfully destroyed, FALSE if not.
Discussion

When this function is called, the dynamic loader calls vm_deallocate (/usr/include/mach/vm_map.h) on the memory pointed to by the objectFileImage parameter.

For portability and efficiency, consider using dlopen in conjunction with dlclose.

See also NSCreateObjectFileImageFromMemory.*/
bool NSDestroyObjectFileImage(
   NSObjectFileImage objectFileImage){
//TODO
};


int NXGetLocalArchInfo(){
//TODO
};

 int NXFindBestFatArch(int a, int b, int c, int d){
//TODO
};


/*NSIsSymbolNameDefined

Returns TRUE if the given symbol is defined in the current program.

enum bool NSIsSymbolNameDefined(
   const char* symbolName);
Parameters
symbolName

A C string. Pass the name of the symbol whose definition status you wish to discover.
Return Value

TRUE when the symbol is defined by any image loaded in the current process; FALSE when the symbol cannot be found.
Discussion

Deprecated in Mac OS X v10.4. Use NSLookupSymbolInImage instead.

If you know the name of the library in which the symbol is likely to be located, you can use the NSIsSymbolNameDefinedWithHint function, which may be faster than this function. You should use the NSIsSymbolNameDefinedInImage function to perform a two-level namespace lookup*/
bool NSIsSymbolNameDefined(
   const char* symbolName){};


/*NSLookupAndBindSymbol

Given a symbol name, returns the corresponding symbol from the global symbol table.

NSSymbol NSLookupAndBindSymbol(
   const char* symbolName);
Parameters
symbolName

A pointer to a C string. Pass the name of the symbol you wish to find.
Return Value

The symbol reference for the requested symbol.
Discussion

Deprecated in Mac OS X v10.4. Use NSLookupSymbolInImage instead.

On error, if you have installed a link edit error handler, it is called; otherwise, this function writes an error message to file descriptor 2 (usually the standard error stream, stderr) and causes a breakpoint trap to end the program.

If you know the name of the library in which the symbol is likely to be located, you can use the NSLookupAndBindSymbolWithHint function, which may be faster than this function. You should use the NSLookupSymbolInImage function to perform a two-level namespace lookup.*/
NSSymbol NSLookupAndBindSymbol(
   const char* symbolName){};


/*ARCH(3)                  BSD Library Functions Manual                  ARCH(3)

NAME
     NXGetAllArchInfos, NXGetLocalArchInfo, NXGetArchInfoFromName,
     NXGetArchInfoFromCpuType, NXFindBestFatArch, NXCombineCpuSubtypes -- get
     architecture information

SYNOPSIS
     #include <mach-o/arch.h>

     extern const NXArchInfo *
     NXGetAllArchInfos(void);

     extern const NXArchInfo *
     NXGetLocalArchInfo(void);

     extern const NXArchInfo *
     NXGetArchInfoFromName(const char *name);

     extern const NXArchInfo *
     NXGetArchInfoFromCpuType(cpu_type_t cputype, cpu_subtype_t cpusubtype);

     extern struct fat_arch *
     NXFindBestFatArch(cpu_type_t cputype, cpu_subtype_t cpusubtype,
         struct fat_arch *fat_archs, unsigned long nfat_archs);

     extern cpu_subtype_t
     NXCombineCpuSubtypes(cpu_type_t cputype, cpu_subtype_t cpusubtype1,
         cpu_subtype_t cpusubtype2);

DESCRIPTION
     These functions are intended for use in programs that have to deal with
     universal files or programs that can target multiple architectures.  Typ-Typically,
     ically, a program will use a command-line argument that starts with
     ``-arch name'', where this specifies an architecture.  These functions
     and data structures provide some help for processing architecture flags
     and then processing the contents of a universal file.

     The structure NXArchInfo is defined in <mach-o/arch.h>:

                   typedef struct {
                           const char *name;
                           cpu_type_t cputype;
                           cpu_subtype_t cpusubtype;
                           enum NXByteOrder byteorder;
                           const char *description;
                   } NXArchInfo;
     It is used to hold the name of the architecture and the corresponding CPU
     type and CPU subtype, together with the architecture's byte order and a
     brief description string.

     The currently known architectures are:

     Name          CPU Type            CPU Subtype                 Description
     ppc           CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_ALL     PowerPC
     ppc64         CPU_TYPE_POWERPC64  CPU_SUBTYPE_POWERPC64_ALL   PowerPC
                                                                   (interim
                                                                   64-bit)
     i386          CPU_TYPE_I386       CPU_SUBTYPE_I386_ALL        Intel 80x86
     m68k          CPU_TYPE_MC680x0    CPU_SUBTYPE_MC680x0_ALL     Motorola
                                                                   68K
     hppa          CPU_TYPE_HPPA       CPU_SUBTYPE_HPPA_ALL        HP-PA
     i860          CPU_TYPE_I860       CPU_SUBTYPE_I860_ALL        Intel 860
     m88k          CPU_TYPE_MC88000    CPU_SUBTYPE_MC88000_ALL     Motorola
                                                                   88K
     sparc         CPU_TYPE_SPARC      CPU_SUBTYPE_SPARC_ALL       SPARC
     ppc601        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_601     PowerPC 601
     ppc603        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_603     PowerPC 603
     ppc604        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_604     PowerPC 604
     ppc604e       CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_604e    PowerPC
                                                                   604e
     ppc750        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_750     PowerPC 750
     ppc7400       CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_7400    PowerPC
                                                                   7400
     ppc7450       CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_7450    PowerPC
                                                                   7450
     ppc970        CPU_TYPE_POWERPC    CPU_SUBTYPE_POWERPC_970     PowerPC 970
     i486          CPU_TYPE_I386       CPU_SUBTYPE_486             Intel 486
     i486SX        CPU_TYPE_I386       CPU_SUBTYPE_486SX           Intel 486SX
     pentium       CPU_TYPE_I386       CPU_SUBTYPE_PENT            Intel
                                                                   Pentium
     i586          CPU_TYPE_I386       CPU_SUBTYPE_586             Intel 586
     pentpro       CPU_TYPE_I386       CPU_SUBTYPE_PENTPRO         Intel
                                                                   Pentium Pro
     i686          CPU_TYPE_I386       CPU_SUBTYPE_PENTPRO         Intel
                                                                   Pentium Pro
     pentIIm3      CPU_TYPE_I386       CPU_SUBTYPE_PENTII_M3       Intel
                                                                   Pentium II
                                                                   Model 3
     pentIIm5      CPU_TYPE_I386       CPU_SUBTYPE_PENTII_M5       Intel
                                                                   Pentium II
                                                                   Model 5
     pentium4      CPU_TYPE_I386       CPU_SUBTYPE_PENTIUM_4       Intel
                                                                   Pentium 4
     m68030        CPU_TYPE_MC680x0    CPU_SUBTYPE_MC68030_ONLY    Motorola
                                                                   68030
     m68040        CPU_TYPE_MC680x0    CPU_SUBTYPE_MC68040         Motorola
                                                                   68040
     hppa7100LC    CPU_TYPE_HPPA       CPU_SUBTYPE_HPPA_7100LC     HP-PA
                                                                   7100LC

     The first set of entries are used for the architecture family.  The sec-second
     ond set of entries are used for a specific architecture, when more than
     one specific architecture is supported in a family of architectures.

     NXGetAllArchInfos() returns a pointer to an array of all known NXArchInfo
     structures.  The last NXArchInfo is marked by a NULL name.

     NXGetLocalArchInfo() returns the NXArchInfo for the local host, or NULL
     if none is known.

     NXGetArchInfoFromName() and NXGetArchInfoFromCpuType() return the NXArch-NXArchInfo
     Info from the architecture's name or CPU type/CPU subtype combination.  A
     CPU subtype of CPU_SUBTYPE_MULTIPLE can be used to request the most gen-general
     eral NXArchInfo known for the given CPU type.  NULL is returned if no
     matching NXArchInfo can be found.

     NXFindBestFatArch() is passed a CPU type and CPU subtype and a set of
     fat_arch structs.  It selects the best one that matches (if any), and
     returns a pointer to that fat_arch struct (or NULL).  The fat_arch
     structs must be in the host byte order and correct such that fat_archs
     really points to enough memory for nfat_archs structs.  It is possible
     that this routine could fail if new CPU types or CPU subtypes are added
     and an old version of this routine is used.  But if there is an exact
     match between the CPU type and CPU subtype and one of the fat_arch
     structs, this routine will always succeed.

     NXCombineCpuSubtypes() returns the resulting CPU subtype when combining
     two different CPU subtypes for the specified CPU type.  If the two CPU
     subtypes can't be combined (the specific subtypes are mutually exclu-exclusive),
     sive), -1 is returned, indicating it is an error to combine them.  This
     can also fail and return -1 if new CPU types or CPU subtypes are added
     and an old version of this routine is used.  But if the CPU subtypes are
     the same, they can always be combined and this routine will return the
     CPU subtype passed in.

SEE ALSO
     arch(1)

                                 July 28, 2005*/
const NXArchInfo *
     NXGetArchInfoFromName(const char *name){};


