#import <Foundation/NSXMLNode.h>
#import <Foundation/NSError.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSString.h>

  @implementation NSXMLNode
/*objectsForXQuery:error:

Returns the objects resulting from executing an XQuery query upon the receiver.

- (NSArray *)objectsForXQuery:(NSString *)xquery error:(NSError **)error
Parameters
xquery

A string that expresses an XQuery query.
error

If query errors occur, indirectly returns an NSError object describing the errors.
Discussion

The receiver acts as the context item for the query (“.”). If the receiver has been changed after parsing to have multiple adjacent text nodes, you should invoke the NSXMLElement method normalizeAdjacentTextNodesPreservingCDATA: (with an argument of NO) to coalesce the text nodes before querying .This convenience method invokes objectsForXQuery:constants:error: with nil for the constants dictionary.
Availability
Available in Mac OS X v10.4 and later.
See Also
– XPath*/
- (NSArray *)objectsForXQuery:(NSString *)xquery error:(NSError **)error{}

/*stringValue

Returns the content of the receiver as a string value.

- (NSString *)stringValue
Discussion

If the receiver is a node object of element kind, the content is that of any text-node children. This method recursively visits elements nodes and concatenates their text nodes in document order with no intervening spaces. If the receiver’s content is set as an object value, this method returns the string value representing the object. If the object value is one of the standard, built-in ones (NSNumber, NSCalendarDate, and so on), the string value is in canonical format as defined by the W3C XML Schema Data Types specification. If the object value is not represented by one of these classes (or if the default value transformer for a class has been overridden), the string value is generated by the NSValueTransformer registered for that object type.
Availability
Available in Mac OS X v10.4 and later.
See Also
– objectValue
– setStringValue:
– setStringValue:resolvingEntities:*/
- (NSString *)stringValue{}

/*elementWithName:stringValue:

Returns an NSXMLElement object with a single text-node child containing the specified text. 

+ (id)elementWithName:(NSString *)name stringValue:(NSString *)string
Parameters
name

A string that is the name (tag identifier) of the element.
string

A string that is the content of the receiver's text node.
Return Value

An NSXMLElement object with a single text-node child—an NSXMLNode object of kind NSXMLTextKind—containing the text specified in string. Returns nil if the object couldn't be created. 
Discussion

The equivalent XML markup is <name>string</name>.
Availability
Available in Mac OS X v10.4 and later.*/
+ (id)elementWithName:(NSString *)name stringValue:(NSString *)string{}

/*childCount

Returns the number of child nodes the receiver has.

- (unsigned int)childCount
Discussion

This receiver should be an NSXMLNode object representing a document, element, or document type declaration. For performance reasons, use this method instead of getting the count from the array returned by children (for example, [[thisNode children] count]). 
Availability
Available in Mac OS X v10.4 and later.
See Also
– childAtIndex:
– children
– parent*/
- (unsigned int)childCount{}


/*detach

Detaches the receiver from its parent node.

- (void)detach
Discussion

This method is applicable to NSXMLNode objects representing elements, text, comments, processing instructions, attributes, and namespaces. Once the node object is detached, you can add it as a child node of another parent.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)detach{}

/*parent

Returns the parent node of the receiver.

- (NSXMLNode *)parent
Discussion

Document nodes and standalone nodes (that is, the root of a detached branch of a tree) have no parent, and sending this message to them returns nil. A one-to-one relationship does not always exists between a parent and its children; although a namespace or attribute node cannot be a child, it still has a parent element.
Availability
Available in Mac OS X v10.4 and later.
See Also
– childCount
– children*/
- (NSXMLNode *)parent{}

/*index

Returns the index of the receiver identifying its position relative to its sibling nodes.

- (unsigned int)index
Return Value

An integer that is the index of the receiver relative to its sibling nodes.
Discussion

The first child node of a parent has an index of zero.
Availability
Available in Mac OS X v10.4 and later.
See Also
– childAtIndex:*/
- (unsigned int)index{}


/*elementWithName:

Returns an NSXMLElement object with a given tag identifier, or name 

+ (id)elementWithName:(NSString *)name
Parameters
name

A string that is the name (or tag identifier) of an element.
Return Value

An NSXMLElement object or nil if the object couldn't be created. 
Discussion

The equivalent XML markup is <name></name>. 
Availability
Available in Mac OS X v10.4 and later.*/
+ (id)elementWithName:(NSString *)name{}


/*attributeWithName:stringValue:

Returns an NSXMLNode object representing an attribute node with a given name and string. 

+ (id)attributeWithName:(NSString *)name stringValue:(NSString *)value
Parameters
name

A string that is the name of an attribute.
value

A string that is the value of an attribute.
Return Value

An NSXMLNode object of kind NSXMLAttributeKind or nil if the object couldn't be created.
Discussion

For example, in the attribute “id=`12345’”, “id” is the attribute name and “12345” is the attribute value.
Availability
Available in Mac OS X v10.4 and later.*/
+ (id)attributeWithName:(NSString *)name stringValue:(NSString *)value{}




@end