#ifndef  COLORSYNC_H
#include <ColorSync/ColorSync.h>
#endif

/*CMMakeProfile

Makes a display or abstract profile by modifying an existing one.

CMError CMMakeProfile(
CMProfileRef      prof,
CFDictionaryRef   spec
);
Parameters
prof

The profile to modify.
spec

A dictionary that specifies the modifications to make to the profile supplied in the prof parameter.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The function CMMakeProfile adds appropriate tags to a profile to make a display or abstract profile based on a specification dictionary you supply. 

One key in the specification dictionary must be "profileType" with a CFString value of either "abstractLab", "displayRGB" or "displayID". 

The dictionary can optionally contain these keys-value pairs:
"description", with an associated CFString value
"copyright", with an associated CFString value

For a profileType key whose value is "abstractLab", the dictionary can also contain the keys-value pairs listed in Table 1.
Table 1  Key-value pairs for “abstractLab”
Key	
Value	
Comment

"gridPoints"	
A CFNumber (SInt32) that is an odd	
Required

"proc"	
A CFNumber (SInt64) coerced from a LabToLabProcPtr data type	
Required

"refcon"	
A CFNumber (SInt64) value coerced from a void* data type	
Optional


For a profileType key whose value is "displayRGB", the dictionary can also contain the keys-value pairs listed in Table 2.
Table 2  Key-value pairs for “displayRGB”
Key	
Value	
Comment

"targetGamma"	
A CFNumber (Float), for example, 1.8 	
Optional

"targetWhite"	
A CFNumber (SInt32), for example, 6500	
Optional

"gammaR	
A CFNumber (Float), for example, 2.5	
Required

"gammaG"	
A CFNumber (Float), for example, 2.5	
Required

"gammaB"	
A CFNumber (Float), for example, 2.5	
Required

"tableChans"	
A CFNumber (SInt32), for example, 1 or 3	
Optional

"tableEntries"	
A CFNumber (SInt32), for example, 16 or 255	
Optional

"tableEntrySize"	
A CFNumber (SInt32), for example,1 or 2	
Optional

"tableData"	
A CFData (lut in RRRGGGBBB order)	
Optional

"phosphorRx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

phosphorRy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

phosphorGx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorGy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorBx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorBy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorSet" 	
A CFString: "WideRGB", "700/525/450nm", "P22-EBU", "HDTV", "CCIR709", "sRGB", "AdobeRGB98" or "Trinitron" 	
Only if not supplying the phospher R, G, B keys

"whitePointx"	
A CFNumber (Float) 	
Only if not supplying a whiteTemp key

"whitePointy"	
A CFNumber (Float)	
Only if not supplying a whiteTemp key

"whiteTemp"	
A CFNumber (SInt32), for example, 5000, 6500, or 9300 	
Only if not supplying whitePointx and whitePointy keys


For a profileType key whose value is "displayID", the dictionary can also contain the keys-value pairs in Table 3
Table 3  Key-value pairs for “displayID”
Key	
Value	
Comment

"targetGamma"	
A CFNumber (Float), for example, 1.8	
Optional

"targetWhite"	
A CFNumber (SInt32), for example, 6500 	
Optional

"displayID”	
A CFNumber (SInt32)	
Required


Optionally, the keys-value pairs s for a profileType key whose value is "displayRGB" can be provided to override the values from the display.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CMMakeProfile(
CMProfileRef      prof,
CFDictionaryRef   spec){
//TODO
};



/*CMNewProfile

Creates a new profile and associated backing copy.

CMError CMNewProfile (
   CMProfileRef * prof,
   const CMProfileLocation * theProfile
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, a reference to the new profile. 
theProfile

A pointer of type CMProfileLocation to the profile location where the new profile should be created. A profile is commonly disk-file based—the disk file type for a profile is 'prof'. However, to accommodate special requirements, you can create a handle- or pointer-based profile, you can create a temporary profile that is not saved after you call the CMCloseProfile function, or you can create a profile that is accessed through a procedure provided by your application. To create a temporary profile, you either specify cmNoProfileBase as the kind of profile in the profile location structure or specify NULL for this parameter. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMNewProfile function creates a new profile and backing copy in the location you specify. After you create the profile, you must fill in the profile header fields and populate the profile with tags and their element data, and then call the function CMUpdateProfile to save the element data to the profile file. The default ColorSync profile contents include a profile header of type CM2Header and an element table.

To set profile elements outside the header, you use the function CMSetProfileElement, the function CMSetProfileElementSize, and the function CMSetPartialProfileElement. You set these elements individually, identifying them by their tag names.

When you create a new profile, all fields of the CM2Header profile header are set to 0 except the size and profileVersion fields. To set the header elements, you call the function CMGetProfileHeader to get a copy of the header, assign values to the header fields, then call the function CMSetProfileHeader to write the new header to the profile.

For each profile class, such as a device profile, there is a specific set of elements and associated tags, defined by the ICC, that a profile must contain to meet the baseline requirements. The ICC also defines optional tags that a particular CMM might use to optimize or improve its processing. You can also define private tags, whose tag signatures you register with the ICC, to provide a CMM with greater capability to refine its processing.

After you fill in the profile with tags and their element data, you must call the CMUpdateProfile function to write the new profile elements to the profile file.

This function is most commonly used by profile developers who create profiles for device manufacturers and by calibration applications. In most cases, application developers use existing profiles. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMNewProfile (
   CMProfileRef * prof,
   const CMProfileLocation * theProfile){
//TODO
};


/*CMCloseProfile

Decrements the reference count for the specified profile reference and, if the reference count reaches 0, frees all private memory and other resources associated with the profile.

CMError CMCloseProfile (
   CMProfileRef prof
);
Parameters
prof

A profile reference of type CMProfileRef that identifies the profile that may need to be closed. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The ColorSync Manager keeps an internal reference count for each profile reference returned from a call to the CMOpenProfile, CMNewProfile, CMCopyProfile, or CWNewLinkProfile functions. Calling the function CMCloneProfileRef increments the count; calling the CMCloseProfile function decrements it. The profile remains open as long as the reference count is greater than 0, indicating there is at least one remaining reference to the profile. When the count reaches 0, the ColorSync Manager releases all private memory, files, or resources allocated in association with that profile.

When the ColorSync Manager releases all private memory and resources associated with a profile, any temporary changes your application made to the profile are not saved unless you first call the CMUpdateProfile function to update the profile.

When your application passes a copy of a profile reference to an independent task, whether synchronous or asynchronous, it should call the function CMCloneProfileRef to increment the reference count. Both the called task and the caller should call CMCloseProfile when finished with the profile reference.

You call CMCloneProfileRef after copying a profile reference, but not after duplicating an entire profile (as with the CMCopyProfile function).

When your application passes a copy of a profile reference internally, it may not need to call CMCloneProfileRef, as long as the application calls CMCloseProfile once for the profile.

In your application, make sure that CMCloseProfile is called once for each time a profile reference is created or cloned. Otherwise, the private memory and resources associated with the profile reference may not be properly freed, or an application may attempt to use a profile reference that is no longer valid.

If you create a new profile by calling the CMNewProfile function, the profile is saved to disk when you call the CMCloseProfile function unless you specified NULL as the profile location when you created the profile.

To save changes to a profile before closing it, use the function CMUpdateProfile. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMCloseProfile (
   CMProfileRef prof){
//TODO
};


/*CMGetProfileByAVID

Gets the current profile for a monitor.

CMError CMGetProfileByAVID (
   CMDisplayIDType theID,
   CMProfileRef * prof
);
Parameters
theAVID

A Display Manager ID value. You pass the ID value for the monitor for which to get the profile. 
prof

A pointer to a profile reference. On return, a reference to the current profile for the monitor specified by theAVID. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

If the Display Manager supports ColorSync, the CMGetProfileByAVID function calls on the Display Manager to get the profile for the specified display. This is the case if the version of the Display Manager is 2.2.5 or higher (if gestaltDisplayMgrAttr has the gestaltDisplayMgrColorSyncAware bit set). 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetProfileByAVID (
   CMDisplayIDType theID,
   CMProfileRef * prof){
//TODO
};


/*CMOpenProfile

Opens the specified profile and returns a reference to the profile.

CMError CMOpenProfile (
   CMProfileRef * prof,
   const CMProfileLocation *theProfile
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, the reference refers to the opened profile. 
theProfile

A pointer to a profile location of type CMProfileLocation for the profile to open. Commonly a profile is disk-file based, but it may instead be temporary, handle-based, pointer-based, or accessed through a procedure supplied by your application. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

If the CMOpenProfile function executes successfully, the profile reference refers to the opened profile. Your application uses this reference, for example, when it calls functions to color match, copy, and update a profile, and validate its contents.

The ColorSync Manager maintains private storage for each request to open a profile, allowing more than one application to use a profile concurrently.

When you create a new profile or modify the elements of an existing profile, the ColorSync Manager stores the new or modified elements in the private storage it maintains for your application. Any new or changed profile elements are not incorporated into the profile itself unless your application calls the function CMUpdateProfile to update the profile. If you call the function CMCopyProfile to create a copy of an existing profile under a new name, any changes you have made are incorporated in the profile duplicate but the original profile remains unchanged.

Before you call the CMOpenProfile function, you must set the CMProfileLocation data structure to identify the location of the profile to open. Most commonly, a profile is stored in a disk file. If the profile is in a disk file, use the profile location data type to provide its file specification. If the profile is in memory, use the profile location data type to specify a handle or pointer to the profile. If the profile is accessed through a procedure provided by your application, use the profile location data type to supply a universal procedure pointer to your procedure.

Your application must obtain a profile reference before you copy or validate a profile, and before you flatten the profile to embed it.

For example, your application can:
open a profile 
call the CMGetProfileHeader function to obtain the profile’s header to modify its values 
set new values 
call the CMSetProfileHeader function to replace the modified header 
pass the profile reference to a function such as NCWNewColorWorld as the source or destination profile in a color world for a color-matching session 
When you close your reference to the profile by calling the function CMCloseProfile, your changes are discarded (unless you called the CMUpdateProfile function). 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMOpenProfile (
   CMProfileRef * prof,
   const CMProfileLocation *theProfile
){};


/*CMCloneProfileRef

Increments the reference count for the specified profile reference.

CMError CMCloneProfileRef (
   CMProfileRef prof
);
Parameters
prof

A profile reference of type CMProfileRef to the profile whose reference count is incremented. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The ColorSync Manager keeps an internal reference count for each profile reference returned from a call to the CMOpenProfile, CMNewProfile, or CMCopyProfile functions. Calling the CMCloneProfileRef function increments the count; calling the function CMCloseProfile decrements it. The profile remains open as long as the reference count is greater than 0, indicating that at least one routine retains a reference to the profile. When the count reaches 0, the ColorSync Manager releases all private memory, files, or resources allocated in association with that profile.

When your application creates a copy of an entire profile with CMCopyProfile, the copy has its own reference count. The CMCloseProfile routine should be called for the copied profile, just as for the original. When the reference count reaches 0, private resources associated with the copied profile are freed.

When your application merely duplicates a profile reference, as it may do to pass a profile reference to a synchronous or an asynchronous task, it should call CMCloneProfileRef to increment the reference count. Both the called task and the caller should call CMCloseProfile when finished with the profile reference.

In your application, you must make sure that CMCloseProfile is called once for each time a profile reference is created or cloned. Otherwise, the memory and resources associated with the profile reference may not be properly freed, or an application may attempt to use a profile reference that is no longer valid. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMCloneProfileRef (
   CMProfileRef prof
){};


/*CWDisposeColorWorld

Releases the private storage associated with a color world when your application has finished using the color world. 

void CWDisposeColorWorld (
   CMWorldRef cw
);
Parameters
cw

A color world reference of type CMWorldRef. 

The function NCWNewColorWorld and the function CWConcatColorWorld both allocate color world references of type CMWorldRef.

Discussion

The following functions use color worlds. If you create a color world to pass to one of these functions, you must dispose of the color world when your application is finished with it.
CWMatchColors
CWCheckColors
CWMatchBitmap
CWCheckBitmap
CWMatchPixMap
CWCheckPixMap
Availability
Available in CarbonLib 1.0 and later when ColorSync 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

void CWDisposeColorWorld (
   CMWorldRef cw
){};

/*CMGetDefaultProfileByUse

Obtains the users’ preferred device profile setting.

CMError CMGetDefaultProfileByUse (
   OSType use,
   CMProfileRef * prof
);
Parameters
use

A value that specifies the device type for which to obtain the profile.
prof
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when ColorSync 3.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetDefaultProfileByUse (
   OSType use,
   CMProfileRef * prof
){};


/*CMSetDefaultProfileBySpace

Sets the default profile for the specified color space.

CMError CMSetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef prof
);
Parameters
dataColorSpace

A four-character identifier of type OSType. You pass a color space signature that identifies the color space you wish to set the default profile for. The currently-supported values are cmRGBData, cmCMYKData, cmLabData, and cmXYZData. These constants are a subset of the constants described in “Color Space Signatures”. If you supply a value that is not supported, the CMGetDefaultProfileBySpace function returns an error value of paramErr. 
prof

A profile reference. Before calling CMSetDefaultProfileBySpace, set the reference to specify the default profile for the color space. The profile must be file-based; otherwise, the function returns a CMInvalidProfileLocation error. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMSetDefaultProfileBySpace function currently supports the RGB, CMYK, Lab, and XYZ color spaces. The signature constants for these color spaces (shown above with the dataColorSpace parameter description) are described in “Color Space Signatures”. Support for additional color spaces may be provided in the future. CMSetDefaultProfileBySpace returns a value of paramErr if you pass a color space constant it does not currently support.

Note that a user can also use the ColorSync control panel to specify a default profile for the RGB and CMYK color spaces. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMSetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef prof
){};



/*CMGetDefaultProfileBySpace

Gets the default profile for the specified color space.

CMError CMGetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef * prof
);
Parameters
dataColorSpace

A four-character identifier of type OSType. You pass a color space signature that identifies the color space you wish to get the default profile for. The currently-supported values are cmRGBData, cmCMYKData, cmLabData, and cmXYZData. These constants are a subset of the constants described in “Color Space Signatures”. If you supply a value that is not supported, the CMGetDefaultProfileBySpace function returns an error value of paramErr. 
prof

A pointer to a profile reference. On return, the reference specifies the current profile for the color space specified by dataColorSpace. CMGetDefaultProfileBySpace currently supports only file-based profiles. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMGetDefaultProfileBySpace function currently supports the RGB, CMYK, Lab, and XYZ color spaces. The signature constants for these color spaces (shown above with the dataColorSpace parameter description) are described in “Color Space Signatures”. Support for additional color spaces may be provided in the future. CMGetDefaultProfileBySpace returns an error value of paramErr if you pass a color space constant it does not currently support.

The CMGetDefaultProfileBySpace function always attempts to return a file-based profile for a supported color space. For example, if the user has not specified a default profile in the ColorSync control panel for the specified color space, or if the profile is not found (the user may have deleted the profiles in the ColorSync Profiles folder or even the folder itself), CMGetDefaultProfileBySpace creates a profile, stores it on disk, and returns a reference to that profile. However, you should always check for an error return—for example, a user may have booted from a CD, so that CMGetDefaultProfileBySpace cannot save a profile file to disk. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMGetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef * prof
){};



/*CMSetDefaultProfileByUse

Sets values for device profile settings.

CMError CMSetDefaultProfileByUse (
   OSType use,
   CMProfileRef prof
);
Parameters
use

A value that specifies the device type for which to set the profile.
prof
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when ColorSync 3.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMSetDefaultProfileByUse (
   OSType use,
   CMProfileRef prof
){};


/*CWMatchBitmap

Matches the colors of a bitmap to the gamut of a destination device using the profiles specified by a color world.

CMError CWMatchBitmap (
   CMWorldRef cw,
   CMBitmap * bitmap,
   CMBitmapCallBackUPP progressProc,
   void * refCon,
   CMBitmap * matchedBitmap
);
Parameters
cw

A reference to a color world of type CMWorldRef in which matching is to occur.

The functions NCWNewColorWorld and CWConcatColorWorld both allocate color world references of type CMWorldRef.

bitmap

A pointer to a bitmap of type CMBitmap whose colors are to be matched. 
progressProc

A calling program–supplied universal procedure pointer to a callback function that allows your application to monitor progress or abort the operation as the bitmap colors are matched. The default CMM calls your function approximately every half-second unless color matching occurs in less time this happens when there is a small amount of data to be matched. If the function returns a result of true, the operation is aborted. To match colors without monitoring the process, specify NULL for this parameter. For a description of the function your application supplies, see the function CMBitmapCallBackProcPtr. 
refCon

A pointer to a reference constant for application data passed through as a parameter to calls to the progressProc function. 
matchedBitmap

A pointer to a bitmap. On return, contains the color-matched image. You must allocate the pixel buffer pointed to by the image field of the structure CMBitmap. If you specify NULL for matchedBitMap, then the source bitmap is matched in place.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CWMatchBitmap function matches a bitmap using the profiles specified by the given color world.

You should ensure that the buffer pointed to by the image field of the bitmap passed in the bitMap parameter is zeroed out before you call this function.

The ColorSync Manager does not explicitly support a CMY color space. However, for printers that have a CMY color space, you can use either of the following circumventions to make the adjustment:
You can use a CMY profile, which the ColorSync Manager does support, with a CMYK color space. If you specify a CMYK color space in this case, the ColorSync Manager zeroes out the K channel to simulate a CMY color space. 
You can use an RGB color space and pass in the bitmap along with an RGB profile, then perform the conversion from RGB to CMY yourself. 

For this function to execute successfully, the source profile’s dataColorSpace field value and the space field value of the source bitmap pointed to by the bitMap parameter must specify the same data color space. Additionally, the destination profile’s dataColorSpace field value and the space field value of the resulting bitmap pointed to by the matchedBitMap parameter must specify the same data color space, unless the destination profile is a named color space profile.

If you set matchedBitMap to NULL to specify in-place matching, you must be sure the space required by the destination bitmap is less than or equal to the size of the source bitmap. 
Version Notes

The color spaces currently supported for the CWMatchBitmap function are defined in “Color Space Constants With Packing Formats”. Support for the following color space constants, was added with ColorSync version 2.5:
cmGray16Space
cmGrayA32Space
cmRGB48Space.
cmCMYK64Space
cmLAB48Space
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CWMatchBitmap (
   CMWorldRef cw,
   CMBitmap * bitmap,
   CMBitmapCallBackUPP progressProc,
   void * refCon,
   CMBitmap * matchedBitmap
){};


/*CMGetScriptProfileDescription

Obtains the internal name (or description) of a profile and the script code identifying the language in which the profile name is specified from the specified profile.

CMError CMGetScriptProfileDescription (
   CMProfileRef prof,
   Str255 name,
   ScriptCode * code
);
Parameters
prof

A profile reference of type CMProfileRef to the profile whose profile name and script code are obtained. 
name

A pointer to a name string. On return, the profile name. 
code

A pointer to a script code. On return, the script code. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The element data of the text description tag (which has the signature 'desc' or constant cmSigProfileDescriptionType, defined in the CMICCProfile.h header file) specifies the profile name and script code. The name parameter returns the profile name as a Pascal string. Use this function so that your application does not need to obtain and parse the element data, which contains other information. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetScriptProfileDescription (
   CMProfileRef prof,
   Str255 name,
   ScriptCode * code
){};


/*CMGetIndImageProfile

Obtains a specific embeded profile for a given image. 

CMError CMGetIndImageProfile (
   const FSSpec * spec,
   UInt32 index,
   CMProfileRef * prof
);
Parameters
spec

A file specification for the image file. See the File Manager documentation for a description of the FSSpec data type.
index

The numeric index of the profile to return. 
prof

On output, points to the profile. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.6 or later is present. 
Declared In
CMScriptingPlugin.h*/
CMError CMGetIndImageProfile (
   const FSSpec * spec,
   UInt32 index,
   CMProfileRef * prof
){};


/*CMEmbedImage

Embeds an image with an ICC profile. 

CMError CMEmbedImage (
   const FSSpec * specFrom,
   const FSSpec * specInto,
   Boolean repl,
   CMProfileRef embProf
);
Parameters
specFrom

A file specification for the image file. See the File Manager documentation for a description of the FSSpec data type.
specInto

If this parameter is a file, it specifies the resulting image. If this parameter is a folder, it specifies the location of the resulting image which will have the same name as the original file. If this parameter is not provided, the original file is modified. See the File Manager documentation for a description of the FSSpec data type.
repl

A Boolean value. If a file with the same name already exists, it will be replaced if this parameter is set to true. 
embProf

The profile to embed in the image. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.6 or later is present. 
Declared In
CMScriptingPlugin.h*/

CMError CMEmbedImage (
   const FSSpec * specFrom,
   const FSSpec * specInto,
   Boolean repl,
   CMProfileRef embProf
){};


/*CMCopyProfileLocalizedString

Gets one specific string out of a profile 

CMError CMCopyProfileLocalizedString (
   CMProfileRef prof,
   OSType tag,
   CFStringRef reqLocale,
   CFStringRef * locale,
   CFStringRef * str
);
Parameters
prof

The profile to query. 
tag

The tag type of profile to query.
reqLocale

The requested locale (optional). 
locale

On ouput, points to the locale (optional). 
str

On output, points to the dictionary string (optional). 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

For example, you pass in the optional tag 'dscm' plus "enUS" for the reqLocale parameter, to for a U.S. Enlish string. If a U.S. English string is not found, ColorSync falls back to a reasonable default: err = CMCopyProfileLocalizedString (prof, 'dscm',
                CFSTR("enUS"), nil, &theStr);

Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMApplication.h*/

CMError CMCopyProfileLocalizedString (
   CMProfileRef prof,
   OSType tag,
   CFStringRef reqLocale,
   CFStringRef * locale,
   CFStringRef * str
){};


/*NCWConcatColorWorld

Defines a color world for color transformations among a series of concatenated profiles. 

CMError NCWConcatColorWorld (
   CMWorldRef * cw,
   NCMConcatProfileSet * profileSet,
   CMConcatCallBackUPP proc,
   void * refCon
);
Parameters
cw

A reference to a color world that the ColorSync Manager returns if the function completes successfully. You pass this reference to other functions that use the color world for color-matching and color-checking sessions. 
profileSet

An array of profiles describing the processing to be carried out. The array is in processing order source through destination. 
proc

A calling-program-supplied callback function that allows your application to monitor progress or abort the operation. 
refCon

A reference constant containing data specified by the calling application program. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The caller can override the color management module (CMM) that would normally be selected by ColorSync by providing a CMM identifier in the NCMConcatProfileSet structure, or pass 0 to accept ColorSync's CMM selection (note that this could either be the user's preferred CMM selection or the CMM called for in the profile). The flags and k parameters are provided to allow easy customization of such attributes as quality and gamut-checking, while preserving the other settings. Each profile in the set can be customized by overriding the intent, and the selection of the transform tag. Together with other profiles, a custom-rendering environment can be set up to transform to or from device-dependent spaces with a minimum of gamut compression and/or unnecessary transformations to and from connection spaces. This flexibility comes at the price of specific knowledge of the profile contents and how device gamuts overlap. 

Note that for standard input and output device profiles, A2B and B2A tags represent transforms from data space to connection space and from connection space to data space, respectively. Under these circumstances, the caller would not normally be able to use the same transform tags (e.g., kUseAtoB ) consecutively, since a connection space would not be the same as the subsequent data space. If the spaces aren't the same, the caller will get a cmCantConcatenateError error returned. For profiles of type cmLinkClass, cmAbstractClass, cmColorSpaceClass , and cmNamedColorClass , these constants are not always meaningful, and the caller is encouraged to think in terms of the actual tags present in the profiles (e.g., A2B0 or B2A0 ). Under these conditions, it may well be appropriate to specify two transform tags of the same type consecutively, as long as the actual color spaces align in between tags. If this is not the case, a cmCantConcatenateError error is returned.

The callback proc is provided as protection against the appearance of a stalled machine during lengthy color world processing. If a CMM takes more than several seconds to process the information and create a color world, it will call the callback proc, if one is provided, and pass it the refCon provided. This is also true for NCWNewLinkProfile. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.6 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError NCWConcatColorWorld (
   CMWorldRef * cw,
   NCMConcatProfileSet * profileSet,
   CMConcatCallBackUPP proc,
   void * refCon
){};



/*CMGetDefaultDevice

Gets the default device.

CMError CMGetDefaultDevice (
   CMDeviceClass deviceClass,
   CMDeviceID * deviceID
);
Parameters
deviceClass

The device class whose default device you want to get. See “Device Classes” for a list of the constants you can supply.
deviceID

On return, points to the device ID for the default device.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

For each class of device, a device management layer may establish which of the registered devices is the default. This helps keep color management choices to a minimum and allows for some automatic features to be enabled, such as the "Default printer" as an output profile selection. 
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/

CMError CMGetDefaultDevice (
   CMDeviceClass deviceClass,
   CMDeviceID * deviceID
){};


/*CMIterateDeviceProfiles

Iterates through the device profiles available on the system and returns information about profiles of the devices to a callback you supply.

CMError CMIterateDeviceProfiles (
   CMIterateDeviceProfileProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   UInt32 flags,
   void * refCon
);
Parameters
proc

A pointer to a function that iterates through device information available on the system. This is optional, but allows you to obtain profile information for each device. If provided, your callback is invoked once for each registered device.
seed

A pointer to a seed value. This is optional. If you pass a pointer to a seed value that is the same as the current seed value, then the callback function specified by the proc parameter is not invoked.
count

On output, the number of color devices available on the system.
flags

A value that specifies which set of profiles you want to iterate through. It can have the following values: cmIterateFactoryDeviceProfiles, cmIterateCustomDeviceProfiles, cmIterateCurrentDeviceProfiles, cmIterateAllDeviceProfiles or 0. Supplying 0 is the same as supplying cmIterateCurrentDeviceProfiles.
refCon

An optional value that passed to your callback.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/
CMError CMIterateDeviceProfiles (
   CMIterateDeviceProfileProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   UInt32 flags,
   void * refCon
){};


/*CMGetDeviceProfile

Gets a profile used by a given device. 

CMError CMGetDeviceProfile (
   CMDeviceClass deviceClass,
   CMDeviceID deviceID,
   CMDeviceProfileID profileID,
   CMProfileLocation * deviceProfLoc
);
Parameters
deviceClass

The device class for the device whose profile you want to get. See “Device Classes” for a list of the constants you can supply.
deviceID

The device ID for the device whose profile you want to get.
defaultID

The ID of the default profile for this device.
deviceProfLoc

On return, the location of the profile.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/
CMError CMGetDeviceProfile (
   CMDeviceClass deviceClass,
   CMDeviceID deviceID,
   CMDeviceProfileID profileID,
   CMProfileLocation * deviceProfLoc
){};


/*CMIterateColorDevices

Iterates through the color devices available on the system, returning device information to a callback you supply.

CMError CMIterateColorDevices (
   CMIterateDeviceInfoProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);
Parameters
proc

A pointer to a function that iterates through device information available on the system. This is optional, but allows you to obtain device information. If provided, your callback is invoked once for each registered device.
seed

A pointer to a seed value. This is optional. If you pass a pointer to a seed value that is the same as the current seed value, then the callback function specified by the proc parameter is not invoked.
count

On output, the number of color devices available on the system.
refCon

An optional value that passed to your callback.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

This routine gets device information about all registered color devices. If provided, the supplied callback functions is called once for each registered device, passing in the device info and the supplied refcon. 
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/

CMError CMIterateColorDevices (
   CMIterateDeviceInfoProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
){};

/*CMIterateColorSyncFolder

Iterates over the available profiles.

CMError CMIterateColorSyncFolder (
   CMProfileIterateUPP proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);
Parameters
proc

A universal procedure pointer of type CMProfileIterateUPP, which is described in CMProfileIterateData. If you do not wish to receive callbacks, pass NULL for this parameter. Otherwise, pass a pointer to your callback routine. 
seed

A pointer to a value of type long. The first time you call CMIterateColorSyncFolder, you typically set the value to 0. In subsequent calls, you set the value to the seed value obtained from the previous call. ColorSync uses the value in determining whether to call your callback routine, as described in the discussion for this function.

On return, the value is the current seed for the profile cache (unless you pass NULL, as described in the discussion).

count

A pointer to a value of type long. On return, the value is the number of available profiles. CMIterateColorSyncFolder provides the number of profiles even when no iteration occurs (unless you pass NULL, as described in the discussion below). To determine the count alone, without iteration, call CMIterateColorSyncFolder and pass a value of NULL for all parameters except count.
refCon

An untyped pointer to arbitrary data supplied by your application. CMIterateColorSyncFolder passes this data to your callback routine. If you pass NULL for the refCon parameter, CMIterateColorSyncFolder passes NULL to your callback routine. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

Starting with ColorSync version 2.5, when your application needs information about the profiles currently available in the ColorSync Profiles folder, it can call the CMIterateColorSyncFolder routine, which in turn calls your callback routine once for each profile.

Even though there may be many profiles available, CMIterateColorSyncFolder can take advantage of ColorSync’s profile cache to return profile information quickly, and (if the cache is valid) without having to open any profiles. For each profile, CMIterateColorSyncFolder supplies your routine with the profile header, script code, name, and location, in a structure of type CMProfileIterateData. As a result, your routine may be able to perform its function, such as building a list of profiles to display in a pop-up menu, without further effort (such as opening each file-based profile).

Only 2.x profiles are included in the profile search result. 

Before calling CMIterateColorSyncFolder for the first time, you typically set seed to 0. ColorSync compares 0 to its current seed for the profile cache. It is not likely they will match—the odds are roughly one in two billion against it. If the values do not match, the routine iterates through all the profiles in the cache, calling your callback routine once for each profile. CMIterateColorSyncFolder then returns the actual seed value in seed (unless you passed NULL for that parameter).

If you pass the returned seed value in a subsequent call, and if there has been no change in the available profiles, the passed seed will match the stored cache seed and no iteration will take place.

Note that you can pass a NULL pointer for the seed parameter without harm. The result is the same as if you passed a pointer to 0, in that the function iterates through the available profiles, calling your callback routine once for each profile. However, the function does not return a seed value, since you have not passed a valid pointer.

You can force ColorSync to call your callback routine (if any profiles are available) by passing a NULL pointer or by passing 0 for the seed value. But suppose you have an operation, such as building a pop-up menu, that you only want to perform if the available profiles have changed. In that case, you pass the seed value from a previous call to CMIterateColorSyncFolder. If the profile folder has not changed, ColorSync will not call your callback routine.

Note that if there are no profiles available, ColorSync does not call your callback routine.

You can safely pass NULL for any or all of the parameters to the CMIterateColorSyncFolder function. If you pass NULL for all of the parameters, calling the function merely forces rebuilding of the profile cache, if necessary. 
Version Notes

Starting with version 2.5, the name and location of the profile folder changed. In addition, the folder can now contain profiles within nested folders, as well as aliases to profiles or aliases to folders containing profiles. There are limits on the nesting of folders and aliases.
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMIterateColorSyncFolder (
   CMProfileIterateUPP proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
){};



/*NewCMProfileIterateUPP

Creates a new universal procedure pointer (UPP) to a profile-iteration callback.

CMProfileIterateUPP NewCMProfileIterateUPP (
   CMProfileIterateProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your profile-iteration callback function.
Return Value

The universal procedure pointer.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMProfileIterateUPP NewCMProfileIterateUPP (
   CMProfileIterateProcPtr userRoutine
){};

/*DisposeCMProfileIterateUPP

Disposes of a universal procedure pointer (UPP) to a profile-iteration callback.

void DisposeCMProfileIterateUPP (
   CMProfileIterateUPP userUPP
);
Parameters
userUPP

The universal procedure pointer to dispose of.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
void DisposeCMProfileIterateUPP (
   CMProfileIterateUPP userUPP
){};



/*CMGetProfileHeader

Obtains the profile header for the specified profile. 

CMError CMGetProfileHeader (
   CMProfileRef prof,
   CMAppleProfileHeader * header
);
Parameters
prof

A profile reference of type CMProfileRef to the profile whose header is to be copied. 
header

A pointer to a profile header. On input, depending on the profile version, you may allocate a ColorSync 2.x or 1.0 header. On return, contains the profile data. For information about the ColorSync 2.x profile header structure, see CM2Header. For information about the ColorSync 1.0 header, see CMHeader. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMGetProfileHeader function returns the header for a ColorSync 2.x or ColorSync 1.0 profile. To return the header, the function uses a union of type CMAppleProfileHeader, with variants for version 1.0 and 2.x headers. 

A 32-bit version value is located at the same offset in either header. For ColorSync 2.x profiles, this is the profileVersion field. For ColorSync 1.0 profiles, this is the applProfileVersion field. You can inspect the value at this offset to determine the profile version, and interpret the remaining header fields accordingly.

To copy a profile header to a profile after you modify the header’s contents, use the function CMSetProfileHeader. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMGetProfileHeader (
   CMProfileRef prof,
   CMAppleProfileHeader * header
){};


/*CMCopyProfileDescriptionString

Returns the name of a profile as a CFString.

CMError CMCopyProfileDescriptionString(
CMProfileRef   prof,
CFStringRef *  str)
Parameters
prof

The profile to query.
str

On ouput, the name of the profile as a CFString.
Return Value

A CMError value. See “ColorSync Manager Result Codes”. 
Discussion

If the profile is localized, ColorSync obtains the best localized name for the current process.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CMCopyProfileDescriptionString(
CMProfileRef   prof,
CFStringRef *  str){};



/*CWFillLookupTexture

Fills a 3-D lookup texture from a color world.

CMError CWFillLookupTexture(
CMWorldRef   cw,
UInt32       gridPoints,
UInt32       format,
UInt32       dataSize,
void *       data
);
Parameters
cw

The color world to use.
gridPoints

The number of grid points per channel in the texture.
format

The format of pixels in texture; for example, cmTextureRGBtoRGBX8.
dataSize

The size in bytes of texture data to fill.
data

On output, points to the texture data to fill.
Return Value

A CMError value. See “ColorSync Manager Result Codes”. 
Discussion

You can use the resulting table in OpenGL to accelerate color management in hardware.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CWFillLookupTexture(
CMWorldRef   cw,
UInt32       gridPoints,
UInt32       format,
UInt32       dataSize,
void *       data
){};

/*CMValidateProfile

Indicates whether the specified profile contains the minimum set of elements required by the current color management module (CMM) for color matching or color checking.

CMError CMValidateProfile (
   CMProfileRef prof,
   Boolean * valid,
   Boolean * preferredCMMnotfound
);
Parameters
prof

A profile reference of type CMProfileRef to the profile to validate. 
valid

A pointer to a valid profile flag. On return, has the value true if the profile contains the minimum set of elements to be valid and false if it does not. 
preferredCMMnotfound

A pointer to a flag for whether the preferred CMM was found. On return, has the value true if the CMM specified by the profile was not available to perform validation or does not support this function and the default CMM was used. Has the value false if the profile’s preferred CMM is able to perform validation.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

When your application calls the CMValidateProfile function, the ColorSync Manager dispatches the function to the CMM specified by the CMMType header field of the profile whose reference you specify. The preferred CMM can support this function or not.

If the preferred CMM supports this function, it determines if the profile contains the baseline elements for the profile class, which the CMM requires to perform color matching or gamut checking. For each profile class, such as a device profile, there is a specific set of required tagged elements defined by the ICC that the profile must include. The ICC also defines optional tags, which may be included in a profile. A CMM might use these optional elements to optimize or improve its processing. Additionally, a profile might include private tags defined to provide a CMM with processing capability particular to the needs of that CMM. The profile developer can define these private tags, register the tag signatures with the ICC, and include the tags in a profile. The CMM checks only for the existence of profile elements it does not check the element’s content and size.

If the preferred CMM does not support the CMValidateProfile function request, the ColorSync Manager calls the default CMM to handle the validation request. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMValidateProfile (
   CMProfileRef prof,
   Boolean * valid,
   Boolean * preferredCMMnotfound
){};


/*CMGetSystemProfile

Obtains a reference to the current system profile.

CMError CMGetSystemProfile (
   CMProfileRef * prof
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, a reference to the current system profile. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The following functions allow you to pass NULL as a parameter value to specify the system profile as a source or destination profile:
CMNewProfile
NCWNewColorWorld
NCMBeginMatching
NCMDrawMatchedPicture

Note that instead of passing NULL, you can pass a profile reference to a specific profile, including the system profile.

If you want to specify the system profile for any other function that requires a profile reference, such as CWConcatColorWorld and CWNewLinkProfile, you must use an explicit reference. You can obtain such a reference with the CMGetSystemProfile function.

There are other reasons you might need to obtain a reference to the current system profile. For example, your application might need to display the name of the current system profile to a user.

To identify the location of the physical file, call the function CMGetProfileLocation.

When your application has finished using the current system profile, it must close the reference to the profile by calling the function CMCloseProfile. 
Version Notes

Starting with version 2.5, use of the system profile has changed. So rather than call CMGetSystemProfile to obtain a reference to the system profile, you may be able to obtain a profile that is more appropriate for the current operation by calling CMGetDefaultProfileBySpace to get the default profile for a color space or by calling CMGetProfileByAVID to get the profile for a specific display.
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetSystemProfile (
   CMProfileRef * prof
){};


























