#ifndef AUDIOTOOLBOX_H
#include <AudioToolbox/AudioToolbox.h>
#endif

/*AudioFileReadPackets

Reads in a certain number of packets from the input file.

extern OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer
);
Discussion

This function reads in the contents of the file by packet, starting at inStartingPoint. The packets that have been read are described in outPacketDescriptions, while the number of packets is specified in ioNumPackets (with the actual number of packets read being the return value), and the size, in bytes, of the read in packets returned in outNumBytes. If the read should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer){
//TODO
};



/*AudioFileGetProperty

Returns the data for the specified property.

extern OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData
);
Discussion

The file and property being queried should be specified in inAudioFile and inPropertyID, respectively, with the size retrieved with AudioFileGetPropertyInfo() passed into ioDataSize, and the resulting data being placed in outPropertyData.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData){
//TODO
};


/*AudioFileGetPropertyInfo

Returns the size of the data that will be returned for the property.

extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable
);
Discussion

The file being queried should be passed in as inAudioFile, while the property being queried is passed in as inPropertyID. The size of the resulting data is returned in outDataSize, and isWritable will reflect if the data is modifiable.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable){
//TODO
};


/*AudioFileWritePackets

Writes the buffer to the file, by packets.

extern OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer
);
Discussion

When writing to inAudioFile, specify the starting index as inStartingPacket, the format of the packet as defined in inPacketDescrptions, the size of the write as inNumBytes, and the number of packets to be written in ioNumPackets. If the write should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.
Property Access*/
OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer){
//TODO
};



/*AudioFileCreate

Creates a new file using the descriptions provided.

extern OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile
);
Discussion

The directory that the file to be place into is provided with inParentRef, the name of the file is contained within inFileName, a File Type constant must be provided with inFileType, the format must be specified using inFormat, inFlag contains flags for opening and creating the file (currently undefined; should be set to 0), and outNewFileRef is provided for file system use, while outAudioFile is for use with other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile){
//TODO
};



/*AudioFileSetProperty

Sets the data for the respective property.

extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData
);
Discussion

The file and property being set should be specified in inAudioFile and inPropertyID, respectively, with the size of the data being written passed into ioDataSize, and the data being written coming from inPropertyData.
Availability
Available in Mac OS X v10.2 and later.
Global Info Access*/
extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData){
//TODO
};


/*AudioFileClose

Closes the file.

extern OSStatus AudioFileClose(AudioFileID inAudioFile);
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioFileClose(AudioFileID inAudioFile){
//TODO
};


/*AudioFileOpen

Opens a file while preserving its contents.

extern OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile
);
Discussion

The inFileRef should be a reference to an existing file, inPermissions being the permissions for the file, as used by FSOpenFork(), and inFlags, currently undefined, should be set to 0; outAudioFile is a file instance that will be returned for use in other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile){
//TODO
};


/*AudioFormatGetPropertyInfo

Retrieves the size of the data to be returned by the property.

extern OSStatus AudioFormatGetPropertyInfo(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* outPropertyDataSize
);
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AudioFormatGetPropertyInfo(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* outPropertyDataSize){
//TODO
};


/*AudioFormatGetProperty

Retrieves the property information for the given property ID and selected specifier.

extern OSStatus AudioFormatGetProperty(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus AudioFormatGetProperty(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* ioPropertyDataSize,
void* outPropertyData){
//TODO
};


//function
/*AudioConverterSetProperty

Sets the property data to inPropertyData.

extern OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
);
Discussion

The inPropertyDataSize should be the size of data being input, and inPropertyData should point to the data to be set for inPropertyID.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
){};


/*AudioConverterGetProperty

Returns the requested property data.

extern OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Discussion

The ioPropertyDataSize parameter should be the value obtained from calling AudioConverterGetPropertyInfo(); the output value of ioPropertyDataSize will be the actual data size of the returned data, for reference.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
){};



/*AudioConverterGetPropertyInfo

Retrieves the size and writable state of the data belonging to the queried property.

extern OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* outSize,
Boolean* outWritable
);
Discussion

The outSize value returned reflects the size, in bytes, of the data returned by calling AudioConverterGetProperty() with the respective property.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 * outSize,
Boolean * outWritable
){};


/*AudioConverterFillComplexBuffer

Fills the AudioBufferList with converted data.

extern OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
);
Discussion

Using the callback provided in inInputDataProc, this function will convert input data using inAudioConverter and will place the resulting converted data in outOutputData. Any relevant data for the callback should be passed in via inInputDataProcUserData, while outPacketDescription will contain the format of the returned data. On input, ioOutDataPacketSize should contain the number of packets requested, and as output, will contain the number of packets returned.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
){};


/*AudioConverterDispose

Destroys an audio converter.

extern OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter);
Discussion

This function deallocates the memory used by inAudioConverter.
Availability
Available in Mac OS X v10.1 and later.*/
 OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter){};

/*AudioConverterNew

Creates a new audio converter.

extern OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
);
Discussion

This function takes in two AudioStreamBasicDescription instances, one for the source, and one for the destination, sets up all of the internal links needed for the conversion, and returns a pointer for the new converter. Note that if the setup fails, an error is returned which specifies the error that was encountered.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
){};


/*NewAUGraph

Creates a new AUGraph instance.

extern OSStatus NewAUGraph(AUGraph *outGraph);
Availability
Available in Mac OS X v10.0 and later.*/
 OSStatus NewAUGraph(AUGraph *outGraph){};

/*AUGraphNewNode

Creates a new node inside of the specified graph.

extern OSStatus AUGraphNewNode(
AUGraph inGraph,
const ComponentDescription *inDescription,
UInt32 inClassDataSize,
const void *inClassData,
AUNode *outNode
);
Discussion

The graph to which the new node is to be added is set in inGraph, while the node to be added may be specified using either a ComponentDescription, obtained from the Component Manager. The value of inClassData is a CFPropertyList containing the serialized data of a saved state. The function returns outNode for future reference towards the newly-created node.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphNewNode(
AUGraph inGraph,
const ComponentDescription *inDescription,
UInt32 inClassDataSize,
const void *inClassData,
AUNode *outNode
){};

/*AUGraphUninitialize

Uninitializes the graph and all of the Audio Units.

extern OSStatus AUGraphUninitialize(AUGraph inGraph);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphUninitialize(AUGraph inGraph){};


/*AUGraphStop

Stops all rendering through the graph.

extern OSStatus AUGraphStop(AUGraph inGraph);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphStop(AUGraph inGraph){};


/*AUGraphConnectNodeInput

Connects two graph nodes together and specifies the way inputs are ordered.

extern OSStatus AUGraphConnectNodeInput(
AUGraph inGraph,
AUNode inSourceNode,
UInt32 inSourceOutputNumber,
AUNode inDestNode,
UInt32 inDestInputNumber
);
Discussion

When connecting nodes together, the developer must specify how the output of one node maps to the input of another. To prevent fan out, all output-input connections are one-to-one, where each node may have multiple inputs and outputs (indexed starting with 0).
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphConnectNodeInput(
AUGraph inGraph,
AUNode inSourceNode,
UInt32 inSourceOutputNumber,
AUNode inDestNode,
UInt32 inDestInputNumber
){};
/*AUGraphGetNodeCount

Returns the number of nodes in the current graph.

extern OSStatus AUGraphGetNodeCount(
AUGraph inGraph,
UInt32 *outNumberOfNodes
);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphGetNodeCount(
AUGraph inGraph,
UInt32 *outNumberOfNodes
){};


/*AUGraphStart

Begins audio rendering through the graph.

extern OSStatus AUGraphStart(AUGraph inGraph);
Discussion

This function starts with the head node, always an output unit, and works through the graph to get to the inputs, pulls the data, and renders it through all of the Audio Units in the path leading to the head.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphStart(AUGraph inGraph){};


/*AUGraphOpen

Instantiates every Audio Unit in the graph.

extern OSStatus AUGraphOpen(AUGraph inGraph);
Discussion

This function should be called after the initial set of nodes is added to the graph and connections have been made between them. This will instantiate the nodes, meaning that their properties will be ready for modification. Each node’s sample rate may also be set after the graph is opened.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphOpen(AUGraph inGraph){};


/*AUGraphClose

Closes the graph and deallocates its Audio Unit nodes.

extern OSStatus AUGraphClose(AUGraph inGraph);
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphClose(AUGraph inGraph){};

/*AUGraphInitialize

Initializes the graph and the connected Audio Units.

extern OSStatus AUGraphInitialize(AUGraph inGraph);
Discussion

Invoking this function will activate the connections between nodes and will initialize all nodes that are part of a connection. It is important to note that if format changes occur, sample rates for output nodes must be set before this function is called.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphInitialize(AUGraph inGraph){};

/*AUGraphGetNodeInfo

Returns information about a node.

extern OSStatus AUGraphGetNodeInfo(
AUGraph inGraph,
AUNode inNode,
ComponentDescription *outDescription,
UInt32 *outClassDataSize,
void **outClassData,
AudioUnit *outAudioUnit
);
Discussion

This function retrieves various pieces of information about a graph’s nodes, which may be saved and used to rebuild the graph later using AUGraphNewNode(). The node and graph containing the node in question are passed as inGraph and inNode, respectively. Upon output, outDescription points to a ComponentDescription, provided by the Component Manager. Also, outClassData points towards a CFPropertyRef, which may be saved and used to rebuild the graph later on. The node’s Audio Unit type is pointed to by outAudioUnit. The outClassDataSize parameter is currently not used, and will return 0.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus AUGraphGetNodeInfo(
AUGraph inGraph,
AUNode inNode,
ComponentDescription *outDescription,
UInt32 *outClassDataSize,
void **outClassData,
AudioUnit *outAudioUnit
){};





