#ifndef TRAPS_H
#define TRAPS_H

#ifndef  CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif



#include <HYS/Traps.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Constants
/Gestalt selectors/
#define gestaltOSTable        'ostt'   /base of Operating System dispatch /
                                       / table/
#define gestaltToolboxTable   'tbtt'   /base of Toolbox dispatch table/
#define gestaltExtToolboxTable'xttt'   /0, unless Toolbox dispatch table /
                                       / is disjoint, in which case base /
                                       / of upper half/
/values of TrapType/
enum {OSTrap, ToolTrap};
/system errors triggered by Trap Manager/
enum {
   dsCoreErr         = 12,             /unimplemented trap error/
   dsBadPatchHeader  = 83              /attempt to install come-from patch/
};*/
//values of TrapType/
enum {OSTrap, ToolTrap};

/*Data Types
typedef unsigned char TrapType;*/
typedef unsigned char TrapType;

//func

/*Installing Patch Addresses Into the Trap Dispatch Tables
pascal void NSetTrapAddress
			(long trapAddr, short trapNum,
			 TrapType tTyp);
pascal void SetOSTrapAddress
			(long trapAddr, short trapNum);
/SetToolboxTrapAddress is also spelled as SetToolTrapAddress/
pascal void SetToolboxTrapAddress
			(long trapAddr, short trapNum);
pascal void SetToolTrapAddress
			(long trapAddr, short trapNum);*/
pascal void NSetTrapAddress
			(long trapAddr, short trapNum,
			 TrapType tTyp);
pascal void SetToolTrapAddress
			(long trapAddr, short trapNum);


/*Accessing Addresses From the Trap Dispatch Tables
pascal long NGetTrapAddress
				(short trapNum, TrapType tTyp);
pascal long GetOSTrapAddress
				(short trapNum);
/GetToolboxTrapAddress is also spelled as GetToolTrapAddress/
pascal long GetToolboxTrapAddress
				(short trapNum);*/
pascal long NGetTrapAddress
				(short trapNum, TrapType tTyp);


#ifdef __cplusplus
}
#endif

#endif