#ifndef  SYSTEMCONFIGURATION_H
#define SYSTEMCONFIGURATION_H

#include <sys/cdefs.h>
#include <CoreFoundation/CoreFoundation.h>
#include <SystemConfiguration/SCDynamicStore.h>
#include <SystemConfiguration/SCDynamicStoreKey.h>
#include <SystemConfiguration/SCDynamicStoreCopySpecific.h>
#include <SystemConfiguration/SCPreferences.h>
#include <SystemConfiguration/SCPreferencesPath.h>
#include <SystemConfiguration/SCNetworkConfiguration.h>
#include <SystemConfiguration/SCSchemaDefinitions.h>
#include <SystemConfiguration/SCNetwork.h>
#include <SystemConfiguration/SCNetworkReachability.h>
#include <SystemConfiguration/SCNetworkConnection.h>

enum { 
    /*
 * Generic error codes
        */
    kSCStatusOK = 0, /* Success */
    kSCStatusFailed = 1001, /* Non-specific failure */
    kSCStatusInvalidArgument = 1002, /* Invalid argument */
    kSCStatusAccessError = 1003, /* Permission denied
 - must be root to obtain lock
 - could not create access/create preferences
        */
    kSCStatusNoKey = 1004, /* No such key */
    kSCStatusKeyExists = 1005, /* Key already defined */
    kSCStatusLocked = 1006, /* Lock already held */
    kSCStatusNeedLock = 1007, /* Lock required for this operation */
    /*
 * SCDynamicStore error codes
        */
    kSCStatusNoStoreSession = 2001, /* Configuration daemon session not active */
    kSCStatusNoStoreServer = 2002, /* Configuration daemon not (no longer) available */
    kSCStatusNotifierActive = 2003, /* Notifier is currently active */
    /*
 * SCPreferences error codes
        */
    kSCStatusNoPrefsSession = 3001, /* Preference session not active */
    kSCStatusPrefsBusy = 3002, /* Preferences update currently in progress */
    kSCStatusNoConfigFile = 3003, /* Configuration file not found */
    kSCStatusNoLink = 3004, /* No such link */
    kSCStatusStale = 3005, /* Write attempted on stale version of object */
    kSCStatusMaxLink = 3006, /* Maximum link count exceeded */
    /*
 * SCNetwork error codes
        */
    kSCStatusReachabilityUnknown = 4001 /* Network reachability cannot be determined */
};

//func

/*SCError

int SCError ();  
Return Value

Returns the last error encountered. 
Discussion 

Returns the most recent status or error code generated as the result of calling a System Configuration framework API.*/
int SCError ();

#endif