#ifndef SCNETWORKREACHABILITY_H
#define SCNETWORKREACHABILITY_H

#include <AvailabilityMacros.h>
#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <CoreFoundation/CoreFoundation.h>
#include <SystemConfiguration/SCNetwork.h>

/*SCNetworkReachabilityRef

typedef const struct __SCNetworkReachability * SCNetworkReachabilityRef;  
Discussion 

This is the handle to a network address or name. 
Availability
Introduced in Mac OS X v10.3.*/
typedef const struct __SCNetworkReachability * SCNetworkReachabilityRef;  

/*SCNetworkReachabilityCallBack

typedef void (*SCNetworkReachabilityCallBack) ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags flags, 
    void *info );  
Parameters
target
The SCNetworkReachability reference being monitored for changes.
flags
The new SCNetworkConnectionFlags representing the reachability status of the network address/name.
info
A C pointer to a user-specified block of data.
Discussion 

Type of the callback function used when the reachability of a network address or name changes. 
Availability
Introduced in Mac OS X v10.3.*/
typedef void (*SCNetworkReachabilityCallBack) ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags flags, 
    void *info );

/*SCNetworkReachabilityContext

typedef struct { 
    CFIndex version; 
    void *info; 
    const void *(*retain)(
        const void *info); 
    void (*release)(
        const void *info); 
    CFStringRef (*copyDescription)(
        const void *info); 
} SCNetworkReachabilityContext;  
Fields
version
The version number of the structure type being passed in as a parameter to the SCDynamicStore creation function. This structure is version 0.
info
A C pointer to a user-specified block of data.
retain
The callback used to add a retain for the info field. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. The value may be NULL.
release
The calllback used to remove a retain previously added for the info field. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. The value may be NULL.
copyDescription
The callback used to provide a description of the info field.
Discussion 

Structure containing user-specified data and callbacks for SCNetworkReachability.
Availability
Introduced in Mac OS X v10.3.*/
typedef struct { 
    CFIndex version; 
    void *info; 
    const void *(*retain)(
        const void *info); 
    void (*release)(
        const void *info); 
    CFStringRef (*copyDescription)(
        const void *info); 
} SCNetworkReachabilityContext;

//functions


/*SCNetworkReachabilityCreateWithName

SCNetworkReachabilityRef SCNetworkReachabilityCreateWithName ( 
    CFAllocatorRef allocator, 
    const char *nodename );  
Parameters
nodename
The node name of the desired host. This name would be the same as that passed to the gethostbyname(3) or getaddrinfo(3) functions.
Return Value

Returns a reference to the new immutable SCNetworkReachabilityRef. 

You must release the returned value. 
Discussion 

Creates a reference to the specified network host or node name. This reference can be used later to monitor the reachability of the target host. 
Availability
Introduced in Mac OS X v10.3.*/
SCNetworkReachabilityRef SCNetworkReachabilityCreateWithName ( 
    CFAllocatorRef allocator, 
    const char *nodename );

/*SCNetworkReachabilitySetCallback

Boolean SCNetworkReachabilitySetCallback ( 
    SCNetworkReachabilityRef target, 
    SCNetworkReachabilityCallBack callout, 
    SCNetworkReachabilityContext *context );  
Parameters
target
The network reference associated with the address or name to be checked for reachability.
callout
The function to be called when the reachability of the target changes. If NULL, the current client for the target is removed.
context
The SCNetworkReachabilityContext associated with the callout. The value may be NULL.
Return Value

Returns TRUE if the notification client was successfully set. 
Discussion 

Assigns a client to a target, which receives callbacks when the reachability of the target changes. 
Availability
Introduced in Mac OS X v10.3.*/

Boolean SCNetworkReachabilitySetCallback ( 
    SCNetworkReachabilityRef target, 
    SCNetworkReachabilityCallBack callout, 
    SCNetworkReachabilityContext *context );  


/*SCNetworkReachabilityUnscheduleFromRunLoop

Boolean SCNetworkReachabilityUnscheduleFromRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
target
The address or name that is set up for asynchronous notifications. Must be non-NULL.
runLoop
A reference to a run loop from which the target should be unscheduled. Must be non-NULL.
runLoopMode
The mode on which to unschedule the target. Must be non-NULL.
Return Value

Returns TRUE if the target is unscheduled successfully; FALSE otherwise. 
Discussion 

Unschedules the given target from the given run loop and mode. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityUnscheduleFromRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );/*

SCNetworkReachabilityScheduleWithRunLoop

Boolean SCNetworkReachabilityScheduleWithRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
target
The address or name that is set up for asynchronous notifications. Must be non-NULL.
runLoop
A reference to a run loop on which the target should be scheduled. Must be non-NULL.
runLoopMode
The mode on which to schedule the target. Must be non-NULL.
Return Value

Returns TRUE if the target is scheduled successfully; FALSE otherwise. 
Discussion 

Schedules the given target with the given run loop and mode. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityScheduleWithRunLoop ( 
    SCNetworkReachabilityRef target,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode );

/*SCNetworkReachabilityGetFlags

Boolean SCNetworkReachabilityGetFlags ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags *flags );  
Parameters
target
The network reference associated with the address or name to be checked for reachability.
flags
A pointer to memory that will be filled with the SCNetworkConnectionFlags detailing the reachability of the specified target.
Return Value

Returns TRUE if the network connection flags are valid; FALSE if the status could not be determined. 
Discussion 

Determines if the given target is reachable using the current network configuration. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityGetFlags ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags *flags );  

#endif