#ifndef QDOFFSCREEN_H
#define QDOFFSCREEN_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif


#include <HYS/QD/QDOffscreen.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*pixPurgeBit

enum {
   pixPurgeBit = 0,
   noNewDeviceBit = 1,
   useTempMemBit = 2,
   keepLocalBit = 3,
   useDistantHdwrMemBit = 4,
   useLocalHdwrMemBit = 5,
   pixelsPurgeableBit = 6,
   pixelsLockedBit = 7,
   mapPixBit = 16,
   newDepthBit = 17,
   alignPixBit = 18,
   newRowBytesBit = 19,
   reallocPixBit = 20,
   clipPixBit = 28,
   stretchPixBit = 29,
   ditherPixBit = 30,
   gwFlagErrBit = 31
};*/
enum {
   pixPurgeBit = 0,
   noNewDeviceBit = 1,
   useTempMemBit = 2,
   keepLocalBit = 3,
   useDistantHdwrMemBit = 4,
   useLocalHdwrMemBit = 5,
   pixelsPurgeableBit = 6,
   pixelsLockedBit = 7,
   mapPixBit = 16,
   newDepthBit = 17,
   alignPixBit = 18,
   newRowBytesBit = 19,
   reallocPixBit = 20,
   clipPixBit = 28,
   stretchPixBit = 29,
   ditherPixBit = 30,
   gwFlagErrBit = 31
};

/*GWorldFlags

Abst_GWorldFlags

typedef unsigned long GWorldFlags;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long GWorldFlags;

/*GWorldPtr

typedef CGrafPtr GWorldPtr;
Discussion

An offscreen graphics world in color QuickDraw contains a CGrafPort structure—and its handles to associated PixMap and ColorTable structures—that describes an offscreen graphics port and contains references to a GDevice structure and other state information. The actual data structure for an offscreen graphics world is kept private to allow for future extensions. However, when your application uses the NewGWorld function to create an offscreen world, NewGWorld returns a pointer of type GWorldPtr by which your application refers to the offscreen graphics world. 

On computers lacking color QuickDraw, GWorldPtr points to an extension of the GrafPort structure. 
Availability
Available in Mac OS X v10.0 and later*/

typedef CGrafPtr GWorldPtr;

/*Graphics World Flags

enum {
   pixPurge = 1L << pixPurgeBit,
   noNewDevice = 1L << noNewDeviceBit,
   useTempMem = 1L << useTempMemBit,
   keepLocal = 1L << keepLocalBit,
   useDistantHdwrMem = 1L << useDistantHdwrMemBit,
   useLocalHdwrMem = 1L << useLocalHdwrMemBit,
   pixelsPurgeable = 1L << pixelsPurgeableBit,
   pixelsLocked = 1L << pixelsLockedBit,
   kAllocDirectDrawSurface = 1L << 14,
   mapPix = 1L << mapPixBit,
   newDepth = 1L << newDepthBit,
   alignPix = 1L << alignPixBit,
   newRowBytes = 1L << newRowBytesBit,
   reallocPix = 1L << reallocPixBit,
   clipPix = 1L << clipPixBit,
   stretchPix = 1L << stretchPixBit,
   ditherPix = 1L << ditherPixBit,
   gwFlagErr = 1L << gwFlagErrBit
};
Constants
pixPurge

If you specify this flag for the flags parameter of the NewGWorld function, UpdateGWorld makes the base address for the offscreen pixel image purgeable.

Available in Mac OS X v10.0 and later.
noNewDevice

If you specify this flag for the flags parameter of the UpdateGWorld function, NewGWorld does not create a new offscreen GDevice structure; instead, NewGWorld uses either the GDevice structure you specify or the GDevice structure for a video card on the user’s system.

Available in Mac OS X v10.0 and later.
useTempMem

If you specify this in the flags parameter of the UpdateGWorld function, NewGWorld creates the base address for an offscreen pixel image in temporary memory. You generally should not use this flag. You should use temporary memory only for fleeting purposes and only with the GetPixelsState function so that other applications can launch.

Available in Mac OS X v10.0 and later.
keepLocal

If you specify this in the flags parameter of the UpdateGWorld function, NewGWorld creates a pixel image in Macintosh main memory where it cannot be cached to a graphics accelerator card. 

If you specify this in the flags parameter of GetPixelsState, UpdateGWorld keeps the offscreen pixel image in Macintosh main memory.

Available in Mac OS X v10.0 and later.
pixelsPurgeable

If you specify this in the state parameter of the UpdateGWorld function, SetPixelsState makes the base address for an offscreen pixel map purgeable. If you use the SetPixelsState function without passing it this flag, then SetPixelsState makes the base address for an offscreen pixel map unpurgeable. If the GetPixelsState function returns this flag, then the base address for an offscreen pixel is purgeable.

Available in Mac OS X v10.0 and later.
pixelsLocked

If you specify this flag for the state parameter of the SetPixelsState function, SetPixelsState locks the base address for an offscreen pixel image. If you use the SetPixelsState function without passing it this flag, then SetPixelsState unlocks the offscreen pixel image. If the GetPixelsState function returns this flag, then the base address for an offscreen pixel is locked.

Available in Mac OS X v10.0 and later.
mapPix

If the UpdateGWorld function returns this flag, then it remapped the colors in the offscreen pixel map to a new color table. 

Available in Mac OS X v10.0 and later.
newDepth

If the UpdateGWorld function returns this flag, then it translated the offscreen pixel map to a different pixel depth. 

Available in Mac OS X v10.0 and later.
alignPix

If the UpdateGWorld function returns this flag, then it realigned the offscreen pixel image to an onscreen window. 

Available in Mac OS X v10.0 and later.
newRowBytes

If the UpdateGWorld function returns this flag, then it changed the rowBytes field of the PixMap structure for the offscreen graphics world. 

Available in Mac OS X v10.0 and later.
reallocPix

If the UpdateGWorld function returns this flag, then it reallocated the base address for the offscreen pixel image. Your application should then reconstruct the pixel image or draw directly in a window instead of preparing the image in an offscreen graphics world.

Available in Mac OS X v10.0 and later.
clipPix

If you specify this flag in the flags parameter of the UpdateGWorld function, then UpdateGWorld updates and clips the pixel image to the new boundary rectangle specified. If the UpdateGWorld function returns this flag, then it clipped the pixel image. 

Available in Mac OS X v10.0 and later.
stretchPix

If you specify this flag in the flags parameter of the UpdateGWorld function, then UpdateGWorld updates and stretches or shrinks the pixel image to the new boundary rectangle specified. If the UpdateGWorld function returns this flag, then it stretched or shrank the offscreen image.

Available in Mac OS X v10.0 and later.
ditherPix

If you specify this flag in the flags parameter of the UpdateGWorld function, then UpdateGWorld dithers the pixel image to the new boundary rectangle specified. Include this flag with the clipPix or stretchPix flag. If the UpdateGWorld function returns this flag, then it dithered the offscreen image. 

Available in Mac OS X v10.0 and later.
gwFlagErr

If the UpdateGWorld function returns this flag, then it was unsuccessful and the offscreen graphics world was left unchanged.

Available in Mac OS X v10.0 and later.
Discussion

Note that with the exception of noNewDeviceBit and nativeEndianPixMapBit, these constants are obsolete in Mac OS X and are ignored by the function NewGWorld.*/
enum {
   pixPurge = 1L << pixPurgeBit,
   noNewDevice = 1L << noNewDeviceBit,
   useTempMem = 1L << useTempMemBit,
   keepLocal = 1L << keepLocalBit,
   useDistantHdwrMem = 1L << useDistantHdwrMemBit,
   useLocalHdwrMem = 1L << useLocalHdwrMemBit,
   pixelsPurgeable = 1L << pixelsPurgeableBit,
   pixelsLocked = 1L << pixelsLockedBit,
   kAllocDirectDrawSurface = 1L << 14,
   mapPix = 1L << mapPixBit,
   newDepth = 1L << newDepthBit,
   alignPix = 1L << alignPixBit,
   newRowBytes = 1L << newRowBytesBit,
   reallocPix = 1L << reallocPixBit,
   clipPix = 1L << clipPixBit,
   stretchPix = 1L << stretchPixBit,
   ditherPix = 1L << ditherPixBit,
   gwFlagErr = 1L << gwFlagErrBit
};



//function


/*DisposeGWorld

Disposes of all the memory allocated for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeGWorld (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. In this parameter, pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Discussion

The DisposeGWorld function disposes of all the memory allocated for the specified offscreen graphics world, including the pixel map, color table, pixel image, and GDevice structure (if one was created).

Call DisposeGWorld only when your application no longer needs the pixel image associated with this offscreen graphics world. If this offscreen graphics world was the current device, the current device is reset to the device stored in the global variable MainDevice. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void DisposeGWorld (
   GWorldPtr offscreenGWorld
);

/*LockPixels

Prevents the base address for an offscreen pixel image from being moved while you draw into or copy from its pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean LockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function . 
Return Value

If the base address for an offscreen pixel image hasn’t been purged by the Memory Manager or is not purgeable, LockPixels returns TRUE as its function result, and your application can draw into or copy from the offscreen pixel map. However, if the base address for an offscreen pixel image has been purged, LockPixels returns FALSE to indicate that you can perform no drawing to or copying from the pixel map. At that point, your application should either call the UpdateGWorld function to reallocate the offscreen pixel image and then reconstruct it, or draw directly in a window instead of preparing the image in an offscreen graphics world. 
Discussion

You must call LockPixels before drawing to or copying from an offscreen graphics world. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function the handle is recovered.

As soon as you are finished drawing into and copying from the offscreen pixel image, call the UnlockPixels function. 
Special Considerations

The LockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Boolean LockPixels (
   PixMapHandle pm
);

/*GetGWorldPixMap

Obtains the pixel map created for an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. Pass the pointer returned to your application by the NewGWorld function when you created the offscreen graphics world. 
Return Value

A handle to the pixel map created for an offscreen graphics world. Your application can, in turn, pass the handle returned by GetGWorldPixMap as a parameter to other QuickDraw functions that accept a handle to a pixel map.

On a system running only basic QuickDraw, the GetGWorldPixMap function returns the handle to a 1-bit pixel map that your application can supply as a parameter to the other functions related to offscreen graphics worlds. However, your application should not supply this handle to color QuickDraw functions.

Special Considerations

To ensure compatibility on systems running basic QuickDraw instead of Color QuickDraw, use GetGWorldPixMap whenever you need to gain access to the bitmap created for a graphics world—that is, do not dereference the GWorldPtr structure for that graphics world.
Version Notes

The GetGWorldPixMap function is not available in systems preceding System 7. You can make sure that the GetGWorldPixMap function is available by using the Gestalt function with the gestaltSystemVersion selector. Test the low-order word in the response parameter; if the value is $0700 or greater, then GetGWorldPixMap is available.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
PixMapHandle GetGWorldPixMap (
   GWorldPtr offscreenGWorld
);

/*GetGWorldDevice

Obtains a handle to the GDevice structure associated with an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);
Parameters
offscreenGWorld

A pointer to an offscreen graphics world. The pointer returned to your application by the NewGWorld function. 
Return Value

A handle to the GDevice structure associated with the offscreen graphics world specified by the offscreenGWorld parameter. 


If you created the offscreen world by specifying the noNewDevice flag, the GDevice structure is for one of the screen devices or is the GDevice structure that you specified to NewGWorld or UpdateGWorld.

If you point to a GrafPort or CGrafPort structure in the offscreenGWorld parameter, GetGWorldDevice returns the current device.

Special Considerations

The GetGWorldDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GDHandle GetGWorldDevice (
   GWorldPtr offscreenGWorld
);

/*GetGWorld

Saves the current graphics port (basic, color, or offscreen) and the current GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);
Parameters
port

On return, a pointer to the current graphics port in the port parameter. This parameter can return values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether the current graphics port is a basic graphics port, color graphics port, or offscreen graphics world. 
gdh

On return, a pointer to a handle to the GDevice structure for the current device. 
Discussion

After using GetGWorld to save a graphics port and a GDevice structure, use the SetGWorld function to restore them. 
Special Considerations

The GetGWorld function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void GetGWorld (
   CGrafPtr * port,
   GDHandle * gdh
);

/*SetGWorld

Changes the current graphics port (basic, color, or offscreen). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);
Parameters
port

A pointer to an offscreen graphics world, color graphics port, or basic graphics port. Specify values of type GrafPtr, CGrafPtr, or GWorldPtr, depending on whether you want to set the current graphics port to be a basic graphics port, color graphics port, or offscreen graphics world. Any drawing your application performs then occurs in this graphics port. 
gdh

A handle to a GDevice structure. If you pass a pointer to an offscreen graphics world in the port parameter, set this parameter to NULL, because SetGWorld ignores this parameter and sets the current device to the device attached to the offscreen graphics world. 
Discussion

The SetGWorld function sets the current graphics port to the one specified by the port parameter and—unless you set the current graphics port to be an offscreen graphics world—sets the current device to that specified by the gdh parameter. 
Special Considerations

The SetGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

void SetGWorld (
   CGrafPtr port,
   GDHandle gdh
);

/*UnlockPixels

Allows the Memory Manager to move the base address for the offscreen pixel map that you specify in the pm parameter. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void UnlockPixels (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. Pass the same handle that you passed previously to the LockPixels function. 
Discussion

To ensure the integrity of the data in a pixel image, call LockPixels before drawing into or copying from a pixel map; then, to prevent heap fragmentation, call UnlockPixels as soon as your application finishes drawing to and copying from the offscreen pixel map. 

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer (which is what the baseAddr field for an onscreen pixel map contains). The LockPixels function dereferences the PixMap handle into a pointer. When you use the UnlockPixels function, the handle is recovered.

You don’t need to call UnlockPixels if LockPixels returns FALSE, because LockPixels doesn’t lock the memory for a pixel image if that memory has been purged. However, calling UnlockPixels on purged memory does no harm. 
Special Considerations

The UnlockPixels function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void UnlockPixels (
   PixMapHandle pm
);

/*GetPixBaseAddr

Obtains a pointer to an offscreen pixel map. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Ptr GetPixBaseAddr (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function. 
Return Value

A 32-bit pointer to the beginning of a pixel image. If the offscreen buffer has been purged, GetPixBaseAddr returns NULL. 
Discussion

The baseAddr field of the PixMap structure for an offscreen graphics world contains a handle instead of a pointer, which is what the baseAddr field for an onscreen pixel map contains. You must use the GetPixBaseAddr function to obtain a pointer to the PixMap structure for an offscreen graphics world.

Your application should never directly access the baseAddr field of the PixMap structure for an offscreen graphics world; instead, always use GetPixBaseAddr. If your application is using 24-bit mode, use the PixMap32Bit function to determine whether a pixel map requires 32-bit addressing mode for access to its pixel image. 
Special Considerations

Any QuickDraw functions that your application uses after calling GetPixBaseAddr may change the base address for the offscreen pixel image.

The GetPixBaseAddr function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
Ptr GetPixBaseAddr (
   PixMapHandle pm
);

/*NewGWorld

Creates an offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDErr NewGWorld (
   GWorldPtr * offscreenGWorld,
   short PixelDepth,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags
);
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this function. You use this pointer when referring to this new offscreen world in other QuickDraw functions. 
PixelDepth

The pixel depth of the offscreen world; possible depths are 1, 2, 4, 8, 16, and 32 bits per pixel. The default parameter (0) uses the pixel depth of the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you specify 0 in this parameter, NewGWorld also uses the GDevice structure from this device instead of creating a new GDevice structure for the offscreen world. If you use NewGWorld on a computer that supports only basic QuickDraw, you may specify only 0 or 1 in this parameter.
boundsRect

The boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if NewGWorld creates one. If you specify 0 in the pixelDepth parameter, NewGWorld interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. NewGWorld then uses the pixel depth, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NULL in this parameter, NewGWorld uses the default color table for the pixel depth that you specify in the pixelDepth parameter. If you set the pixelDepth parameter to 0, NewGWorld ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use NewGWorld on a computer that supports only basic QuickDraw, you may specify only NULL in this parameter. 
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case NewGWorld attaches this GDevice structure to the new offscreen graphics world. If you set the pixelDepth parameter to 0, or if you do not set the noNewDevice flag, NewGWorld ignores the aGDevice parameter, so set it to NULL. If you set the pixelDepth parameter to 0, NewGWorld uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NULL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds. 
flags

Options available to your application. You can set a combination of the flags pixPurge, noNewDevice, useTempMem, and keepLocal. If you don’t wish to use any of these flags, specify 0 in this parameter to accept the default behavior for NewGWorld. The default behavior creates an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, it uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See Graphics World Flags for a description of the values you can use here. 
Return Value

A result code.
Discussion

Typically, you pass 0 in the pixelDepth parameter, a window’s port rectangle in the boundsRect parameter, NULL in the cTable and aGDevice parameters, and in the flags parameter a 0. This provides your application with the default behavior of NewGWorld, and it supports computers running basic QuickDraw. This also allows QuickDraw to optimize the CopyBits, CopyMask, and CopyDeepMask functions when your application copies the image in an offscreen graphics world into an onscreen graphics port.

The NewGWorld function allocates memory for an offscreen graphics port and its pixel map. On computers that support only basic QuickDraw, NewGWorld creates a 1-bit pixel map that your application can manipulate using other relevant functions described in this chapter. Your application can copy this 1-bit pixel map into basic graphics ports.

Unless you specify 0 in the pixelDepth parameter–or pass the noNewDevice flag in the flags parameter and supply a GDevice structure in the aGDevice parameter– NewGWorld also allocates a new offscreen GDevice structure.

When creating an image, use the NewGWorld function to create an offscreen graphics world that is optimized for an image’s characteristics—for example, its best pixel depth. After creating the image, use the CopyBits, CopyMask, or CopyDeepMask function to copy that image to an onscreen graphics port. Color QuickDraw automatically renders the image at the best available pixel depth for the screen. Creating an image in an offscreen graphics port and then copying it to the screen in this way prevents the visual choppiness that would otherwise occur if your application were to build a complex image directly onscreen.

The NewGWorld function initializes the offscreen graphics port by calling the OpenCPort function. The NewGWorld function sets the offscreen graphics port’s visible region to a rectangular region coincident with its boundary rectangle. The NewGWorld function generates an inverse table with the Color Manager function MakeITable, unless one of the GDevice structures for the screens has the same color table as the GDevice structure for the offscreen world, in which case NewGWorld uses the inverse table from that GDevice structure.

The address of the offscreen pixel image is not directly accessible from the PixMap structure for the offscreen graphics world. However, you can use the GetPixBaseAddr function to get a pointer to the beginning of the offscreen pixel image. 

For purposes of estimating memory use, you can compute the size of the offscreen pixel image by using this formula:

rowBytes * (boundsRect.bottom – boundsRect.top)

In the flags parameter, you can specify several options. If you don’t want to use any of these options, pass 0 in the flags parameter:
If you specify the pixPurge flag, NewGWorld stores the offscreen pixel image in a purgeable block of memory. In this case, before drawing to or from the offscreen pixel image, your application should call the LockPixels function and ensure that it returns TRUE. If LockPixels returns FALSE, the memory for the pixel image has been purged, and your application should either call UpdateGWorld to reallocate it and then reconstruct the pixel image, or draw directly in a window instead of preparing the image in an offscreen graphics world. Never draw to or copy from an offscreen pixel image that has been purged without reallocating its memory and then reconstructing it. 
If you specify the noNewDevice flag, NewGWorld does not create a new offscreen GDevice structure. Instead, it uses the GDevice structure that you specify in the aGDevice parameter–and its associated pixel depth and color table–to create the offscreen graphics world. (If you set the pixelDepth parameter to 0, NewGWorld uses the GDevice structure for the screen with the greatest pixel depth among all the screens whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter–even if you specify the noNewDevice flag.) The NewGWorld function keeps a reference to the GDevice structure for the offscreen graphics world, and the SetGWorld function uses that structure to set the current graphics device. 
If you set the useTempMem flag, NewGWorld creates the base address for an offscreen pixel image in temporary memory. You generally would not use this flag, because you should use temporary memory only for fleeting purposes and only with the AllowPurgePixels function. 
If you specify the keepLocal flag, your offscreen pixel image is kept in Macintosh main memory and is not cached to a graphics accelerator card. use this flag carefully, as it negates the advantages provided by any graphics acceleration card that might be present. 

If your application needs to change the pixel depth, boundary rectangle, or color table for an offscreen graphics world, use the UpdateGWorld function. 
Special Considerations

If you supply a handle to a ColorTable structure in the cTable parameter, NewGWorld makes a copy of the structure and stores its handle in the offscreen PixMap structure. It is your application’s responsibility to make sure that the ColorTable structure you specify in the cTable parameter is valid for the offscreen graphics port’s pixel depth. 

If when using NewGWorld you specify a pixel depth, color table, or GDevice structure that differs from those used by the window into which you copy your offscreen image, the CopyBits, CopyMask, and CopyDeepMask functions require extra time to complete.

To use a custom color table in an offscreen graphics world, you need to create the associated offscreen GDevice structure, because Color QuickDraw needs its inverse table. 

The NewGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
QDErr NewGWorld (
   GWorldPtr * offscreenGWorld,
   short PixelDepth,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags
);

/*GetPixRowBytes

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

long GetPixRowBytes (
   PixMapHandle pm
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/

long GetPixRowBytes (
   PixMapHandle pm
);

/*NewGWorldFromPtr

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDErr NewGWorldFromPtr (
   GWorldPtr * offscreenGWorld,
   unsigned long PixelFormat,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags,
   Ptr newBuffer,
   long rowBytes
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
QDErr NewGWorldFromPtr (
   GWorldPtr * offscreenGWorld,
   unsigned long PixelFormat,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags,
   Ptr newBuffer,
   long rowBytes
);

/*CTabChanged

Signals QuickDraw that the content of a ColorTable structure has been modified. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CTabChanged (
   CTabHandle ctab
);
Parameters
ctab

A handle to the ColorTable structure changed by your application. 
Discussion

The CTabChanged function calls the function GetCTSeed and gets a new, unique identifier in the ctSeed field of the ColorTable structure, and notifies QuickDraw of the change.

Your application should never need to directly modify a ColorTable structure and use the CTabChanged function; instead, your application should use the QuickDraw functions provided for manipulating the values in a ColorTable structure. 
Special Considerations

The CTabChanged function may move or purge memory in the application heap; do not call the CTabChanged function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void CTabChanged (
   CTabHandle ctab
);

/*GetPixelsState

Saves the current information about the memory allocated for an offscreen pixel image. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GWorldFlags GetPixelsState (
   PixMapHandle pm
);
Parameters
pm

A handle to an offscreen pixel map. To get a handle to an offscreen pixel map, use the GetGWorldPixMap function. 
Return Value

Information about the memory allocated for the base address for an offscreen pixel image. This result can be either of the constants, pixelsPurgeable or pixelsLocked. If the pixelsPurgeable flag is not returned, then the base address for the offscreen pixel image is unpurgeable. If the pixelsLocked flag is not returned, then the base address for the offscreen pixel image is unlocked. 
Discussion

After using GetPixelsState to save this state information, use the SetPixelsState function to restore this state to the offscreen graphics world.

After using GetPixelsState and before using SetPixelsState, temporarily use the AllowPurgePixels function to make the base address for an offscreen pixel image purgeable, the NoPurgePixels function to make it unpurgeable, the LockPixels function to prevent it from being moved, and the UnlockPixels function to allow it to be moved. 
Special Considerations

The GetPixelsState function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GWorldFlags GetPixelsState (
   PixMapHandle pm
);

/*PortChanged

Notifies QuickDraw that the content of a GrafPort structure or CGrafPort structure, including any of the data structures specified by handles within the structure, has been modified. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PortChanged (
   GrafPtr port
);
Parameters
port

A pointer to the GrafPort structure that you have changed. 
Discussion

If your application has changed a CGrafPort structure, it must coerce the CGrafPtr so it will point to a GrafPtr before passing the pointer in the port parameter.

You generally should not directly change any of the PixPat structures specified in a CGrafPort structure, but instead use the PenPixPat and BackPixPat functions. However, if your application does change the content of a PixPat structure, it should call the PixPatChanged function and the PortChanged function.

If your application changes the pmTable field of the PixMap structure specified in the graphics port, your application should call PortChanged. If your application changes the content of the ColorTable structure referenced by the pmTable field, it should call CTabChanged also. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
void PortChanged (
   GrafPtr port
);

/*UpdateGWorld

Changes the pixel depth, boundary rectangle, or color table for an existing offscreen graphics world. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GWorldFlags UpdateGWorld (
   GWorldPtr * offscreenGWorld,
   short pixelDepth,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags
);
Parameters
offscreenGWorld

On input, a pointer to an existing offscreen graphics world; upon completion, the pointer to the updated offscreen graphics world. 
pixelDepth

The pixel depth of the offscreen world; possible depths are 1, 2, 4, 8, 16, and 32 bits per pixel. If you specify 0 in this parameter, UpdateGWorld rescans the device list and uses the depth of the screen with the greatest pixel depth among all screens whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you specify 0 in this parameter, UpdateGWorld also copies the GDevice structure from this device to create an offscreen GDevice structure. The UpdateGWorld function ignores the value you supply for this parameter if you specify a GDevice structure in the aGDevice parameter.
boundsRect

The boundary rectangle and port rectangle for the offscreen pixel map. This also becomes the boundary rectangle for the GDevice structure, if NewGWorld creates one. If you specify 0 in the pixelDepth parameter, NewGWorld interprets the boundaries in global coordinates, with which it determines which screens intersect the rectangle. (NewGWorld then uses the pixel depth, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle.) Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NULL in this parameter, UpdateGWorld uses the default color table for the pixel depth that you specify in the pixelDepth parameter; if you set the pixelDepth parameter to 0, UpdateGWorld copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. The UpdateGWorld function ignores the value you supply for this parameter if you specify a GDevice structure in the aGDevice parameter. 
aGDevice

As an option, a handle to a GDevice structure whose pixel depth and color table you want to use for the offscreen graphics world. To use the pixel depth and color table that you specify in the pixelDepth and cTable parameters, set this parameter to NULL. 
flags

Options available to your application. You can set a combination of the flags clipPix, stretchPix, and ditherPix. If you don’t wish to use any of these flags, specify 0. However, you should pass either clipPix or stretchPix to ensure that the pixel map is updated to reflect the new color table. See GWorldFlags for a description of the values you can use here. 
Return Value

UpdateGWorld returns the gwFlagErr flag if UpdateGWorld was unsuccessful; in this case, the offscreen graphics world is left unchanged. Use the QDError function to help you determine why UpdateGWorld failed. 
Discussion

You should call UpdateGWorld after every update event and whenever your windows move or change size. 

If the LockPixels function reports that the Memory Manager has purged the base address for the offscreen pixel image, use UpdateGWorld to reallocate its memory. Then, reconstruct the pixel image or draw directly in a window instead of preparing the image in an offscreen graphics world.

The UpdateGWorld function uses the following algorithm when updating the offscreen pixel image:
If the color table that you specify in the cTable parameter is different from the previous color table, or if the color table associated with the GDevice structure that you specify in the aGDevice parameter is different, Color QuickDraw maps the pixel values in the offscreen pixel map to the new color table. 
If the value you specify in the pixelDepth parameter differs from the previous pixel depth, Color QuickDraw translates the pixel values in the offscreen pixel image to those for the new pixel depth. 
If the rectangle you specify in the boundsRect parameter differs from, but has the same size as, the previous boundary rectangle, QuickDraw realigns the pixel image to the screen for optimum performance for the CopyBits function. 
If the rectangle you specify in the boundsRect parameter is smaller than the previous boundary rectangle and you specify the clipPix flag, the pixel image is clipped along the bottom and right edges. 
If the rectangle you specify in the boundsRect parameter is bigger than the previous boundary rectangle and you specify the clipPix flag, the bottom and right edges of the pixel image are undefined. 
If the rectangle you specify in the boundsRect parameter is smaller than the previous boundary rectangle and you specify the stretchPix flag, the pixel image is reduced to the new size. 
If the rectangle you specify in the boundsRect parameter is bigger than the previous boundary rectangle and you specify the stretchPix flag, the pixel image is stretched to the new size. 
If the Memory Manager purged the base address for the offscreen pixel image, UpdateGWorld reallocates the memory, but the pixel image is lost. You must reconstruct it. 
Special Considerations

The UpdateGWorld function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
QDOffscreen.h*/
GWorldFlags UpdateGWorld (
   GWorldPtr * offscreenGWorld,
   short pixelDepth,
   const Rect * boundsRect,
   CTabHandle cTable,
   GDHandle aGDevice,
   GWorldFlags flags
);



#ifdef __cplusplus
}
#endif
#endif