#ifndef  PMDEFINITIONS_H
#define PMDEFINITIONS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>
#include <HYS/PrintCore/PMDefinitions.h>
#if PRAGMA_ONCE
#pragma once
#endif

/*Print Queue States

Constants that specify the current state of a print queue.

typedef UInt16 PMPrinterState;
enum {
   kPMPrinterIdle = 3,
   kPMPrinterProcessing = 4,
   kPMPrinterStopped = 5
};
Constants
kPMPrinterIdle

Specifies the idle state.

Available in Mac OS X v10.2 and later.
kPMPrinterProcessing

Specifies the processing state.

Available in Mac OS X v10.2 and later.
kPMPrinterStopped

Specifies the stopped state.

Available in Mac OS X v10.2 and later.*/

typedef UInt16 PMPrinterState;
enum {
   kPMPrinterIdle = 3,
   kPMPrinterProcessing = 4,
   kPMPrinterStopped = 5
};


/*PMServer

An opaque type that identifies a local or remote print server.

typedef struct OpaquePMServer* PMServer;
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct OpaquePMServer* PMServer;

/*Lock State

Specifies whether an item is locked or unlocked.

enum {
   kPMUnlocked = 0,
   kPMLocked = 1
};
Constants
kPMUnlocked

Indicates items is unlocked.

Available in Mac OS X v10.0 and later.
kPMLocked

Indicates items is locked.

Available in Mac OS X v10.0 and later.*/
enum {
   kPMUnlocked = 0,
   kPMLocked = 1
};


/*PMPrintContext

An opaque type that describes the graphics environment for printing a document.

typedef struct OpaquePMPrintContext* PMPrintContext;
Discussion

This data type is used by functions that are not recommended or deprecated.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPrintContext* PMPrintContext;

/*Document Format Strings

Constants that specify the document format for a print job.

#define kPMDocumentFormatDefault
   CFSTR("com.apple.documentformat.default")
#define kPMDocumentFormatPDF
   CFSTR("application/pdf")
#define kPMDocumentFormatPICT
   CFSTR("application/vnd.apple.printing-pict")
#define kPMDocumentFormatPICTPS
   CFSTR("application/vnd.apple.printing-pict-ps")
#define kPMDocumentFormatPostScript
   CFSTR("application/postscript")
Constants
kPMDocumentFormatDefault

Specifies the default format for the printing system. In Mac OS X, the default format is PDF.

Available in Mac OS X v10.0 and later.
kPMDocumentFormatPDF

Specifies PDF.

Available in Mac OS X v10.0 and later.
kPMDocumentFormatPICT

Specifies PICT format.

Available in Mac OS X v10.0 and later.
kPMDocumentFormatPICTPS

Specifies PICT format with embedded PostScript.

Available in Mac OS X v10.0 and later.
kPMDocumentFormatPostScript

Specifies PostScript format.

Available in Mac OS X v10.0 and later.*/
#define kPMDocumentFormatDefault \
   CFSTR("com.apple.documentformat.default")
#define kPMDocumentFormatPDF \
   CFSTR("application/pdf")
#define kPMDocumentFormatPICT \
   CFSTR("application/vnd.apple.printing-pict")
#define kPMDocumentFormatPICTPS \
   CFSTR("application/vnd.apple.printing-pict-ps")
#define kPMDocumentFormatPostScript \
   CFSTR("application/postscript")


/*Graphics Context Types

Constants that specify the graphics context for a print job.

#define kPMGraphicsContextDefault
   CFSTR("com.apple.graphicscontext.default")
#define kPMGraphicsContextQuickdraw
   CFSTR("com.apple.graphicscontext.quickdraw")
#define kPMGraphicsContextCoreGraphics
   CFSTR("com.apple.graphicscontext.coregraphics")
Constants
kPMGraphicsContextDefault

Specifies the default graphics context for the application’s runtime environment.

Available in Mac OS X v10.0 and later.
kPMGraphicsContextQuickdraw

Specifies a QuickDraw graphics context.

Available in Mac OS X v10.0 and later.
kPMGraphicsContextCoreGraphics

Specifies a Quartz graphics context. The default coordinate system for a Quartz printing context is not the same as that used for a QuickDraw printing context. A Quartz printing context defines the coordinates of the lower-left corner of the paper as (0,0) whereas the origin for a QuickDraw is at the upper-right corner of the paper’s imageable area.

Available in Mac OS X v10.0 and later.*/
#define kPMGraphicsContextDefault \
   CFSTR("com.apple.graphicscontext.default")
#define kPMGraphicsContextQuickdraw\
   CFSTR("com.apple.graphicscontext.quickdraw")
#define kPMGraphicsContextCoreGraphics \
   CFSTR("com.apple.graphicscontext.coregraphics")


/*PMRect

A data structure that describes a rectangle using four double-precision coordinates.

struct PMRect {
   double top;
   double left;
   double bottom;
   double right;
};
Fields
top

The vertical coordinate for the upper-left point of the rectangle.
left

The horizontal coordinate for the upper-left point of the rectangle.
bottom

The vertical coordinate for the lower-right point of the rectangle.
right

The horizontal coordinate for the lower-right point of the rectangle.*/
typedef struct PMRect {
   double top;
   double left;
   double bottom;
   double right;
}PMRect 
;

/*User Cancellation Constant

A constant that specifies an error value that indicates the user canceled a printing operation.

enum {
   kPMCancel = 128
};
Constants
kPMCancel

Specifies that the user clicked the Cancel button in a Print or Page Setup dialog.

Available in Mac OS X v10.0 and later.
Discussion

This constant is provided for compatibility with old applications and printer drivers that expect the iPrAbort error code to be returned when the user cancels a printing operation.

The Carbon Printing Manager’s default idle function checks for Command-period keyboard events during printing, and sets the error condition equal to kPMCancel if one occurs. Your application can check for this condition using the PMSessionError function, and should cancel the print job if kPMCancel is returned.

If you supply your own idle function (not needed in Mac OS 8, 9, or X), your function must check for Command-period keyboard events, and set the error condition using the function PMSessionSetError.*/
enum {
   kPMCancel = 128
};


/*Data Not Wanted Constants

Constants your application can use to indicate it does not need certain types of data returned by various Carbon Printing Manager functions.

#define kPMNoData  NULL
#define kPMDontWantSize  NULL
#define kPMDontWantData  NULL
#define kPMDontWantBoolean  NULL
#define kPMNoPrintSettings  NULL
#define kPMNoPageFormat  NULL
#define kPMNoReference  NULL
Constants
kPMNoData

Specifies that your application does not need data returned for a particular parameter. For future compatibility, you are encouraged to use one of the following constants in cases where a specific type of data is not required.

Available in Mac OS X v10.0 and later.
kPMDontWantSize

Specifies that your application does not need the size information returned by the Carbon Printing Manager.

Available in Mac OS X v10.0 and later.
kPMDontWantData

Specifies that your application does not need the data returned by the Carbon Printing Manager.

Available in Mac OS X v10.0 and later.
kPMDontWantBoolean

Specifies that your application does not need a Boolean value returned by the Carbon Printing Manager.

Available in Mac OS X v10.0 and later.
kPMNoPrintSettings

Specifies that your application does not need a PMPrintSettings object returned by the Carbon Printing Manager.

Available in Mac OS X v10.0 and later.
kPMNoPageFormat

Specifies that your application does not need a PMPageFormat object returned by the Carbon Printing Manager.

Available in Mac OS X v10.0 and later.
kPMNoReference

Specifies that your application does not need a reference returned by the Carbon Printing Manager.

Available in Mac OS X v10.0 and later.*/

#define kPMNoData  NULL
#define kPMDontWantSize  NULL
#define kPMDontWantData  NULL
#define kPMDontWantBoolean  NULL
#define kPMNoPrintSettings  NULL
#define kPMNoPageFormat  NULL
#define kPMNoReference  NULL

/*PMPageFormat

An opaque type that stores the settings in the Page Setup dialog.

typedef struct OpaquePMPageFormat* PMPageFormat;
Discussion

Your application uses page format objects to store information such as the paper size, orientation, and scale of pages in a printing session. To create a page format object, you use the function PMCreatePageFormat. A new page format object is empty and unusable until you call PMSessionDefaultPageFormat or PMCopyPageFormat to initialize the settings. You can also use the functions PMSetPageFormatExtendedData and PMGetPageFormatExtendedData to store and retrieve application-specific data in a page format object.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPageFormat* PMPageFormat;

/*PMPrintSession

An opaque type that stores information about a print job.

typedef struct OpaquePMPrintSession* PMPrintSession;
Discussion

A printing session object contains information that’s needed by the page format and print settings objects, such as default page format and print settings values. For this reason, some Carbon Printing Manager functions can be called only after you have created a printing session object. For example, setting defaults for or validating page format and print settings objects can only be done after you have created a printing session object. Your application creates a printing session object using the function PMCreateSession.

You can use a printing session to implement multithreaded printing, and you can create multiple sessions within a single-threaded application. If your application does not use sheets, then your application can open only one dialog at a time. Each printing session can have its own dialog, and settings changed in one dialog are independent of settings in any other dialog.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPrintSession* PMPrintSession;


/*PMPrintSettings

An opaque type that stores the settings in the Print dialog.

typedef struct OpaquePMPrintSettings* PMPrintSettings;
Discussion

Your application uses print settings objects to store information such as the number of copies and the range of pages to print in a printing session. To create a print settings object, you use the function PMCreatePrintSettings. A new print settings object is empty and unusable until you call PMSessionDefaultPrintSettings or PMCopyPrintSettings to initialize the settings. You can also use the functions PMSetPrintSettingsExtendedData and PMGetPrintSettingsExtendedData to store and retrieve application-specific data in a print settings object.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPrintSettings* PMPrintSettings;

/*PMPrinter

An opaque type that represents a printer.

typedef struct OpaquePMPrinter* PMPrinter;
Discussion

You typically obtain a printer object using the function PMSessionGetCurrentPrinter or PMServerCreatePrinterList.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPrinter* PMPrinter;

/*Destination Types

Constants that specify a destination for a print job.

typedef UInt16 PMDestinationType;
enum {
   kPMDestinationInvalid = 0,
   kPMDestinationPrinter = 1,
   kPMDestinationFile = 2,
   kPMDestinationFax = 3,
   kPMDestinationPreview = 4,
   kPMDestinationProcessPDF = 5
};
Constants
kPMDestinationInvalid

Specifies the destination is invalid.

Available in Mac OS X v10.1 and later.
kPMDestinationPrinter

Specifies output to a printer.

Available in Mac OS X v10.0 and later.
kPMDestinationFile

Specifies output to a file.

Available in Mac OS X v10.0 and later.
kPMDestinationFax

Specifies output to a fax. This destination is currently not supported.

Available in Mac OS X v10.0 and later.
kPMDestinationPreview

Specifies output to print preview.

Available in Mac OS X v10.1 and later.
kPMDestinationProcessPDF

Specifies output to a PDF workflow option.

Available in Mac OS X v10.4 and later.*/

typedef UInt16 PMDestinationType;
enum {
   kPMDestinationInvalid = 0,
   kPMDestinationPrinter = 1,
   kPMDestinationFile = 2,
   kPMDestinationFax = 3,
   kPMDestinationPreview = 4,
   kPMDestinationProcessPDF = 5
};

/*PMObject

The base type for all the opaque types used in the Carbon Printing Manager.

typedef const void* PMObject;
Discussion

PMObject is the base type for opaque types such as PMPrintSession, PMPageFormat, PMPrintSettings, PMPrinter, PMPaper, PMPreset, and PMServer. PMObject is used in functions such as PMRetain and PMRelease that operate on any opaque type.
Availability
Available in Mac OS X v10.0 and later.*/
typedef const void* PMObject;

/*PMPageFormat

An opaque type that stores the settings in the Page Setup dialog.

typedef struct OpaquePMPageFormat* PMPageFormat;
Discussion

Your application uses page format objects to store information such as the paper size, orientation, and scale of pages in a printing session. To create a page format object, you use the function PMCreatePageFormat. A new page format object is empty and unusable until you call PMSessionDefaultPageFormat or PMCopyPageFormat to initialize the settings. You can also use the functions PMSetPageFormatExtendedData and PMGetPageFormatExtendedData to store and retrieve application-specific data in a page format object.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaquePMPageFormat* PMPageFormat;

/*PMResolution
A data structure that contains printing resolution information.

struct PMResolution {
   double hRes;
   double vRes;
};
Fields
hRes

The horizontal resolution in dots per inch (dpi).
vRes

The vertical resolution in dots per inch (dpi).
Discussion

The functions PMGetResolution and PMPrinterGetPrinterResolution use this structure to return printing resolution information. Your application can pass this information to the function PMSetResolution.*/

struct PMResolution {
   double hRes;
   double vRes;
};
typedef struct PMResolution PMResolution;

#endif