#ifndef MACTEXTEDITOR_H
#define MACTEXTEDITOR_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif

#ifndef QDOFFSCREEN_H
#include <QD/QDOffscreen.h>//hys
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Read and Write Privileges Settings

Specify the privileges setting for a text object. 

enum {
   kTXNReadWrite = false,
   kTXNReadOnly = true
};
Constants
kTXNReadWrite

The document has read and write privileges.

Available in Mac OS X v10.0 and later.
kTXNReadOnly

The document is read-only.

Available in Mac OS X v10.0 and later.
Discussion

Passed in the iControlData parameter of the TXNSetTXNObjectControls function when the value of the iControlTags parameter is kTXNIOPrivilegesTag, or returned in the oControlData parameter of the TXNGetTXNObjectControls function when the value of the iControlTags parameter is kTXNIOPrivilegesTag.*/
enum {
   kTXNReadWrite = false,
   kTXNReadOnly = true
};


/*Action Types

Specify constants for editing actions taken by the user in versions of Mac OS X prior to Mac OS X v10.4. (Deprecated. These constants were used in the TXNCanUndo and TXNCanRedo functions, which are deprecated in Mac OS X v10.4. Use the TXNCanUndoAction and TXNCanRedoAction functions instead.)

typedef UInt32 TXNActionKey;
enum {
   kTXNTypingAction = 0,
   kTXNCutAction = 1,
   kTXNPasteAction = 2,
   kTXNClearAction = 3,
   kTXNChangeFontAction = 4,
   kTXNChangeFontColorAction = 5,
   kTXNChangeFontSizeAction = 6,
   kTXNChangeStyleAction = 7,
   kTXNAlignLeftAction = 8,
   kTXNAlignCenterAction = 9,
   kTXNAlignRightAction = 10,
   kTXNDropAction = 11,
   kTXNMoveAction = 12,
   kTXNFontFeatureAction = 13,
   kTXNFontVariationAction = 14,
   kTXNUndoLastAction = 1024
};
Constants
kTXNTypingAction

A typing action.

Available in Mac OS X v10.0 and later.
kTXNCutAction

A cut action.

Available in Mac OS X v10.0 and later.
kTXNPasteAction

A paste action.

Available in Mac OS X v10.0 and later.
kTXNClearAction

A clear action.

Available in Mac OS X v10.0 and later.
kTXNChangeFontAction

A font change action.

Available in Mac OS X v10.0 and later.
kTXNChangeFontColorAction

A change in font color action.

Available in Mac OS X v10.0 and later.
kTXNChangeFontSizeAction

A change in font size action.

Available in Mac OS X v10.0 and later.
kTXNChangeStyleAction

A change in font style action.

Available in Mac OS X v10.0 and later.
kTXNAlignLeftAction

An align left action.

Available in Mac OS X v10.0 and later.
kTXNAlignCenterAction

An align center action.

Available in Mac OS X v10.0 and later.
kTXNAlignRightAction

An align right action.

Available in Mac OS X v10.0 and later.
kTXNDropAction

A drop action.

Available in Mac OS X v10.0 and later.
kTXNMoveAction

A move selection action.

Available in Mac OS X v10.0 and later.
kTXNFontFeatureAction

A change in font feature action.

Available in Mac OS X v10.0 and later.
kTXNFontVariationAction

A change in font variation action.

Available in Mac OS X v10.0 and later.
kTXNUndoLastAction

Use this if none of the other constants apply.

Available in Mac OS X v10.0 and later.*/
typedef UInt32 TXNActionKey;
enum {
   kTXNTypingAction = 0,
   kTXNCutAction = 1,
   kTXNPasteAction = 2,
   kTXNClearAction = 3,
   kTXNChangeFontAction = 4,
   kTXNChangeFontColorAction = 5,
   kTXNChangeFontSizeAction = 6,
   kTXNChangeStyleAction = 7,
   kTXNAlignLeftAction = 8,
   kTXNAlignCenterAction = 9,
   kTXNAlignRightAction = 10,
   kTXNDropAction = 11,
   kTXNMoveAction = 12,
   kTXNFontFeatureAction = 13,
   kTXNFontVariationAction = 14,
   kTXNUndoLastAction = 1024
};


/*Supported Frame Types

Represents a frame type. (Deprecated. No longer needed.)

typedef UInt32 TXNFrameType;
enum {
   kTXNTextEditStyleFrameType = 1,
   kTXNPageFrameType = 2,
   kTXNMultipleFrameType = 3
};
Constants
kTXNTextEditStyleFrameType

A single rectangle that allows text to scroll if the rectangle fills. Although you can pass this as a parameter to the function TXNNewObject, you should instead use the function TXNCreateObject, which does not require a frame type.

Available in Mac OS X v10.0 and later.
kTXNPageFrameType

A single rectangle with a bottom. That is, text moves to a new page if the frame is full. This constant is not supported in Mac OS X version 10.3 and later. 

Available in Mac OS X v10.0 and later.
kTXNMultipleFrameType

Multiple frames. This constant is not supported in Mac OS X version 10.3 and later. 

Available in Mac OS X v10.0 and later.
Special Considerations

This data type is used only by the TXNNewObject function, which is deprecated.*/
typedef UInt32 TXNFrameType;
enum {
   kTXNTextEditStyleFrameType = 1,
   kTXNPageFrameType = 2,
   kTXNMultipleFrameType = 3
};

/*Text Encoding Preferences

Represents how to encode text for your application.

typedef UInt32 TXNPermanentTextEncodingType;
enum {
   kTXNSystemDefaultEncoding = 0,
   kTXNMacOSEncoding = 1,
   kTXNUnicodeEncoding = 2
};
Constants
kTXNSystemDefaultEncoding

Use the encoding that is used internally by MLTE and the system. The preferred encoding is Unicode for a system that has ATSUI.

Available in Mac OS X v10.0 and later.
kTXNMacOSEncoding

Incoming and outgoing text should be in traditional Mac OS script system encodings even if MLTE uses another format internally. MLTE will use the Text Encoding Convertor (TEC) to convert text and offsets to match your application’s preference.

Available in Mac OS X v10.0 and later.
kTXNUnicodeEncoding

Incoming and outgoing text should be in Unicode even on systems that do not have ATSUI. MLTE will use the Text Encoding Convertor (TEC) to convert text and offsets to match the applications preference.

Available in Mac OS X v10.0 and later.
Discussion

These convenience constants can be used in the functions TXNNewObject and TXNSave.*/
typedef UInt32 TXNPermanentTextEncodingType;
enum {
   kTXNSystemDefaultEncoding = 0,
   kTXNMacOSEncoding = 1,
   kTXNUnicodeEncoding = 2
};

/*TXNObjectRefCon

Contains data specific to your application. (Deprecated. Used only in the TXNNewObject function, which is deprecated.)

typedef void * TXNObjectRefCon;*/
typedef void * TXNObjectRefCon;
typedef TXNObjectRefCon TXNObjectRefcon;

/*TXNMargins

Contains the margin values of a text object.

struct TXNMargins {
   SInt16 topMargin;
   SInt16 leftMargin;
   SInt16 bottomMargin;
   SInt16 rightMargin;
};
typedef struct TXNMargins TXNMargins;
Fields
topMargin

The location of the top margin. Available in MLTE version 1.2 and later.
leftMargin

The location of the left margin. Available in MLTE version 1.2 and later.
bottomMargin

The location of the bottom margin. This is a placeholder; it is currently not possible to set the bottom margin.
rightMargin

The location of the right margin. Available in MLTE version 1.2 and later. 
Discussion

This structure is used as a field in the TXNControlData union. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TXNMargins {
   SInt16 topMargin;
   SInt16 leftMargin;
   SInt16 bottomMargin;
   SInt16 rightMargin;
};
typedef struct TXNMargins TXNMargins;

/*Scroll Bar States

Represents the scroll bar state for the window attached to a text object.

typedef Boolean TXNScrollBarState;
enum {
   kScrollBarsAlwaysActive = true,
   kScrollBarsSyncWithFocus = false
};
Constants
kScrollBarsAlwaysActive

Indicates that scroll bars should always appear in the active state even then the text area does not have focus.

Available in Mac OS X v10.0 and later.
kScrollBarsSyncWithFocus

Indicates that scroll bars should be active only if the frame in which they are enclosed is focused.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNActivate function.*/
typedef Boolean TXNScrollBarState;
enum {
   kScrollBarsAlwaysActive = true,
   kScrollBarsSyncWithFocus = false
};

/*TXNFrameID

Represents the text frame to which actions should be applied.

typedef UInt32 TXNFrameID;
Discussion

Used in the functions TXNNewObject, TXNActivate, TXNResizeFrame, TXNSetFrameBounds, TXNDragReceiver, and TXNDragTracker. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 TXNFrameID;

/*Initialization Option Bits

Specify initialization options for MLTE. 

enum {
   kTXNWantMoviesBit = 0,
   kTXNWantSoundBit = 1,
   kTXNWantGraphicsBit = 2,
   kTXNAlwaysUseQuickDrawTextBit = 3,
   kTXNUseTemporaryMemoryBit = 4
};
Constants
kTXNWantMoviesBit

When this bit is set, it specifies that movie data is supported in a text object.

Available in Mac OS X v10.0 and later.
kTXNWantSoundBit

When this bit is set, it specifies that sound data is supported in a text object.

Available in Mac OS X v10.0 and later.
kTXNWantGraphicsBit

When this bit is set, it specifies that graphics data is supported in a text object.

Available in Mac OS X v10.0 and later.
kTXNAlwaysUseQuickDrawTextBit

When this bit is set, it specifies that MLTE should use QuickDraw for imaging even if ATSUI is available. This is often the best choice for applications that need speed and efficient memory usage.

Available in Mac OS X v10.0 and later.
kTXNUseTemporaryMemoryBit

When this bit is set, it specifies that MLTE should use temporary memory for all memory allocations.

Available in Mac OS X v10.0 and later.*/

enum {
   kTXNWantMoviesBit = 0,
   kTXNWantSoundBit = 1,
   kTXNWantGraphicsBit = 2,
   kTXNAlwaysUseQuickDrawTextBit = 3,
   kTXNUseTemporaryMemoryBit = 4
};


/*Frame Option Bits

Specify frame options for a text object.

enum {
   kTXNDrawGrowIconBit = 0,
   kTXNShowWindowBit = 1,
   kTXNWantHScrollBarBit = 2,
   kTXNWantVScrollBarBit = 3,
   kTXNNoTSMEverBit = 4,
   kTXNReadOnlyBit = 5,
   kTXNNoKeyboardSyncBit = 6,
   kTXNNoSelectionBit = 7,
   kTXNSaveStylesAsSTYLResourceBit = 8,
   kOutputTextInUnicodeEncodingBit = 9,
   kTXNDoNotInstallDragProcsBit = 10,
   kTXNAlwaysWrapAtViewEdgeBit = 11,
   kTXNDontDrawCaretWhenInactiveBit = 12,
   kTXNDontDrawSelectionWhenInactiveBit = 13,
   kTXNSingleLineOnlyBit = 14,
   kTXNDisableDragAndDropBit = 15,
   kTXNUseQDforImagingBit = 16,
   kTXNMonostyledTextBit = 17
};
Constants
kTXNDrawGrowIconBit

When this bit is set, it indicates the frame will have a size box. The presence of a size box in the lower right corner of an MLTE pane is only useful for resizing an MLTE pane if the MLTE pane occupies the entire window (a full-window MLTE object). In this case your application would look for a mouse-down event in the size box and call the function TXNGrowWindow as appropriate. Note that the size box is not supported as a means of resizing MLTE panes using TXNGrowWindow for MLTE pane objects. 

Passing the kTXNDrawGrowIconMask constant to the function TXNNewObject only causes a size box to be drawn in the lower right corner of the MLTE pane. Passing this constant does not create a size box control in the window. The window will not contain an actual size box control. This means the window will not receive events that indicate a mouse-down event in the grow region. For this to happen, when you create the window that contains the MLTE pane, you must create the window to have a size box.

In summary, although you may pass the constants kTXNDrawGrowIconMask to the function TXNNewObject when you create an MLTE object in a window, this action only causes the visual appearance of a size box in the lower right corner of the MLTE pane. If you want to detect mouse-down events in the size box, you must also provide a size box in the window through the appropriate Window Manager functions or other tools.

Available in Mac OS X v10.0 and later.
kTXNShowWindowBit

When this bit is set, it indicates MLTE should display a window when a text object is created. If this bit is set, your application no longer needs to call the ShowWindow function from the Window Manager; MLTE will do this for you.

Available in Mac OS X v10.0 and later.
kTXNWantHScrollBarBit

When this bit is set, it indicates the frame should have a horizontal scroll bar.

Available in Mac OS X v10.0 and later.
kTXNWantVScrollBarBit

When this bit is set, it indicates the frame should have a vertical scroll bar.

Available in Mac OS X v10.0 and later.
kTXNNoTSMEverBit


When this bit is set, it indicates not to use Text Services Manager. You cannot use this bit when your application accepts Unicode input. (Deprecated. You can no longer set this because in Mac OS X, MLTE always uses the Text Services Manager.)

Available in Mac OS X v10.0 and later.
kTXNReadOnlyBit

When this bit is set, it indicates the text object is read-only. If you set this bit when you call the function TXNNewObject, the text object is put into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag.

Available in Mac OS X v10.0 and later.
kTXNNoKeyboardSyncBit

When this bit is set, it indicates no keyboard synchronization.

Available in Mac OS X v10.0 and later.
kTXNNoSelectionBit

When this bit is set, it indicates MLTE should not show the insertion point.

Available in Mac OS X v10.0 and later.
kTXNSaveStylesAsSTYLResourceBit

When this bit is set, it indicates text style should be saved as a kTXNMultipleStylesPerTextDocumentResType resource. You can set this to assure compatibility with SimpleText. If you use kTXNMultipleStylesPerTextDocumentResType resources to save style info, your documents can have as many styles as you’d like. However tabs are not saved. If you don’t set this bit, plain text files are saved as kTXNSingleStylePerTextDocumentResType resources, and only the first style in the document is saved. (Your application is expected to apply all style changes to the entire document.) If you save files with a kTXNSingleStylePerTextDocumentResType resource, their output is similar to those output by CodeWarrior, BBEdit, and MPW.

Available in Mac OS X v10.0 and later.
kOutputTextInUnicodeEncodingBit

When this bit is set, it indicates plain text should be saved as Unicode.

Available in Mac OS X v10.0 and later.
kTXNDoNotInstallDragProcsBit

When this bit is set, it indicates you want to call your own drag handlers.

Available in Mac OS X v10.0 and later.
kTXNAlwaysWrapAtViewEdgeBit

When this bit is set, it indicates line wrap at the edge of the view rectangle.

Available in Mac OS X v10.0 and later.
kTXNDontDrawCaretWhenInactiveBit


When this bit is set, it indicates the caret should not be drawn when the object does not have focus. (Deprecated. In Mac OS X v10.4, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDontDrawSelectionWhenInactiveBit

When this bit is set, it indicates the selection should not be drawn when the object does not have focus.

Available in Mac OS X v10.0 and later.
kTXNSingleLineOnlyBit

When this bit is set, it indicates that the text object will not scroll vertically. Horizontal scrolling will stop when the end of the text is visible, and there will be no limit to the width of the text. In addition, a line break character typed, pasted, or dropped into the text object will be translated into a hyphen (-).

Available in Mac OS X v10.1 and later.
kTXNDisableDragAndDropBit

When this bit is set, it indicates that drag and drop will not be allowed in the text object.

Available in Mac OS X v10.1 and later.
kTXNUseQDforImagingBit


When this bit is set, it indicates that QuickDraw will be used for imaging instead of the Quartz (CoreGraphics) which is the default. Available in Mac OS X only. (Deprecated. You can no longer set the imaging system to use; MLTE always uses Quartz imaging.)

Available in Mac OS X v10.1 and later.
kTXNMonostyledTextBit

When this bit is set, it indicates that the text object will have a single style no matter what kind of changes are made to the object.

Available in Mac OS X v10.2 and later.*/
enum {
   kTXNDrawGrowIconBit = 0,
   kTXNShowWindowBit = 1,
   kTXNWantHScrollBarBit = 2,
   kTXNWantVScrollBarBit = 3,
   kTXNNoTSMEverBit = 4,
   kTXNReadOnlyBit = 5,
   kTXNNoKeyboardSyncBit = 6,
   kTXNNoSelectionBit = 7,
   kTXNSaveStylesAsSTYLResourceBit = 8,
   kOutputTextInUnicodeEncodingBit = 9,
   kTXNDoNotInstallDragProcsBit = 10,
   kTXNAlwaysWrapAtViewEdgeBit = 11,
   kTXNDontDrawCaretWhenInactiveBit = 12,
   kTXNDontDrawSelectionWhenInactiveBit = 13,
   kTXNSingleLineOnlyBit = 14,
   kTXNDisableDragAndDropBit = 15,
   kTXNUseQDforImagingBit = 16,
   kTXNMonostyledTextBit = 17
};


/*Supported File Types

Represents a file type.

typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};
Constants
kTXNTextensionFile

A file that contains Unicode or Mac OS text. By default, it contains Unicode text. Files are saved in a private format.

Available in Mac OS X v10.0 and later.
kTXNTextFile

A file that contains plain text data. 

Available in Mac OS X v10.0 and later.
kTXNPictureFile

A file that contains graphics data in PICT format.

Available in Mac OS X v10.0 and later.
kTXNMovieFile

A file that contains movie data in 'MooV' format.

Available in Mac OS X v10.0 and later.
kTXNSoundFile

A file that contains sound data in 'sfil' format.

Available in Mac OS X v10.0 and later.
kTXNAIFFFile

A file that contains sound data in 'aiff' format.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextFile

A file that contains Unicode text data.

Available in Mac OS X v10.0 and later.*/
typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};

/*Supported Data Types

Specifies the type of data being requested from or passed to an MLTE function.

typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};
Constants
kTXNTextData

Text data.

Available in Mac OS X v10.0 and later.
kTXNPictureData

Graphics (PICT) data.

Available in Mac OS X v10.0 and later.
kTXNMovieData

Movie or sound data.

Available in Mac OS X v10.0 and later.
kTXNSoundData

Sound data.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextData

Unicode text data.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNGetDataEncoded function.*/
typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};

/*Data Offsets

Specifies offsets to use when manipulating data in a text object. Offsets in MLTE are always character offsets.

typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};
Constants
kTXNUseCurrentSelection

Use the current selection.

Available in Mac OS X v10.0 and later.
kTXNStartOffset

The first offset of the text in a text object.

Available in Mac OS X v10.0 and later.
kTXNEndOffset

The last offset of the text in a text object.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be passed and returned in functions that have the parameter of type TXNOffset.*/
typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};

/*TXNObject

Contains private variables and functions necessary to represent text and handle text formatting at a document level. 

typedef struct OpaqueTXNObject * TXNObject;
Discussion

You obtain a structure of type TXNObject from the TXNNewObject function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueTXNObject * TXNObject;

/*Frame Option Masks

Represents information about frame behavior (such as whether there are scroll bars and a size box). 

typedef OptionBits TXNFrameOptions;
enum {
   kTXNDrawGrowIconMask = 1L << kTXNDrawGrowIconBit,
   kTXNShowWindowMask = 1L << kTXNShowWindowBit,
   kTXNWantHScrollBarMask = 1L << kTXNWantHScrollBarBit,
   kTXNWantVScrollBarMask = 1L << kTXNWantVScrollBarBit,
   kTXNNoTSMEverMask = 1L << kTXNNoTSMEverBit,
   kTXNReadOnlyMask = 1L << kTXNReadOnlyBit,
   kTXNNoKeyboardSyncMask = 1L << kTXNNoKeyboardSyncBit,
   kTXNNoSelectionMask = 1L << kTXNNoSelectionBit,
   kTXNSaveStylesAsSTYLResourceMask = 1L <<                 kTXNSaveStylesAsSTYLResourceBit,
   kOutputTextInUnicodeEncodingMask = 1L <<             kOutputTextInUnicodeEncodingBit,
   kTXNDoNotInstallDragProcsMask = 1L << kTXNDoNotInstallDragProcsBit,
   kTXNAlwaysWrapAtViewEdgeMask = 1L << kTXNAlwaysWrapAtViewEdgeBit,
   kTXNDontDrawCaretWhenInactiveMask = 1L <<             kTXNDontDrawCaretWhenInactiveBit,
   kTXNDontDrawSelectionWhenInactiveMask = 1L <<             kTXNDontDrawSelectionWhenInactiveBit,
   kTXNSingleLineOnlyMask = 1L << kTXNSingleLineOnlyBit,
   kTXNDisableDragAndDropMask = 1L << kTXNDisableDragAndDropBit,
   kTXNUseQDforImagingMask = 1L << kTXNUseQDforImagingBit,
   kTXNMonostyledTextMask = 1L << kTXNMonostyledTextBit
};
Constants
kTXNDrawGrowIconMask

Use to set or test for the kTXNDrawGrowIconBit bit.

Available in Mac OS X v10.0 and later.
kTXNShowWindowMask

Use to set or test for the kTXNShowWindowBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantHScrollBarMask

Use to set or test for the kTXNWantHScrollBarBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantVScrollBarMask

Use to set or test for the kTXNWantVScrollBarBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoTSMEverMask


Use to set or test for the kTXNNoTSMEverBit bit. (Deprecated. You can no longer set this because in Mac OS X, MLTE always uses the Text Services Manager.)

Available in Mac OS X v10.0 and later.
kTXNReadOnlyMask

Use to set or test for the kTXNReadOnlyBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoKeyboardSyncMask

Use to set or test for the kTXNNoKeyboardSyncBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoSelectionMask

Use to set or test for the kTXNNoSelectionBit bit.

Available in Mac OS X v10.0 and later.
kTXNSaveStylesAsSTYLResourceMask

Use to set or test for the kTXNXNSaveStylesAsSTYLResourceBit bit.

Available in Mac OS X v10.0 and later.
kOutputTextInUnicodeEncodingMask

Use to set or test for the kOutputTextInUnicodeEncodingBit bit.

Available in Mac OS X v10.0 and later.
kTXNDoNotInstallDragProcsMask

Use to set or test for the kTXNDoNotInstallDragProcsBit bit.

Available in Mac OS X v10.0 and later.
kTXNAlwaysWrapAtViewEdgeMask

Use to set or test for the kTXNAlwaysWrapAtViewEdgeBit bit.

Available in Mac OS X v10.0 and later.
kTXNDontDrawCaretWhenInactiveMask


Use to set or test for the kTXNDontDrawCaretWhenInactiveBit bit. (Deprecated. In Mac OS Xv10.4 and later, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDontDrawSelectionWhenInactiveMask

Use to set or test for the kTXNDontDrawSelectionWhenInactiveBit bit.

Available in Mac OS X v10.0 and later.
kTXNSingleLineOnlyMask

Use to set or test for the kTXNSingleLineOnlyBit bit.

Available in Mac OS X v10.1 and later.
kTXNDisableDragAndDropMask

Use to set or test for the kTXNDisableDragAndDropBit bit.

Available in Mac OS X v10.1 and later.
kTXNUseQDforImagingMask


Use to set or test for the kTXNUseQDforImagingBit bit. (Deprecated. You can no longer set the imaging system; MLTE always uses Quartz imaging.)

Available in Mac OS X v10.1 and later.
kTXNMonostyledTextMask

Use to set or test for the kTXNMonostyledTextBit bit.

Available in Mac OS X v10.2 and later.
Discussion

See Frame Option Bits.*/

typedef OptionBits TXNFrameOptions;
enum {
   kTXNDrawGrowIconMask = 1L << kTXNDrawGrowIconBit,
   kTXNShowWindowMask = 1L << kTXNShowWindowBit,
   kTXNWantHScrollBarMask = 1L << kTXNWantHScrollBarBit,
   kTXNWantVScrollBarMask = 1L << kTXNWantVScrollBarBit,
   kTXNNoTSMEverMask = 1L << kTXNNoTSMEverBit,
   kTXNReadOnlyMask = 1L << kTXNReadOnlyBit,
   kTXNNoKeyboardSyncMask = 1L << kTXNNoKeyboardSyncBit,
   kTXNNoSelectionMask = 1L << kTXNNoSelectionBit,
   kTXNSaveStylesAsSTYLResourceMask = 1L <<                 kTXNSaveStylesAsSTYLResourceBit,
   kOutputTextInUnicodeEncodingMask = 1L <<             kOutputTextInUnicodeEncodingBit,
   kTXNDoNotInstallDragProcsMask = 1L << kTXNDoNotInstallDragProcsBit,
   kTXNAlwaysWrapAtViewEdgeMask = 1L << kTXNAlwaysWrapAtViewEdgeBit,
   kTXNDontDrawCaretWhenInactiveMask = 1L <<             kTXNDontDrawCaretWhenInactiveBit,
   kTXNDontDrawSelectionWhenInactiveMask = 1L <<             kTXNDontDrawSelectionWhenInactiveBit,
   kTXNSingleLineOnlyMask = 1L << kTXNSingleLineOnlyBit,
   kTXNDisableDragAndDropMask = 1L << kTXNDisableDragAndDropBit,
   kTXNUseQDforImagingMask = 1L << kTXNUseQDforImagingBit,
   kTXNMonostyledTextMask = 1L << kTXNMonostyledTextBit
};


/*TXNMacOSPreferredFontDescription

Contains information about the preferred font, font size, and style for a given text encoding.

struct TXNMacOSPreferredFontDescription {
   UInt32 fontID;
   Fixed pointSize;
   TextEncoding encoding;
   Style fontStyle;
};
typedef struct TXNMacOSPreferredFontDescription  TXNMacOSPreferredFontDescription;
Fields
fontID

The ID of the preferred font. 
pointSize

The point size of the preferred font. 
encoding

The text encoding of the preferred font. 
fontStyle

The font style of the preferred font. 
Discussion

Used in the functions TXNInitTextension, TXNSetFontDefaults, and TXNGetFontDefaults. 
Availability
Available in Mac OS X v10.0 and later.*/

struct TXNMacOSPreferredFontDescription {
   UInt32 fontID;
   Fixed pointSize;
   TextEncoding encoding;
   Style fontStyle;
};
typedef struct TXNMacOSPreferredFontDescription TXNMacOSPreferredFontDescription;

/*TXNMacOSPreferredFontDescription;

Initialization Option Masks

Represents MLTE initialization options.

typedef OptionBits TXNInitOptions;
enum {
   kTXNWantMoviesMask = 1L << kTXNWantMoviesBit,
   kTXNWantSoundMask = 1L << kTXNWantSoundBit,
   kTXNWantGraphicsMask = 1L << kTXNWantGraphicsBit,
   kTXNAlwaysUseQuickDrawTextMask = 1L << kTXNAlwaysUseQuickDrawTextBit,
   kTXNUseTemporaryMemoryMask = 1L << kTXNUseTemporaryMemoryBit
};
Constants
kTXNWantMoviesMask

Use to set or test for the kTXNWantMoviesBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantSoundMask

Use to set or test for the kTXNWantSoundBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantGraphicsMask

Use to set or test for the kTXNWantGraphicsBit bit.

Available in Mac OS X v10.0 and later.
kTXNAlwaysUseQuickDrawTextMask

Use to set or test for the kTXNAlwaysUseQuickDrawTextBit bit. 

Available in Mac OS X v10.0 and later.
kTXNUseTemporaryMemoryMask

Use to set or test for the kTXNUseTemporaryMemoryBit bit.

Available in Mac OS X v10.0 and later.
Discussion

Used in the iUsageFlags parameter of the TXNInitTextension function.*/
typedef OptionBits TXNInitOptions;
enum {
   kTXNWantMoviesMask = 1L << kTXNWantMoviesBit,
   kTXNWantSoundMask = 1L << kTXNWantSoundBit,
   kTXNWantGraphicsMask = 1L << kTXNWantGraphicsBit,
   kTXNAlwaysUseQuickDrawTextMask = 1L << kTXNAlwaysUseQuickDrawTextBit,
   kTXNUseTemporaryMemoryMask = 1L << kTXNUseTemporaryMemoryBit
};


/*Formatting and Privileges Settings

Specifies the formatting and privileges information to get from or set for a text object.

typedef FourCharCode TXNControlTag;
enum {
   kTXNLineDirectionTag = 'lndr',
   kTXNJustificationTag = 'just',
   kTXNIOPrivilegesTag = 'iopv',
   kTXNSelectionStateTag = 'slst',
   kTXNInlineStateTag = 'inst',
   kTXNWordWrapStateTag = 'wwrs',
   kTXNKeyboardSyncStateTag = 'kbsy',
   kTXNAutoIndentStateTag = 'auin',
   kTXNTabSettingsTag = 'tabs',
   kTXNRefConTag = 'rfcn',
   kTXNMarginsTag = 'marg',
   kTXNFlattenMoviesTag = 'flat',
   kTXNDoFontSubstitution = 'fSub',
   kTXNNoUserIOTag = 'nuio',
   kTXNUseCarbonEvents = 'cbcb',
   kTXNDrawCaretWhenInactiveTag = 'dcrt',
   kTXNDrawSelectionWhenInactiveTag = 'dsln',
   kTXNDisableDragAndDropTag = 'drag',
   kTXNSingleLevelUndoTag = 'undo',
   kTXNVisibilityTag = 'visb'
   kTXNDisableLayoutAndDrawTag = kTXNVisibilityTag,
   kTAXNAutoScrollbehaviorTag = ‘sbev’
};
Constants
kTXNLineDirectionTag

Specifies a setting for the direction text is written on the line. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies the line direction in the iControlData parameter. See Line Direction Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNJustificationTag

Specifies a justification setting. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies a justification setting in the iControlData parameter. See Justification Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNIOPrivilegesTag

Indicates a privileges setting. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies a privileges setting in the iControlData parameter. See Read and Write Privileges Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNSelectionStateTag

Specifies a selection state; that is, whether MLTE displays a cursor and allows selections in a read-only document. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies the selection state in the iControlData parameter. See Selection State Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNInlineStateTag

Specifies an inline state that is, whether text is input through the document’s window (inline) or through a small floating window that appears at the bottom of the screen. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies the inline state in the iControlData parameter. See Inline State Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNWordWrapStateTag

Specifies a word-wrap setting. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies the line-wrapping state in the iControlData parameter. See Line Wrapping Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNKeyboardSyncStateTag

Specifies whether to synchronize the keyboard with the font setting. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies the keyboard synchronization state in the iControlData parameter. See Keyboard Synchronization Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNAutoIndentStateTag

Specifies an automatic indentation setting. This is available only when word warp is turned off. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies the indentation state in the iControlData parameter. See Automatic Indentation Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNTabSettingsTag

Specifies a tab width setting. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a TXNTab structure in the iControlData parameter.

Available in Mac OS X v10.0 and later.
kTXNRefConTag

An application-specific constant you define. 

Available in Mac OS X v10.0 and later.
kTXNMarginsTag

Specifies margin settings. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a pointer to a TXNMargins structure in the iControlData parameter. You use this structure to specify the top, left, and right margin settings.

Available in Mac OS X v10.0 and later.
kTXNFlattenMoviesTag

Specifies whether to flattens movies. A flattened movie is self-contained. If you don’t flatten a movie, it can’t be played unless any external files (such as audio or image files) on which it depends are available. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a Boolean value in the iControlData parameter that specifies whether to enable (true) or disable (false) movie flattening.

Available in Mac OS X v10.0 and later.
kTXNDoFontSubstitution

Specifies a font substitution setting. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a Boolean value in the iControlData parameter that specifies whether to enable (true) or disable (false) font substitution. For best performance, don’t enable font substitution. 

Available in Mac OS X v10.0 and later.
kTXNNoUserIOTag

Specifies an input setting; that is, whether to prevent input typed by the user, but allows your application to use the TXNSetData function. Text objects could have read-only with respect to the application user, but have read-and-write privileges with respect to the application. If you pass this constant in the iControlTags parameter of the TXNSetTXNObjectControls function, you must also pass a value that specifies a read-write setting in the iControlData parameter. See Read and Write Privileges Settings for a description of possible values.

Available in Mac OS X v10.0 and later.
kTXNUseCarbonEvents


Specifies settings for using Carbon events. (Deprecated. Use TXNGetEventTarget and TXNSetEventTarget.)

Available in Mac OS X v10.0 and later.
kTXNDrawCaretWhenInactiveTag


Specifies settings for drawing the caret when the text object does not have focus. (Deprecated. In Mac OS Xv10.4 and later, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDrawSelectionWhenInactiveTag

Specifies settings for drawing the selection when the text object does not have focus.

Available in Mac OS X v10.0 and later.
kTXNDisableDragAndDropTag

Specifies settings for drag and drop support.

Available in Mac OS X v10.1 and later.
kTXNSingleLevelUndoTag

Specifies to use a single level of undo.

Available in Mac OS X v10.2 and later.
kTXNVisibilityTag

Specifies visibility.

Available in Mac OS X v10.2 and later.
kTXNDisableLayoutAndDrawTag

Specifies visibility. Equivalent to kTXNVisibilityTag. Available in Mac OS X v10.4 and later. Use this tag to disable and re-enable layout and drawing. It optimizes performance when adding data incrementally to a text object.

Available in Mac OS X v10.4 and later.
kTXNAutoScrollBehaviorTag

Specifies autoscroll behavior. Available in Mac OS X v10.4 and later. For constants that represent the various types of autoscrolling, see Automatic Scrolling Behavior.

Available in Mac OS X v10.4 and later.
Discussion

You pass formatting and privileges settings in the iControlTags parameter of the TXNSetTXNObjectControls or TXNGetTXNObjectControls functions. If you want to clear a setting associated with a control tag, you can set the value of the iControlData parameter to Clearance Settings.*/
typedef FourCharCode TXNControlTag;
enum {
   kTXNLineDirectionTag = 'lndr',
   kTXNJustificationTag = 'just',
   kTXNIOPrivilegesTag = 'iopv',
   kTXNSelectionStateTag = 'slst',
   kTXNInlineStateTag = 'inst',
   kTXNWordWrapStateTag = 'wwrs',
   kTXNKeyboardSyncStateTag = 'kbsy',
   kTXNAutoIndentStateTag = 'auin',
   kTXNTabSettingsTag = 'tabs',
   kTXNRefConTag = 'rfcn',
   kTXNMarginsTag = 'marg',
   kTXNFlattenMoviesTag = 'flat',
   kTXNDoFontSubstitution = 'fSub',
   kTXNNoUserIOTag = 'nuio',
   kTXNUseCarbonEvents = 'cbcb',
   kTXNDrawCaretWhenInactiveTag = 'dcrt',
   kTXNDrawSelectionWhenInactiveTag = 'dsln',
   kTXNDisableDragAndDropTag = 'drag',
   kTXNSingleLevelUndoTag = 'undo',
   kTXNVisibilityTag = 'visb',
   kTXNDisableLayoutAndDrawTag = kTXNVisibilityTag  ,
   kTAXNAutoScrollbehaviorTag='sbev'
};

/*Tab Types

Defines the tab settings for a text object.

typedef SInt8 TXNTabType;
enum {
   kTXNRightTab = -1,
   kTXNLeftTab = 0,
   kTXNCenterTab = 1
};
Constants
kTXNRightTab

Right tabs are active.

Available in Mac OS X v10.0 and later.
kTXNLeftTab

Left tabs are active; not available in MLTE version 1.0.

Available in Mac OS X v10.0 and later.
kTXNCenterTab

Center tabs are active; not available in MLTE version 1.0.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNTab structure.*/
typedef SInt8 TXNTabType;
enum {
   kTXNRightTab = -1,
   kTXNLeftTab = 0,
   kTXNCenterTab = 1
};


/*TXNTab

Contains tab information for a text object. 

struct TXNTab {
   SInt16 value;
   TXNTabType tabType;
   UInt8 filler;
};
typedef struct TXNTab TXNTab;
Fields
value

The distance between tabs. 
tabType

The type of tab settings, such as right or left. See Tab Types for a description of possible values. 
filler

An unsigned 8-bit integer that exists only to make the structure exactly 4 bytes in size. 
Discussion

Passed in the iControlData parameter of the TXNSetTXNObjectControls function when the value of the iControlTags parameter is kTXNTabSettingsTag, or returned in the oControlData parameter of the TXNGetTXNObjectControls function when the value of the iControlTags parameter is kTXNTabSettingsTag. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TXNTab {
   SInt16 value;
   TXNTabType tabType;
   UInt8 filler;
};
typedef struct TXNTab TXNTab;


/*TXNControlData

Contains information about formatting and other settings that control how a text object is displayed or behaves.

union TXNControlData {
   UInt32 uValue;
   SInt32 sValue;
   TXNTab tabValue;
   TXNMargins *marginsPtr;
};
typedef union TXNControlData TXNControlData;
Fields
uValue

A control setting. You should use this field for control settings, except tab and margins, whose value is unsigned. 
sValue

A control setting. You should use this only for control settings, except tab and margins, whose value is signed. There currently are no control settings whose value is signed. 
tabValue

A structure that contains tab distance and tab type settings. 
marginsPtr

A pointer to a TXNMargins structure that specifies the top, left, and right margin settings. 
Discussion

The TXNControlData data type is a parameter in the TXNSetTXNObjectControls and TXNGetTXNObjectControls functions. The data contained in the union is determined by the iControlData parameter of those functions. 
Availability
Available in Mac OS X v10.0 and later.*/
union TXNControlData {
   UInt32 uValue;
   SInt32 sValue;
   TXNTab tabValue;
   TXNMargins *marginsPtr;
};
typedef union TXNControlData TXNControlData;

/*Text Background Types

Represents a background data type used in the TXNBackground structure.

typedef UInt32 TXNBackgroundType;
enum {
   kTXNBackgroundTypeRGB = 1
};
Constants
kTXNBackgroundTypeRGB

Indicates color.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNBackground structure. MLTE supports only color as the background type.*/
typedef UInt32 TXNBackgroundType;
enum {
   kTXNBackgroundTypeRGB = 1
};

/*TXNBackgroundData

Represents background data used in the TXNBackground structure.

union TXNBackgroundData {
   RGBColor color;
};
typedef union TXNBackgroundData TXNBackgroundData;
Fields
color

A value that specifies the background color on which data is displayed. Color is the only background data that is currently supported. 
Availability
Available in Mac OS X v10.0 and later.*/
union TXNBackgroundData {
   RGBColor color;
};
typedef union TXNBackgroundData TXNBackgroundData;


/*TXNBackground

Specifies the background for text and other data in a text object.

struct TXNBackground {
   TXNBackgroundType bgType;
   TXNBackgroundData bg;
};
typedef struct TXNBackground TXNBackground;
Fields
bgType

Defines the type of data. See TXNBackgroundType data type.
bg

Specifies the data MLTE should use as a background. 
Discussion

Used in the TXNSetBackground function. 
Version Notes

MLTE 1.1 and earlier supports only color.
Availability
Available in Mac OS X v10.0 and later.*/
struct TXNBackground {
   TXNBackgroundType bgType;
   TXNBackgroundData bg;
};
typedef struct TXNBackground TXNBackground;


//function

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (
   TXNObject iTXNObject
);

/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject
);

/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject
);

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView);

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);

/*TXNWriteRangeToCFURL

Writes a range of a text object to a file or to a special file bundle.

OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);
Parameters
iTXNObject

The text object having a range that is to be written.
iStartOffset

The offset in iTXNObject at which to start writing data to iFileURL.
iEndOffset

The offset in iTXNObject at which to stop writing data to iFileURL. 
iDataOptions

A CFDictionaryRef that specifies options for writing out the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is written out using MLTE’s native format.
iDocumentAttributes

The document attributes that are to be embedded in the data stream. This parameter is only supported when writing out the data using one of the following formats: RTF and MLTE native format. Only the key / values defined in Document Attribute Keys are written out. The content of the dictionary is ignored for any other format. If the dictionary is NULL, no attributes are added to the data stream.
iFileURL

CFURLRef for an existing file or directory, whichever is appropriate for the file type. On return, iFileURL contains a copy of the data in the given range for the iTXNObject with the format and encoding specified by iDataOptions. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function writes a range of a text object to a file or a special file bundle (directory). It supports several document formats and encodings, which can be specified in the data options dictionary. Clients can specify additional document attributes when data is written out using a file format, such as RTF and native MLTE file format) that supports such attributes.
Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);

/*TXNReadFromCFURL

Reads data from a CFURLRef into a TXNObject.

OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);
Parameters
iTXNObject

The text object into which data read from iFileURL is to be added.
iStartOffset

The offset in iTXNObject at which to start placing data read from iFileURL.
iEndOffset

The offset in iTXNObject at which to stop placing data read from iFileURL. 
iDataOptions

Options for reading the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is read in using MLTE’s native format.
iFileURL

A CFURLRef to the data that is to be added to the text object specified by inTXNObject.
oDocumentAttributes

A value of type CFDictionary that, on return, contains the document attributes present in the data stream, if the file format supports them; otherwise this parameter is NULL. The native MLTE file format and RTF support embedded document attributes. See Document Attribute Keys for a list of supported attributes. If this parameter is NULL, no document attributes are written out.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function reads data from a file or a special file bundle (directory) into a text object. Offset parameters are used to specify whether the new data is inserted, appended or replaces an existing data range in the text object. Clients can specify the document format and encoding of the data using the iDataOptions parameter. This functions also returns the document attributes present in the data stream. Document attributes are supported only for the rich text file formats supported by MLTE, which are RTF and MLTE native file format.

If the caller passes a pointer to a CFDictionaryRef, this function returns a reference to a dictionary of attributes, if there is one, that the caller is responsible for releasing. In all other cases, this function sets the reference to NULL. Here is some sample code:CFDictionaryRef oDocumentAttributes = NULL;
status = TXNReadFromCFRUL (....,&oDocumentAttributes);
if (oDocumentAttributes != NULL) ::CFReleases(oDocumentAttributes);

Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);

/*HITextViewCreate

Creates an HITextView that is initially invisible.

OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
);
Parameters
inBoundsRect

The bounding box of the view. Pass NULL, if you want to initialize the bounds of the view to 0.
inOptions

Reserved for future use; you must pass 0.
inTXNFrameOptions

The frame options you want to set for the text view. 
outTextView

On output, points to the newly-created text view. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

An HITextView is an MLTE text view that can be embedded in the HIView hierarchy. The view can be embedded in an HIScrollView if you want scroll bars and can also be used in a composited window. For more information on HIView, see the document Introducing HIView, available from the Apple Developer Documentation website.

When you call the function HITextViewCreate to create a text view, an MLTE text object (TXNObject) is allocated and attached to the text view. You can extract the text object by calling the function HITextViewGetTXNObject. You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. 

The following MLTE functions return an error if you pass a text object that comes from an HITextView:
TXNAttachObjectToWindowRef
TXNGetWindowRef
TXNDrawObject
TXNSetScrollbarState
TXNGrowWindow
TXNZoomWindow
TXNResizeFrame
TXNSetFrameBounds
TXNSetViewRect
TXNDraw
TXNFocus
TXNUpdate
TXNForceUpdate
TXNPageSetup
TXNPrint
TXNIdle
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
);

/*TXNInitTextension

Initializes MLTE. 

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
);
Parameters
iDefaultFonts

An array of TXNMacOSPreferredFontDescription structures. You use this to specify a table of font information that includes the font family ID, point size, style, and script code. The table can be NULL or can have an entry for any script for which you would like to designate a default font. To designate that MLTE should use the default settings for a specified script, you need to supply a valid script code value in the TextEncoding field of the font description structure and a value of kTXNUseScriptDefaultValue in all other fields of the structure. In Mac OS X, the default settings are read from the Theme settings. In Mac OS 9, the default settings are read from the Script Manager.
iCountDefaultFonts

The number of scripts for which you are designating a default font in the iDefaultFonts array. 
iUsageFlags

A value that specifies whether embedded objects should be supported. You can also specify whether MLTE should use QuickDraw as the imaging system and whether temporary memory should be used. See Initialization Option Masks for a description of possible values. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For systems prior to Mac OS X v10.3, you should call this function along with any other initialization calls you make when your application starts up. If you call this function a second time, it has no effect; the defaults you set up the first time you called the TXNInitTextension function are in effect until you call the TXNTerminateTextension function.

For Mac OS X v10.3 and later, you do not have to call this function. However, you may want to call this function to set default fonts that are different from the system default font or to enable multimedia support.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
);

/*TXNActivate

Sets the state of the scroll bars so they are drawn correctly in response to activate events. (Deprecated in Mac OS X v10.3. Use TXNSetScrollbarState instead.)

Not recommended.

OSStatus TXNActivate (
   TXNObject iTXNObject,
   TXNFrameID iTXNFrameID,
   TXNScrollBarState iActiveState
);
Parameters
iTXNObject

The text object that identifies the document to be activated. 
iTXNFrameID

The frame ID of the document that is to be activated. You obtain a frame ID from TXNNewObject when you create a text object. 
iActiveState

A value that indicates the state of the scroll bars. See Scroll Bar States for a description of possible values. If you pass the kScrollBarsAlwaysActive constant, the scroll bars are always active, whether or not the frame’s text area currently has keyboard focus. Passing kScrollBarsAlwaysActive can be useful for a window such as a dialog box that may contain multiple text areas, each of which may have a scrollable frame. If you pass kScrollBarsSyncWithFocus, MLTE synchronizes the activity state of the scroll bars with the focus state of the frame. Therefore, only when the frame has keyboard focus does it have active scroll bars. A value of kScrollBarsSyncWithFocus is the default and is typically recommended if you have only one frame per window. 
Return Value

A result code. See “MLTE Result Codes”. TXNActivate returns ParamErr if you pass an invalid text object or frame ID.
Discussion

You typically call TXNActivate in response to an activate event. If the text object was previously inactive, TXNActivate removes any visual indication of its prior inactive state (such as a dimmed or framed selection area or inactive scroll bars). Before you call the TXNActivate function, you should make sure that the window belongs to your application.

The TXNActivate function does not change the keyboard focus. This means your application can have a text area that is not focused, but in which the scroll bars are active. This lets application users scroll the inactive text without changing the focus from another text area.

If you want to display a text area that has both keyboard focus and active scroll bars, you must call the TXNFocus function immediately before you call the TXNActivate function. Note that MLTE does not retain information about keyboard focus. So if, for example, you set the keyboard focus on a text area and the window containing the text area becomes deactivated, you must call the TXNFocus function when the window becomes activated again. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNActivate (
   TXNObject iTXNObject,
   TXNFrameID iTXNFrameID,
   TXNScrollBarState iActiveState
);

/*TXNFocus

Changes the focus of a text object.

void TXNFocus (
   TXNObject iTXNObject,
   Boolean iBecomingFocused
);
Parameters
iTXNObject

The text object whose focus you want to change.
iBecomingFocused

If you pass true, the text object receives focus. This means the current selection or insertion point is active, text input appears at the insertion point, and the keyboard and font are synchronized. (Note that the font and keyboard are synchronized only if keyboard synchronization is enabled. See Keyboard Synchronization Settings.) If the scroll bars are not already active, they are activated. If you pass false, the text object’s current selection or insertion point is inactive.
Discussion

You should use the TXNActivate function to make scroll bars active while text input is not focused. This behavior is often desirable for windows with multiple text areas that are scrollable. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNFocus (
   TXNObject iTXNObject,
   Boolean iBecomingFocused
);

/*TXNSetTXNObjectControls

Sets formatting and privileges attributes (such as justification, line direction, tab values, and read-only status) that apply to the entire text object.

OSStatus TXNSetTXNObjectControls (
   TXNObject iTXNObject,
   Boolean iClearAll,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   const TXNControlData iControlData[]
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set formatting and privileges attributes. 
iClearAll

A Boolean value. If you set this to true, all formatting and privileges attributes are reset to their default value. That is, true clears existing tags and resets each to its default value. 
iControlCount

The number of items in the iControlTags array. 
iControlTags

An array of values that specifies kind of data that is passed in the iControlData parameter. See Formatting and Privileges Settings for a description of possible values. On systems that use Apple Type Services for Unicode Imaging (ATSUI), you can also pass any of the following ATSUI attribute tag constants:
kATSULineDirectionTag
kATSULineJustificationFactorTag
kATSULineFlushFactorTag
kATSULineBaselineValuesTag
kATSULineLayoutOptionsTag
kATSUCGContextTag

See the ATSUI documentation for a description of these ATSUI constants.
iControlData

An array of TXNControlData unions that contain the information your application wants to set. The value you supply to the iControlTags parameter specifies how the union of type TXNControlData is treated. You must make sure that the value you assign to the iControlData parameter is the appropriate type implied by the value you passed in the iControlTags parameter. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

On systems that use Apple Type Services for Unicode Imaging (ATSUI), the ATSUI line control attribute tags can be passed to this function in the iControlTag parameter. This is the case for all the ATSUI tags except kATSULineRotationTag. ATSUI tags are applied to the entire text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetTXNObjectControls (
   TXNObject iTXNObject,
   Boolean iClearAll,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   const TXNControlData iControlData[]
);

/*TXNSetBackground

Sets the background on which the text object’s data is drawn. 

OSStatus TXNSetBackground (
   TXNObject iTXNObject,
   const TXNBackground * iBackgroundInfo
);
Parameters
iTXNObject

The text object that identifies the document to be activated. 
iBackgroundInfo

A pointer to a structure that describes the background. 
Return Value

A result code. See “MLTE Result Codes”.
Version Notes

MLTE supports only color as the background. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetBackground (
   TXNObject iTXNObject,
   const TXNBackground * iBackgroundInfo
);

/*TXNGetSelection

Gets the absolute offsets of the current selection. 

void TXNGetSelection (
   TXNObject iTXNObject,
   TXNOffset * oStartOffset,
   TXNOffset * oEndOffset
);
Parameters
iTXNObject

The text object for the current text area. 
oStartOffset

On return, a pointer to the absolute starting offset of the current selection. 
oEndOffset

On return, a pointer to the absolute ending offset of current selection.
Discussion

Offsets in MLTE are always character offsets. Each embedded graphics or sound object is counted as one character. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNGetSelection (
   TXNObject iTXNObject,
   TXNOffset * oStartOffset,
   TXNOffset * oEndOffset
);

/*TXNDataSize

Reports the amount of memory used to hold the text in a given text object.

ByteCount TXNDataSize (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that you want to examine.
Return Value

The number of bytes required to hold the characters.
Discussion

You can use this function to determine how large a handle should be if, for example, you copy text. Note that because every individual sound, picture, or movie in a text object is represented by a single character in the text buffer, the TXNDataSize function returns a value that does not necessarily represent the true size of any non-text data.

If you are using Unicode and you want to know the number of characters, divide the returned ByteCount value by sizeof(UniChar) or 2, since MLTE uses the 16-bit Unicode Transformation Format (UTF-16). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
ByteCount TXNDataSize (
   TXNObject iTXNObject
);

/*TXNNewObject

Creates a new MLTE text object which is an opaque structure that handles text formatting at the document level. (Deprecated in Mac OS X v10.3. Use TXNCreateObject instead.)

Not recommended.

OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
);
Parameters
iFileSpec

A pointer to a variable of type FSSpec. If you pass NULL you start with an empty document. Otherwise, the contents of the file to which iFileSpec points are read into the object. The referenced file must consist entirely of data that MLTE can read ('TEXT', 'RTF ', 'utxt', or 'txtn'). If the referenced file contains your application’s private data and data that MLTE can read, you should call the TXNNewObject function with the iFileSpec parameter set to NULL. Once TXNNewObject creates the text object, your application can read the private data into the text object by calling the TXNSetDataFromFile function. 
iWindow

A reference to the window in which the document will be displayed. This parameter can be NULL. If it is NULL, you must attach a window or graphics port to the text object by using the TXNAttachObjectToWindow function. 
iFrame

A pointer to a variable of type Rect. If you pass NULL, the window’s portRect rectangle is used as the frame. If you do not want to fill the entire window, you use the iFrame parameter to specify the area to fill. 
iFrameOptions

A value that specifies the options you want the frame to support. See Frame Option Masks for a description of possible values. 

If you want to create a read-only document, you need to pass the option kTXNReadOnlyMask. Note that this option puts the text object into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically, you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag. If you choose to set the text object into this restrictive state, you will get an error if you try to call the function TXNSetData on the text object. (In this case, you can change the text object to a less restrictive state by calling TXNSetTXNObjectControls, passing the tag kTXNNoUserIOTag.)
iFrameType

A value that specifies the frame type of the text object. See Supported Frame Types for a description of possible values. 
iFileType

A value that specifies the file type of the text object. See Supported File Types for a description of possible values. You should specify the primary file type. If you use the kTXNTextensionFile constant, files are saved in a custom format. If you want saved files to be plain text files, you should specify the kTXNTextFile constant, then use the iframeOptions parameter to specify whether the plain text files should be saved with kTXNSingleStylePerTextDocumentResType or kTXNMultipleStylesPerTextDocumentResType resources. 
iPermanentEncoding

A value that specifies the encoding in which the document is saved. See Text Encoding Preferences for a description of possible values. 
oTXNObject

A pointer to a structure of type TXNObject. On return, this points to the opaque text object data structure allocated by the function. You need to pass this object to most MLTE functions. 
oTXNFrameID

On return, a pointer to the unique ID for the text object’s frame. However, in MLTE version 1.1 and earlier, the frame ID is always set to 0. 
iRefCon

A value of type TXNObjectRefcon. You can define how to use this for your application. You can set this to any value and retrieve it later. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For each document, a new text object is allocated by the TXNNewObject function and returned in the oTXNObject parameter. The object is allocated only if no errors occur, including errors that may occur when reading a file. If there is an error during the allocation process, MLTE frees the text object. 

If you are writing a text editing application, you may want to call the TXNNewObject function when the application launches (a new document will be displayed) and whenever the user selects New from the File menu. 

Many MLTE functions require you to pass a text object; some functions also require the frame ID supplied back to your application in the oTXNFrameID parameter of TXNNewObject.

Because of how MLTE uses Carbon events internally, the window in which the document is displayed must have the standard event handlers installed. You can do this in one of the following ways:
When you create the window, add the attribute kWindowStandardHandlerAttribute to the window. See Inside Mac OS X: Window Manager Reference for more information.
Call the Carbon Event Manager function InstallStandardEventHandler on the window's event target. See Inside Mac OS X: Handling Carbon Events for more information.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
);

/*TXNIsScrapPastable

Tests whether the Clipboard contains data that is supported by MLTE. 

Boolean TXNIsScrapPastable ();
Return Value

Returns true if the data type on the Clipboard is supported.
Discussion

You can call the TXNIsScrapPastable function to determine if the Paste item in the Edit menu should be active. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
Boolean TXNIsScrapPastable ();

/*TXNCanRedo

Returns whether the most recently undone action is redoable and indicates the type of action that can be redone. (Deprecated in Mac OS X v10.4. Use TXNCanRedoAction instead.)

Not recommended.

Boolean TXNCanRedo (
   TXNObject iTXNObject,
   TXNActionKey * oTXNActionKey
);
Parameters
iTXNObject

The text object for the document you want to examine. 
oTXNActionKey

A pointer to a value of type TXNActionKey. On return, this value specifies the action that can be redone. See Action Constants for a description of possible values. You can use this information to customize the Redo menu item for the specific action to be redone. For example, if the value obtained by TXNCanRedo is kTXNTypingAction, you can map that value to a string that reads “Redo Typing” on a system localized for U.S. English. MLTE does not perform the mapping your program is responsible for mapping the key to the appropriate localized string you want displayed to the user. Pass NULL if you do not want to obtain this information. 
Return Value

A Boolean value. If true, the last command is redoable; otherwise the last command cannot be redone. 
Discussion

You can call the TXNCanRedo function to determine whether the Redo item in the Edit menu should be enabled. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
Boolean TXNCanRedo (
   TXNObject iTXNObject,
   TXNActionKey * oTXNActionKey
);

/*TXNCanUndo

Returns whether the most recent action is undoable and provides a value that indicates the type of action than can be undone. (Deprecated in Mac OS X v10.4. Use TXNCanUndoAction instead.)

Not recommended.

Boolean TXNCanUndo (
   TXNObject iTXNObject,
   TXNActionKey *oTXNActionKey
);
Parameters
iTXNObject

The text object for the document you want to examine. 
oTXNActionKey

A pointer to a value of type TXNActionKey. On return, this value identifies the action that can be undone. See Action Constants for a description of possible values. You can use this information to customize the Undo menu item for the specific action to be undone. For example, if the value obtained by TXNCanUndo is kTXNTypingAction, you can map that value to a string that reads “Undo Typing” on a system localized for U.S. English. MLTE does not perform such a mapping your program is responsible for mapping the key to the appropriate localized string you want displayed to the user. Pass NULL if you do not wish to obtain this information. 
Return Value

A Boolean value. If true, the last command is undoable; otherwise the last command cannot be undone. 
Discussion

You can call TXNCanUndo to determine whether the Undo item in the Edit menu should be enabled. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
Boolean TXNCanUndo (
   TXNObject iTXNObject,
   TXNActionKey *oTXNActionKey
);

/*TXNDeleteObject

Deletes a previously allocated text object. 

void TXNDeleteObject (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object you want to delete.
Discussion

You should call the TXNDeleteObject function when you close the window associated with a text object. The function TXNDeleteObject releases the specified text object and all associated data structures from memory. If the object has multiple frames, all frames are deleted. 
Version Notes

Multiple frames are not yet implemented in MLTE.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNDeleteObject (
   TXNObject iTXNObject
);

/*TXNClear

Deletes the current selection.

OSStatus TXNClear (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the current text area.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

To remove a selected object from a text area, a user can either press the Delete key or choose Clear from the Edit menu. Before you call the TXNClear function, you can use the TXNIsSelectionEmpty function to determine whether any text is selected. Unlike the function TXNCut, the TXNClear function does not add the deleted selection to the private MLTE scrap. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNClear (
   TXNObject iTXNObject
);

/*TXNGetTXNObjectControls

Gets the current formatting and privileges attributes (such as justification, line direction, tab values, and read-only status) for a text object.

OSStatus TXNGetTXNObjectControls (
   TXNObject iTXNObject,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   TXNControlData oControlData[]
);
Parameters
iTXNObject

The text object that identifies the document to be activated. 
iControlCount

The number of items in the iControlTags array. 
iControlTags

An array of values that specify the kind of formatting information you want returned in the oControlData array. See Formatting and Privileges Settings for a description of possible values. 
oControlData

An array of TXNControlData unions. On return, the array contains the information that was requested through the iControlTags array. Your application must allocate the oControlData array. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetTXNObjectControls (
   TXNObject iTXNObject,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   TXNControlData oControlData[]
);

/*TXNPaste

Pastes the contents of the private MLTE scrap into the text object.

OSStatus TXNPaste (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the current document.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Before you call TXNPaste, you can call the TXNIsScrapPastable function to determine if the current scrap contains data supported by MLTE. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPaste (
   TXNObject iTXNObject
);

/*TXNRedo

Redoes the last command.

void TXNRedo (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the document you want to examine. 
Discussion

If the user undoes an action and then undoes it again, the second undo is the same as a redo. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNRedo (
   TXNObject iTXNObject
);

/*TXNConvertFromPublicScrap

Converts the Clipboard content to the private MLTE scrap. (Deprecated in Mac OS X v10.3. This function isn't needed in Mac OS X.)

Not recommended.

OSStatus TXNConvertFromPublicScrap ();
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You should call the TXNConvertFromPublicScrap function after another application has modified the contents of the Clipboard. Calling the TXNConvertFromPublicScrap function ensures that the contents of the system Clipboard are available to your application. Typically, when you receive a resume event, you call the Scrap Manager function GetCurrentScrap to determine whether the Clipboard content has been modified. If so, you should then call TXNConvertFromPublicScrap. 
Special Considerations

The function TXNConvertFromPublicScrap is no longer needed in Mac OS X version 10.2 and later. Calling the function TXNPaste automatically handles conversion from public scrap.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNConvertFromPublicScrap ();

/*TXNConvertToPublicScrap

Converts the private MLTE scrap content to the Clipboard. (Deprecated in Mac OS X v10.3. This function isn't needed in Mac OS X.)

Not recommended.

OSStatus TXNConvertToPublicScrap ();
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNConvertToPublicScrap ();

/*TXNAdjustCursor

Obtains the current cursor position and draws the cursor in a form appropriate to the content over which it is placed.

void TXNAdjustCursor (
   TXNObject iTXNObject,
   RgnHandle ioCursorRgn
);
Parameters
iTXNObject

The text object that identifies the text area for which MLTE should adjust the cursor.
ioCursorRgn

A handle to a region created by your application. Pass NULL if you do not want TXNAdjustCursor to provide information about the cursor position to your application. If you do want to obtain the cursor’s current position, pass a valid region handle in this parameter. If you pass a valid region handle and the cursor is over the text area or its scroll bars, on return TXNAdjustCursor sets the region to a 2-pixel by 2-pixel square, centered on the cursor’s hot spot. If the cursor is not over the text area or its scroll bars, or if you have passed NULL, TXNAdjustCursor does not adjust the input value.
Discussion

If the cursor is over a text area, TXNAdjustCursor sets the cursor to an I-beam. If the cursor is over graphics, a sound file, a movie, a scroll bar, or outside of a window, TXNAdjustCursor sets the cursor to an arrow. Before you call the TXNAdjustCursor function, you should make sure that the window belongs to your application.

You can pass the region handle returned by the TXNAdjustCursor function in the ioCursorRgn parameter to the WaitNextEvent function; this ensures that you receive mouse-moved events if the cursor moves outside that region. If you then receive a mouse-moved event, you can call TXNAdjustCursor again to ensure that the cursor type is appropriate to its new position. Alternately, to ensure that the cursor is adjusted correctly, you can simply call TXNAdjustCursor with every event that your application receives. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNAdjustCursor (
   TXNObject iTXNObject,
   RgnHandle ioCursorRgn
);

/*TXNClick

Processes a mouse-down event in a window’s content area. 

void TXNClick (
   TXNObject iTXNObject,
   const EventRecord * iEvent
);
Parameters
iTXNObject

The text object in which the mouse-down event occurred.
iEvent

A pointer to the event record that contains the mouse-down event to process.
Discussion

When you pass the event to the TXNClick function, it responds to the user’s action by scrolling, selecting text, playing a sound or movie, handling a drag–and-drop operation, or responding to a double- or triple-click, as appropriate. Before you call TXNClick, you should make sure that the front window belongs to your application. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNClick (
   TXNObject iTXNObject,
   const EventRecord * iEvent
);

/*TXNCopy

Copies the current selection to the private MLTE scrap.

OSStatus TXNCopy (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the current text area.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNCopy function to respond to a user-requested copy action. Before you call TXNCopy, you can use the TXNIsSelectionEmpty function to determine whether any text is selected. 

The TXNCopy function copies the current selection to the MLTE scrap. In a Carbon application, the Scrap Manager automatically converts your application’s private scrap to the Clipboard so it is available to other applications. In a Classic application, you must call the function TXNConvertToPublicScrap after you call TXNCopy. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNCopy (
   TXNObject iTXNObject
);

/*TXNSetFrameBounds

Changes the boundaries of a text object’s frame.

void TXNSetFrameBounds (
   TXNObject iTXNObject,
   SInt32 iTop,
   SInt32 iLeft,
   SInt32 iBottom,
   SInt32 iRight,
   TXNFrameID iTXNFrameID
);
Parameters
iTXNObject

The text object for the current text area. 
iTop

The top boundary of the rectangle. 
iLeft

The left boundary of the rectangle. 
iBottom

The bottom boundary of the rectangle. 
iRight

The right boundary of the rectangle. 
iTXNFrameID

The frame ID of the frame you want to move. You obtain a frame ID when you call the TXNNewObject function. 
Discussion

If you want to change the view and destination rectangles, you should call the TXNResizeFrame function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNSetFrameBounds (
   TXNObject iTXNObject,
   SInt32 iTop,
   SInt32 iLeft,
   SInt32 iBottom,
   SInt32 iRight,
   TXNFrameID iTXNFrameID
);

/*TXNDraw

Redraws the text area, including any scroll bars associated with the text frame. (Deprecated in Mac OS X v10.3. Use the TXNDrawObject .)

Not recommended.

void TXNDraw (
   TXNObject iTXNObject,
   GWorldPtr iDrawPort
);
Parameters
iTXNObject

The text object whose text is to be redrawn. 
iDrawPort

A value of type GWorldPtr. Pass a valid pointer or NULL. If you pass NULL, the TXNDraw function redraws the text area into the port that is currently associated with the text object. If you pass a valid pointer instead of NULL, TXNDraw redraws the text area into the specified port, and does not update the selection. You should pass NULL if you want to draw on the screen but pass a valid pointer if you want to take a snapshot of the screen to save or print. 
Discussion

You can call the TXNDraw function in response to an update event for a window that contains multiple text objects or other graphic elements. If necessary, your application is also responsible for calling the Window Manager functions BeginUpdate and EndUpdate in response to the update event.

If there is nothing in your window except a single MLTE text object, you should call the TXNUpdate function to redraw the area instead of calling TXNDraw. The TXNUpdate f unction draws everything in the frame, and you do not have to call the Window Manager functions BeginUpdate and EndUpdate yourself. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
void TXNDraw (
   TXNObject iTXNObject,
   GWorldPtr iDrawPort
);

/*TXNUndo

Undoes the last command. 

void TXNUndo (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the document you want to examine. 
Discussion

The undo stack is 32 levels deep. That is, undoable actions are tracked until the total count is 32. If a user undoes two actions, the Redo command must be used twice to get back to the original state. If more than 32 actions are performed, the oldest actions are forgotten as each new action takes place.

If the user performs a new action after choosing Redo from the Edit menu, the redone action is no longer available to be undone. For example, a user performs the following actions: types some text, cuts some text, pastes some text, types some text; undoes the last typing action, and undoes the paste operation; redoes the paste; types some new text. After the new text has been typed, the undo stack contains the first text that was typed, the cut action, and the new text that was just typed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNUndo (
   TXNObject iTXNObject
);

/*TXNCut

Deletes the current selection and copies it to the private MLTE scrap.

OSStatus TXNCut (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the current text area.
Return Value

A result code. See “MLTE Result Codes”.TXNCut also returns Scrap Manager errors.
Discussion

You can use the TXNCut function to respond to a user-requested cut action. Before you call TXNCut, you can use the TXNIsSelectionEmpty function to determine whether any text is selected. The TXNCut function deletes the current selection and then copies it to the private MLTE scrap. In a Carbon application, the Scrap Manager automatically converts your application’s private scrap to the Clipboard so it is available to other applications. In a Classic application, you must call the function TXNConvertToPublicScrap after you call TXNCut to move the selection to the Clipboard. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNCut (
   TXNObject iTXNObject
);


#ifdef __cplusplus
}
#endif
#endif