#ifndef HIVIEW_H
#define HIVIEW_H

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef HISHAPE_H
#include <HIToolbox/HIShape.h>
#endif


#include <HYS/HIToolbox/HIView.h>

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*HIView Feature Constants

Specify constants for view features.

enum {
   kHIViewFeatureSupportsGhosting = 1 << 0,
   kHIViewFeatureAllowsSubviews = 1 << 1,
   kHIViewFeatureGetsFocusOnClick = 1 << 8,
   kHIViewFeatureSupportsLiveFeedback = 1 << 10,
   kHIViewFeatureSupportsRadioBehavior = 1 << 11,
   kHIViewFeatureAutoToggles = 1 << 14,
   kHIViewFeatureIdlesWithTimer = 1 << 23,
   kHIViewFeatureInvertsUpDownValueMeaning = 1 << 24,
   kHIViewFeatureIsOpaque = 1 << 25,
   kHIViewFeatureDoesNotDraw = 1 << 27,
   kHIViewFeatureDoesNotUseSpecialParts = 1 << 28,
   kHIViewFeatureIgnoresClicks = 1 << 29
}; typedef UInt64 HIViewFeatures;
Constants
kHIViewFeatureSupportsGhosting

This view supports using the ghosting protocol when live tracking is not enabled. Use this constant instead of the legacy constant, kHIViewSupportsGhosting. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureAllowsSubviews

This view allows subviews to be embedded within it. Use this constant instead of the legacy constant, kHIViewAllowsSubviews. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureGetsFocusOnClick

If this view is clicked, the keyboard focus should be set to this view automatically; used primarily for edit text controls. Use this constant instead of the legacy constant, kHIViewGetsFocusOnClick. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureSupportsLiveFeedback

This view supports the live feedback protocol, which is necessary for implementing live scroll bar tracking. Clients of a view should never disable this bit. Use this constant instead of the legacy constant, kHIViewSupportsLiveFeedback. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureSupportsRadioBehavior

This view can be placed in a radio group. Radio buttons and bevel buttons report this behavior. Use this constant instead of the legacy constant, kHIViewSupportsRadioBehavior. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureAutoToggles

This view supports the auto-toggle protocol and should at the very least auto-toggle between off and on. The view can support a Carbon event for more advanced auto-toggling of its value. The tab view supports this, for example, so that when a tab is clicked its value changes automatically. Use this constant instead of the legacy constant, kHIViewAutoToggles. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureIdlesWithTimer

An informational bit. Turning this bit off would not necessarily disable any timer a view might be using, but a timer could obey this bit if desired. Use this constant instead of the legacy constant, kHIViewIdlesWithTimer. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureInvertsUpDownValueMeaning

This bit tells the Control Manager that when the Up button part of the control is clicked, the value of the control should increase. A Scroll bar, conversely, decreases in value when its Up button is clicked. Use this constant instead of the legacy constant, kHIViewInvertsUpDownValueMeaning. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureIsOpaque

When set, the view’s structure region is used to determine the view’s opaque region, and calling the view can usually be avoided. Use this constant instead of the legacy constant, kHIViewIsOpaque. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureDoesNotDraw

This bit is an optimization that tells the Control Manager that a view is transparent and does not do any drawing, so the Control Manager doesn’t have to invalidate the view and instead should invalidate views behind this view. For example, on a metal window, the content view is actually fully transparent, so invalidating it is unnecessary. Use this constant instead of the legacy constant, kHIViewDoesNotDraw. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
kHIViewFeatureDoesNotUseSpecialParts

Indicates to the Control Manager that this view doesn’t use the special part codes for indicator, inactive, and disabled. (Available in Mac OS X 10.3 and later.) Use this constant instead of the legacy constant, kHIViewDoesNotUseSpecialParts.

Available in Mac OS X v10.4 and later.
kHIViewFeatureIgnoresClicks

When set, this bit tells the Control Manager that it does not need to ask the control for it’s clickable region. A view such as the visual separator would set this bit, and metal windows set this bit when doing asynchronous window dragging. This bit is typically set in conjunction with the kHIViewFeatureDoesNotDrawBit. Use this constant instead of the legacy constant, kHIViewIgnoresClicks. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.4 and later.
Discussion

View feature flags are generally determined by the view itself and are not typically changed by clients of the view. Call HIViewGetFeatures to obtain a view’s features, and HIViewChangeFeatures to set and clear a view’s features.*/
enum {
   kHIViewFeatureSupportsGhosting = 1 << 0,
   kHIViewFeatureAllowsSubviews = 1 << 1,
   kHIViewFeatureGetsFocusOnClick = 1 << 8,
   kHIViewFeatureSupportsLiveFeedback = 1 << 10,
   kHIViewFeatureSupportsRadioBehavior = 1 << 11,
   kHIViewFeatureAutoToggles = 1 << 14,
   kHIViewFeatureIdlesWithTimer = 1 << 23,
   kHIViewFeatureInvertsUpDownValueMeaning = 1 << 24,
   kHIViewFeatureIsOpaque = 1 << 25,
   kHIViewFeatureDoesNotDraw = 1 << 27,
   kHIViewFeatureDoesNotUseSpecialParts = 1 << 28,
   kHIViewFeatureIgnoresClicks = 1 << 29
}; typedef UInt64 HIViewFeatures;


/*Text Field Event Parameter Constants

Specify constants for text field event parameters.

enum {
   kEventParamTextSelection = 'txsl',
   kEventParamCandidateText = 'tstx',
   kEventParamReplacementText = 'trtx',
   kEventParamUnconfirmedRange = 'tunr',
   kEventParamUnconfirmedText = 'txun'
};
Constants
kEventParamTextSelection

The range of the selection that is about to be changed. The units of the selection are in the same units that are returned in a EditTextSelectionRec, when called with GetControlData using kControlEditTextSelectionTag.

Available in Mac OS X v10.4 and later.
kEventParamCandidateText

The text that is to replace the selection. Note that this string was originally created with CFStringCreateWithCharactersNoCopy, and the original text has a limited life span. If for some reason you need to retain the text past the end of your event handler, you should extract the characters from the string with CFStringGetCharacters, and then store those characters or create a new CFString from them.

Available in Mac OS X v10.4 and later.
kEventParamReplacementText

Optional replacement text.

Available in Mac OS X v10.4 and later.
kEventParamUnconfirmedRange

If the text field currently has an open inline hole, this parameter contains the range of text inside the hole. This parameter is optional and is only present during inline editing.

Available in Mac OS X v10.4 and later.
kEventParamUnconfirmedText

If the text field currently has an open inline hole, this parameter contains the non-confirmed text currently being edited inside the hole. This parameter is optional and is only present during inline editing. Note that this string was originally created with CFStringCreateWithCharactersNoCopy, and the original text has a limited life span. If for some reason you need to retain the text past the end of your event handler, you should extract the characters from the string with CFStringGetCharacters, and then store those characters or create a new CFString from them.

Available in Mac OS X v10.4 and later.*/
enum {
   kEventParamTextSelection = 'txsl',
   kEventParamCandidateText = 'tstx',
   kEventParamReplacementText = 'trtx',
   kEventParamUnconfirmedRange = 'tunr',
   kEventParamUnconfirmedText = 'txun'
};


/*Text Field Event Constants

Specify constants for text field events (kEventClassTextField).

enum {
   kEventTextAccepted = 1,
   kEventTextShouldChangeInRange = 2,
   kEventTextDidChange = 3
};
Constants
kEventTextAccepted

This event is sent as a notification when the text contained in a control’s editable text field has been accepted by the user. Text is accepted when the user presses Return or Enter on the keyboard for the EditUnicodeText, HIComboBox, and HISearchField controls, or when the text has changed in the field and the field loses focus for the EditUnicodeText, HIComboBox, HISearchField and HITextView controls. This event is sent to the control containing the text field only, it is not propagated. It is sent to all handlers installed on the control containing the text field. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventTextShouldChangeInRange

This event is sent whenever the text is about to be modified in text field, either by user input or in other scenarios such as a paste from the clipboard, spell-checking word correction, or Mac OS X Service operation. You can change the text that is inserted by providing a replacement string as a parameter to this event. This event is only sent for Unicode text controls; it is not sent for the Classic non-Unicode EditText control. This event is not sent prior to programmatic modification of the text field contents using SetControlData. This event is not sent while an active inline editing session is in progress. Once the inline text has been confirmed, this event is sent prior to the confirmed text being inserted into the text field. If you need control over keystrokes during an inline editing session, you can use the kEventTextInputFilterText event. This event is sent to the control containing the text field only; it does not propagate. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
kEventTextDidChange

This event is sent to indicate that the contents of an editable text field have changed. This event is sent by all of the Unicode-based editable text views: HIComboBox, HISearchField, HITextView and EditUnicodeText. This event is not sent for the Classic non-Unicode EditText control. Note that this event is sent after inline editing operations, such as pressing a dead key, or using a input method that creates an inline editing hole. Most clients of this event should ignore the event during inline editing, and only respond to changes to the text after inline editing completes. A client can check for the presence of the kEventParamUnconfirmedRange parameter to determine whether inline editing is currently active; if this parameter is present, the client may wish to ignore the event. This event is not sent after programmatic modification of the text field contents using SetControlData. This event is sent only to the control containing the text field; it does not propagate. It is sent to all handlers registered for it. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
Discussion

Table 5 shows the event parameters associated with these events.
Table 5  Parameter names and types for text field events
Event kind	
Parameter name	
Parameter type

kEventTextAccepted	
kEventParamDirectObject	
typeControlRef

kEventTextShouldChangeInRange	
kEventParamTextSelection	
typeCFRange

	
kEventParamCandidateText	
typeCFStringRef

	
kEventParamReplacementText (Optional)	
typeCFStringRef

kEventTextDidChange	
kEventParamUnconfirmedRange	
typeCFRange

	
kEventParamUnconfirmedText	
typeCFStringRef*/

enum {
   kEventTextAccepted = 1,
   kEventTextShouldChangeInRange = 2,
   kEventTextDidChange = 3
};




/*Scrollable Event Constants

Specify constants for scrollable events (kEventClassScrollable).

enum {
   kEventScrollableGetInfo = 1,
   kEventScrollableInfoChanged = 2,
   kEventScrollableScrollTo = 10
};
Constants
kEventScrollableGetInfo

This event is sent by an HIScrollView to its scrollable view to determine the current size and origin of the scrollable view. A scrollable view must implement this event in order to scroll properly inside an HIScrollView. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventScrollableInfoChanged

This event is not sent by an HIScrollView itself. Instead, it may be sent to an instance of HIScrollView to notify the scroll view that the size or origin of its scrollable view has changed. The HIScrollView responds to this event by sending a kEventScrollableGetInfo event to its scrollable view. It then updates the scroll bars appropriately to reflect the changes. It does not move the origin of the scrollable view at all. This event is just a notification to allow the scroll view to sync up with its scrollable view. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventScrollableScrollTo

This event is sent by an HIScrollView to its scrollable view to request that the scrollable view update its current origin and redraw. Typically, a scrollable view scrolls its content by setting its bounds origin using HIViewSetBoundsOrigin or by offsetting its drawing by the scroll origin. If the view embeds other views, it must use HIViewSetBoundsOrigin to allow the embedded views to scroll along with their containing view. A view that uses HIViewSetBoundsOrigin should call that API in response to this event. A view that offsets its drawing by the scroll origin should update its current origin in its own instance data in response to this event. A scrollable view should also use HIViewScrollRect to scroll its content or HIViewSetNeedsDisplay to cause itself to redraw using the new origin point. A scrollable view must implement this event in order to scroll properly inside an HIScrollView. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
Discussion

Table 4 shows the event parameters associated with these events.*/
enum {
   kEventScrollableGetInfo = 1,
   kEventScrollableInfoChanged = 2,
   kEventScrollableScrollTo = 10
};

/*Scrollable Event Parameter Constants

Specify scrollable event parameter constants.

enum {
   kEventParamImageSize = 'imsz',
   kEventParamViewSize = 'vwsz',
   kEventParamLineSize = 'lnsz',
   kEventParamOrigin = 'orgn'
};
Constants
kEventParamImageSize

A value of type typeHISize representing the image size. The image size is the total size of the scrollable view, including any parts of the view that are not currently visible. For example, a scrollable view that displays a hundred page document would return an image size equal to one hundred times the height of the page.

Available in Mac OS X v10.2 and later.
kEventParamViewSize

A value of type typeHISize representing the view size. The view size is the current size of the scrollable view. Typically, this is the same as the view’s bounds and can be acquired by calling HIViewGetBounds.

Available in Mac OS X v10.2 and later.
kEventParamLineSize

A value of type typeHISize representing the line size. The line size is the distance that the HIScrollView should scroll its subview when the user clicks a scroll bar arrow. For example, this might be 10 pixels vertically and 20 pixels horizontally.

Available in Mac OS X v10.2 and later.
kEventParamOrigin

A value of type typeHIPoint representing the origin. The origin is the current view-relative origin within the total scrollable image that is displayed at the top left corner of the view. These coordinates should always be greater than or equal to zero and less than or equal to the view’s image size minus its view size. Typically, a view that implements the kEventScrollableScrollTo event by calling HIViewSetBoundsOrigin returns the current bounds origin for this parameter, and a view implements the ScrollTo event by storing the origin in its instance data returns its stored origin for this parameter. For example, a scrollable view that currently is displaying page ten of a hundred page document would return a horizontal origin of zero and a vertical origin equal to ten times the height of the page.

Available in Mac OS X v10.2 and later.*/

enum {
   kEventParamImageSize = 'imsz',
   kEventParamViewSize = 'vwsz',
   kEventParamLineSize = 'lnsz',
   kEventParamOrigin = 'orgn'
};


/*Scroll View Constants

Specify constants for scroll view options.

enum {
   kHIScrollViewOptionsVertScroll = (1 << 0),
   kHIScrollViewOptionsHorizScroll = (1 << 1),
   kHIScrollViewOptionsAllowGrow = (1 << 2),
   kHIScrollViewValidOptions = (kHIScrollViewOptionsVertScroll  |  kHIScrollViewOptionsHorizScroll | kHIScrollViewOptionsAllowGrow)
};
Constants
kHIScrollViewOptionsVertScroll

Indicates that a vertical scroll bar is desired. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kHIScrollViewOptionsHorizScroll

Indicates that a horizontal scroll bar is desired. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kHIScrollViewOptionsAllowGrow

Indicates that space for a grow box should be taken into account when laying out scroll bars. On Mac OS X v10.3 and earlier, if both horizontal and vertical scroll bars are requested, this attribute is assumed. On Mac OS X v10.4 and later, this attribute is not assumed; this allows the scroll view to support independent auto-hiding of the two scroll bars on Mac OS X v10.4 and later. If you want to preserve space for the grow box on all systems, specify this option bit.

Available in Mac OS X v10.2 and later.
kHIScrollViewValidOptions

All valid scroll view options.

Available in Mac OS X v10.2 and later.
Discussion

These constants are used in conjunction with HIScrollViewCreate.*/
enum {
   kHIScrollViewOptionsVertScroll = (1 << 0),
   kHIScrollViewOptionsHorizScroll = (1 << 1),
   kHIScrollViewOptionsAllowGrow = (1 << 2),
   kHIScrollViewValidOptions = (kHIScrollViewOptionsVertScroll  |  kHIScrollViewOptionsHorizScroll | kHIScrollViewOptionsAllowGrow)
};

/*Event Class Constants

Specify event class constants.

enum {
   kEventClassClockView = 'cloc',
   kEventClassScrollable = 'scrl',
   kEventClassHIComboBox = 'hicb',
   kEventClassSearchField = 'srfd',
   kEventClassTextField = 'txfd'
};
Constants
kEventClassClockView

Event class for events related to a clock view. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
kEventClassScrollable

Event class for events related to a scrollable view. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kEventClassHIComboBox

Event class for events related to a combo box view. (

Available in Mac OS X v10.4.)
kEventClassSearchField

Event calls for events related to a search field view. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kEventClassTextField

Event class for events related to text field views. (Available in Mac OS X v10.3 and later.) 

Available in Mac OS X v10.3 and later.*/

enum {
   kEventClassClockView = 'cloc',
   kEventClassScrollable = 'scrl',
   kEventClassHIComboBox = 'hicb',
   kEventClassSearchField = 'srfd',
   kEventClassTextField = 'txfd'
};


/*Combo Box Data Tags

Specify constants for combo box data tags.

enum {
   kHIComboBoxListTag = 'cbls',
   kHIComboBoxListPixelWidthTag = 'cblw',
   kHIComboBoxListPixelHeightTag = 'cblh',
   kHIComboBoxNumVisibleItemsTag = 'cbni'
};
Constants
kHIComboBoxListTag

Extract the contents of the combo box list as a CFArray. The CFArray is retained; if you get the array, you own it and must release it. If you set it by calling SetControlData, the toolbox makes a copy of it, and you are free to release your reference. The reference count is bumped on get/retains on set. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kHIComboBoxListPixelWidthTag

A UInt32 containing the width of the combo box list. The width can be customized. This tag disables the autosize attribute. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kHIComboBoxListPixelHeightTag

A UInt32 containing the height of the combo box list. The height can be customized. This tag disables the autosize attribute. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
kHIComboBoxNumVisibleItemsTag

A UInt32 containing the number of visible items in the combo box list. The number can be customized. This tag disables the autosize attribute. (Available in Mac OS X v10.2 and later.)

Available in Mac OS X v10.2 and later.
Discussion

The combo box view also supports these tags previously defined for the EditUnicodeText control. These tags are available through GetControlData and SetControlData with a ControlPartCode of kHIComboBoxEditTextPart:
kControlFontStyleTag
kControlEditTextFixedTextTag
kControlEditTextTextTag
kControlEditTextKeyFilterTag
kControlEditTextValidationProcTag
kControlEditUnicodeTextPostUpdateProcTag
kControlEditTextSelectionTag
kControlEditTextKeyScriptBehaviorTag
kControlEditTextCharCount
kControlEditTextCFStringTag
Availability
Available in Mac OS X v10.2 and later.*/
enum {
   kHIComboBoxListTag = 'cbls',
   kHIComboBoxListPixelWidthTag = 'cblw',
   kHIComboBoxListPixelHeightTag = 'cblh',
   kHIComboBoxNumVisibleItemsTag = 'cbni'
};

/*Combo Box Part Constants

Specify constants for combo box part codes.

enum {
   kHIComboBoxEditTextPart = 5,
   kHIComboBoxDisclosurePart = 28
};
Constants
kHIComboBoxEditTextPart

Edit text part.

Available in Mac OS X v10.2 and later.
kHIComboBoxDisclosurePart

Disclosure part.

Available in Mac OS X v10.2 and later.
Discussion

Combo box part code constants are used when calling HIViewSetHilite, HIViewCopyShape and are returned by HIViewRegionChanged, HIViewGetFocusPart. They are also used by the hit testing functions, HIViewSimulateClick and HIViewGetPartHit.*/
enum {
   kHIComboBoxEditTextPart = 5,
   kHIComboBoxDisclosurePart = 28
};

/*Mouse Tracking Area Event Constants

Specify constants for mouse tracking area events (kEventClassControl).

enum {
   kEventControlTrackingAreaEntered = 23,
   kEventControlTrackingAreaExited = 24,
   kEventParamHIViewTrackingArea = 'ctra',
   typeHIViewTrackingAreaRef = 'ctra'
};
Constants
kEventControlTrackingAreaEntered

If you installed a mouse tracking area in your view, you will receive this event when the mouse enters that area. The tracking area reference is sent with the event. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
kEventControlTrackingAreaExited

If you installed a mouse tracking area in your view, you will receive this event when the mouse leaves that area. The tracking area reference is sent with the event. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
kEventParamHIViewTrackingArea

An HIViewTrackingAreaRef for the tracking area that was entered.

Available in Mac OS X v10.4 and later.
Discussion

Table 3 shows the event parameters associated with these events.
Table 3  Parameter names and types for mouse tracking area events
Event kind	
Parameter name	
Parameter type

kEventControlTrackingAreaEntered	
kEventParamHIViewTrackingArea	
typeHIViewTrackingAreaRef

	
kEventParamKeyModifiers	
typeUInt32

	
kEventParamMouseLocation	
typeHIPoint

kEventControlTrackingAreaExited	
kEventParamHIViewTrackingArea	
typeHIViewTrackingAreaRef

	
kEventParamKeyModifiers	
typeUInt32

	
kEventParamMouseLocation	
typeHIPoint*/

enum {
   kEventControlTrackingAreaEntered = 23,
   kEventControlTrackingAreaExited = 24,
   kEventParamHIViewTrackingArea = 'ctra',
   typeHIViewTrackingAreaRef = 'ctra'
};

/*HIViewTrackingAreaID

Define an HIView tracking area ID.

typedef UInt64 HIViewTrackingAreaID;
Availability
Available in Mac OS X v10.4 and later.*/
typedef UInt64 HIViewTrackingAreaID;

/*HIViewTrackingAreaRef

Define an HIView tracking area reference.

typedef struct OpaqueHIViewTrackingAreaRef HIViewTrackingAreaRef;
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct OpaqueHIViewTrackingAreaRef HIViewTrackingAreaRef;

/*Class ID Constants

Specify class identifiers for view-related subclasses of HIObject.

#define kHIViewClassID              CFSTR("com.apple.hiview")
#define kHIGrowBoxViewClassID       CFSTR("com.apple.higrowboxview")
#define kHIImageViewClassID         CFSTR("com.apple.HIImageView")
#define kHIMenuViewClassID          CFSTR("com.apple.HIMenuView")
#define kHIStandardMenuViewClassID  CFSTR("com.apple.HIStandardMenuView")
#define kHISegmentedViewClassID     CFSTR("com.apple.HISegmentedView")
#define kHIScrollViewClassID        CFSTR("com.apple.HIScrollView")
#define kHIComboBoxClassID          CFSTR("com.apple.HIComboBox")
#define kHISearchFieldClassID       CFSTR("com.apple.HISearchField")
Constants
kHIViewClassID

Class identifier for the HIView class.
kHIGrowBoxViewClassID

Class identifier for the HIGrowBoxView class.
kHIImageViewClassID

Class identifier for the HIImageView class.
kHIMenuViewClassID

Class identifier for the HIMenuView class.
kHIStandardMenuViewClassID

Class identifier for the HIStandardMenuView class.
kHISegmentedViewClassID

Class identifier for the HISegmentedView class.
kHIScrollViewClassID

Class identifier for the HIScrollView class.

Available in Mac OS X v10.3 and later.
kHIComboBoxClassID

Class identifier for the HIComboBox class.

Available in Mac OS X v10.3 and later.
kHISearchFieldClassID

Class identifier for the HISearchField class.

Available in Mac OS X v10.3 and later.*/
#define kHIViewClassID              CFSTR("com.apple.hiview")
#define kHIGrowBoxViewClassID       CFSTR("com.apple.higrowboxview")
#define kHIImageViewClassID         CFSTR("com.apple.HIImageView")
#define kHIMenuViewClassID          CFSTR("com.apple.HIMenuView")
#define kHIStandardMenuViewClassID  CFSTR("com.apple.HIStandardMenuView")
#define kHISegmentedViewClassID     CFSTR("com.apple.HISegmentedView")
#define kHIScrollViewClassID        CFSTR("com.apple.HIScrollView")
#define kHIComboBoxClassID          CFSTR("com.apple.HIComboBox")
#define kHISearchFieldClassID       CFSTR("com.apple.HISearchField")

/*HIViewID

Defines the HIView ID.

typedef ControlID HIViewID;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlID HIViewID;

/*HIViewPartCode Constants

Specify view parts constants.

enum {
   kHIViewNoPart = 0,
   kHIViewIndicatorPart = 129,
   kHIViewDisabledPart = 254,
   kHIViewInactivePart = 255,
   kHIViewEntireView = kHIViewNoPart
};
typedef ControlPartCode HIViewPartCode;
Constants
kHIViewNoPart

The entire view; used when not referring to a specific part.

Available in Mac OS X v10.4 and later.
kHIViewIndicatorPart

Indicator part.

Available in Mac OS X v10.4 and later.
kHIViewDisabledPart

Disabled part.

Available in Mac OS X v10.4 and later.
kHIViewInactivePart

Inactive part.

Available in Mac OS X v10.4 and later.
kHIViewEntireView

The entire view; used when not referring to a specific part.

Available in Mac OS X v10.4 and later.
Discussion

These constants are used when calling HIViewSetHilite, HIViewRegionChanged, HIViewCopyShape, HIViewSimulateClick, HIViewGetPartHit, and HIViewGetFocusPart. These constants are also used with various kEventClassControl Carbon events.*/
enum {
   kHIViewNoPart = 0,
   kHIViewIndicatorPart = 129,
   kHIViewDisabledPart = 254,
   kHIViewInactivePart = 255,
   kHIViewEntireView = kHIViewNoPart
};
typedef ControlPartCode HIViewPartCode;


/*Standard View Constants

Specify IDs of views that are commonly used. 

   
const HIViewID kHIViewWindowContentID;
const HIViewID kHIViewWindowGrowBoxID;
const HIViewID kHIViewMenuContentID;
Constants
kHIViewWindowContentID

The standard view ID for the content view of a window.

Available in Mac OS X v10.2 and later.
kHIViewWindowGrowBoxID

The standard view ID for the grow box view of a window. Not all windows have grow boxes, so you might not find this view if you look for it.

Available in Mac OS X v10.2 and later.
kHIViewMenuContentID

The standard view ID for the content view of a menu. The Menu Manager assigns this view ID to all menu content views.

Available in Mac OS X v10.3 and later.*/
const HIViewID kHIViewWindowContentID;
const HIViewID kHIViewWindowGrowBoxID;
const HIViewID kHIViewMenuContentID;

/*HILayoutInfoVersion Constant

Specify version 0 of the HILayoutInfo structure

enum {
   kHILayoutInfoVersionZero = 0
};
Constants
kHILayoutInfoVersionZero

The version of the HILayoutInfo structure is 0.

Available in Mac OS X v10.3 and later.*/
enum {
   kHILayoutInfoVersionZero = 0
};

/*HIViewRef

Define an HIView reference.

typedef ControlRef HIViewRef;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlRef HIViewRef;

/*HIPositionKind Constants

Specify position constants used by the HIView layout engine.

enum {
   kHILayoutPositionNone = 0,
   kHILayoutPositionCenter = 1,
   kHILayoutPositionMin = 2,
   kHILayoutPositionMax = 3,
   kHILayoutPositionLeft = kHILayoutPositionMin,
   kHILayoutPositionRight = kHILayoutPositionMax,
   kHILayoutPositionTop = kHILayoutPositionMin,
   kHILayoutPositionBottom = kHILayoutPositionMax
};
typedef UInt16 HIPositionKind;
Constants
kHILayoutPositionNone

No positioning is to occur.

Available in Mac OS X v10.3 and later.
kHILayoutPositionCenter

Bind to the center.

Available in Mac OS X v10.3 and later.
kHILayoutPositionMin

Bind to the minimum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutPositionMax

Bind to the maximum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutPositionLeft

Synonym for kHILayoutPositionMin.

Available in Mac OS X v10.3 and later.
kHILayoutPositionRight

Synonym for kHILayoutPositionMax.

Available in Mac OS X v10.3 and later.
kHILayoutPositionTop

Synonym for kHILayoutPositiondMin.

Available in Mac OS X v10.3 and later.
kHILayoutPositionBottom

Synonym for kHILayoutPositionMax.

Available in Mac OS X v10.3 and later.*/
enum {
   kHILayoutPositionNone = 0,
   kHILayoutPositionCenter = 1,
   kHILayoutPositionMin = 2,
   kHILayoutPositionMax = 3,
   kHILayoutPositionLeft = kHILayoutPositionMin,
   kHILayoutPositionRight = kHILayoutPositionMax,
   kHILayoutPositionTop = kHILayoutPositionMin,
   kHILayoutPositionBottom = kHILayoutPositionMax
};
typedef UInt16 HIPositionKind;

/*HIAxisPosition

An axial position description for an HIView.

struct HIAxisPosition {
   HIViewRef toView;
   HIPositionKind kind;
   float offset;
};
Fields
toView

An HIViewRef to the view relative to which a view positioned. This field can be NULL, which indicates that the axis is positioned relative to its parent’s view.
kind

The type of positioning. For possible values, see HIPositionKind Constants.
offset

After the position kind has been applied, the origin component that corresponds to the positioning axis is offset by this value. For example, left aligned + 10.*/
struct HIAxisPosition {
   HIViewRef toView;
   HIPositionKind kind;
   float offset;
};
typedef struct HIAxisPosition HIAxisPosition;

/*HIPositioning

A positioning description for an HIView.

struct HIPositioning {
   HIAxisPosition x;
   HIAxisPosition y;
};
Fields
x

The X axis.
y

The Y axis.*/

struct HIPositioning {
   HIAxisPosition x;
   HIAxisPosition y;
};
typedef struct HIPositioning HIPositioning ;

/*HIScaleKind Constant

Specify a constant that indicates the scale is determined from the axis size.

enum {
   kHILayoutScaleAbsolute = 0
};
typedef UInt16 HIScaleKind;
Constants
kHILayoutScaleAbsolute

Indicates that the scale is determined from the axis size.

Available in Mac OS X v10.3 and later.
Discussion

This constant is used in conjunction with the HIView layout engine.*/
enum {
   kHILayoutScaleAbsolute = 0
};
typedef UInt16 HIScaleKind;


/*HIAxisScale

Represents a scale description for an axis of a view. 

struct HIAxisScale {
   HIViewRef toView;
   HIScaleKind kind;
   float ratio;
};
Fields
toView

An HIViewRef to the view to which this axis is scaled. This field can be NULL, which indicates that the axis is scaled relative to its parent’s view.
kind

The type of scaling. Currently, this field must be kHILayoutScaleAbsolute.
ratio

A value that indicates how much to scale the view. Zero indicates no scaling. A value of one indicates that the view is to always have the same axial size.*/
struct HIAxisScale {
   HIViewRef toView;
   HIScaleKind kind;
   float ratio;
};
typedef struct HIAxisScale HIAxisScale;

/*HIViewID

Defines the HIView ID.

typedef ControlID HIViewID;
Availability
Available in Mac OS X v10.2 and later.*/
typedef ControlID HIViewID;



/*HILayout Binding Kind Constants

Specify binding constants used by the HIView layout engine.

enum {
kHILayoutBindNone = 0,
kHILayoutBindMin = 1,
kHILayoutBindMax= 2,
kHILayoutBindLeft = kHILayoutBindMin,
kHILayoutBindRight = kHILayoutBindMax,
kHILayoutBindTop = kHILayoutBindMin,
kHILayoutBindBottom = kHILayoutBindMax
};
typedef UInt16 HIBindingKind;
Constants
kHILayoutBindNone

No binding is to occur.

Available in Mac OS X v10.3 and later.
kHILayoutBindMin

Bind to the minimum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutBindMax

Bind to the maximum of the axis.

Available in Mac OS X v10.3 and later.
kHILayoutBindLeft

Synonym for kHILayoutBindMin.

Available in Mac OS X v10.3 and later.
kHILayoutBindRight

Synonym for kHILayoutBindMax.

Available in Mac OS X v10.3 and later.
kHILayoutBindTop

Synonym for kHILayoutBindMin.

Available in Mac OS X v10.3 and later.
kHILayoutBindBottom

Synonym for kHILayoutBindMax.

Available in Mac OS X v10.3 and later.
Discussion

Mac OS X v10.3 provides a layout engine for HIViews that allows applications to specify the layout relationships between multiple views. When necessary, the layout engine automatically repositions and resizes views that have layout information. For more information on how to use the layout engine, see HIViewSetLayoutInfo.

Horizontal and vertical bindings are very similar in application, but along different axes, so the binding kinds have been abstracted to minimum and maximum. Synonyms are provided for convenience, and you are encouraged to use them.
Availability
Available in Mac OS X v10.3 and later.*/
enum {
kHILayoutBindNone = 0,
kHILayoutBindMin = 1,
kHILayoutBindMax= 2,
kHILayoutBindLeft = kHILayoutBindMin,
kHILayoutBindRight = kHILayoutBindMax,
kHILayoutBindTop = kHILayoutBindMin,
kHILayoutBindBottom = kHILayoutBindMax
};
typedef UInt16 HIBindingKind;

/*HIScaling

A set of scaling descriptions for the axes of a view.

struct HIScaling {
   HIAxisScale x;
   HIAxisScale y;
};
Fields
x

The horizontal scaling for a view.
x

The vertical scaling for a view.*/
struct HIScaling {
   HIAxisScale x;
   HIAxisScale y;
};
typedef struct HIScaling  HIScaling ;

/*HISideBinding

Structure for storing the binding for the side of a view. 

struct HISideBinding {
   HIViewRef toView;
   HIBindingKind kind;
   float offset;
};
Fields
toView

An HIViewRef to the view to which this side is bound. This field can be NULL, which indicates that the side is bound to its parent view.
kind

The bind kind. For possible values, see HILayout Binding Kind Constants.
offset

Reserved; must be set to zero.
Discussion

The layout engine can automatically reposition and resize views for which relationships have been set up. (Call HIViewSetLayoutInfo to establish these relationships.) A side binding is entirely related to the change of the parent’s position or size but only as the size affects the maximum edge position. A side binding doesn’t mean “move to where my relative’s side is” but rather “move as my relative’s side has moved.”*/
struct HISideBinding {
   HIViewRef toView;
   HIBindingKind kind;
   float offset;
};

typedef  struct HISideBinding  HISideBinding ;

/*HIBinding

Represents a set of top, left, bottom, and right bindings for an view. 

struct HIBinding {
   HISideBinding top;
   HISideBinding left;
   HISideBinding bottom;
   HISideBinding right;
};
Fields
top

The top side bindings.
left

The left side bindings.
bottom

The bottom side bindings.
right

The right side bindings.
Discussion

These constants are used in conjunction with the HIView layout engine.*/
struct HIBinding {
   HISideBinding top;
   HISideBinding left;
   HISideBinding bottom;
   HISideBinding right;
};
typedef struct HIBinding HIBinding;

/*HILayoutInfo

Structure that stores the layout of an HIView.

struct HILayoutInfo {
   UInt32 version;
   HIBinding binding;
   HIScaling scale;
   HIPositioning position;
};
Fields
version

The version of this structure. The current version is kHILayoutInfoVersionZero.
binding

An HIBinding structure describing the bindings to apply to the sides of an HIView.
scale

An HIScaling structure describing the axial scaling to apply to an HIView.
position

An HIPositioning structure describing the positioning to apply to an HIView.
Discussion

This structure is provided as a parameter to HIViewGetLayoutInfo and HIViewSetLayoutInfo.*/
struct HILayoutInfo {
   UInt32 version;
   HIBinding binding;
   HIScaling scale;
   HIPositioning position;
};
typedef struct HILayoutInfo  HILayoutInfo ;


/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);

/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A view’s top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);

/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);

/*HIViewAddSubview

Adds a subview to the given parent view.

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);
Parameters
inParent

The view that will receive the new subview.
inNewChild

The subview being added.
Return Value

An operating system result code. The result code errNeedsCompositedWindow is returned if you try to embed into the content view in a non-compositing window; you can only embed into the content view in a compositing window.
Discussion

The new subview is added to the front of the list of subviews (that is, it is made topmost). The subview being added is not retained by the new parent view. Do not release the view after adding it, or it will cease to exist. All views in a window are released automatically when the window is destroyed.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);

/*HIViewSetLayoutInfo

Sets the layout information of an HIView. 

OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);
Parameters
inView

The view whose layout information is to be set.
inLayoutInfo

A pointer to an HILayoutInfo structure containing the layout values that are to be set.
Return Value

An operating system result code.
Discussion

Layouts are used to automatically change the size and positioning of a view when another view changes size or position. Layout changes only take effect in two cases:
When HIViewApplyLayout is called after the view’s layout has been set by calling HIViewSetLayoutInfo. The HIViewApplyLayout function is most useful when first applying a scaling or positioning layout to a view in order to set up the view’s initial position and size relative to the view referenced in the layout.
When the related view changes its size or position.

A layout allows a view’s size or position to be modified in three ways: side binding, axial scaling, and axial positioning. In the following examples, View A initially has a left side of 100 and a right side of 150, and is placed inside a parent view that has a width of 275.
Bindings — Setting up a binding relationship between two views specifies that one edge of a view is to change by an amount equal to the change in an edge of another view. If View A has a right-side binding to its parent’s maximum (or right) side, when the parent’s right side changes, View A’s right side changes by the same amount. If the parent view resizes to be 325 units wide (50 units wider than before), View A is resized so that its left side changes to 150 units and its right side changes to 200, which is 50 units more to the right than before. You can think of bindings as a way to maintain distance. An edge bound to another view’s edge always maintains its offset from that related edge. In other view systems, this concept is often referred to as “springs and rods.” Note that a binding does not cause one side of the view to exactly align with the side of another view; a binding merely causes one side of the view to change by the same amount as another view changes. To align one edge of a view to another view’s edge, use positioning. Bindings depend on changes in size or position of the related view. As a result, calling HIViewApplyLayout does not activate side bindings, as no changes have occurred. Bindings are implemented using the HIBinding structure and one HISideBinding structure per view edge.
Scaling — Setting up a scaling relationship between two views specifies that the axial size (that is, the width or height) of a view is to be a specified ratio of the size of another view when that other view moves or resizes. If View A has an x-axis scaling for its parent view with a ratio of 0.8, when the parent view’s width changes, View A’s width changes to be the parent’s width multiplied by 0.8. If the parent view resizes to be 325 units wide, View A resizes so that its left side stays at 100 and its right side changes to 360 (100 + 325 * 0.8). Note that when a scaling layout is first set up on a view with HIViewSetLayoutInfo, no scaling is applied to the view because scaling only occurs when the related view resizes. If scaling is required at initial setup, call HIViewSetLayoutInfo and then HIViewApplyLayout. Scaling is implemented using the HIScaling structure and one HIAxisScale structure per view axis.
Positioning — Setting up a positioning relationship between two views specifies that the axial position (i.e., vertical or horizontal) of a view is to change so that the view aligns with the minimum, maximum, or center of another view when that other view resizes. If View A has an x-axis position with its parent view with center positioning specified, when the parent view changes size, View A moves so that it is centered horizontally relative to its parent. If the parent view resizes to be 300 units wide, View A repositions so that its left side is at 125 and its right side is at 175, centered in the parent view. Positioning is implemented using the HIPositioning structure and one HIAxisPosition per view axis.

The HIView layout engine applies transformations to a view sequentially. First, bindings are applied. Then scaling is applied, which could override some of the previously applied bindings. Then positioning is applied, which could also override some of the previously applied bindings. The bindings are applied recursively to a container’s subviews, which requires care on your part to avoid infinite recursion, especially when applying inter-relational bindings. For example, if View A’s x axis is scaled relative to View B and View B’s x-axis is scaled to View A, your application could hang when the layouts are applied because View A would affect View B, which would affect View A, and so on.

For more information on using the layout engine, see HIView Programming Guide.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);

/*HIViewSetVisible

Hides or shows a view. 

OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);
Parameters
inView

The view to hide or show.
inVisible

A Boolean value that indicates whether you want to hide the view (false) or show the view (true).
Return Value

An operating system result code.
Discussion

Marks the area the view will occupy or previously occupied as needing to be redrawn later. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);

/*HIViewGetLastSubview

Returns the last subview in a parent view.

HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the last subview of a container. The last subview is the bottommost subview in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);

/*HIViewGetPreviousView

Returns the view above the specified view.

HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view in front of it or is invalid.
Discussion

Returns the view before the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);

/*HIViewSetText

Sets the text of a view to the specified string.

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
);
Parameters
inView

The view whose text is to be set.
inText

The text that is to be set.
Return Value

An operating system result code.
Discussion

This function attempts to set the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag SetControlData tag. If this function can’t set that text, it sets the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
);

/*HIViewSetID

Sets the HIViewID of a view.

OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
);
Parameters
inView

The view whose HIViewID is to be set.
inID

The HIViewID to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
);

/*HIViewGetValue

Obtains the value of a view.

SInt32 HIViewGetValue (
HIViewRef inView
);
Parameters
inView

The view whose value is to be obtained.
Return Value

The view’s value.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetValue (
HIViewRef inView
);

/*HIViewSetHilite

Sets highlighting on a view.

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
);
Parameters
inView

The view for which highlighting is to be set.
inHilitePart

The part of the view whose highlighting is to be set. For possible values, see “HIViewPartCode Constants”.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
);

/*HIViewSetValue

Sets the value of a view.

OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
);
Parameters
inView

The view whose value is to be set.
inValue

The value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
);

/*HIViewSetMaximum

Sets a view’s maximum value.

OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
);
Parameters
inView

The view whose maximum value is to be set.
inView

The maximum value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
);

/*HIViewSetViewSize

Sets the view size of a view.

OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
);
Parameters
inView

The view whose view size is to be set.
inViewSize

The view size that is to be set.
Return Value

An operating system result code.
Discussion

The view size is the size of the content to which a view’s display is proportioned. The view size is commonly used to set the proportional size of a scroll bar’s thumb indicator.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
);

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewSetMinimum (
HIViewRef inView
);

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/

SInt32 HIViewGetMinimum (
HIViewRef inView
);

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewGet Maximum(
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetMaximum (
HIViewRef inView
);

/*HIViewGetSuperview

Returns a view’s parent view.

HIViewRef HIViewGetSuperview (
   HIViewRef inView
);
Parameters
inView

The view whose parent you are interested in getting.
Return Value

An HIView reference, or NULL if this view has no parent or is invalid.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetSuperview (
   HIViewRef inView
);

/*HIViewConvertRect

Converts a rectangle from one view to another. 

OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioRect

The rectangle to convert. 
inSourceView

The view whose coordinate system ioRect is starting out in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
inDestView

The view whose coordinate system ioRect should end up in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
);

/*HIViewDrawCGImage

Draws a Core Graphics image appropriately for a view.

OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
);
Parameters
inContext

The context to draw in.
inBounds

The bounds to draw the image into.
inImage

The image to draw.
Return Value

An operating system status code.
Discussion

This function is similar to CGContextDrawImage, but it flips the context so that the image is drawn correctly. The origin of a view is at the top left corner, so you are really drawing upside-down. This call insulates you from that fact.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
);

/*HIImageViewSetImage

Sets the image to display in an image view.

OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
);
Parameters
inView

The image view to affect.
inImage

The image to set.
Return Value

An operating system status code.
Discussion

The image passed in is retained by the view, so you may release the image after calling this function if you no longer need to reference it.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
);

/*HIImageViewSetOpaque

Sets the opacity of an image view.

OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
);
Parameters
inView

The image view to set.
inOpaque

A Boolean whose value is true to make the image view opaque or false to disable the opacity setting.
Return Value

An operating system result code.
Discussion

When opacity is enabled, the image view can make certain optimizations for compositing and scrolling. The alpha-related image view APIs are rendered useless when opacity is enabled. An image view, when created, is opaque by default. You must pass false to this function in order to change the alpha, etc. or if your image does not fill the full bounds of the view.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
);

/*HIViewNewTrackingArea

Creates a new tracking area for a view.

OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
);
Parameters
inView

The view for which a new tracking area is to be created.
inShape

The shape to use. Pass NULL to use the entire structure region of the view.
inID

An identifier for the new tracking area. You can specify any value you want, or zero if you don’t want associate an identifier with the new tracking area.
outRef

On return, a pointer to the reference to the new tracking area. A count is not maintained for this reference.
Return Value

An operating system result code.
Discussion

All tracking areas attached to a view are automatically disposed of when the view is disposed of, so you don’t need to dispose of a tracking area explicitly unless you want to remove it from a view before the view is disposed of.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
);

/*HIImageViewSetAlpha

Sets the alpha value for an image view.

OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
);
Parameters
inView

The image view to affect.
inAlpha

The new alpha value. 
Return Value

An operating system result code.
Discussion

Allows you to set the alpha for an image, making it more or less transparent. An alpha of 1.0 is fully opaque, and an alpha of 0.0 is fully transparent. The default alpha for an image is 1.0. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
);

/*HIImageViewSetScaleToFit

Specifies whether an image should scale or clip to the view’s bounds.

OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
);
Parameters
inView

The image view.
inScaleToFit

A Boolean whose value is true to indicate that the image should be scaled to fit the view bounds or false to indicate that the image should clip to the view’s bounds.
Return Value

An operating system status code.
Discussion

Normally, an image view clips to the view’s bounds. Use this function to tell the image view to size the image to fit into the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
);
/*HIViewConvertPoint

Converts a point’s coordinates from one view to another.

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioPoint

The point to convert. 
inSourceView

The view whose coordinate system ioPoint is starting out in. You can pass NULL to indicate that ioPoint is a window-relative point.
inDestView

The view whose coordinate system ioPoint should end up in. You can pass NULL to indicate that ioPoint is a window-relative point.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
);

/*HIViewSetFrame

Sets the frame of a view. 

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
);
Parameters
inView

The view whose frame is to be set.
inRect

The new frame to set.
Return Value

An operating system result code.
Discussion

This function effectively moves the view within its parent. It also marks the view (and anything that was exposed behind it) to be redrawn. 
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
);


/*HiewMoveBy

Move a view by the specified distance relative to its current location. 

OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
);
Parameters
inView

The view you want to move.
inDX

The horizontal distance to move the view. Negative values move the view to the left, positive values to the right.
inDY

The vertical distance to move the view. Negative values move the view up, positive values down.
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
);

/*HIViewGetFirstSubview

Returns the first subview of a parent view. 

HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the first subview of a container. The first subview is the topmost subview in z-order. 
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
);

/*HIViewGetNextView

Returns the view behind the specified view.

HIViewRef HIViewGetNextView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view behind it or is invalid.
Discussion

Returns the view after the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetNextView (
   HIViewRef inView
);
/*HIScrollViewCreate

Creates a scroll view. 

OSStatus HIScrollViewCreate (
   OptionBits inOptions,
   HIViewRef* outView
);
Parameters
inOptions

Options for our scroll view. You must specify either a horizontal or a vertical scroll bar. If neither is passed, an error is returned. For possible values, see “Scroll View Constants”.
outView

The new scroll view. 
Return Value

An operating system result code.
Discussion

This view has three parts. It can have a horizontal scroll bar, a vertical scroll bar, and a view to be scrolled that must be added by calling HIViewAddSubview. The added scroll view integrates itself automatically and appropriately.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIScrollViewCreate (
   OptionBits inOptions,
   HIViewRef* outView
);


/*HIViewGetFrame

Obtains the frame bounds of a view. 

OSStatus HIViewGetFrame (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose frame you want to obtain.
outRect

The frame of the view.
Return Value

An operating system result code.
Discussion

The frame bounds is the bounds of a view relative to its parent’s local coordinate system. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetFrame (
   HIViewRef inView,
   HIRect* outRect
);

/*HIViewGetLayoutInfo

Obtains the layout information of an view. 

OSStatus HIViewGetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * outLayoutInfo
);
Parameters
inOptions

The view whose layout information is to be obtained.
outLayoutInfo

A pointer to an HILayoutInfo into which to copy the view’s layout information. If the version field of this structure is not valid, the call will fail.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewGetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * outLayoutInfo
);

/*HIViewPlaceInSuperviewAt

Places a view at an absolute location within its parent. 

OSStatus HIViewPlaceInSuperviewAt (
   HIViewRef inView,
   float inX,
   float inY
);
Parameters
inView

The view you want to position.
inX

The absolute horizontal coordinate at which to position the view. 
inY

The absolute vertical coordinate at which to position the view. 
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewPlaceInSuperviewAt (
   HIViewRef inView,
   float inX,
   float inY
);

/*HIViewSetNeedsDisplayInShape

Uses a shape to mark a portion of a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplayInShape (
HIViewRef inView,
HIShapeRef inArea,
Boolean inNeedsDisplay
);
Parameters
inView

The view having a shape that is to be marked as dirty (needs to be redrawn) or clean (valid and not needing to be redrawn).
inArea

The area, in view-relative coordinates, that is to be marked.
inNeedsDisplay

A Boolean whose value is true to mark the area described by inArea as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken. The area specified by inArea is intersected with the view’s visible region.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetNeedsDisplayInShape (
HIViewRef inView,
HIShapeRef inArea,
Boolean inNeedsDisplay
);

/*HIViewCopyText

Copies the text of a view.

CFStringRef HIViewCopyText (
HIViewRef inView
);
Parameters
inView

The view whose text is to be copied.
Return Value

A CFString containing a copy of the view’s text. The caller is responsible for releasing the CFString.
Discussion

This function attempts to copy the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag GetControlData tag. If this function can’t copy that text, it copies the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

CFStringRef HIViewCopyText (
HIViewRef inView
);

/*HIViewSetBoundsOrigin

Sets the origin of the view.

OSStatus HIViewSetBoundsOrigin (
   HIViewRef inView,
   float inX,
   float inY
);
Parameters
inView

The view whose origin you wish to adjust. 
inX

The X coordinate. 
inY

The Y coordinate. 
Return Value

An operating system result code.
Discussion

This effectively also moves all subcontrols of a view as well. This call will not invalidate the view, in case you might want to move the contents with HIViewScrollRect instead of redrawing the complete content.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetBoundsOrigin (
   HIViewRef inView,
   float inX,
   float inY
);

/*HIViewGetWindow

Obtains a reference to the window to which the specified view is bound.

WindowRef HIViewGetWindow (
   HIViewRef inView
);
Parameters
inView

The view to query.
Return Value

An operating system result code, or NULL if the view reference specified by inView is invalid or if the view is not bound to any window.
Availability
Available in Mac OS X v10.3 and later.*/
WindowRef HIViewGetWindow (
   HIViewRef inView
);

/*HIViewRender

Renders the invalid portions of a view.

OSStatus HIViewRender (
HIViewRef inView
);
Parameters
inView

The view that is to be rendered.
Return Value

An operating system result code.
Discussion

Normally, areas are redrawn at event loop time, but there might be times when an immediate redraw is needed. You should call this function sparingly because it does a fully composited redraw for the area of the view. That is, all other views that intersect the area of the specified view are also redrawn. Calling this function for several views at a particular level of a hierarchy would be costly, so you should only pass the root view of a window to this function.

The behavior of this function when passed a non-root view changed in Mac OS X v10.4. In Mac OS X v10.3, when called on a non-root view, this function validated all of the views in the window that intersect the specified view, including portions that did not intersect the specified view. Consequently, all of the views were not actually redrawn. In Mac OS X v10.4, when called on a non-root view, this function only validates those portions of each view that intersect the specified view.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewRender (
HIViewRef inView
);

/*HIViewGetEventTarget

Returns the EventTargetRef for the specified view.

EventTargetRef HIViewGetEventTarget (
   HIViewRef inView
);
Parameters
inImage

The view for which the EventTargetRef should be returned.
Return Value

The EventTargetRef.
Discussion

Once you obtain this reference, you can install an event handler and send events to the target.
Availability
Available in Mac OS X v10.4 and later.*/
EventTargetRef HIViewGetEventTarget (
   HIViewRef inView
);

/*HIViewRemoveFromSuperview

Removes a view from its parent.

OSStatus HIViewRemoveFromSuperview (
   HIViewRef inView
);
Parameters
inView

The view to remove.
Return Value

An operating system result code.
Discussion

The subview that is removed from the parent is not released and still exists.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewRemoveFromSuperview (
   HIViewRef inView
);

/*HIViewChangeFeatures

Changes the features of a view.

OSStatus HIViewChangeFeatures (
   HIViewRef inView,
   HIViewFeatures * inFeaturesToSet,
   HIViewFeatures inFeaturesToClear
);
Parameters
inView

The view whose features are to be changed.
inFeaturesToSet

The features that are to be set. For details, see “HIView Feature Constants”.
inFeaturesToClear

The features that are to be cleared. For details, see “HIView Feature Constants”.
Return Value

An operating system result code.
Discussion

The view itself typically controls its features. For example, the view might decide that under some situations it is opaque and in others it is transparent. In general entities outside of the view itself should not call this function. The only exception might be user-interface building tools that want to make sure a view always responds to clicks, for example, so it could override mouse tracking to drag items.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewChangeFeatures (
   HIViewRef inView,
   HIViewFeatures * inFeaturesToSet,
   HIViewFeatures inFeaturesToClear
);

#include <HYS/HIToolbox/HIView_end.h>
#ifdef __cplusplus
}
#endif

#endif