#ifndef  DRIVERGESTALT_H
#define DRIVERGESTALT_H

#ifndef  MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef  OSUTILS_H
#include <CarbonCore/OSUtils.h>
#endif

#ifndef  NAMEREGISTRY_H
#include <CarbonCore/NameRegistry.h>
#endif

#ifndef  SCSI_H
#include <OSServices/SCSI.h>
#endif



#ifndef   USB_H
#include <IOKit/usb/USB.h>
#endif

#ifndef  DISKS_H
#include <Disks.h>
#endif



#include <HYS/DriverGestalt.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Table 8-6 DriverGestalt selector four character codes and constants 
Four character code selector	
Selector constants
'boot' 	kdgBoot 
'dAPI' 	kdgAPI 
'devt' 	kdgDeviceType 
'dics ' 	kdgPhysDriveIconSuite 
'ejec ' 	kdgEject 
'flus' 	kdgFlush 
'intf' 	kdgInterface 
'lpwr' 	kdgSupportsSwitching 
'mics' 	kdgMediaIconSuite 
'mnam' 	kdgMediaName 
'pmn3' 	kdgMin3VPower 
'pmn5' 	kdgMin5VPower 
'pmx3' 	kdgMax3VPower 
'pmx5' 	kdgMax5VPower 
'psta' 	kdgInHighPower 
'psup' 	kdgSupportsPowerCtl 
'purg' 	kdgPurge 
'sync' 	kdgSync 
'vers' 	kdgVersion 
'vmop' 	kdgVMOptions 
'wide' 	kdgWide*/
enum {
	kdgBoot ='boot' ,
	kdgAPI ='dAPI' ,
	kdgDeviceType ='devt' ,
	kdgPhysDriveIconSuite= 'dics ' ,
	kdgEject ='ejec ' ,
	kdgFlush ='flus' ,
 	kdgInterface ='intf',
	kdgSupportsSwitching ='lpwr' ,
	kdgMediaIconSuite ='mics' ,
 	kdgMediaName= 'mnam',
kdgMin3VPower= 'pmn3' 	,
kdgMin5VPower ='pmn5' 	,
kdgMax3VPower= 'pmx3' 	,
	kdgMax5VPower ='pmx5' ,
	kdgInHighPower ='psta' ,
	kdgSupportsPowerCtl= 'psup' ,
kdgPurge ='purg' 	,
kdgSync= 'sync' 	,
	kdgVersion ='vers' ,
 	kdgVMOptions ='vmop',
	kdgWide ='wide' 
};

/*The following response buffers are defined for some of the driver gestalt selectors listed in Table 8-5 :
struct DriverGestaltSyncResponse
{
    Boolean behavesSynchronously;
    UInt8       pad[3]
}; 
struct DriverGestaltBootResponse
{
    UInt8 extDev;                       / packed target (upper 5 bits)
                                             LUN (lower 3 bits) /
    UInt8 partition;                    / partition /
    UInt8 SIMSlot;                      / slot /
    UInt8 SIMsRSRC;                     / sRsrcID /
}; 
struct DriverGestaltDevTResponse
{
    OSType deviceType;
};
enum {
    kdgDiskType             = 'disk',   / standard r/w disk drive /
    kdgTapeType             = 'tape',   / tape drive /
    kdgPrinterType          = 'prnt',   / printer /
    kdgProcessorType        = 'proc',   / processor /
    kdgWormType             = 'worm',   / write-once /
    kdgCDType               = 'cdrm',   / cd-rom drive /
    kdgFloppyType           = 'flop',   / floppy disk drive /
    kdgScannerType          = 'scan',   / scanner /
    kdgFileType             = 'file',   / logical partition based on a
                                            file (drive Container) /
    kdgRemovableType        = 'rdsk'    / removable media hard disk /
}; 
struct DriverGestaltIntfResponse
{
    OSType interfaceType;
};
enum {
    kdgScsiIntf             = 'scsi', / SCSI interface /
    kdgPcmciaIntf           = 'pcmc', / PCMCIA interface /
    kdgATAIntf              = 'ata ', / ATA/ATAPI interface /
    kdgFireWireIntf         = 'fire', / FireWire 1394 interface /
    kdgExtBus               = 'card' / Card Bus interface /
}; 
struct DriverGestaltAPIResponse 
{
    short               partitionCmds;  / if bit 0 is nonzero, /
                                        / supports partition /
                                        / control and status calls /
                    / prohibitMounting (control, kProhibitMounting) /
                    / partitionToVRef (status, kGetPartitionStatus) /
                    / getPartitionInfo (status, kGetPartInfo) /
    short                   unused1;        / All the unused fields /
                                            / should be zero /
    short                   unused2;
    short                   unused3;
    short                   unused4;
    short                   unused5;
    short                   unused6;
    short                   unused7;
    short                   unused8;
    short                   unused9;
    short                   unused10;
}; 
struct DriverGestaltPowerResponse {
    unsigned long       powerValue;     / Power consumed in Watts /
}; 
struct DriverGestaltFlushResponse 
{
    Boolean             canFlush;       / Return true if driver /
                                        /  supports the kdcFlush /
                                        / driver configure _Control /
                                        / call /
    Boolean             needsFlush;     / Return true if /
                                        / driver/device has /
                                        / data cached /
                                        / and needs to be flushed 
                                        / when the disk volume /
                                        / is flushed by the /
                                        / File Manager /
    UInt8               pad[2];
}; 
/ Flags for purge permissions /
enum {
    kbCloseOk               = 0,            / Ok to call Close /
    kbRemoveOk              = 1,            / Ok to call RemoveDrvr /
    kbPurgeOk               = 2,            / Ok to call DisposePtr /
    kmNoCloseNoPurge        = 0,
    kmOkCloseNoPurge        = (1 << kbCloseOk) + (1 << kbRemoveOk),
    kmOkCloseOkPurge        = (1 << kbCloseOk) + (1 << kbRemoveOk) + (1 << 
kbPurgeOk)
}; 
struct DriverGestaltPurgeResponse 
{
    UInt16          purgePermission;    / 0 = Do not change /
                                        / the state of the driver /
                                        / 3 = Do Close() and /
                                        / DrvrRemove() this driver /
                                            / but don't deallocate /
                                            / driver code /
                                            / 7 = Do Close(), /
                                            / DrvrRemove(), and /
                                            / DisposePtr() /
    UInt16          purgeReserved;
    Ptr             purgeDriverPointer;/ pointer to the start of /
                                            / the driver block (valid /
                                            / only if DisposePtr /
                                            / permission is given /
}; 
struct DriverGestaltEjectResponse {
    UInt32                  ejectFeatures;      / Features field /
}; 
/ Flags for Ejection Features field /
enum {
    kRestartDontEject           = 0,            / Dont Want eject /
                                                / during Restart /
    kShutDownDontEject          = 1,            / Dont Want eject /
                                                / during Shutdown /
    kRestartDontEject_Mask          = 1 << kRestartDontEject,
    kShutDownDontEject_Mask         = 1 << kShutDownDontEject
}; 
struct DriverGestaltWideResponse
{
    Boolean supportsWide;
};*/

struct DriverGestaltSyncResponse
{
    Boolean behavesSynchronously;
    UInt8       pad[3]
}; 
typedef struct DriverGestaltSyncResponse DriverGestaltSyncResponse;

struct DriverGestaltBootResponse
{
    UInt8 extDev;                       /* packed target (upper 5 bits)
                                             LUN (lower 3 bits) */
    UInt8 partition;                    /* partition */
    UInt8 SIMSlot;                      /* slot */
    UInt8 SIMsRSRC;                     /* sRsrcID */
}; 
struct DriverGestaltDevTResponse
{
    OSType deviceType;
};
enum {
    kdgDiskType             = 'disk',   /* standard r/w disk drive */
    kdgTapeType             = 'tape',   /* tape drive */
    kdgPrinterType          = 'prnt',   /* printer */
    kdgProcessorType        = 'proc',   /* processor */
    kdgWormType             = 'worm',   /* write-once */
    kdgCDType               = 'cdrm',   /* cd-rom drive */
    kdgFloppyType           = 'flop',   /* floppy disk drive */
    kdgScannerType          = 'scan',   /* scanner */
    kdgFileType             = 'file',   /* logical partition based on a
                                            file (drive Container) */
    kdgRemovableType        = 'rdsk'    /* removable media hard disk */
}; 
struct DriverGestaltIntfResponse
{
    OSType interfaceType;
};
enum {
    kdgScsiIntf             = 'scsi', /* SCSI interface */
    kdgPcmciaIntf           = 'pcmc', /* PCMCIA interface */
    kdgATAIntf              = 'ata ', /* ATA/ATAPI interface */
    kdgFireWireIntf         = 'fire', /* FireWire 1394 interface */
    kdgExtBus               = 'card' /* Card Bus interface */
}; 
struct DriverGestaltAPIResponse 
{
    short               partitionCmds;  /* if bit 0 is nonzero, */
                                        /* supports partition */
                                        /* control and status calls */
                    /* prohibitMounting (control, kProhibitMounting) */
                    /* partitionToVRef (status, kGetPartitionStatus) */
                    /* getPartitionInfo (status, kGetPartInfo) */
    short                   unused1;        /* All the unused fields */
                                            /* should be zero */
    short                   unused2;
    short                   unused3;
    short                   unused4;
    short                   unused5;
    short                   unused6;
    short                   unused7;
    short                   unused8;
    short                   unused9;
    short                   unused10;
}; 
struct DriverGestaltPowerResponse {
    unsigned long       powerValue;     /* Power consumed in Watts */
}; 
struct DriverGestaltFlushResponse 
{
    Boolean             canFlush;       /* Return true if driver */
                                        /*  supports the kdcFlush */
                                        /* driver configure _Control */
                                        /* call */
    Boolean             needsFlush;     /* Return true if */
                                        /* driver/device has */
                                        /* data cached */
                                        /* and needs to be flushed *
                                        /* when the disk volume */
                                        /* is flushed by the */
                                        /* File Manager */
    UInt8               pad[2];
}; 
/* Flags for purge permissions */
enum {
    kbCloseOk               = 0,            /* Ok to call Close */
    kbRemoveOk              = 1,            /* Ok to call RemoveDrvr */
    kbPurgeOk               = 2,            /* Ok to call DisposePtr */
    kmNoCloseNoPurge        = 0,
    kmOkCloseNoPurge        = (1 << kbCloseOk) + (1 << kbRemoveOk),
    kmOkCloseOkPurge        = (1 << kbCloseOk) + (1 << kbRemoveOk) + (1 << 
kbPurgeOk)
}; 
struct DriverGestaltPurgeResponse 
{
    UInt16          purgePermission;    /* 0 = Do not change */
                                        /* the state of the driver */
                                        /* 3 = Do Close() and */
                                        /* DrvrRemove() this driver */
                                            /* but don't deallocate */
                                            /* driver code */
                                            /* 7 = Do Close(), */
                                            /* DrvrRemove(), and */
                                            /* DisposePtr() */
    UInt16          purgeReserved;
    Ptr             purgeDriverPointer;/* pointer to the start of */
                                            /* the driver block (valid */
                                            /* only if DisposePtr */
                                            /* permission is given */
}; 
struct DriverGestaltEjectResponse {
    UInt32                  ejectFeatures;      /* Features field */
}; 
/* Flags for Ejection Features field */
enum {
    kRestartDontEject           = 0,            /* Dont Want eject */
                                                /* during Restart */
    kShutDownDontEject          = 1,            /* Dont Want eject */
                                                /* during Shutdown */
    kRestartDontEject_Mask          = 1 << kRestartDontEject,
    kShutDownDontEject_Mask         = 1 << kShutDownDontEject
}; 
struct DriverGestaltWideResponse
{
    Boolean supportsWide;
};

#ifdef __cplusplus
}
#endif

#endif 

