

#ifndef DRCOREERRORS_H
#define DRCOREERRORS_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DiscRecording Errors

enum { 
    kDRFirstErr = 0x80020000, 
    kDRInternalErr = kDRFirstErr,  
    kDRDeviceAccessErr = 0x80020020, 
    kDRDeviceBusyErr = 0x80020021, 
    kDRDeviceCommunicationErr = 0x80020022, 
    kDRDeviceInvalidErr = 0x80020023, 
    kDRDeviceNotReadyErr = 0x80020024, 
    kDRDeviceNotSupportedErr = 0x80020025,  
    kDRMediaBusyErr = 0x80020040, 
    kDRMediaNotPresentErr = 0x80020041, 
    kDRMediaNotWritableErr = 0x80020042, 
    kDRMediaNotSupportedErr = 0x80020043, 
    kDRMediaNotBlankErr = 0x80020044, 
    kDRMediaNotErasableErr = 0x80020045,  
    kDRBurnUnderrunErr = 0x80020060, 
    kDRBurnNotAllowedErr = 0x80020061, 
    kDRDataProductionErr = 0x80020062, 
    kDRVerificationFailedErr = 0x80020063, 
    kDRTooManyTracksForDVDErr = 0x80020064, 
    kDRBadLayoutErr = 0x80020065, 
    kDRUserCanceledErr = 0x80020066, 
    kDRFunctionNotSupportedErr = 0x80020067, 
    kDRTrackReusedErr = 0x8002006F,  
    // content errors //
    kDRFileModifiedDuringBurnErr = 0x80020100, 
    kDRFileLocationConflictErr = 0x80020101, 
    kDRTooManyNameConflictsErr = 0x80020102, 
    kDRDeviceCantWriteCDTextErr = 0x80020201,  
    // drive feature errors //
    kDRDeviceBurnStrategyNotAvailableErr = 0x80020200, 
    kDRDeviceCantWriteIndexPointsErr = 0x80020202, 
    kDRDeviceCantWriteISRCErr = 0x80020203, 
    kDRDeviceCantWriteSCMSErr = 0x80020204, 
    kDRDevicePreGapLengthNotValidErr = 0x80020205 
};  
Constants
kDRInternalErr
Internal Disc Recording error.
kDRDeviceAccessErr
Device is not accessible, hardware is disconnected, etc.
kDRDeviceBusyErr
Device is in use by another process
kDRDeviceCommunicationErr
Device failed to respond properly, unable to recover or retry.
kDRDeviceInvalidErr
Attempt was made to use an invalid DRDeviceRef.
kDRDeviceNotReadyErr
Device is unable to respond now, please try again later.
kDRDeviceNotSupportedErr
Device is not supported for the requested burn operation.
kDRMediaBusyErr
Disc is busy, usually indicating the volume is unmountable.
kDRMediaNotPresentErr
Disc isn't present, and needs to be.
kDRMediaNotWritableErr
Disc isn't writable, and needs to be.
kDRMediaNotSupportedErr
Disc isn't supported for the requested burn operation.
kDRMediaNotBlankErr
Disc isn't blank, and the requested operation needs it to be.
kDRMediaNotErasableErr
Disc isn't erasable, and the requested operation needs it to be.
kDRBurnUnderrunErr
The burn failed because the device drained its buffer without burn underrun protection.
kDRBurnNotAllowedErr
User is not allowed to burn to this device on this system.
kDRDataProductionErr
Error while producing data for the burn
kDRVerificationFailedErr
Data verification failed
kDRTooManyTracksForDVDErr
DVD discs can contain only one track
kDRBadLayoutErr
Too many tracks or sessions
kDRUserCanceledErr
User canceled the burn
kDRFunctionNotSupportedErr
Track producer cannot perform requested function
kDRTrackReusedErr
One or more tracks were included multiple times in the burn
kDRFileModifiedDuringBurnErr
File changed during flatten or burn
kDRFileLocationConflictErr
Conflicting locations specified for two files
kDRTooManyNameConflictsErr
Too many filename conflicts to resolve (10,000,000 or more)
kDRDeviceCantWriteCDTextErr
Device does not support writing CD-Text
kDRDeviceBurnStrategyNotAvailableErr
Device does not support the required burn strategy for this burn
kDRDeviceCantWriteIndexPointsErr
Device does not support writing index points
kDRDeviceCantWriteISRCErr
Device does not support writing ISRC
kDRDeviceCantWriteSCMSErr
Device does not support writing SCMS
kDRDevicePreGapLengthNotValidErr
Device does not support the required pregap length for the track
Discussion 

Errors returned from the Disc Recording framework. All errors returned by the Disc Recording framework will fall into the range of 0x80020000 -> 0x8002FFFF.*/

enum { 
    kDRFirstErr = 0x80020000, 
    kDRInternalErr = kDRFirstErr,  
    kDRDeviceAccessErr = 0x80020020, 
    kDRDeviceBusyErr = 0x80020021, 
    kDRDeviceCommunicationErr = 0x80020022, 
    kDRDeviceInvalidErr = 0x80020023, 
    kDRDeviceNotReadyErr = 0x80020024, 
    kDRDeviceNotSupportedErr = 0x80020025,  
    kDRMediaBusyErr = 0x80020040, 
    kDRMediaNotPresentErr = 0x80020041, 
    kDRMediaNotWritableErr = 0x80020042, 
    kDRMediaNotSupportedErr = 0x80020043, 
    kDRMediaNotBlankErr = 0x80020044, 
    kDRMediaNotErasableErr = 0x80020045,  
    kDRBurnUnderrunErr = 0x80020060, 
    kDRBurnNotAllowedErr = 0x80020061, 
    kDRDataProductionErr = 0x80020062, 
    kDRVerificationFailedErr = 0x80020063, 
    kDRTooManyTracksForDVDErr = 0x80020064, 
    kDRBadLayoutErr = 0x80020065, 
    kDRUserCanceledErr = 0x80020066, 
    kDRFunctionNotSupportedErr = 0x80020067, 
    kDRTrackReusedErr = 0x8002006F,  
    /* content errors */
    kDRFileModifiedDuringBurnErr = 0x80020100, 
    kDRFileLocationConflictErr = 0x80020101, 
    kDRTooManyNameConflictsErr = 0x80020102, 
    kDRDeviceCantWriteCDTextErr = 0x80020201,  
    /* drive feature errors */
    kDRDeviceBurnStrategyNotAvailableErr = 0x80020200, 
    kDRDeviceCantWriteIndexPointsErr = 0x80020202, 
    kDRDeviceCantWriteISRCErr = 0x80020203, 
    kDRDeviceCantWriteSCMSErr = 0x80020204, 
    kDRDevicePreGapLengthNotValidErr = 0x80020205 
};  

/*kDRErrorStatusErrorStringKey

extern const CFStringRef kDRErrorStatusErrorStringKey;  
Discussion 

A key for the DRErrorStatus dictionary. The value of this key is a CFString object containing the localized string describing the kDRErrorStatusErrorKey key. This value is optional and may not be present if a suitable string does not exist to describe the failure. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRErrorStatusErrorStringKey;  

/*kDRErrorStatusKey

extern const CFStringRef kDRErrorStatusKey;  
Discussion 

A key for the DRErrorStatus dictionary, returned by any of the DRxxxCopyStatus calls or kDRxxxStatusChangedNotifications, to describe a failure. The value of this key is a CFDictionary object containing error code and device sense information. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRErrorStatusKey;  

#ifdef __cplusplus
}
#endif

#endif 
