#import <Foundation/Foundation.h>
#import <CoreServices/CoreServices.h>
#import <DiscRecordingEngine/DRCoreCDText.h>

#import <HYS/DiscRecordingEngine/DRCDText.h>
#include <AvailabilityMacros.h>

/*DRCDTextMCNISRCKey

extern NSString* const DRCDTextMCNISRCKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSData, containing either 13 bytes of MCN (for the disc) or 12 bytes of ISRC (for tracks). 

This information can also be specified in the burn and track properties. CD-Text simply provides an alternative, possibly redundant way to encode this information. If the MCN or ISRC was specified in the properties for the burn or track, this value should be the same. See the descriptions of DRMediaCatalogNumberKey and DRTrackISRCKey for more details on the precise format of the data. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextMCNISRCKey;  

/*DRCDTextPerformerKey

extern NSString* const DRCDTextPerformerKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the track/disc performer. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextPerformerKey;  

/*DRCDTextComposerKey

extern NSString* const DRCDTextComposerKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the track/disc composer. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextComposerKey;  

/*DRCDTextClosedKey

extern NSString* const DRCDTextClosedKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing disc information. The format of this data is arbitrary and is up to the content provider. This information is private and players should not display it to the user of the disc. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextClosedKey;  

/*DRCDTextGenreCodeKey

extern NSString* const DRCDTextGenreCodeKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSNumber, containing the numeric code for the disc genre as enumerated above. 

This key is only valid for the disc (array index 0) and is ignored when set in the dictionaries for tracks. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextGenreCodeKey;  

/*DRCDTextDiscIdentKey

extern NSString* const DRCDTextDiscIdentKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing disc ID information, such as the catalog number and name of the record company, point of sale code, year of sales, etc. Each item shall be separated by a slash ("/"). 

This key is only valid for the disc (array index 0) and is ignored when set in the dictionaries for tracks. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextDiscIdentKey;  

/*DRCDTextArrangerKey

extern NSString* const DRCDTextArrangerKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the track/disc arranger. 
Availability
Introduced in Mac OS X v10.4.&*/
extern NSString* const DRCDTextArrangerKey;  

/*DRCDTextSongwriterKey

extern NSString* const DRCDTextSongwriterKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the track/disc songwriter. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextSongwriterKey;  

/*DRCDTextGenreKey

extern NSString* const DRCDTextGenreKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the description of the disc genre. 

This key is only valid for the disc (array index 0) and is ignored when set in the dictionaries for tracks. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextGenreKey;  

/*DRCDTextGenreKey

extern NSString* const DRCDTextGenreKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the description of the disc genre. 

This key is only valid for the disc (array index 0) and is ignored when set in the dictionaries for tracks. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextGenreKey;  

/*DRCDTextSpecialMessageKey

extern NSString* const DRCDTextSpecialMessageKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing a text message which may be displayed to the user by some players. 
Availability
Introduced in Mac OS X v10.4.&*/
extern NSString* const DRCDTextSpecialMessageKey;  

/*DRCDTextSpecialMessageKey

extern NSString* const DRCDTextSpecialMessageKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing a text message which may be displayed to the user by some players. 
Availability
Introduced in Mac OS X v10.4.8.*/
extern NSString* const DRCDTextSpecialMessageKey; 

//class



@class DRCDTextBlock;

/*DRCDTextTitleKey

extern NSString* const DRCDTextTitleKey;  
Discussion 

One of the keys for the track dictionaries in a CD-Text block. The value for this key is an NSString, containing the track/disc title. 
Availability
Introduced in Mac OS X v10.4.*/
extern NSString* const DRCDTextTitleKey;  

@interface DRCDTextBlock : NSObject
/*cdTextBlockWithLanguage:encoding:


Creates a CD-Text block. 
private

+ (DRCDTextBlock*) cdTextBlockWithLanguage:(NSString*)lang 
        encoding:(NSStringEncoding)enc; 
Parameters
lang
ISO 639 language code describing the language in which the strings are provided. CD-Text allows the concept of an unknown language, which can be represented here by an empty string.
enc
Character encoding into which the strings should be converted.
Return Value

An autoreleased DRCDTextBlock object. 
Availability
Introduced in Mac OS X v10.4.*/

+ (DRCDTextBlock*) cdTextBlockWithLanguage:(NSString*)lang 
        encoding:(NSStringEncoding)enc; 

/*setObject:forKey:ofTrack:


Changes a single string in the block. 
private

- (void) setObject:(id)value forKey:(NSString*)key ofTrack:(unsigned)trackIndex; 
Parameters
value
Value - an NSString, NSData, or NSNumber as appropriate.
key
Key to assign.
trackIndex
One-based index of the track to modify, or 0 to modify the disc.
Availability
Introduced in Mac OS X v10.4.*/
- (void) setObject:(id)value forKey:(NSString*)key ofTrack:(unsigned)trackIndex; 

@end

//@interface DRCDTextBlock (PropertyConvenienceMethods)

//@end

