#import <Foundation/Foundation.h>
#import <DiscRecordingContent/DRFSObject.h>

@interface DRFolder : DRFSObject

/*folderWithPath:


Creates a real folder object 
private

+ (DRFolder*) folderWithPath:(NSString*)path;
Parameters
path
The path to an existing file.
Return Value

An autoreleased DRFolder object. 
Discussion 

Creates and initializes a DRFolder object that will use the folder contents of the folder located at path as a source.*/
+ (DRFolder*) folderWithPath:(NSString*)path;

@end

@interface DRFolder (VirtualFolders)

/*virtualFolderWithName:


Creates a virtual folder object 
private

+ (DRFolder*) virtualFolderWithName:(NSString*)name;
Parameters
name
The name of the folder on the output disc.
Return Value

An autoreleased DRFolder object. 
Discussion 

Creates and initializes a DRFolder object that will be populated with specified DRFile and DRFolder objects at runtime.*/
+ (DRFolder*) virtualFolderWithName:(NSString*)name;

/*addChild:


Adds an object reference (either a file or folder) as a child of a virtual folder object. 
private

- (void) addChild:(DRFSObject*)child; 
Parameters
child
The child to add to the folder
Discussion 

This method only applies to virtual folders. Real folders are considered leaf nodes and cannot have children.*/
- (void) addChild:(DRFSObject*)child; 

/*removeChild:


Removes an object reference (either a file or folder) as a child of a virtual folder object. 
private

- (void) removeChild:(DRFSObject*)child; 
Parameters
child
The child to remove from the folder
Discussion 

This method only applies to virtual folders. Real folders are considered leaf nodes and cannot have children.*/
- (void) removeChild:(DRFSObject*)child; 

/*makeVirtual


Changes the real DRFolder object into a virtual DRFolder object. 
private

- (void) makeVirtual; 
Discussion 

The virtual folder created in this way is a snapshot of the on-disk folder at the moment of the call. The newly created virtual folder will contain real folder and file objects corresponding to the on-disk children of the original on-disk folder.
If the on-disk folder is modified (eg, if the folder attributes change, or if children are added to or removed from the on-disk tree): during this call, the virtual folder may or may not reflect the changes. If modified after this call, the virtual folder will not reflect the changes.*/
- (void) makeVirtual; 


@end
