#ifndef CMDEVICEINTEGRATION_H
#define CMDEVICEINTEGRATION_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef CMAPPLICATION_H
#include <ColorSync/CMApplication.h>
#endif

#ifndef CMICCPROFILE_H
#include <ColorSync/CMICCProfile.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Profile Iteration Values

Specify profiles to iterate.

enum {
   cmIterateFactoryDeviceProfiles = 0x00000001,
   cmIterateCustomDeviceProfiles = 0x00000002,
   cmIterateCurrentDeviceProfiles = 0x00000003,
   cmIterateAllDeviceProfiles = 0x00000004,
   cmIterateDeviceProfilesMask = 0x0000000F
};
Constants
cmIterateFactoryDeviceProfiles

Iterate profiles registered through the routine CMSetDeviceFactoryProfiles. To retrieve all factory profiles for all devices, use cmIterateFactoryDeviceProfiles as the flags value when calling CMIterateDeviceProfiles. I

Available in Mac OS X v10.0 and later.
cmIterateCustomDeviceProfiles

Iterate profiles that are meant to take the place of the factory profiles, as a result of customization or calibration. To retrieve only custom profiles for all devices, use the cmIterateCustomDeviceProfiles, as the flags value when calling CMIterateDeviceProfiles. 

Available in Mac OS X v10.0 and later.
cmIterateCurrentDeviceProfiles

Iterate profiles registered through the routing CMSetDeviceProfiles. To get the profiles in use for all devices, use cmIterateCurrentDeviceProfiles as the flags value. This will replace the factory profiles with any overrides, yielding the currently used set.I

Available in Mac OS X v10.0 and later.
cmIterateAllDeviceProfiles

Iterate all profiles, without replacement.

Available in Mac OS X v10.1 and later.
cmIterateDeviceProfilesMask

Available in Mac OS X v10.0 and later.
Discussion

These are possible values for flags passed to the function CMIterateDeviceProfiles.*/

enum {
   cmIterateFactoryDeviceProfiles = 0x00000001,
   cmIterateCustomDeviceProfiles = 0x00000002,
   cmIterateCurrentDeviceProfiles = 0x00000003,
   cmIterateAllDeviceProfiles = 0x00000004,
   cmIterateDeviceProfilesMask = 0x0000000F
};

/*CMDeviceProfileID


typedef UInt32 CMDeviceProfileID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CMDeviceProfileID;

/*CMDeviceState


typedef UInt32 CMDeviceState;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CMDeviceState;

/*CMDeviceID

Defines a data type for a CM device ID.

typedef UInt32 CMDeviceID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 CMDeviceID;


/*Device Classes

Define constants to represent a variey of input and output devices.

enum {
   cmScannerDeviceClass = 'scnr',
   cmCameraDeviceClass = 'cmra',
   cmDisplayDeviceClass = 'mntr',
   cmPrinterDeviceClass = 'prtr',
   cmProofDeviceClass = 'pruf'
};
typedef OSType CMDeviceClass;
Constants
cmScannerDeviceClass

Available in Mac OS X v10.0 and later.
cmCameraDeviceClass

Available in Mac OS X v10.0 and later.
cmDisplayDeviceClass

Available in Mac OS X v10.0 and later.
cmPrinterDeviceClass

Available in Mac OS X v10.0 and later.
cmProofDeviceClass

Available in Mac OS X v10.0 and later.*/
enum {
   cmScannerDeviceClass = 'scnr',
   cmCameraDeviceClass = 'cmra',
   cmDisplayDeviceClass = 'mntr',
   cmPrinterDeviceClass = 'prtr',
   cmProofDeviceClass = 'pruf'
};
typedef OSType CMDeviceClass;

/*CMDeviceScope


struct CMDeviceScope {
   CFStringRef deviceUser;
   CFStringRef deviceHost;
};
typedef struct CMDeviceScope CMDeviceScope;
typedef CMDeviceScope CMDeviceProfileScope;
Fields
deviceUser
deviceHost
Availability
Available in Mac OS X v10.0 and later.*/

struct CMDeviceScope {
   CFStringRef deviceUser;
   CFStringRef deviceHost;
};
typedef struct CMDeviceScope CMDeviceScope;
typedef CMDeviceScope CMDeviceProfileScope;/*

CMDeviceInfo


struct CMDeviceInfo {
   UInt32 dataVersion;
   CMDeviceClass deviceClass;
   CMDeviceID deviceID;
   CMDeviceScope deviceScope;
   CMDeviceState deviceState;
   CMDeviceProfileID defaultProfileID;
   CFDictionaryRef * deviceName;
   UInt32 profileCount;
   UInt32 reserved;
};
typedef struct CMDeviceInfo CMDeviceInfo;
typedef CMDeviceInfo * CMDeviceInfoPtr;
Fields
dataVersion
deviceClass
deviceID
deviceScope
deviceState
defaultProfileID
deviceName

See the CFDictionary documentation for a description of the CFDictionaryRef data type.
profileCount
reserved
Availability
Available in Mac OS X v10.0 and later.*/
struct CMDeviceInfo {
   UInt32 dataVersion;
   CMDeviceClass deviceClass;
   CMDeviceID deviceID;
   CMDeviceScope deviceScope;
   CMDeviceState deviceState;
   CMDeviceProfileID defaultProfileID;
   CFDictionaryRef * deviceName;
   UInt32 profileCount;
   UInt32 reserved;
};
typedef struct CMDeviceInfo CMDeviceInfo;
typedef CMDeviceInfo * CMDeviceInfoPtr;


/*http://developer.apple.com/technotes/tn/tn2035.html

Here's the specific notification strings (from the ColorSync interface file CMDeviceIntegration.h) which you can use with the above functions:
#define  kCMDeviceRegisteredNotification   CFSTR("CMDeviceRegisteredNotification")
#define  kCMDeviceUnregisteredNotification  CFSTR("CMDeviceUnregisteredNotification")
#define  kCMDeviceOnlineNotification  CFSTR("CMDeviceOnlineNotification")
#define  kCMDeviceOfflineNotification  CFSTR("CMDeviceOfflineNotification")
#define  kCMDeviceStateNotification   CFSTR("CMDeviceStateNotification")
#define  kCMDefaultDeviceNotification  CFSTR("CMDefaultDeviceNotification")
#define  kCMDeviceProfilesNotification  CFSTR("CMDeviceProfilesNotification")
#define  kCMDefaultDeviceProfileNotification
                            CFSTR("CMDefaultDeviceProfileNotification")
#define  kCMPrefsChangeDeviceNotification
                            CFSTR("AppleColorSyncPreferencesChangedNotification")*/
#define  kCMDeviceRegisteredNotification   CFSTR("CMDeviceRegisteredNotification")
#define  kCMDeviceUnregisteredNotification  CFSTR("CMDeviceUnregisteredNotification")
#define  kCMDeviceOnlineNotification  CFSTR("CMDeviceOnlineNotification")
#define  kCMDeviceOfflineNotification  CFSTR("CMDeviceOfflineNotification")
#define  kCMDeviceStateNotification   CFSTR("CMDeviceStateNotification")
#define  kCMDefaultDeviceNotification  CFSTR("CMDefaultDeviceNotification")
#define  kCMDeviceProfilesNotification  CFSTR("CMDeviceProfilesNotification")
#define  kCMDefaultDeviceProfileNotification \
                            CFSTR("CMDefaultDeviceProfileNotification")
#define  kCMPrefsChangeDeviceNotification \
                            CFSTR("AppleColorSyncPreferencesChangedNotification")


/*NCMDeviceProfileInfo


struct NCMDeviceProfileInfo {
   UInt32 dataVersion;
   CMDeviceProfileID profileID;
   CMProfileLocation profileLoc;
   CFDictionaryRef profileName;
   CMDeviceProfileScope profileScope;
   UInt32 reserved;
};
typedef struct NCMDeviceProfileInfo NCMDeviceProfileInfo;
Fields
dataVersion
profileID
profileLoc
profileName
profileScope
reserved
Availability
Available in Mac OS X v10.1 and later.*/
struct NCMDeviceProfileInfo {
   UInt32 dataVersion;
   CMDeviceProfileID profileID;
   CMProfileLocation profileLoc;
   CFDictionaryRef profileName;
   CMDeviceProfileScope profileScope;
   UInt32 reserved;
};
typedef struct NCMDeviceProfileInfo NCMDeviceProfileInfo;

/*CMIterateDeviceProfileProcPtr

Defines a pointer to a function that iterates through the device profiles available on the system.

typedef OSErr (*CMIterateDeviceProfileProcPtr)
(
   const CMDeviceInfo * deviceInfo,
   const NCMDeviceProfileInfo * profileInfo,
   void * refCon
);

If you name your function MyCMIterateDeviceProfileProc, you would declare it like this:

OSErr MyCMIterateDeviceProfileProc (
   const CMDeviceInfo * deviceInfo,
   const NCMDeviceProfileInfo * profileInfo,
   void * refCon
);
Parameters
deviceData
profileData
refCon
Return Value

An OSErr value.*/

typedef OSErr (*CMIterateDeviceProfileProcPtr)
(
   const CMDeviceInfo * deviceInfo,
   const NCMDeviceProfileInfo * profileInfo,
   void * refCon
);

/*CMIterateDeviceInfoProcPtr

Defines a pointer to a function that iterates through device information available on the system.

typedef OSErr (*CMIterateDeviceInfoProcPtr)
(
   const CMDeviceInfo * deviceInfo,
   void * refCon
);

If you name your function MyCMIterateDeviceInfoProc, you would declare it like this:

OSErr MyCMIterateDeviceInfoProc (
   const CMDeviceInfo * deviceInfo,
   void * refCon
);
Parameters
deviceData
refCon
Return Value

An OSErr value.*/

typedef OSErr (*CMIterateDeviceInfoProcPtr)
(
   const CMDeviceInfo * deviceInfo,
   void * refCon
);




//functions

/*CMGetDefaultDevice

Gets the default device.

CMError CMGetDefaultDevice (
   CMDeviceClass deviceClass,
   CMDeviceID * deviceID
);
Parameters
deviceClass

The device class whose default device you want to get. See “Device Classes” for a list of the constants you can supply.
deviceID

On return, points to the device ID for the default device.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

For each class of device, a device management layer may establish which of the registered devices is the default. This helps keep color management choices to a minimum and allows for some automatic features to be enabled, such as the "Default printer" as an output profile selection. 
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/

CMError CMGetDefaultDevice (
   CMDeviceClass deviceClass,
   CMDeviceID * deviceID
);

/*CMIterateDeviceProfiles

Iterates through the device profiles available on the system and returns information about profiles of the devices to a callback you supply.

CMError CMIterateDeviceProfiles (
   CMIterateDeviceProfileProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   UInt32 flags,
   void * refCon
);
Parameters
proc

A pointer to a function that iterates through device information available on the system. This is optional, but allows you to obtain profile information for each device. If provided, your callback is invoked once for each registered device.
seed

A pointer to a seed value. This is optional. If you pass a pointer to a seed value that is the same as the current seed value, then the callback function specified by the proc parameter is not invoked.
count

On output, the number of color devices available on the system.
flags

A value that specifies which set of profiles you want to iterate through. It can have the following values: cmIterateFactoryDeviceProfiles, cmIterateCustomDeviceProfiles, cmIterateCurrentDeviceProfiles, cmIterateAllDeviceProfiles or 0. Supplying 0 is the same as supplying cmIterateCurrentDeviceProfiles.
refCon

An optional value that passed to your callback.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/
CMError CMIterateDeviceProfiles (
   CMIterateDeviceProfileProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   UInt32 flags,
   void * refCon
);

/*CMGetDeviceProfile

Gets a profile used by a given device. 

CMError CMGetDeviceProfile (
   CMDeviceClass deviceClass,
   CMDeviceID deviceID,
   CMDeviceProfileID profileID,
   CMProfileLocation * deviceProfLoc
);
Parameters
deviceClass

The device class for the device whose profile you want to get. See “Device Classes” for a list of the constants you can supply.
deviceID

The device ID for the device whose profile you want to get.
defaultID

The ID of the default profile for this device.
deviceProfLoc

On return, the location of the profile.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/
CMError CMGetDeviceProfile (
   CMDeviceClass deviceClass,
   CMDeviceID deviceID,
   CMDeviceProfileID profileID,
   CMProfileLocation * deviceProfLoc
);

/*CMIterateColorDevices

Iterates through the color devices available on the system, returning device information to a callback you supply.

CMError CMIterateColorDevices (
   CMIterateDeviceInfoProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);
Parameters
proc

A pointer to a function that iterates through device information available on the system. This is optional, but allows you to obtain device information. If provided, your callback is invoked once for each registered device.
seed

A pointer to a seed value. This is optional. If you pass a pointer to a seed value that is the same as the current seed value, then the callback function specified by the proc parameter is not invoked.
count

On output, the number of color devices available on the system.
refCon

An optional value that passed to your callback.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

This routine gets device information about all registered color devices. If provided, the supplied callback functions is called once for each registered device, passing in the device info and the supplied refcon. 
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/

CMError CMIterateColorDevices (
   CMIterateDeviceInfoProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);

#ifdef __cplusplus
}
#endif

#endif