#ifndef DRIVERSERVICES_H
#define DRIVERSERVICES_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif

#ifndef MACHINEEXCEPTIONS_H
#include <CarbonCore/MachineExceptions.h>
#endif

#ifndef DEVICES_H
#include <CarbonCore/Devices.h>
#endif

#ifndef DRIVERSYNCHRONIZATION_H
#include <CarbonCore/DriverSynchronization.h>
#endif

#ifndef NAMEREGISTRY_H
#include <CarbonCore/NameRegistry.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Another form for representing time is in Nanoseconds, the values of which are represented by unsigned 64-bit integers:
typedef struct Nanoseconds
{
    unsigned long   hi;
    unsigned long   lo;
} Nanoseconds;*/
typedef struct Nanoseconds
{
    unsigned long   hi;
    unsigned long   lo;
} Nanoseconds;


/*The Driver Services Library provides the following definitions for use with values of type Duration :
enum
{
    durationMicrosecond             = -1,
    durationMillisecond             = 1,
    durationSecond                  = 1000,
    durationMinute                  = 1000 * 60,
    durationHour                    = 1000 * 60 * 60,
    durationDay                     = 1000 * 60 * 60 * 24,
    durationForever                 = 0x7FFFFFFF,
    durationImmediate               = 0,
};*/
enum
{
    durationMicrosecond             = -1,
    durationMillisecond             = 1,
    durationSecond                  = 1000,
    durationMinute                  = 1000 * 60,
    durationHour                    = 1000 * 60 * 60,
    durationDay                     = 1000 * 60 * 60 * 24,
    durationForever                 = 0x7FFFFFFF,
    durationImmediate               = 0,
};

//func

/*UpTime
AbsoluteTime UpTime (void); 
DESCRIPTION

UpTime returns the time since OS initialization in AbsoluteTime units.
EXECUTION CONTEXT

UpTime may be called from task level, secondary interrupt level, or hardware interrupt level.*/
AbsoluteTime UpTime (void); 

/*Time Conversion Routines

The Driver Services Library provides the following conversion routines to convert between Nanoseconds, Duration, and AbsoluteTime units:
Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime); 

Nanoseconds DurationToNanoseconds (Duration duration); 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime); 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds); 

AbsoluteTime DurationToAbsolute (Duration duration); 

Duration NanosecondsToDuration (Nanoseconds nanoseconds); 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2); 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Note

The value of rightAbsoluteTime is usually larger than that of leftAbsoluteTime. However, if you subtract a rightAbsoluteTime value from a leftAbsoluteTime value, the result is 0, not a negative number. 
EXECUTION CONTEXT

The time conversion routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/

Nanoseconds AbsoluteToNanoseconds (AbsoluteTime absoluteTime); 

Nanoseconds DurationToNanoseconds (Duration duration); 

Duration AbsoluteToDuration (AbsoluteTime absoluteTime); 

AbsoluteTime NanosecondsToAbsolute (Nanoseconds nanoseconds); 

AbsoluteTime DurationToAbsolute (Duration duration); 

Duration NanosecondsToDuration (Nanoseconds nanoseconds); 

AbsoluteTime AddAbsoluteToAbsolute(
                     AbsoluteTime absoluteTime1,
                     AbsoluteTime absoluteTime2); 

AbsoluteTime SubAbsoluteFromAbsolute(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

AbsoluteTime AddNanosecondsToAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime AddDurationToAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubNanosecondsFromAbsolute(
                     Nanoseconds nanoseconds,
                     AbsoluteTime absoluteTime); 

AbsoluteTime SubDurationFromAbsolute(
                     Duration duration,
                     AbsoluteTime absoluteTime); 

Nanoseconds AbsoluteDeltaToNanoseconds(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 

Duration AbsoluteDeltaToDuration(
                     AbsoluteTime leftAbsoluteTime,
                     AbsoluteTime rightAbsoluteTime); 




#ifdef __cplusplus
}
#endif

#endif