#import <AppKit/NSImageRep.h>

@interface NSPDFImageRep : NSImageRep

/*pageCount

Returns the number of pages in the receiver.

- (int)pageCount
Return Value

The number of pages in the PDF data.
Availability
Available in Mac OS X v10.0 and later.*/
- (int)pageCount;

/*setCurrentPage:

Sets the page to display to the specified value.

- (void)setCurrentPage:(int)page
Parameters
page

A zero-based index indicating the page you want to display. 
Availability
Available in Mac OS X v10.0 and later.
See Also
– currentPage*/
- (void)setCurrentPage:(int)page;

/*bounds

Returns the receiver's bounding rectangle.

- (NSRect)bounds
Return Value

The bounding rectangle. This value is equivalent to the crop box specified by the PDF data. 
Availability
Available in Mac OS X v10.0 and later.*/
- (NSRect)bounds;

@end

