#ifdef OPENCOCOA

#include <sys/attr.h>
#include <sys/kernel_types.h>
#include <stdint.h>

#include <HYS/sys/mount.h>

/*MNAMELEN

See Also:
FS stats
#define MNAMELEN 90 /* length of buffer for returned name *
Discussion 

file system statistics*/
#define MNAMELEN 90 /* length of buffer for returned name */

/*MFSNAMELEN

See Also:
FS stats
#define MFSNAMELEN 15 / length of fs type name, not inc. null *
Discussion 

file system statistics*/
#define MFSNAMELEN 15 /* length of fs type name, not inc. null */

/*MNT_EXPORTED

#define MNT_EXPORTED 0x00000100 / file system is exported *
Discussion 

NFS export related mount flags.*/
#define MNT_EXPORTED 0x00000100 /* file system is exported */

/*MNT_UNKNOWNPERMISSIONS

#define MNT_UNKNOWNPERMISSIONS 0x00200000 / VFS will ignore ownership information on filesystem objects *
Discussion 

backwards compatibility only*/
#define MNT_UNKNOWNPERMISSIONS 0x00200000 /* VFS will ignore ownership information on filesystem objects */

/*MNT_DONTBROWSE

See Also:
User-specifiable Mount Flags
#define MNT_DONTBROWSE 0x00100000 / file system is not appropriate path to user data *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_DONTBROWSE 0x00100000 /* file system is not appropriate path to user data */

/*MNT_ASYNC

See Also:
User-specifiable Mount Flags
#define MNT_ASYNC 0x00000040 / file system written asynchronously *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_ASYNC 0x00000040 /* file system written asynchronously */

/*MNT_JOURNALED

See Also:
User-specifiable Mount Flags
#define MNT_JOURNALED 0x00800000 / filesystem is journaled *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_JOURNALED 0x00800000 /* filesystem is journaled */

/*MNT_UNION

See Also:
User-specifiable Mount Flags
#define MNT_UNION 0x00000020 / union with underlying filesystem *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_UNION 0x00000020 /* union with underlying filesystem */

/*MNT_NODEV

See Also:
User-specifiable Mount Flags
#define MNT_NODEV 0x00000010 / don't interpret special files *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_NODEV 0x00000010 /* don't interpret special files */

/*MNT_AUTOMOUNTED

See Also:
User-specifiable Mount Flags
#define MNT_AUTOMOUNTED 0x00400000 /filesystem was mounted by automounter *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_AUTOMOUNTED 0x00400000 /* filesystem was mounted by automounter */

/*MNT_NOSUID

See Also:
User-specifiable Mount Flags
#define MNT_NOSUID 0x00000008 / don't honor setuid bits on fs *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_NOSUID 0x00000008 /* don't honor setuid bits on fs */

/*MNT_NOEXEC

See Also:
User-specifiable Mount Flags
#define MNT_NOEXEC 0x00000004 / can't exec from filesystem *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_NOEXEC 0x00000004 /* can't exec from filesystem */

/*MNT_SYNCHRONOUS

See Also:
User-specifiable Mount Flags
#define MNT_SYNCHRONOUS 0x00000002 /file system written synchronously *
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_SYNCHRONOUS 0x00000002 /* file system written synchronously */

/*Internal Mount Flags

See Also:
MNT_LOCAL
MNT_QUOTA
MNT_ROOTFS
MNT_DOVOLFS
#define MNT_LOCAL 0x00001000 / filesystem is stored locally
    *
#define MNT_QUOTA 0x00002000 / quotas are enabled on 
    filesystem *
#define MNT_ROOTFS 0x00004000 /identifies the root 
    filesystem 
#define MNT_DOVOLFS 0x00008000 / FS supports volfs 
Discussion 

Flags set by internal operations.*/

#define MNT_LOCAL 0x00001000 /* filesystem is stored locally
    */
#define MNT_QUOTA 0x00002000 /* quotas are enabled on 
    filesystem */
#define MNT_ROOTFS 0x00004000 /* identifies the root 
    filesystem */
#define MNT_DOVOLFS 0x00008000

/*MNT_RDONLY

See Also:
User-specifiable Mount Flags
#define MNT_RDONLY 0x00000001 / read only filesystem 
Discussion 

User specifiable flags. 

Unmount uses MNT_FORCE flag.*/
#define MNT_RDONLY 0x00000001 /* read only filesystem */

/*vfs_attr

struct vfs_attr { 
    uint64_t f_supported; 
    uint64_t f_active;  
    uint64_t f_minsize; / XXX must be removed /
    uint64_t f_objcount; / number of filesystem objects in volume /
    uint64_t f_filecount; / ... files /
    uint64_t f_dircount; / ... directories /
    uint64_t f_maxobjcount; / maximum number of filesystem objects /
    size_t f_iosize; / optimal transfer block size /
    uint64_t f_blocks; / total data blocks in file system /
    uint64_t f_bfree; / free blocks in fs /
    uint64_t f_bavail; / free blocks avail to non-superuser /
    uint64_t f_bused; / blocks in use /
    uint64_t f_files; / total file nodes in file system /
    uint64_t f_ffree; / free file nodes in fs /
    fsid_t f_fsid; / file system id /
    uid_t f_owner; / user that mounted the filesystem /
    uint64_t f_uuid; / volume UUID /
    vol_capabilities_attr_t f_capabilities; 
    vol_attributes_attr_t f_attributes;  
    struct timespec f_create_time; / creation time /
    struct timespec f_modify_time; / last modification time /
    struct timespec f_access_time; / time of last access /
    struct timespec f_backup_time; / last backup time /
    / XXX must go away /
    char f_fstypename[MFSTYPENAMELEN];/ fs type name inclus /
    char f_mntonname[MAXPATHLEN];/ directory on which mounted /
    char f_mntfromname[MAXPATHLEN];/ mounted filesystem /
    uint32_t f_fssubtype; / filesystem subtype /
    uint32_t f_bsize; / block size for the above size values /
    char f_volname[90 / length of buffer for returned name /
        ]; / volume name /
};  
Discussion 

New VFS_STAT argument structure.*/


struct vfs_attr { 
    uint64_t f_supported; 
    uint64_t f_active;
    uint64_t f_minsize; /* XXX must be removed */
    uint64_t f_objcount; /* number of filesystem objects in volume */
    uint64_t f_filecount; /* ... files */
    uint64_t f_dircount; /* ... directories */
    uint64_t f_maxobjcount; /* maximum number of filesystem objects */
    size_t f_iosize; /* optimal transfer block size */
    uint64_t f_blocks; /* total data blocks in file system */
    uint64_t f_bfree; /* free blocks in fs */
    uint64_t f_bavail; /* free blocks avail to non-superuser */
    uint64_t f_bused; /* blocks in use */
    uint64_t f_files; /* total file nodes in file system */
    uint64_t f_ffree; /* free file nodes in fs */
    fsid_t f_fsid; /* file system id */
    uid_t f_owner; /* user that mounted the filesystem */
    uint64_t f_uuid; /* volume UUID */
    vol_capabilities_attr_t f_capabilities;
    vol_attributes_attr_t f_attributes;
    struct timespec f_create_time; /* creation time */
    struct timespec f_modify_time; /* last modification time */
    struct timespec f_access_time; /* time of last access */
    struct timespec f_backup_time; /* last backup time */
    /* XXX must go away */
    char f_fstypename[MFSTYPENAMELEN];/* fs type name inclus */
    char f_mntonname[MAXPATHLEN];/* directory on which mounted */
    char f_mntfromname[MAXPATHLEN];/* mounted filesystem */
    uint32_t f_fssubtype; /* filesystem subtype */
    uint32_t f_bsize; /* block size for the above size values */
    char f_volname[90 /* length of buffer for returned name */
        ]; /* volume name */
};  
typedef struct vfs_attr vfs_attr;


/*vfs_fsprivate

void * vfs_fsprivate(
    mount_t);  
Discussion 

Description forthcoming*/
void * vfs_fsprivate(
    mount_t);  

/*vfs_typenum

int vfs_typenum(
    mount_t);  
Discussion 

Description forthcoming*/

int vfs_typenum(
    mount_t);  


/*vfs_fsremove

int vfs_fsremove(
    vfstable_t);  
Discussion 

Description forthcoming*/
int vfs_fsremove(
    vfstable_t);  


/*vfs_statfs

struct vfsstatfs * vfs_statfs(
    mount_t);  
Discussion 

Description forthcoming*/

struct vfsstatfs * vfs_statfs(
    mount_t);  


/*STATFS(2)                   BSD System Calls Manual                  STATFS(2)

NAME
     statfs -- get file system statistics

SYNOPSIS
     #include <sys/param.h>
     #include <sys/mount.h>

     int
     statfs(const char path, struct statfs buf);

     int
     fstatfs(int fd, struct statfs buf);

DESCRIPTION
     Statfs() returns information about a mounted file system.  Path is the
     path name of any file within the mounted file system.  Buf is a pointer
     to a statfs structure defined as follows:

     typedef struct { int32_t val[2]; } fsid_t;

     #define MFSNAMELEN   15 / length of fs type name, not inc. nul /
     #define MNAMELEN     90 / length of buffer for returned name /

     struct statfs {
         short   f_otype;    / type of file system (reserved: zero) /
         short   f_oflags;   / copy of mount flags (reserved: zero) /
         long    f_bsize;    / fundamental file system block size /
         long    f_iosize;   / optimal transfer block size /
         long    f_blocks;   / total data blocks in file system /
         long    f_bfree;    / free blocks in fs /
         long    f_bavail;   / free blocks avail to non-superuser /
         long    f_files;    / total file nodes in file system /
         long    f_ffree;    / free file nodes in fs /
         fsid_t  f_fsid;     / file system id (super-user only) /
         uid_t   f_owner;    / user that mounted the file system /
         short   f_reserved1;        / reserved for future use /
         short   f_type;     / type of file system (reserved) /
         long    f_flags;    / copy of mount flags (reserved) /
         long    f_reserved2[2];     / reserved for future use /
         char    f_fstypename[MFSNAMELEN]; / fs type name /
         char    f_mntonname[MNAMELEN];    / directory on which mounted /
         char    f_mntfromname[MNAMELEN];  / mounted file system /
         char    f_reserved3;        / reserved for future use /
         long    f_reserved4[4];     / reserved for future use /
     };

     Fields that are undefined for a particular file system are set to -1.
     Fstatfs() returns the same information about an open file referenced by
     descriptor fd.

RETURN VALUES
     Upon successful completion, a value of 0 is returned.  Otherwise, -1 is
     returned and the global variable errno is set to indicate the error.

ERRORS
     Statfs() fails if one or more of the following are true:

     [ENOTDIR]          A component of the path prefix of Path is not a direc-directory.
                        tory.

     [ENAMETOOLONG]     The length of a component of path exceeds {NAME_MAX}
                        characters, or the length of path exceeds {PATH_MAX}
                        characters.

     [ENOENT]           The file referred to by path does not exist.

     [EACCES]           Search permission is denied for a component of the
                        path prefix of path.

     [ELOOP]            Too many symbolic links were encountered in translat-translating
                        ing path.

     [EFAULT]           Buf or path points to an invalid address.

     [EIO]              An I/O error occurred while reading from or writing to
                        the file system.

     Fstatfs() fails if one or more of the following are true:

     [EBADF]            fd is not a valid open file descriptor.

     [EFAULT]           Buf points to an invalid address.

     [EIO]              An I/O error occurred while reading from or writing to
                        the file system.

HISTORY
     The statfs() function first appeared in 4.4BSD.

BSD                            February 11, 1994                           BSD*/
//   typedef struct { int32_t val[2]; } fsid_t;

     #define MFSNAMELEN   15 /* length of fs type name, not inc. nul */
     #define MNAMELEN     90 /* length of buffer for returned name */

     struct statfs {
         short   f_otype;    /* type of file system (reserved: zero) */
         short   f_oflags;   /* copy of mount flags (reserved: zero) */
         long    f_bsize;    /* fundamental file system block size */
         long    f_iosize;   /* optimal transfer block size */
         long    f_blocks;   /* total data blocks in file system */
         long    f_bfree;    /* free blocks in fs */
         long    f_bavail;   /* free blocks avail to non-superuser */
         long    f_files;    /* total file nodes in file system */
         long    f_ffree;    /* free file nodes in fs */
         fsid_t  f_fsid;     /* file system id (super-user only) */
         uid_t   f_owner;    /* user that mounted the file system */
         short   f_reserved1;        /* reserved for future use */
         short   f_type;     /* type of file system (reserved) */
         long    f_flags;    /* copy of mount flags (reserved) */
         long    f_reserved2[2];     /* reserved for future use */
         char    f_fstypename[MFSNAMELEN]; /* fs type name */
         char    f_mntonname[MNAMELEN];    /* directory on which mounted */
         char    f_mntfromname[MNAMELEN];  /* mounted file system */
         char    f_reserved3;        /* reserved for future use */
         long    f_reserved4[4];     /* reserved for future use */
     };

 int
     statfs(const char *path, struct statfs *buf);

     int
     fstatfs(int fd, struct statfs *buf);


/*vfs_fsadd

int vfs_fsadd(
    struct vfs_fsentry *,
    vfstable_t *);  
Discussion 

Description forthcoming*/
int vfs_fsadd(
    struct vfs_fsentry *,
    vfstable_t *);  

#endif