#ifdef OPENCOCOA

#import <Foundation/NSArray.h>
#import <Foundation/NSSet.h>

//@class NSIndexSet, NSString;
//@interface NSKeyValueObserving 
//dummy
//@end



@interface NSObject (NSKeyValueObserving)

/*willChangeValueForKey:

Invoked to inform the receiver that the value of a given property is about to change.

- (void)willChangeValueForKey:(NSString *)key
Parameters
key

The name of the property that will change.
Discussion

You should invoke this method when implementing key-value observer compliance manually.

The change type of this method is NSKeyValueChangeSetting.

Important: After the values have been changed, a corresponding didChangeValueForKey: must be invoked with the same parameter. 

Availability
Available in Mac OS X v10.3 and later.
See Also
– didChangeValueForKey:
– willChange:valuesAtIndexes:forKey:*/
- (void)willChangeValueForKey:(NSString *)key;

/*didChangeValueForKey:

Invoked to inform the receiver that the value of a given property has changed.

- (void)didChangeValueForKey:(NSString *)key
Parameters
key

The name of the property that changed.
Discussion

You should invoke this method when implementing key-value observer compliance manually. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– willChangeValueForKey:
– didChange:valuesAtIndexes:forKey:*/
- (void)didChangeValueForKey:(NSString *)key;


/*addObserver:forKeyPath:options:context:

Registers anObserver to receive KVO notifications for the specified key-path relative to the receiver.

- (void)addObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
Parameters
anObserver

The object to register for KVO notifications. The observer must implement the key-value observing method observeValueForKeyPath:ofObject:change:context:. 
keyPath

The key path, relative to the receiver, of the property to observe. This value must not be nil.
options

A combination of the NSKeyValueObservingOptions values that specifies what is included in observation notifications. For possible values, see NSKeyValueObservingOptions. 
context

Arbitrary data that is passed to anObserver in observeValueForKeyPath:ofObject:change:context:. 
Discussion

Neither the receiver, nor anObserver, are retained. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– removeObserver:forKeyPath:*/

- (void)addObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context;

/*removeObserver:forKeyPath:

Stops a given object from receiving change notifications for the property specified by a given key-path relative to the receiver.

- (void)removeObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath
Parameters
anObserver

The object to remove as an observer.
keyPath

A key-path, relative to the receiver, for which anObserver is registered to receive KVO change notifications.
Availability
Available in Mac OS X v10.3 and later.
See Also
– addObserver:forKeyPath:options:context:*/
- (void)removeObserver:(NSObject *)anObserver forKeyPath:(NSString *)keyPath;


/*setKeys:triggerChangeNotificationsForDependentKey:

Configures the receiver to post change notifications for a given property if any of the properties specified in a given array changes. 

+ (void)setKeys:(NSArray *)keys triggerChangeNotificationsForDependentKey:(NSString *)dependentKey
Parameters
keys

The names of the properties upon which the value of the property identified by dependentKey depends.
dependentKey

The name of a property whose value depends on the properties specified by keys.
Discussion

Invocations of will- and did-change KVO notification methods for any key in keys will automatically invoke the corresponding change notification methods for dependentKey. The dependentKey will not receive willChange/didChange messages to generate the notifications.

Dependencies should be registered before any instances of the receiving class are created, so you typically invoke this method in a class's initialize method, as illustrated in the following example.+ (void)initialize
{
    [self setKeys:[NSArray arrayWithObjects:@"firstName", @"lastName", nil]
          triggerChangeNotificationsForDependentKey:@"fullName"];
}

Availability
Available in Mac OS X v10.3 and later.*/
+ (void)setKeys:(NSArray *)keys triggerChangeNotificationsForDependentKey:(NSString *)dependentKey;

@end

#endif