

#import <Foundation/NSFormatter.h>
#include <CoreFoundation/CFDateFormatter.h>

//@class NSLocale, NSDate, NSCalendar, NSTimeZone, NSError, NSArray, NSMutableDictionary;
/*NSDateFormatterBehavior

These constants specify the behavior NSDateFormatter should exhibit. 

typedef enum {
   NSDateFormatterBehaviorDefault = 0,
   NSDateFormatterBehavior10_0    = 1000,
   NSDateFormatterBehavior10_4    = 1040,
} NSDateFormatterBehavior;
Constants
NSDateFormatterBehaviorDefault

Specifies default formatting behavior.

Available in Mac OS X v10.4 and later.
NSDateFormatterBehavior10_0

Specifies formatting behavior equivalent to that in Mac OS X 10.0.

Available in Mac OS X v10.4 and later.
NSDateFormatterBehavior10_4

Specifies formatting behavior equivalent for Mac OS X 10.4.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Foundation/NSDateFormatter.h*/
typedef enum {
   NSDateFormatterBehaviorDefault = 0,
   NSDateFormatterBehavior10_0    = 1000,
   NSDateFormatterBehavior10_4    = 1040,
} NSDateFormatterBehavior;

/*NSDateFormatterStyle

The following constants specify predefined date and time format styles.

typedef enum {
   NSDateFormatterNoStyle     = kCFDateFormatterNoStyle,
   NSDateFormatterShortStyle  = kCFDateFormatterShortStyle,
   NSDateFormatterMediumStyle = kCFDateFormatterMediumStyle,
   NSDateFormatterLongStyle   = kCFDateFormatterLongStyle,
   NSDateFormatterFullStyle   = kCFDateFormatterFullStyle
} NSDateFormatterStyle;
Constants
NSDateFormatterNoStyle

Specifies no style.

Equal to kCFDateFormatterNoStyle.

Available in Mac OS X v10.4 and later.
NSDateFormatterShortStyle

Specifies a short style, typically numeric only, such as “11/23/37” or “3:30pm”.

Equal to kCFDateFormatterShortStyle.

Available in Mac OS X v10.4 and later.
NSDateFormatterMediumStyle

Specifies a medium style, typically with abbreviated text, such as “Nov 23, 1937”.

Equal to kCFDateFormatterMediumStyle.

Available in Mac OS X v10.4 and later.
NSDateFormatterLongStyle

Specifies a long style, typically with full text, such as “November 23, 1937” or “3:30:32pm”.

Equal to kCFDateFormatterLongStyle.

Available in Mac OS X v10.4 and later.
NSDateFormatterFullStyle

Specifies a full style with complete details, such as “Tuesday, April 12, 1952 AD” or “3:30:42pm PST”.

Equal to kCFDateFormatterFullStyle.

Available in Mac OS X v10.4 and later.
Discussion

The format for these date and time styles is not exact because they depend on the locale, user preference settings, and the operating system version. Do not use these constants if you want an exact format.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Foundation/NSDateFormatter.h*/

typedef enum {
   NSDateFormatterNoStyle     = kCFDateFormatterNoStyle,
   NSDateFormatterShortStyle  = kCFDateFormatterShortStyle,
   NSDateFormatterMediumStyle = kCFDateFormatterMediumStyle,
   NSDateFormatterLongStyle   = kCFDateFormatterLongStyle,
   NSDateFormatterFullStyle   = kCFDateFormatterFullStyle
} NSDateFormatterStyle;


@interface NSDateFormatter( ADD)

/*setDefaultFormatterBehavior:

Sets the default formatting behavior for instances of the class.

+ (void)setDefaultFormatterBehavior:(NSDateFormatterBehavior)behavior
Parameters
behavior

The default formatting behavior for instances of the class. For possible values, see NSDateFormatterBehavior.
Availability
Available in Mac OS X v10.4 and later.
See Also
+ defaultFormatterBehavior
– formatterBehavior
– setFormatterBehavior:*/
+ (void)setDefaultFormatterBehavior:(NSDateFormatterBehavior)behavior;

/*setTimeStyle:

Sets the time style of the receiver.

- (void)setTimeStyle:(NSDateFormatterStyle)style
Parameters
style

The time style for the receiver. For possible values, see NSDateFormatterStyle.
Availability
Available in Mac OS X v10.4 and later.
See Also
– timeStyle*/
- (void)setTimeStyle:(NSDateFormatterStyle)style;

/*setDateStyle:

Sets the date style of the receiver.

- (void)setDateStyle:(NSDateFormatterStyle)style
Parameters
style

The date style of the receiver. For possible values, see NSDateFormatterStyle.
Availability
Available in Mac OS X v10.4 and later.
See Also
– dateStyle.*/
- (void)setDateStyle:(NSDateFormatterStyle)style;

/*stringFromDate:

Returns a string representation of a given date formatted using the receiver’s current settings.

- (NSString *)stringFromDate:(NSDate *)date
Parameters
date

The date to format.
Return Value

A string representation of date formatted using the receiver’s current settings.
Availability
Available in Mac OS X v10.4 and later.
See Also
– dateFromString:*/

- (NSString *)stringFromDate:(NSDate *)date;

/*getObjectValue:forString:range:error:

Returns by reference a date representation of a given string and the range of the string used, and returns a Boolean value that indicates whether the string could be parsed.

- (BOOL)getObjectValue:(id *)objforString:(NSString *) stringrange:(inout NSRange *)rangep error:(NSError **)error
Parameters
obj

If the receiver is able to parse string, upon return contains a date representation of string.
string

The string to parse.
rangep

If the receiver is able to parse string, upon return contains the range of string used to create the date.
error

If the receiver is unable to create a date by parsing string, upon return contains an NSError object that describes the problem.
Return Value

YES if the receiver can create a date by parsing string, otherwise NO.
Availability
Available in Mac OS X v10.4 and later.
See Also
– dateFromString:
– stringForObjectValue:*/
- (BOOL)getObjectValue:(id *)obj forString:(NSString *) string range:(inout NSRange *)rangep    error:(NSError **)error;



@end

