#ifndef ADD_NSAPPLICAYION_H
#define ADD_NSAPPLICAYION_H

/*NSApplicationDelegateReply

These constants indicate whether or not a copy or print operation was successful, was cancelled, or failed. These constants are used by the replyToOpenOrPrint: method.

typedef enum NSApplicationDelegateReply {
   NSApplicationDelegateReplySuccess = 0,
   NSApplicationDelegateReplyCancel = 1,
   NSApplicationDelegateReplyFailure = 2
} NSApplicationDelegateReply;
Constants
NSApplicationDelegateReplySuccess

Indicates the operation succeeded.

Available in Mac OS X v10.3 and later.
NSApplicationDelegateReplyCancel

Indicates the user cancelled the operation.

Available in Mac OS X v10.3 and later.
NSApplicationDelegateReplyFailure

Indicates an error occurred processing the operation.

Available in Mac OS X v10.3 and later.
Availability
Available in Mac OS X v10.3 and later.
Declared In
NSApplication.h*/
typedef enum NSApplicationDelegateReply {
   NSApplicationDelegateReplySuccess = 0,
   NSApplicationDelegateReplyCancel = 1,
   NSApplicationDelegateReplyFailure = 2
} NSApplicationDelegateReply;



/*NSApplicationLoad

Startup function to call when running Cocoa code from a Carbon application.

BOOL NSApplicationLoad(void)
Discussion

If NSApplication is not already initialized, initializes it and sets up event handlers for Cocoa. You typically call this before calling other Cocoa code in a plug-in loaded into a primarily Carbon application. A return value of YES indicates that NSApplication was successfully initialized for the Carbon application.
Availability
Available in Mac OS X v10.2 and lat*/
BOOL NSApplicationLoad(void);


@interface NSApplication (hys)

/*replyToOpenOrPrint:

Handles errors that might occur when the user attempts to open or print files.

- (void)replyToOpenOrPrint:(NSApplicationDelegateReply)reply
Discussion

Delegates should invoke this method if an error is encountered in the application:openFiles: or application:printFiles: delegate methods. Possible values for reply are described in “Constants”.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)replyToOpenOrPrint:(NSApplicationDelegateReply)reply;

@end

#endif
