#import <XgridFoundation/XGConnection.h>

@implementation XGConnection 

/*setAuthenticator:


Sets the authenticator of the receiver. 
- (void)setAuthenticator:(XGAuthenticator *)authenticator;
Discussion

The authenticator is retained. The authenticator will be used by the connection if the client or controller requires the connection to be authenticated.*/
- (void)setAuthenticator:(XGAuthenticator *)authenticator{}

/*name


Returns the name of the connection. This may be the name of the netService or the hostname, depending on which the receiver was initialized with. 
- (NSString *)name;
method result
The name of the receiver.*/
- (NSString *)name{}

/*error


Returns the error of the receiver. 
- (NSError *)error;
method result
The error of the receiver. 
Discussion

The error is nil during the Opening and Closing states. The error represents success if the connection is in the Open state. If the connection closes due to an error, then this will be set to that error. If the connection closes due to a -close message, then this will be a success error.*/
- (NSError *)error{}


/*close


Starts closing the connection from the client to the controller. 
- (void)close;
Discussion

This method may only be called when the connection is in the Opening or Open states.*/
- (void)close{}


/*open


Starts opening the connection from the client to the controller. 
- (void)open;
Discussion

This method may only be called when the connection is in the Closed state.*/
- (void)open{}

/*initWithNetService:


Initializes a XGConnection object with a NSNetService. 
- (id)initWithNetService:(NSNetService *)netService;
Parameter Descriptions
netService
The net service to connect to. Must not be nil.
method result
An initialized XGConnection object.*/
- (id)initWithNetService:(NSNetService *)netService{}



/*initWithHostname:portnumber:


Initializes a XGConnection object with a hostname and portnumber. 
- (id)initWithHostname:(NSString *)hostname portnumber:(UInt32)portnumber;
Parameter Descriptions
hostname
The hostname to connect to. May be a name or address. Must not be nil.
portnumber
The portnumber to connect to. If portnumber is 0 then the default portnumber will be used.*/
- (id)initWithHostname:(NSString *)hostname portnumber:(UInt32)portnumber{}


/*delegate


Returns the delegate of the receiver. 
- (id)delegate;
method result
The delegate of the receiver.*/
- (id)delegate{}



/*setDelegate:


Sets the delegate of the receiver. 
- (void)setDelegate:(id)delegate;
Parameter Descriptions
delegate
The delegate.
Discussion

The delegate is not retained. If the delegate implements any of the methods in the XGConnectionDelegate protocol then it will receive callbacks when connection events occur, prior to the notification of key-value observers.*/
- (void)setDelegate:(id)delegate{}



/*authenticator


Returns the authenticator of the receiver. 
- (XGAuthenticator *)authenticator;
method result
The authenticator of the receiver.*/
- (XGAuthenticator *)authenticator{}



@end


