#import <WebKit/WebView.h>

@implementation  WebView
/*setUIDelegate:

Sets the receiver's user interface delegate.

- (void)setUIDelegate:(id)anObject
Discussion

This method sets the receiver’s user interface delegate to anObject, which conforms to the WebUIDelegate informal protocol.
Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.
See Also
– UIDelegate*/
- (void)setUIDelegate:(id)anObject{}

/*setResourceLoadDelegate:

Sets the receiver's resource load delegate.

- (void)setResourceLoadDelegate:(id)delegate
Discussion

This method sets the receiver’s resource load delegate to anObject, which conforms to the WebResourceLoadDelegate informal protocol.
Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.
See Also
– resourceLoadDelegate*/
- (void)setResourceLoadDelegate:(id)delegate{}


/*mainFrame

Returns the main frame, the root of the WebFrame hierarchy for this page. 

- (WebFrame *)mainFrame
Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.*/
- (WebFrame *)mainFrame{}
/*windowScriptObject

Returns the receiver’s window object from the scripting environment. 

- (WebScriptObject *)windowScriptObject
Availability
Available in Mac OS X v10.3.9 and later.
See Also
– objectForWebScript (WebPlugIn) (WebFrameLoadDelegate)
– webView:windowScriptObjectAvailable:*/
- (WebScriptObject *)windowScriptObject{}

/*stringByEvaluatingJavaScriptFromString:

Returns the result of running a script.

- (NSString *)stringByEvaluatingJavaScriptFromString:(NSString *)script
Discussion

Returns the result of running a JavaScript specified by script, or nil if the script failed.
Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.*/
- (NSString *)stringByEvaluatingJavaScriptFromString:(NSString *)script{}

@end