#include <DrawSprocket/DrawSprocket.h>


/*DSpStartup

Initializes DrawSprocket. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpStartup ();
Parameters
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

You must call this function before attempting to call any DrawSprocket functions (except for DSpGetVersion ). 

Note that the debug version of DrawSprocket will notify you if you did not call the DSpStartup function. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpStartup (){};


/*DSpShutdown

Shuts down DrawSprocket. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpShutdown ();
Parameters
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

You must call this function before quitting the application. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpShutdown (){};

/*DSpGetFirstContext

Obtains the first context in the list of contexts available for a specified display. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpGetFirstContext (
   DisplayIDType inDisplayID,
   DSpContextReference * outContext
);
Parameters
inDisplayID

The ID of the display whose context you desire. You can obtain the display ID by calling the Display Manager. 
outContext

On return, a reference to the first context in the list of available contexts for the specified display. You cannot use this context with any function other than DSpContext_GetAttributes, DSpContext_GetFlattendSize, DSpContext_Flatten, and DSpContext_GetDisplayID unless you reserve it with DSpContext_Reserve. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

Using the function DSpGetFirstContext in combination with DSpGetNextContext allows you to iterate over the list of contexts and choose one that best suits your needs. You may also have DrawSprocket find one for you with DSpFindBestContext or let the user select one by calling DSpUserSelectContext. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpGetFirstContext (
   DisplayIDType inDisplayID,
   DSpContextReference * outContext
){};


/*DSpContext_GetAttributes

Obtains the attributes of a given context. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

   OSStatus DSpContext_GetAttributes(
   DSpContextReferenceConst   inContext,
   DSpContextAttributesPtr    outAttributes)
Parameters
inContext

The context whose attributes you want to obtain.
outAttributes

On return, outAttributes points to a context attributes structure. See DSpContextAttributes for more information. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
 OSStatus DSpContext_GetAttributes(
   DSpContextReferenceConst   inContext,
   DSpContextAttributesPtr    outAttributes){};


/*DSpGetNextContext

Obtains the next context in a list of available contexts for a display. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpGetNextContext (
   DSpContextReference inCurrentContext,
   DSpContextReference * outContext
);
Parameters
inCurrentContext

A reference to a context in the list of contexts available for a display. This should be a reference that was just returned by DSpGetFirstContext or DSpGetNextContext. If this parameter contains the last context in the list, DSpGetNextContext returns an error. 
outContext

On return, a reference to the next context in the list of available contexts.
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

Using the function DSpGetNextContext in combination with DSpGetFirstContext allows you to iterate over the list of contexts and choose one that best suits your needs. For example, you could have code such as the following:DSpContextReference theContext;
theError = DSpGetFirstContext(theDisplayID, &theContext)
/ process the error *
while (theContext)
{
    / process the context *
    / get the next context *
    theError = DSpGetNextContext(theContext, &theContext)
    / process the error *
}


You may also have DrawSprocket find a display context for you by calling DSpFindBestContext or DSpFindBestContextOnDisplayID. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpGetNextContext (
   DSpContextReference inCurrentContext,
   DSpContextReference * outContext
){};


/*DSpFindBestContext

Finds the context that best matches the requirements you specify. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpFindBestContext (
   DSpContextAttributesPtr inDesiredAttributes,
   DSpContextReference * outContext
);
Parameters
inDesiredAttributes

A pointer to a context attributes structure describing the desired display characteristics of the context, such as display height and width, preferred pixel depth, and color capability. See DSpContextAttributes for more information about this structure. 
outContext

On return, a reference to the context that best meets or exceeds the specified attribute requirements, or NULL if no such context exists. 
Return Value

A result code. See “Game Sprockets Result Codes”. If no context meets the requirements you specified, the function returns kDSpContextNotFoundErr.
Discussion

Even if the call to DSpFindBestContext returns successtully, the game should check the attributes of the chosen context by calling the function DSpContext_GetAttributes. It is possible that the game may want to use attributes of the context that exceed those asked for. For example, the game may request a mode such as 320x200x8 but the best match is a 640x480x8 display; the game can adapt to a full screen mode once it is aware of the situation. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpFindBestContext (
   DSpContextAttributesPtr inDesiredAttributes,
   DSpContextReference * outContext
){};

/*DSpContext_GetDisplayID

Obtains the ID of the display a context is associated with. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_GetDisplayID (
   DSpContextReferenceConst inContext,
   DisplayIDType * outDisplayID
);
Parameters
inContext

A reference to the context whose monitor display ID you want to determine. 
outDisplayID

On return, the display ID for the monitor associated with the context. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

Note that 3D hardware accelerators (such as RAVE) typically must draw using a graphics device ( GDevice) rather than a graphics port. To do so, you can call DSpContext_GetDisplayID to get the display ID of the device associated with the context and then call the Display Manager function DMGetDeviceByDisplayID to obtain the GDevice. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_GetDisplayID (
   DSpContextReferenceConst inContext,
   DisplayIDType * outDisplayID
){};


/*DSpContext_Reserve

Reserves a context so that you can begin using it in your game. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_Reserve (
   DSpContextReference inContext,
   DSpContextAttributesPtr inDesiredAttributes
);
Parameters
inContext

A reference to the context to reserve. When the context is reserved, it is in the inactive state. There will be no visible indication that the context has been reserved at this point. To enable your context, call DSpContext_SetState. The context will show up on the display once the context has been placed in the active state. 
inDesiredAttributes

A pointer to an attributes structure that specifies the configuration you would like for the display when it is in the active or paused state. If you would like to override the attributes of the context, you may do so in the attributes structure. For example, if you ask for a 320x240x16 display but the closest match is a context that is 640x480x32, passing in your requested attributes when you reserve the context will cause the DSpContext_GetBackBuffer function to return a graphics pointer that refers to a 320x240x16 drawing environment. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

You should turn off features that you are not interested in when you reserve the context. For example, if the context supports page flipping (and you know this because you requested the actual capabilities of the context using DSpContext_GetAttributes), you can turn off the page-flipping bit in your desired attributes so that you will be assured of using software buffering.

You should only specify a back buffer bit depth different from the display bit depth when you absolutely must, as it is the worst case scenario for DrawSprocket and will result in a synchronous call to CopyBits to bring your back buffer to the display.

To release a reserved context, you must call the function DSpContext_Release. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_Reserve (
   DSpContextReference inContext,
   DSpContextAttributesPtr inDesiredAttributes
){};



/*DSpContext_FadeGammaOut

Completely fades out a display to a color of your choice. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_FadeGammaOut (
   DSpContextReference inContext,
   RGBColor * inZeroIntensityColor
);
Parameters
inContext

A reference to the context whose display is to be faded. The function fades the display from 100 percent to 0 percent intensity over a period of one second. If you pass NULL for this parameter, the fade operation applies simultaneously to all displays. 
inZeroIntensityColor

A pointer to the color that is to correspond to zero intensity. If you pass NULL for this parameter, the zero-intensity color is black. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

The initial gamma is that set by DrawSprocket when DSpStartup was called, or the last gamma value set by calling the DSpContext_FadeGamma function. If you had changed the system gamma to a different value, you may see a flash at the beginning of the fade due to the change in the initial gamma. 

A key press or a mouse button click will jump the fade to its end point immediately. 

You can perform a manual fade with the DSpContext_FadeGamma function. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpContext_FadeGammaOut (
   DSpContextReference inContext,
   RGBColor * inZeroIntensityColor
){};


/*DSpGetVersion

Determines the version of DrawSprocket installed on the host computer. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

NumVersion DSpGetVersion ();
Parameters
Return Value

The version number of DrawSprocket installed. 
Discussion
Special Considerations
Version Notes

Introduced with DrawSprocket 1.7. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
NumVersion DSpGetVersion (){};

/*DSpContext_FadeGammaIn

Completely fades in a display to a color of your choice. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_FadeGammaIn (
   DSpContextReference inContext,
   RGBColor * inZeroIntensityColor
);
Parameters
inContext

A reference to the context whose display is to be faded. The function fades the display from 0 percent to 100 percent intensity over a period of one second. If you pass NULL for this parameter, the fade operation applies simultaneously to all displays. 
inZeroIntensityColor

The color that is to correspond to zero intensity. If you pass NULL for this parameter, the zero-intensity color is black. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

A key press or a mouse-button click will jump the fade to its end point immediately. 

You can perform a manual fade with the function DSpContext_FadeGamma. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_FadeGammaIn (
   DSpContextReference inContext,
   RGBColor * inZeroIntensityColor
){};


/*DSpContext_GetCLUTEntries

Retrieves one or more color entries from a color lookup table. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_GetCLUTEntries (
   DSpContextReferenceConst inContext,
   ColorSpec * outEntries,
   UInt16 inStartingEntry,
   UInt16 inLastEntry
);
Parameters
inContext

The context whose color lookup table is to be accessed. 
outEntries

On return, an array of color specification records that contain the retrieved table entries. 
inStartingEntry

The (zero-based) index position in the color lookup table of the first entry to retrieve. 
inLastEntry

The number of entries to retrieve.
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

After you get the entries you can modify them and reassign them to the color table, for purposes such as color-table animation, with the function DSpContext_SetCLUTEntries. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_GetCLUTEntries (
   DSpContextReferenceConst inContext,
   ColorSpec * outEntries,
   UInt16 inStartingEntry,
   UInt16 inLastEntry
){};


/*DSpContext_SetCLUTEntries

Assigns one or more color entries to a color lookup table. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_SetCLUTEntries (
   DSpContextReference inContext,
   const ColorSpec * inEntries,
   UInt16 inStartingEntry,
   UInt16 inLastEntry
);
Parameters
inContext

The context whose color lookup table is to be modified. 
inEntries

A pointer to an array of color specification records. 
inStartingEntry

The (zero-based) index position in the color lookup table of the first entry to replace. 
inLastEntry

The number of entries to replace.
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

The DSpContext_SetCLUTEntries function allows you to change a range of entries in a color lookup table, for purposes such as color-table animation.

Because of video hardware limitations, the changes you make to a color table with this function may not take effect until the next vertical retrace. Nevertheless, this function attempts to execute asynchronously and return immediately, so your program can continue execution without having to wait for the changes to be made. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_SetCLUTEntries (
   DSpContextReference inContext,
   const ColorSpec * inEntries,
   UInt16 inStartingEntry,
   UInt16 inLastEntry
){};

/*DSpSetBlankingColor

Assigns a background color to the blanking window for all displays. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpSetBlankingColor (
   const RGBColor * inRGBColor
);
Parameters
inRGBColor

A pointer to the background color to use for the blanking window. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

The blanking color replaces the desktop and system adornments, such as the menu bar, for all display devices as long as any context is active. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpSetBlankingColor (
   const RGBColor * inRGBColor
){};


/*DSpContext_Restore

Restores a context that was saved previously, most likely to preserve a user’s preferences. 

Unsupported

OSStatus DSpContext_Restore (
   void *inFlatContext,
   DSpContextReference *outRestoredContext
);
Parameters
inFlatContext

A pointer to the flattened context. Typically, the context would have been saved out to disk and reloaded on a later execution of the game before calling this function. 
outRestoredContext

On return, a reference to the restored context, if it exists. 
Return Value
Discussion

If DSpContext_Restore can’t find a match, the user probably has reconfigured the displays since the last time your game was run, and the call returns an error. This function has a high probability of failure, so your game should not rely on being able to restore the context. However, the game should attempt to do so as part of the normal saving of the user preferences.

If you save a context, flatten it by calling DSpContext_Flatten before you first make the context’s play state active otherwise, the saved data will not contain the proper information with which to locate the display. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_Restore (
   void *inFlatContext,
   DSpContextReference *outRestoredContext
){};


/*DSpContext_Flatten

Converts a context into a format suitable for saving to disk—for example, to save user preferences.

Unsupported

OSStatus DSpContext_Flatten (
   DSpContextReference inContext,
   void *outFlatContext
);
Parameters
inContext

A reference to the context to be flattened. 
outFlatContext

A pointer to the buffer to hold the flattened context. The buffer must be large enough to hold the flattened context. You can find out the correct size by calling DSpContext_GetFlattenedSize. On return, the buffer holds the flattened context. 
Return Value
Discussion
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/
OSStatus DSpContext_Flatten (
   DSpContextReference inContext,
   void *outFlatContext
){};



/*DSpContext_GetFlattenedSize

Determines how much memory is required to store a flattened version of a context.

Unsupported

OSStatus DSpContext_GetFlattenedSize (
   DSpContextReference inContext,
   UInt32 *outFlatContextSize
);
Parameters
inContext

A reference to the context you intend to flatten. 
outFlatContextSize

On return, the number of bytes required to store a flattened version of the context. 
Return Value
Discussion

After calling the DSpContext_GetFlattenedSize function, you can then allocate a buffer of outFlatContextSize size and pass it to DSpContext_Flatten. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_GetFlattenedSize (
   DSpContextReference inContext,
   UInt32 *outFlatContextSize
){};

/*DSpCanUserSelectContext

Determines whether there is a meaningful choice of contexts to present to the user with the DSpUserSelectContext function.

Unsupported

OSStatus DSpCanUserSelectContext (
   DSpContextAttributesPtr inDesiredAttributes,
   Boolean *outUserCanSelectContext
);
Parameters
inDesiredAttributes

A pointer to a context attributes structure that specifies the required attributes. 
outUserCanSelectContext

On return, the value is true if there are multiple contexts that meet the specified attribute requirements; false if there are not. 
Return Value

A result code.
Discussion

This function DSpCanUserSelectContext allows you to check whether calling DSpUserSelectContext is useful so as to avoid presenting the user with a selection dialog box when there is no choice of displays. 
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/
OSStatus DSpCanUserSelectContext (
   DSpContextAttributesPtr inDesiredAttributes,
   Boolean *outUserCanSelectContext
){};


/*DSpUserSelectContext

Presents a dialog box that allows the user to select a display.

Unsupported

OSStatus DSpUserSelectContext (
   inDesiredAttributes,
   DisplayIDType inDialogDisplayLocation,
   DSpEventUPP inEventProc,
   DSpContextReference *outContext
);
Parameters
inDesiredAttributes

A pointer to an attributes structure that specifies a minimum set of required display characteristics. 
inDialogDisplayLocation

The ID of the display on which to present the selection dialog box. If this parameter is 0, DrawSprocket positions the dialog box on the main screen. 
inEventProc

A pointer to an application-defined event-processing function that allows you to handle events received by the dialog box that DrawSprocket cannot process, such as update events, in your game context area. See the function DSpEventProcPtr for more information about implementing this function. 
outContext

On return, a reference to a context. 
Return Value

A result code.
Discussion

In the selection dialog box all graphics devices appear, although the user can select only those contexts that meet or exceed the minimum characteristics given in the inDesiredAttributes parameter. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0. 
Declared In
DrawSprocket.h*/
OSStatus DSpUserSelectContext (
    DSpContextAttributesPtr  inDesiredAttributes,
   DisplayIDType inDialogDisplayLocation,
   DSpEventUPP inEventProc,
   DSpContextReference *outContext
){};

/*DSpAltBuffer_Dispose

Disposes of an alternate buffer.

Unsupported

OSStatus DSpAltBuffer_Dispose (
   DSpAltBufferReference inAltBuffer
);
Parameters
inAltBuffer

A reference to the buffer to dispose. 
Return Value
Discussion
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/

OSStatus DSpAltBuffer_Dispose (
   DSpAltBufferReference inAltBuffer
){};



/*DSpContext_SwapBuffers

Draws a context’s back buffer to the screen. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_SwapBuffers (
   DSpContextReference inContext,
   DSpCallbackUPP inBusyProc,
   void * inUserRefCon
);
Parameters
inContext

A reference to the context whose buffers are to be swapped. The function causes the invalid parts of the back buffer of the context specified in this parameter (or the entire back buffer, if its invalid-rectangle list is empty) to be drawn to the screen. 
inBusyProc

A pointer to a callback function that performs any required pre-swap tasks. See DSpCallbackProcPtr for more information about implementing this function. 
inUserRefCon

A reference constant to be handed back by DrawSprocket when it calls the callback specified by the inBusyProc parameter. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

This function returns immediately, even if the buffer swap has not yet occurred. To determine when the next call to DSpContext_GetBackBuffer will not block, you can repeatedly call the function DSpContext_IsBusy until it returns a value of false.

Before performing the buffer swap, DrawSprocket repeatedly calls an application-supplied callback function, DSpContext_SwapBuffers

Draws a context’s back buffer to the screen. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_SwapBuffers (
   DSpContextReference inContext,
   DSpCallbackUPP inBusyProc,
   void * inUserRefCon
);
Parameters
inContext

A reference to the context whose buffers are to be swapped. The function causes the invalid parts of the back buffer of the context specified in this parameter (or the entire back buffer, if its invalid-rectangle list is empty) to be drawn to the screen. 
inBusyProc

A pointer to a callback function that performs any required pre-swap tasks. See DSpCallbackProcPtr for more information about implementing this function. 
inUserRefCon

A reference constant to be handed back by DrawSprocket when it calls the callback specified by the inBusyProc parameter. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

This function returns immediately, even if the buffer swap has not yet occurred. To determine when the next call to DSpContext_GetBackBuffer will not block, you can repeatedly call the function DSpContext_IsBusy until it returns a value of false.

Before performing the buffer swap, DrawSprocket repeatedly calls an application-supplied callback function, pointed to by the inBusyProc parameter, to make sure that any constraints you impose are satisfied before the swap occurs. When DrawSprocket calls the callback routine, it passes the reference constant you passed to DspContext_SwapBuffers in the refCon parameter.

See the callback function under DSpCallbackProcPtr for more information. 

In a worst case scenario where the back buffer and the display have different bit depths, DSpContext_SwapBuffers immediately calls CopyBits to transfer the data. To avoid this, and to use the optimized DrawSprocket blitters, always insure that your back buffer and display bit depths are identical. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.hpointed to by the inBusyProc parameter, to make sure that any constraints you impose are satisfied before the swap occurs. When DrawSprocket calls the callback routine, it passes the reference constant you passed to DspContext_SwapBuffers in the refCon parameter.

See the callback function under DSpCallbackProcPtr for more information. 

In a worst case scenario where the back buffer and the display have different bit depths, DSpContext_SwapBuffers immediately calls CopyBits to transfer the data. To avoid this, and to use the optimized DrawSprocket blitters, always insure that your back buffer and display bit depths are identical. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpContext_SwapBuffers (
   DSpContextReference inContext,
   DSpCallbackUPP inBusyProc,
   void * inUserRefCon
){};

/*DSpContext_InvalBackBufferRect

Invalidates a specific area of a context’s back buffer, so that only a portion of the screen needs to be redrawn when the buffers are next swapped.

Unsupported

OSStatus DSpContext_InvalBackBufferRect (
   DSpContextReference inContext,
   const Rect *inRect
);
Parameters
inContext

A reference to the context whose back buffer is to be invalidated. 
inRect

A pointer to a rectangle specifying the area (in back-buffer coordinates) to invalidate. 
Return Value

A result code.
Discussion

If you do not call this function between buffer swaps, the entire back buffer is considered invalid when a swap occurs. The invalid rectangles must be set prior to each call to DSpContext_SwapBuffers; the dirty rectangle list is emptied before DSpContext_GetBackBuffer returns the back buffer for re-use.

You can make multiple calls to this function between swaps to accumulate invalid rectangular areas. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/
OSStatus DSpContext_InvalBackBufferRect (
   DSpContextReference inContext,
   const Rect *inRect
){};


/*DSpContext_GetBackBuffer

Obtains the back buffer for the context. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_GetBackBuffer (
   DSpContextReference inContext,
   DSpBufferKind inBufferKind,
   CGrafPtr * outBackBuffer
);
Parameters
inContext

A reference to the context whose back buffer is to be returned. 
inBufferKind

The kind of buffer. Currently the only supported buffer kind is kDSpBufferKind_Normal. 
outBackBuffer

On return, a pointer to the back buffer (that is, to a CGrafPort). 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

The back buffer, which is where the game should draw to, is the next buffer that will be displayed on a call to the function DSpContext_SwapBuffers.

The pointer to the back buffer may change after a call to DSpContext_SwapBuffers, so you must call this function before rendering every frame.

If you have speDSpContext_GetBackBuffer

Obtains the back buffer for the context. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_GetBackBuffer (
   DSpContextReference inContext,
   DSpBufferKind inBufferKind,
   CGrafPtr * outBackBuffer
);
Parameters
inContext

A reference to the context whose back buffer is to be returned. 
inBufferKind

The kind of buffer. Currently the only supported buffer kind is kDSpBufferKind_Normal. 
outBackBuffer

On return, a pointer to the back buffer (that is, to a CGrafPort). 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

The back buffer, which is where the game should draw to, is the next buffer that will be displayed on a call to the function DSpContext_SwapBuffers.

The pointer to the back buffer may change after a call to DSpContext_SwapBuffers, so you must call this function before rendering every frame.

If you have specified an underlay for the context, the back buffer will have the underlay image restored before this call returns.

If there are no available back buffers (they are all queued up for display), this function will block until one is available. To avoid blocking, call the DSpContext_IsBusy function until it returns false.

Note that 3D hardware accelerators typically must draw using a graphics device ( GDevice) rather than a graphics port. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.hcified an underlay for the context, the back buffer will have the underlay image restored before this call returns.

If there are no available back buffers (they are all queued up for display), this function will block until one is available. To avoid blocking, call the DSpContext_IsBusy function until it returns false.

Note that 3D hardware accelerators typically must draw using a graphics device ( GDevice) rather than a graphics port. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_GetBackBuffer (
   DSpContextReference inContext,
   DSpBufferKind inBufferKind,
   CGrafPtr * outBackBuffer
){};



/*DSpAltBuffer_InvalRect

Invalidates a rectangle in an alternate buffer. 

Unsupported

OSStatus DSpAltBuffer_InvalRect (
   DSpAltBufferReference inAltBuffer,
   const Rect *inInvalidRect
);
Parameters
inAltBuffer

A reference to an alternate buffer. 
inInvalidRect

A pointer to the rectangle to be invalidated. 
Return Value
Discussion

For example, you must invalidate areas of an underlay you have changed so that the changes are transferred to the back buffer on the next call to DSpContextSwapBuffers.
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0. 
Declared In
DrawSprocket.h*/

OSStatus DSpAltBuffer_InvalRect (
   DSpAltBufferReference inAltBuffer,
   const Rect *inInvalidRect
){};

/*DSpAltBuffer_GetCGrafPtr

Obtains the drawing area for an alternate buffer. 

Unsupported

OSStatus DSpAltBuffer_GetCGrafPtr (
   DSpAltBufferReference inAltBuffer,
   DSpBufferKind inBufferKind,
   CGrafPtr *outCGrafPtr,
   GDHandle *outGDevice
);
Parameters
inAltBuffer

A reference to an alternate buffer. 
inBufferKind

The kind of buffer. Currently the only supported buffer kind is kDSpBufferKind_Normal. 
outCGrafPtr

On return, the graphics pointer associated with an alternate buffer. 
outGDevice

On return, a pointer to the graphics device associated with the CGrafPort. 
Return Value
Discussion

You must set both the proper graphics port ( CGrafPort) and graphics device ( GDevice) when you draw to DrawSprocket buffers to account for cases of multiple monitors and the like. 

After the DSpAltBuffer_GetCGrafPtr function returns, you can use the pointer indicated in outCGrafPtr to draw into the alternate buffer. After drawing into the alternate buffer, you should invalidate the rectangles that you have worked in using the function DSpAltBuffer_InvalRect. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/
OSStatus DSpAltBuffer_GetCGrafPtr (
   DSpAltBufferReference inAltBuffer,
   DSpBufferKind inBufferKind,
   CGrafPtr *outCGrafPtr,
   GDHandle *outGDevice
){};

/*DSpContext_SetUnderlayAltBuffer

Designates an alternate buffer to be used as the current underlay buffer for a context.

Unsupported

OSStatus DSpContext_SetUnderlayAltBuffer (
   DSpContextReference inContext,
   DSpAltBufferReference inNewUnderlay
);
Parameters
inContext

A reference to the context that uses the underlay. 
inNewUnderlay

A reference to the alternate buffer that holds the underlay. 
Return Value
Discussion

Underlay buffers are used to “clean” a back buffer when DSpContext_GetBackBuffer is called. When a back buffer is retrieved and there is an underlay buffer, the invalid areas in the back buffer are restored from the underlay buffer. This is most useful in sprite games, or in games where the background is static (or changes infrequently). 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/
OSStatus DSpContext_SetUnderlayAltBuffer (
   DSpContextReference inContext,
   DSpAltBufferReference inNewUnderlay
){};

/*DSpAltBuffer_New

Creates an alternate buffer for an underlay.

Unsupported

OSStatus DSpAltBuffer_New (
   DSpContextReference inContext,
   Boolean inVRAMBuffer,
   DSpAltBufferAttributes *inAttributes,
   DSpAltBufferReference *outAltBuffer
);
Parameters
inContext

A reference to the context for which you want to create an alternate buffer. 
inVRAMBuffer

A value of true requests that DrawSprocket create the buffer in VRAM if possible (it may be created in the current heap). A value of false means to create the buffer in the current heap. 
inAttributes

A pointer to a structure specifying additional attributes of the alternate buffer. See DSpAltBuffersAttributes for more information. If you pass NULL, the alternate buffer has the same attributes as the specified context. 
outAltBuffer

On return, a pointer to the alternate buffer reference. 
Return Value
Discussion

If you specify additional attributes in the inAttributes parameter, you cannot use the alternate buffer as an underlay buffer. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Declared In
DrawSprocket.h*/

OSStatus DSpAltBuffer_New (
   DSpContextReference inContext,
   Boolean inVRAMBuffer,
   DSpAltBufferAttributes *inAttributes,
   DSpAltBufferReference *outAltBuffer
){};

/*DSpContext_SetState

Sets the play state of a context. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_SetState (
   DSpContextReference inContext,
   DSpContextState inState
);
Parameters
inContext

A reference to the context whose play state you want to set. 
inState

A constant specifying the desired play state. Valid input values for this parameter are kDSpContextState_Active, kDSpContextState_Paused, and kDSpContextState_Inactive. See “Play State Constants” for more information. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

In summary, you can make these choices:
A context’s initial play state is inactive. When all contexts for a display are set to kDSpContextState_Inactive, the display looks exactly as it does when the user is using their Macintosh normally: the monitor resolutions are set to the default, the menu bar is available, and so on. 
Set the play state to kDSpContextState_Active to use the display. In this state, the attributes of the context are used to change the display resolution, remove the menu bar, and so on. When at least one context is active, all the display devices in the system are covered by a blanking window. When a context is in the active state, the display is completely owned by the game. 
Set the play state to kDSpContextState_Paused to temporarily restore system adornments, while maintaining the attributes used by the context. This gives the user the opportunity to use the menus and switch to other applications. While the context is in the paused state, it is very important to call DSpProcessEvent to allow DrawSprocket to correctly handle events such as suspend or resume (see DSpProcessEvent. Page flipping and double buffering are inactive in this state, and the context will be placed back at page 0 if page flipping was being used. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/
OSStatus DSpContext_SetState (
   DSpContextReference inContext,
   DSpContextState inState
){};

/*DSpContext_Release

Releases a context you are finished using. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSStatus DSpContext_Release (
   DSpContextReference inContext
);
Parameters
inContext

A reference to the context to be released. Releasing the context does not necessarily remove the blanking window from the corresponding display. All displays remain covered by the blanking window until all contexts have been released or put in an inactive play state. 
Return Value

A result code. See “Game Sprockets Result Codes”.
Discussion

You must release the context whether it was reserved or queued. 
Special Considerations

Do not call at interrupt time.
Version Notes

Introduced with DrawSprocket 1.0.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DrawSprocket.h*/

OSStatus DSpContext_Release (
   DSpContextReference inContext
){};
















