#include <DiscRecordingUI/DRBurnSession.h>


/*DRBurnSessionCreate


Creates a new burn session. 
extern DRBurnSessionRef DRBurnSessionCreate();  
Return Value

A reference to a new DRBurnSession. 
Availability
Introduced in Mac OS X v10.3.*/
DRBurnSessionRef DRBurnSessionCreate(){};


/*DRBurnSessionSetupDialog


Presents the setup interface as a modal dialog. 
extern SInt8 DRBurnSessionSetupDialog( 
    DRBurnSessionRef burnSession, 
    DRBurnSessionSetupDialogOptions*options, 
    DRBurnSessionSetupCallbacks*setupCallbacks);  
Parameters
burnSession
The burn session object
options
A pointer to a structure of type DRBurnSessionSetupDialogOptions . This pointer may be NULL if no custom configuration is required.
setupCallbacks
A pointer to a structure of type DRBurnSessionSetupCallbacks . This pointer may be NULL if no custom behavior is desired.
Return Value

Returns one of the constants defined by Burn Session Dialog Result Codes . 
Discussion 

This function present the user with a modal dialog that allows them to configure a burn to their custom settings. These include: the device to use, whether or not to eject the media when finished, the burn speed and others. The function does not return until the user dismissed the dialog. 
Availability
Introduced in Mac OS X v10.3.*/
SInt8 DRBurnSessionSetupDialog( 
    DRBurnSessionRef burnSession, 
    DRBurnSessionSetupDialogOptions*options, 
    DRBurnSessionSetupCallbacks*setupCallbacks){};  


/*DRBurnSessionBeginProgressDialog


Presents the progress interface as a non-modal dialog. 
extern void DRBurnSessionBeginProgressDialog( 
    DRBurnSessionRef burnSession, 
    CFTypeRef layout, 
    DRBurnSessionProgressDialogOptions*options, 
    DRBurnSessionProgressCallbacks*progressCallbacks);  
Parameters
burnSession
The burn session object
layout
The track layout to be used for the burn.
options
A pointer to a structure of type DRBurnSessionSetupDialogOptions .
progressCallbacks
A pointer to a structure of type DRBurnSessionProgressCallbacks . This pointer may be NULL if no custom behavior is desired.
Discussion 

This function present the user with a non-modal dialog that shows the burn progress. 
Availability
Introduced in Mac OS X v10.3.*/
void DRBurnSessionBeginProgressDialog( 
    DRBurnSessionRef burnSession, 
    CFTypeRef layout, 
    DRBurnSessionProgressDialogOptions*options, 
    DRBurnSessionProgressCallbacks*progressCallbacks){};  


