#import <CoreData/NSManagedObjectModel.h>


@implementation NSManagedObjectModel
/*mergedModelFromBundles:

Finds all models in the specified bundles, merges them, and returns the merged model.

+ (NSManagedObjectModel *)mergedModelFromBundles:(NSArray *)bundles
Parameters
bundles

An array of instances of NSBundle to search. If you specify nil, then the main bundle is searched.
Return Value

A model created by merging all models found in bundles.
Availability
Available in Mac OS X v10.4 and later.
See Also
+ modelByMergingModels:
– initWithContentsOfURL:*/
+ (NSManagedObjectModel *)mergedModelFromBundles:(NSArray *)bundles{}

/*entities

Returns the entities of the receiver.

- (NSArray *)entities
Return Value

The entities of the receiver.
Discussion

Entities are instances of NSEntityDescription. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– entitiesByName
– entitiesForConfiguration:
– setEntities:
– setEntities:forConfiguration:*/
- (NSArray *)entities{}


/*entitiesByName

Returns the entities of the receiver in a dictionary.

- (NSDictionary *)entitiesByName
Return Value

The entities of the receiver in a dictionary, where the keys in the dictionary are the names of the corresponding entities. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– entities
– entitiesForConfiguration:
– setEntities:
– setEntities:forConfiguration:
+ entityForName:inManagedObjectContext:*/
- (NSDictionary *)entitiesByName{}





@end
