#import <GNUstepBase/GSVersionMacros.h>

#include <Foundation/NSObject.h>
#include <AppKit/NSOpenGL.h>

//@implementation  NSOpenGLPixelFormat (ADD)

//@end

@implementation NSOpenGLContext (hys)


/*CGLContextObj

Returns the low-level, platform-specific Core OpenGL (CGL) context object represented by the receiver.

- (void *)CGLContextObj
Return Value

A pointer to the CGLContextObj data type represented by the receiver. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void *)CGLContextObj{}


/*setTextureImageToPixelBuffer:colorBuffer:

Attaches the image data in the specified pixel buffer to the texture object currently bound by the receiver.

- (void)setTextureImageToPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer colorBuffer:(unsigned long)source
Parameters
pixelBuffer

The pixel buffer to attach.
source

An OpenGL constant indicating which of the pixel buffer's color buffers to use. Potential values for this parameter include GL_FRONT, GL_BACK, and GL_AUX0. 
Discussion

This method corresponds to the Core OpenGL method CGLTexImagePBuffer. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setTextureImageToPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer colorBuffer:(unsigned long)source{}

/*setPixelBuffer:cubeMapFace:mipMapLevel:currentVirtualScreen:

Attaches the specified pixel buffer to the receiver.

- (void)setPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer cubeMapFace:(unsigned long)face mipMapLevel:(long)level currentVirtualScreen:(int)screen
Parameters
pixelBuffer

The pixel buffer to attach.
face

For pixel buffers with a texture target of GL_CUBE_MAP, this parameter should be zero or one of the following values:
GL_TEXTURE_CUBE_MAP_POSITIVE_X
GL_TEXTURE_CUBE_MAP_POSITIVE_Y
GL_TEXTURE_CUBE_MAP_POSITIVE_Z
GL_TEXTURE_CUBE_MAP_NEGATIVE_X
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
level

The desired mipmap level for rendering. This value must be less than or equal to the maximum texture mipmap level of pixelBuffer (accessible through an NSOpenGLPixelBuffer object’s textureMaxMipMapLevel method). 
screen

The virtual screen of the receiver (if applicable) should be set to the same value as the current virtual screen you are using for rendering onscreen
Discussion

The NSOpenGLPixelBuffer object gives the receiver access to accelerated offscreen rendering in the pixel buffer, which is primarily used for textures. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– pixelBufferCubeMapFace
– pixelBufferMipMapLevel
– setCurrentVirtualScreen:
– initWithTextureTarget:textureInternalFormat:textureMaxMipMapLevel:pixelsWide:pixelsHigh: (NSOpenGLPixelBuffer)*/

- (void)setPixelBuffer:(NSOpenGLPixelBuffer *)pixelBuffer cubeMapFace:(unsigned long)face mipMapLevel:(long)level currentVirtualScreen:(int)screen{}


@end

@implementation  NSOpenGLPixelBuffer : NSObject

/*pixelsWide

Returns the width of the receiver’s texture (in pixels).

- (int)pixelsWide
Return Value

The width of the texture (in pixels).
Availability
Available in Mac OS X v10.3 and later.
See Also
– pixelsHigh*/
- (int)pixelsWide{};

/*pixelsHigh

Returns the height of the receiver’s texture (in pixels).

- (int)pixelsHigh
Return Value

The height of the texture (in pixels). 
Availability
Available in Mac OS X v10.3 and later.
See Also
– pixelsWide
pixelsWide*/
- (int)pixelsHigh{}

/*initWithTextureTarget:textureInternalFormat:textureMaxMipMapLevel:pixelsWide:pixelsHigh:

Returns an NSOpenGLPixelBuffer object initialized with the specified parameters. 

- (id)initWithTextureTarget:(unsigned long)target textureInternalFormat:(unsigned long)format textureMaxMipMapLevel:(long)maxLevel pixelsWide:(int)pixelsWide pixelsHigh:(int)pixelsHigh
Parameters
target

The texture object. This value should be one of the following: GL_TEXTURE_2D,GL_TEXTURE_CUBE_MAP, or GL_TEXTURE_RECTANGLE_EXT. 
format

The base internal format of the texture. This value should be GL_RGB, GL_RGBA, or GL_DEPTH_COMPONENT. 
maxLevel

The desired maximum mipmap level of the structure, starting with zero.
pixelsWide

The width of the texture (in pixels) in the pixel buffer.
pixelsHigh

The height of the texture (in pixels) in the pixel buffer.
Return Value

An initialized NSOpenGLPixelBuffer object or nil if the initialization failed. Initialization can fail if there is inconsistency among the parameter values. See the OpenGL documentation for glTexImage2D for more information. 
Discussion

The value you pass to the target parameter defines several other constraints that are then applied to the remaining parameters. The list below gives the values you can pass to target and the additional constraints. 
GL_TEXTURE_2D - the values in pixelsWide and pixelsHigh must be powers of two. 
GL_TEXTURE_CUBE_MAP - the values in pixelsWide and pixelsHigh must be powers of two and they must be equal.
GL_TEXTURE_RECTANGLE_EXT - maxLevel must be zero. 
Availability
Available in Mac OS X v10.3 and later.*/
- (id)initWithTextureTarget:(unsigned long)target textureInternalFormat:(unsigned long)format textureMaxMipMapLevel:(long)maxLevel pixelsWide:(int)pixelsWide pixelsHigh:(int)pixelsHigh{}

@end


@implementation  NSOpenGLPixelFormat (hys)

/*CGLPixelFormatObj

Returns the low-level, platform-specific Core OpenGL (CGL) pixel format object represented by the receiver.

- (void *)CGLPixelFormatObj
Return Value

A pointer to the underlying CGLPixelFormatObj object. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void *)CGLPixelFormatObj{}

@end