#import <Foundation/Foundation.h>
#import <XgridFoundation/XGResource.h>

@class XGFileInternal;
@class XGJob;

/*XGFileType

See Also:
XGFileType
typedef enum { 
    XGFileTypeNone = 0, 
    XGFileTypeRegular, 
    XGFileTypeStream 
} XGFileType; 
Constants
XGFileTypeNone
No file type.
XGFileTypeRegular
The file is regular.
XGFileTypeStream
The file is a stream.
Discussion

The type of file.*/
typedef enum { 
    XGFileTypeNone = 0, 
    XGFileTypeRegular, 
    XGFileTypeStream 
} XGFileType; 


@interface XGFile : NSObject

/*taskIdentifier


Returns the identifier of the task associated with the receiver. 
- (NSString *)taskIdentifier;
method result
The task identifier.*/
- (NSString *)taskIdentifier;

/*path


Returns the path of the receiver. 
- (NSString *)path;
method result
The path.*/
- (NSString *)path;

/*type


Returns the XGFileType of the receiver. 
- (XGFileType)type;
method result
The file type.*/
- (XGFileType)type;

@end

/*XGFileStandardOutputPath

extern NSString * const XGFileStandardOutputPath; 
Discussion

The standard output stream has this path.*/
extern NSString * const XGFileStandardOutputPath; 

/*XGFileStandardErrorPath

extern NSString * const XGFileStandardErrorPath; 
Discussion

The standard error stream has this path.*/
extern NSString * const XGFileStandardErrorPath; 
