#ifndef CVRETURN_H
#define CVRETURN_H

#include <TargetConditionals.h>

#include <QuartzCore/CVBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*Result Codes

The table below lists the result codes returned for Core Video. Note that these result codes are of type CVReturn, not type OSErr.Result Code	Value	Description
kCVReturnSuccess	0	
No error
kCVReturnFirst	-6660	
Placeholder to mark the beginning of Core Video result codes (not returned by any functions). 
kCVReturnError	-6660	
An otherwise undefined error occurred. 
kCVReturnInvalidArgument	-6661	
Invalid function parameter. For example, out of range or the wrong type. 
kCVReturnAllocationFailed	-6662	
Memory allocation for a buffer or buffer pool failed.
kCVReturnInvalidDisplay	-6670	
The display specified when creating a display link is invalid. 
kCVReturnDisplayLinkAlreadyRunning	-6671	
The specified display link is already running. 
kCVReturnDisplayLinkNotRunning	-6672	
The specified display link is not running. 
kCVReturnDisplayLinkCallbacksNotSet	-6673	
No callback registered for the specified display link. You must set either the output callback or both the render and display callbacks. 
kCVReturnInvalidPixelFormat	-6600	
The buffer does not support the specified pixel format. 
kCVReturnInvalidSize	-6601	
The buffer cannot support the requested buffer size (usually too big).
kCVReturnInvalidPixelBufferAttributes	-6602	
A buffer cannot be created with the specified attributes. 
kCVReturnPixelBufferNotOpenGLCompatible	-6603	
The pixel buffer is not compatible with OpenGL due to an unsupported buffer size, pixel format, or attribute. 
kCVReturnPoolAllocationFailed	-6690	
Allocation for a buffer pool failed, most likely due to a lack of resources. Check to make sure your parameters are in range. 
kCVReturnInvalidPoolAttributes	-6691	
A buffer pool cannot be created with the specified attributes. 
kCVReturnLast	-6699	
Placeholder to mark the end of Core Video result codes (not returned by any functions).*/
enum {
kCVReturnSuccess	=0	,
kCVReturnFirst	=-6660	,
kCVReturnError	=-6660	,
kCVReturnInvalidArgument	=-6661	,
kCVReturnAllocationFailed	=-6662	,
kCVReturnInvalidDisplay	=-6670	,
kCVReturnDisplayLinkAlreadyRunning	=-6671	,
kCVReturnDisplayLinkNotRunning	=-6672	,
kCVReturnDisplayLinkCallbacksNotSet=	-6673,	
kCVReturnInvalidPixelFormat	=-6600	,
kCVReturnInvalidSize	=-6601	,
kCVReturnInvalidPixelBufferAttributes	=-6602	,
kCVReturnPixelBufferNotOpenGLCompatible	=-6603	,
kCVReturnPoolAllocationFailed	=-6690	,
kCVReturnInvalidPoolAttributes	=-6691	,
kCVReturnLast	=-6699	
};

/*CVReturn

Defines the return error code for Core Video functions.

typedef int32_t CVReturn;
Discussion

See “Result Codes” for possible values. 
Availability
Available in Mac OS X v10.3 and later.*/
typedef int32_t CVReturn;



#ifdef __cplusplus
}
#endif
#endif