#ifndef PALETTES_H
#define PALETTES_H

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif



#include <AvailabilityMacros.h>
#include <HYS/QD/Palettes.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*SetPalette

Associates a palette with a window. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Not recommended.

void SetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   Boolean cUpdates
);
Parameters
dstWindow

A pointer to the window to which you want to assign a new palette. 
srcPalette

A handle to the palette you want to assign. 
cUpdates

A Boolean value in which your application specifies whether the window is to receive updates as a result of changes to the color environment. Specify TRUE if you want the window to be updated, even if the window is not the frontmost window. When a window is the frontmost window, changes to its palette cause it to get an update event regardless of how the cUpdates parameter is set. 
Discussion

You can use the NSetPalette function, which does the same thing as SetPalette, when you need greater flexibility in setting criteria for updates. The nCUpdates parameter for the NSetPalette function includes the option of turning off updates when the window is the frontmost window.

Use the NSetPalette function to associate a palette with a window but with additional options as to when an update event is triggered by changes to the color environment. 

Use the GetNewPalette function or the NewPalette function to create a new palette. To dispose of a palette, use the DisposePalette function. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
void SetPalette (
   WindowRef dstWindow,
   PaletteHandle srcPalette,
   Boolean cUpdates
);

/*GetGray

Determines the best intermediate color between two colors on a given graphics device. (Deprecated in Mac OS X v10.4. There is no replacement; 8-bit graphics mode is not supported by the Mac OS X GUI.)

Boolean GetGray (
   GDHandle device,
   const RGBColor * backGround,
   RGBColor * foreGround
);
Parameters
device

A handle to the graphics device for which an intermediate color or gray is needed. 
backGround

The RGBColor structure for one of the two colors for which you want an intermediate color. 
foreGround

On input, the RGBColor structure for the other of the two colors; upon completion, the best intermediate color between these two.
Return Value

If no gray is available (or if no distinguishable third color is available), the foreGround parameter is unchanged, and the function returns FALSE. If at least one gray or intermediate color is available, it is returned in the foreGround parameter, and the function returns TRUE. 
Discussion

The GetGray function determines the midpoint values for the red, green, and blue values of the two colors you specify in the backGround and foreGround parameters.

You can also use GetGray to return the best gray. For example, when dimming an object, supply black and white as the two colors, and GetGray returns the best available gray that lies between them. 
Special Considerations

For applications running in Mac OS X, the Palette Manager is no longer relevant because display devices always support direct color (pixel depth of 16 or 32 bits). The palette-based graphics model only works in 256-color (8-bit pseudocolor) modes of operation, which are not supported for the Mac OS X GUI.

There is some support for palettes in Quartz Services; see Quartz Display Services Reference.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Palettes.h*/
Boolean GetGray (
   GDHandle device,
   const RGBColor * backGround,
   RGBColor * foreGround
);


#ifdef __cplusplus
}
#endif
#endif