#ifndef DISPLAYS_H
#define DISPLAYS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef VIDEO_H
#include <QD/Video.h>
#endif

#ifndef CMAPPLICATION_H
#include <ColorSync/CMApplication.h>
#endif

#ifndef  APPLEEVENTS_H
#include <AE/AppleEvents.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DMExtendedNotificationProcPtr

Defines a pointer to an extended notification callback function.

typedef void (*DMExtendedNotificationProcPtr)
(
   void * userData,
   short theMessage,
   void * notifyData
);

If you name your function MyDMExtendedNotificationProc, you would declare it like this:

void MyDMExtendedNotificationProc (
   void * userData,
   short theMessage,
   void * notifyData
);
Parameters
userData

A pointer you passed into DMRegisterExtendedNotifyProc. 
theMessage

A message selector. See “Notification Messages” for information on specific message selectors. 
notifyData

A pointer to message-specific information data provided by the the Display Manager, described in “Notification Messages”.
Discussion

Display Manager notification functions use this callback function when your application needs to know when certain events have occurred. The system software may implement these events or follow a user action. When these events occur, the Display Manager will send notification messages to registrants.

When you call the function DMRegisterExtendedNotifyProc you designate an application-defined function to handle the extended notification procedure. 

When you implement this function, the pointer you pass to the DMRegisterExtendedNotifyProc function should be a universal procedure pointer with the following type definition:typedef (DMExtendedNotificationProcPtr)             DMExtendedNotificationUPP;


To create a universal procedure pointer for your application-defined function, you should use the NewDMExtendedNotificationProc macro as follows:DMExtendedNotificationUPP  MyExtendedNotificationUPP;
MyExtendedNotificationUPP = NewDMExtendedNotificationProc  (MyExtendedNotificationCallback);


You can then pass MyExtendedNotificationUPP in the notifyProc parameter of the DMRegisterExtendedNotifyProc function. When you no longer need notifications, you should remove it using the DMRemoveExtendedNotifyProc function. You sould also dispose of the UPP using the DisposeDMExtendedNotificationUPP function:

DisposeDMExtendedNotificationUPP(MyExtendedNotificationUPP);

Using this call ensures that the call is made through a universal procedure pointer.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.*/

typedef void (*DMExtendedNotificationProcPtr)
(
   void * userData,
   short theMessage,
   void * notifyData
);


/*DMExtendedNotificationUPP

typedef DMExtendedNotificationProcPtr DMExtendedNotificationUPP;
Discussion

For more information, see the description of the DMExtendedNotificationProcPtr callback function.*/
typedef DMExtendedNotificationProcPtr DMExtendedNotificationUPP;

//function

/*DMGetFirstScreenDevice

Returns a handle for the first video device in the device list. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

GDHandle DMGetFirstScreenDevice (
   Boolean activeOnly
);
Parameters
activeOnly

If true, the DMGetFirstScreenDevice function returns a handle to the first of all active video devices. If false, the function returns a handle to the first of all video devices, active or not. You may use the Active Device Constants in this parameter. See “Active Device Only Values”.
Return Value

If activeOnly is true, a handle to the GDevice structure for the first active video device. If activeOnly is false, a handle to the GDevice structure for the first video device. See the QuickDraw Manager documentation for a description of the GDHandle data type.
Discussion

The DMGetFirstScreenDevice function is useful if you want to find out more about the current mode.

You can use the function DMGetNextScreenDevice to loop through all of the video devices in the device list.

The DMGetFirstScreenDevice function is similar to the QuickDraw function GetDeviceList, except that when returning GDevice structures, GetDeviceList does not distinguish between inactive and active video devices or between the GDevice structures for video devices and the GDevice structures associated with no video devices. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/

GDHandle DMGetFirstScreenDevice (
   Boolean activeOnly
);

/*DMGetDisplayIDByGDevice

Obtains the display ID number for a video device. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

OSErr DMGetDisplayIDByGDevice (
   GDHandle displayDevice,
   DisplayIDType * displayID,
   Boolean failToMain
);
Parameters
displayDevice

A handle to the GDevice structure for the video device whose display ID you wish to obtain. 
displayID

On return, a pointer to the display ID for the video device specified by the displayDevice parameter. 
failToMain

If true and the specified video device does not have a display ID, on return the function sets the displayID parameter to a pointer to the display ID of the video device for the main screen. If false and the specified video device does not have a display ID, the function returns the kDMDisplayNotFoundErr result code. 
Return Value

A result code. See “Display Manager Result Codes”.
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
OSErr DMGetDisplayIDByGDevice (
   GDHandle displayDevice,
   DisplayIDType * displayID,
   Boolean failToMain
);

/*DMGetNextScreenDevice

Returns a handle for the next video device in the device list. (Deprecated in Mac OS X v10.4. Use Quartz Display Services instead; see Quartz Display Services Reference.)

GDHandle DMGetNextScreenDevice (
   GDHandle theDevice,
   Boolean activeOnly
);
Parameters
theDevice

A handle to the GDevice structure at which you want the function to begin. You can supply the handle returned by the function DMGetFirstScreenDevice or DMGetNextScreenDevice. 
activeOnly

If true, the DMGetNextScreenDevice function returns a handle for the next active video device. If false, DMGetNextScreenDevice returns a handle for the next video device, active or not. You may use the Active Device Constants in this parameter. See “Active Device Only Values”.
Return Value

If activeOnly is true, a handle to the next GDevice structure for an active video device. If activeOnly is false, a handle to the next GDevice structure for a video device. If there are no more GDevice structures in the list, DMGetNextScreenDevice returns NULL. See the QuickDraw Manager documentation for a description of the GDHandle data type.
Discussion

The DMGetNextScreenDevice function is similar to the QuickDraw function GetNextDevice, except that when returning GDevice structures, GetNextDevice does not distinguish between inactive and active video devices or between the GDevice structures for video devices and the GDevice structures associated with no video devices. 
Special Considerations

Because this function may move or purge memory blocks or access handles, you cannot call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Displays.h*/
GDHandle DMGetNextScreenDevice (
   GDHandle theDevice,
   Boolean activeOnly
);


#ifdef __cplusplus
}
#endif

#endif
