#ifndef PMERRORS_H
#define PMERRORS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Carbon Printing Manager. Result Codes

This table lists result codes defined for the Carbon Printing Manager.
Result Code	Value	Description
kPMGeneralError	-30870	
An unspecified error occurred.
kPMOutOfScope	-30871	
Your application called this function out of sequence with other Carbon Printing Manager functions.
kPMNoDefaultPrinter	-30872	
The user has not specified a default printer.
kPMNotImplemented	-30873	
The function is not implemented.
kPMNoSuchEntry	-30874	
There is no entry to match your application’s request.
kPMInvalidPrintSettings	-30875	
Your application passed an invalid print settings object.
kPMInvalidPageFormat	-30876	
Your application passed an invalid page format object.
kPMValueOutOfRange	-30877	
Your application passed an out-of-range value.
kPMLockIgnored	-30878	
The lock value was ignored.
kPMInvalidPrintSession	-30879	
Your application passed an invalid printing session object.
kPMInvalidPrinter	-30880	
Your application passed an invalid printer object.
kPMObjectInUse	-30881	
The specified object is in use.
kPMInvalidIndex	-30882	
An array index is invalid.
kPMStringConversionFailure	-30883	
An internal error occurred while converting a string.
kPMXMLParseError	-30884	
An error occurred while parsing XML data.
kPMInvalidJobTemplate	-30885	
An internal error occurred while creating a job template.
kPMInvalidPrinterInfo	-30886	
The printer information is invalid.
kPMInvalidConnection	-30887	
The printer connection type is invalid.
kPMInvalidKey	-30888	
The key in a ticket, job template, or dictionary is invalid.
kPMInvalidValue	-30889	
The value in a ticket, job template, or dictionary is missing.
kPMInvalidAllocator	-30890	
The specified memory allocator is invalid.
kPMInvalidTicket	-30891	
The job ticket is invalid.
kPMInvalidItem	-30892	
The item being added to a ticket is invalid.
kPMInvalidType	-30893	
The data type in a ticket, job template, or dictionary is not the expected type.
kPMInvalidReply	-30894	
A remote server or client sent an invalid reply.
kPMInvalidFileType	-30895	
The file type is invalid.
kPMInvalidObject	-30896	
The object is invalid.
kPMInvalidPaper	-30897	
Your application passed an invalid paper object.
kPMInvalidCalibrationTarget	-30898	
The dictionary specifying a printer calibration target is invalid.
kPMInvalidPreset	-30899	
Your application passed an invalid preset object.*/
enum {
kPMGeneralError=	-30870	,
kPMOutOfScope	=-30871	,
kPMNoDefaultPrinter	=-30872	,
kPMNotImplemented	=-30873	,
kPMNoSuchEntry	=-30874	,
kPMInvalidPrintSettings=	-30875	,
kPMInvalidPageFormat	=-30876	,
kPMValueOutOfRange	=-30877	,
kPMLockIgnored	=-30878	,
kPMInvalidPrintSession=	-30879	,
kPMInvalidPrinter	=-30880	,
kPMObjectInUse	=-30881	,
kPMInvalidIndex	=-30882	,
kPMStringConversionFailure	=-30883	,
kPMXMLParseError=	-30884	,
kPMInvalidJobTemplate	=-30885	,
kPMInvalidPrinterInfo	=-30886	,
kPMInvalidConnection	=-30887	,
kPMInvalidKey	=-30888	,
kPMInvalidValue	=-30889	,
kPMInvalidAllocator	=-30890	,
kPMInvalidTicket	=-30891	,
kPMInvalidItem	=-30892	,
kPMInvalidType=	-30893	,
kPMInvalidReply=	-30894	,
kPMInvalidFileType	=-30895	,
kPMInvalidObject	=-30896	,
kPMInvalidPaper	=-30897	,
kPMInvalidCalibrationTarget	=-30898	,
kPMInvalidPreset	=-30899	
};

#ifdef __cplusplus
}
#endif

#endif 

