#import <Foundation/Foundation.h>
#import <AvailabilityMacros.h>

@class DRFolder;



/*DRFilesystemInclusionMask constants

enum { 
    DRFilesystemInclusionMaskISO9660 = (
        1<<0), 
    DRFilesystemInclusionMaskJoliet = (
        1<<1), 
    DRFilesystemInclusionMaskUDF = (
        1<<2), 
    DRFilesystemInclusionMaskHFSPlus = (
        1<<3) 
};  
Constants
DRFilesystemInclusionMaskISO9660
Indicates the object should be included in the ISO9660 filesytem
DRFilesystemInclusionMaskJoliet
Indicates the object should be included in the Joliet filesytem
DRFilesystemInclusionMaskUDF
Indicates the object should be included in the UDF filesytem
DRFilesystemInclusionMaskHFSPlus
Indicates the object should be included in the HFS+ filesytem
Discussion 

Mask constants for determing the presence of a DRFSObject in a specific filesystem*/

enum { 
    DRFilesystemInclusionMaskISO9660 = (
        1<<0), 
    DRFilesystemInclusionMaskJoliet = (
        1<<1), 
    DRFilesystemInclusionMaskUDF = (
        1<<2), 
    DRFilesystemInclusionMaskHFSPlus = (
        1<<3) 
};  


/*DRFilesystemInclusionMask


Mask value determing the presence of a DRFSObject in a specific filesystem. 
typedef UInt32 DRFilesystemInclusionMask;  
Discussion 

The filesystem mask is a bitfield which contains a 1 if the object will appear in the corresponding filesystem, and 0 otherwise.*/
typedef UInt32 DRFilesystemInclusionMask;  

//class

@interface DRFSObject : NSObject 

/*setExplicitFilesystemMask:


Sets the filesystems the receiver will be included on. 
private

- (void) setExplicitFilesystemMask:(DRFilesystemInclusionMask)mask; 
Parameters
mask
A filesystem mask
Discussion 

The effective mask for an item cannot be more inclusive than the effective mask of it's parent. If the mask set for a child is more inclusive than its parent's mask, those filesystems not allowed by the parent will be stripped from the resulting effective mask of the child.*/
- (void) setExplicitFilesystemMask:(DRFilesystemInclusionMask)mask; 

/*explicitFilesystemMask


Returns the explicit filesystem mask set for the reciever. 
private

- (DRFilesystemInclusionMask) explicitFilesystemMask; 
Return Value

A filesystem mask 
Discussion 

The explicit mask is one that has been explicitly set by a client through the setExplicitFilesystemMask: method.*/
- (DRFilesystemInclusionMask) explicitFilesystemMask; 

/*propertyForKey:inFilesystem:mergeWithOtherFilesystems:


Returns a file/folder property specified by key for the specified filesystem. 
private

- (id) propertyForKey:(NSString*)key inFilesystem:(NSString*)filesystem 
        mergeWithOtherFilesystems:(BOOL)merge; 
Parameters
key
The property to return.
filesystem
The filesystem to look in.
merge
If YES, also look for the property in the umbrella DRAllFilesystems .
Return Value

The value associated with the property. 
Discussion 

Normally you would call this method with merge set to YES since you are interested in the property that will be used when writing the object to disc. But if you have a need to determine what property is set just for a specific filesystem, then pass in NO for merge. In this case only the specific filesystem is checked. So if DRHFSPlus is passed in for filesystem and merge is NO then the property returned is the value set for the HFS+ filesytem only. If that property has not been directly set for HFS+ yet, then the returned value will be nil.*/
- (id) propertyForKey:(NSString*)key inFilesystem:(NSString*)filesystem 
        mergeWithOtherFilesystems:(BOOL)merge; 

/*setProperty:forKey:inFilesystem:


Sets the value of the receiver's property specified by key for the specific filesystem. 
private

- (void) setProperty:(id)property forKey:(NSString*)key 
        inFilesystem:(NSString*)filesystem; 
Parameters
property
The value of the property.
key
The property key.
filesystem
The filesystem to set the property in.
Discussion 

The property is set only in the filesystem dictionary specified by filesystem. DRAllFilesystems may be specified as the filesystem in which case the umbrella property affecting all filesystems at once will be set. Setting a property for DRAllFilesystems does not preclude setting a filesystem specific property.*/

- (void) setProperty:(id)property forKey:(NSString*)key 
        inFilesystem:(NSString*)filesystem; 

/*setSpecificName:forFilesystem:


Sets the name used for the receiver in a particular filesystem. 
private

- (void) setSpecificName:(NSString*)name forFilesystem:(NSString*)filesystem; 
Parameters
name
The name to set.
filesystem
The filesystem to set the name for.
Discussion 

Every effort will be made to use the name passed in. However, if a name is illegal, it will be modified to fit the rules for the filesystem's names. Because of this, you should always call specificNameForFilesystem: after to ensure that you are always displaying the most current names to the user.*/
- (void) setSpecificName:(NSString*)name forFilesystem:(NSString*)filesystem; 

/*specificNameForFilesystem:


Returns a single filesystem-specific name for the receiver. 
private

- (NSString*) specificNameForFilesystem:(NSString*)filesystem; 
Parameters
filesystem
The filesystem to return the name from.
Return Value

An NSString containing the name of the file.*/
- (NSString*) specificNameForFilesystem:(NSString*)filesystem; 

/*mangledNameForFilesystem:


Returns a single filesystem-specific name for the receiver, mangled for uniqueness. 
private

- (NSString*)mangledNameForFilesystem:(NSString*)filesystem; 
Parameters
filesystem
The filesystem to set the name for.
Return Value

The name of the file mangled for filesystem constraints. 
Discussion 

The string will be mangled for uniqueness amongst its siblings if the burn were to happen immediately after this call, this is the name which would be used on the resulting disc.*/
- (NSString*)mangledNameForFilesystem:(NSString*)filesystem;

/*baseName


Returns the base name for the receiver. 
private

- (NSString*) baseName; 
Return Value

The base name of the object. 
Discussion 

The base name is the name from which any necessary filesystem-specific names are automatically generated. 
Because the content creation API is able to generate multiple filesystems which require multiple varied naming conventions, a sensible system for naming is required. Thus each file has a base name which corresponds to its default name in any filesystem.
Whenever possible, the base name will be used in the generated filesystem without modification. If the name cannot be used as-is (if, for example, it contains illegal characters, exceeds the length requirements, doesn't meet the required format, or a name collision is detected) then an acceptable name that meets the filesystem's criteria will be generated automatically from the base name.
The default base name for a real file or folder is the actual on-disk name of the item.*/
- (NSString*) baseName; 

/*parent


Returns the parent folder (if any) of the receiver in the content hierarchy. 
private

- (DRFolder*) parent; 
Return Value

A DRFolder object.*/
- (DRFolder*) parent; 

/*effectiveFilesystemMask


Returns the effective filesystem mask set for the reciever. 
private

- (DRFilesystemInclusionMask) effectiveFilesystemMask; 
Return Value

A filesystem mask 
Discussion 

The parent filesystem mask is taken into account for the receiver.*/
- (DRFilesystemInclusionMask) effectiveFilesystemMask; 

/*setBaseName:


Sets the base name for the receiver. 
private

- (void) setBaseName:(NSString*)baseName; 
Parameters
baseName
The new base name of the object.
Discussion 

The base name is the name from which any necessary filesystem-specific names are automatically generated. 
Because the content creation API is able to generate multiple filesystems which require multiple varied naming conventions, a sensible system for naming is required. Thus each file has a base name which corresponds to its default name in any filesystem.
Whenever possible, the base name will be used in the generated filesystem without modification. If the name cannot be used as-is (if, for example, it contains illegal characters, exceeds the length requirements, doesn't meet the required format, or a name collision is detected) then an acceptable name that meets the filesystem's criteria will be generated automatically from the base name.
The default base name for a real file or folder is the actual on-disk name of the item.*/
- (void) setBaseName:(NSString*)baseName; 

/*isVirtual


Indicates whether the receiver is real or virtual. 
private

- (BOOL) isVirtual; 
Return Value

YES if the receiver is virtual and NO if real.*/
- (BOOL) isVirtual; 

/*sourcePath


Returns the path to a real object. 
private

- (NSString*) sourcePath; 
Return Value

A path 
Discussion 

This method only applies to DRFSObjects pointing to real objects.*/
- (NSString*) sourcePath; 

@end


/*DRMacIconLocation

extern NSString* const DRMacIconLocation;  
Discussion 

NSData containing a Point (not NSPoint) for the item's icon location in its parent folder (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacIconLocation;  

/*DRMacWindowBounds

extern NSString* const DRMacWindowBounds;  
Discussion 

NSData containing a Rect (not NSRect) for the window bounds for a folder (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacWindowBounds;  

/*DRMacFileType

extern NSString* const DRMacFileType;  
Discussion 

NSData containing the OSType for the file type (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacFileType;  

/*DRMacFinderFlags

extern NSString* const DRMacFinderFlags;  
Discussion 

NSNumber containing the item's Finder flags (MacOS only). The invisible bit is ignored - use DRInvisible instead. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacFinderFlags;  

/*DRAttributeModificationDate

extern NSString* const DRAttributeModificationDate;  
Discussion 

NSDate containing the item's attribute modification date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRAttributeModificationDate;  

/*DRCreationDate

extern NSString* const DRCreationDate;  
Discussion 

NSDate containing the item's creation date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRCreationDate;  

/*DRMacWindowView

extern NSString* const DRMacWindowView;  
Discussion 

NSNumber containing the folder's window view type (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacWindowView;

/*DRMacExtendedFinderFlags

extern NSString* const DRMacExtendedFinderFlags;  
Discussion 

NSNumber containing the item's extended Finder flags (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacExtendedFinderFlags;  

/*DRMacScrollPosition

extern NSString* const DRMacScrollPosition;  
Discussion 

NSData containing a Point (not NSPoint) for the folder's scroll position (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacScrollPosition; 

/*DRMacFileCreator

extern NSString* const DRMacFileCreator;  
Discussion 

NSData containing the OSType for the file creator (MacOS only). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRMacFileCreator;  

/*DRHFSPlusCatalogNodeID

extern NSString* const DRHFSPlusCatalogNodeID;  
Discussion 

NSNumber containing item's catalog node ID (HFS+ only). Currently, this value if set is only a suggestion. The burn engine will attempt to use this node ID, but may use another value if it needs to resolve conflicts. Default behavior is to allocate node IDs incrementally from kHFSFirstUserCatalogNodeID . 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRHFSPlusCatalogNodeID;  

/*DRContentModificationDate

extern NSString* const DRContentModificationDate;  
Discussion 

NSDate containing the item's content modification date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRContentModificationDate;  

/*DRHFSPlus

extern NSString* const DRHFSPlus;  
Discussion 

The key for accessing the HFS+ name/properties for the file. HFS+ names can be up to 255 decomposed unicode characters long. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRHFSPlus;  

/*DRHFSPlusTextEncodingHint

extern NSString* const DRHFSPlusTextEncodingHint;  
Discussion 

NSNumber containing the item's text encoding hint (HFS+ only). 

This value is used by the MacOS to help when converting the natively UTF-16 filename into an 8-bit-per-character representation (such as MacRoman, Shift-JIS, or UTF8). If not set, default behavior is to call CFStringGetMostCompatibleMacStringEncoding (CFStringGetSmallestEncoding ()). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRHFSPlusTextEncodingHint;  

/*DRAccessDate

extern NSString* const DRAccessDate;  
Discussion 

NSDate containing the item's last-accessed date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRAccessDate;  

/*DRPosixUID

extern NSString* const DRPosixUID;  
Discussion 

NSNumber containing the item's POSIX UID. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRPosixUID;  

/*DRBackupDate

extern NSString* const DRBackupDate;  
Discussion 

NSDate containing the item's backup date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRBackupDate;  

/*DRPosixFileMode

extern NSString* const DRPosixFileMode;  
Discussion 

NSNumber containing the item's POSIX file mode. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRPosixFileMode;  

/*DRPosixGID

extern NSString* const DRPosixGID;  
Discussion 

NSNumber containing the item's POSIX GID. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRPosixGID;  

/*DRJoliet

extern NSString* const DRJoliet;  
Discussion 

The key for accessing the Joliet name/properties for the file. Joliet names can be 64 precomposed unicode characters long, but are only allowed one "." character and many punctuation characters are illegal. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRJoliet;  

/*DRISO9660LevelTwo

extern NSString* const DRISO9660LevelTwo;  
Discussion 

The key for accessing the ISO-9660 level 2 name for the file. This key is used to refer specifically to the name generated for ISO-9660 if the ISO level is set to 2. When used for a property, it is equivalent in use to the DRISO9660 key and acts as a synonym for that key. 

ISO9660 level 2 names can be 32 chars long, are limited to a subset of the 7-bit ASCII chars (capital letters, numbers, space, punctuation), and are only allowed one "." character. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISO9660LevelTwo;  

/*DRISO9660LevelOne

extern NSString* const DRISO9660LevelOne;  
Discussion 

The key for accessing the ISO-9660 level 1 name for the file. This key is used to refer specifically to the name generated for ISO-9660 if the ISO level is set to 1. When used for a property, it is equivalent in use to the DRISO9660 key and acts as a synonym for that key. 

ISO9660 level 1 names are in the form typically known as 8.3 - eight characters of name and three characters of extension (if it's a file; directories can't have extensions). Character set is limited to A-Z, 0-9, and _. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISO9660LevelOne;  

/*DRISO9660

extern NSString* const DRISO9660;  
Discussion 

The key for accessing the ISO-9660 properties for the file. This key is used to refer specifically to the properties for the file. 

This key cannot be used to refer to the name of the file; it is ambiguous, since the name may be in either level 1 or level 2 format. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISO9660;  

/*DRAllFilesystems

extern NSString* const DRAllFilesystems;  
Discussion 

The key for accessing the name or properties for the file in all filesystems together. When this key is used to refer to a name, it refers to the base name (which has no naming restrictions). 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRAllFilesystems;  

/*DREffectiveDate

extern NSString* const DREffectiveDate;  
Discussion 

NSDate containing the item's effective date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DREffectiveDate;  

/*DRExpirationDate

extern NSString* const DRExpirationDate;  
Discussion 

NSDate containing the item's expiration date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRExpirationDate;  

/*DRRecordingDate

extern NSString* const DRRecordingDate;  
Discussion 

NSDate containing the item's recording date. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRRecordingDate; 

/*DRISO9660VersionNumber

extern NSString* const DRISO9660VersionNumber;  
Discussion 

NSNumber containing the ISO9660 version number for the object. Default value is 1. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISO9660VersionNumber;  

/*DRInvisible

extern NSString* const DRInvisible;  
Discussion 

NSBoolean indicating whether the item is invisibile or not. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRInvisible;  

