#ifndef CFBUNDLE_H
#define CFBUNDLE_H

#include <CoreFoundation/CFBase.h>

#ifndef CFARRAY_H
#include <CoreFoundation/CFArray.h>
#endif

#include <CoreFoundation/CFDictionary.h>
#include <CoreFoundation/CFString.h>
#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif
#if defined(__cplusplus)
extern "C" {
#endif

/*Information Property List Keys

Standard keys found in a bundle’s information property list file. 

const CFStringRef kCFBundleInfoDictionaryVersionKey;
const CFStringRef kCFBundleExecutableKey;
const CFStringRef kCFBundleIdentifierKey;
const CFStringRef kCFBundleVersionKey;
const CFStringRef kCFBundleDevelopmentRegionKey;
const CFStringRef kCFBundleNameKey;
const CFStringRef kCFBundleLocalizationsKey;
Constants
kCFBundleInfoDictionaryVersionKey

The version of the information property list format.

Available in Mac OS X v10.0 and later.
kCFBundleExecutableKey

The name of the executable in this bundle (if any).

Available in Mac OS X v10.0 and later.
kCFBundleIdentifierKey

The bundle identifier.

Available in Mac OS X v10.0 and later.
kCFBundleVersionKey

The version number of the bundle.

For Mac OS 9 style version numbers (for example “2.5.3d5”), clients can use CFBundleGetVersionNumber instead of accessing this key directly since that function will properly convert the version string into its compact integer representation.

Available in Mac OS X v10.0 and later.
kCFBundleDevelopmentRegionKey

The name of the development language of the bundle.

When CFBundle looks for resources, the fallback is to look in the lproj whose name is given by the kCFBundleDevelopmentRegionKey in the Info.plist file. You must, therefore, ensure that a bundle contains an lproj with that exact name containing a copy of every localized resource, otherwise CFBundle cannot guarantee the fallback mechanism will work.

Available in Mac OS X v10.0 and later.
kCFBundleNameKey

The human-readable name of the bundle. 

This key is often found in the InfoPlist.strings since it is usually localized.

Available in Mac OS X v10.0 and later.
kCFBundleLocalizationsKey

Allows an unbundled application that handles localization itself to specify which localizations it has available.

Available in Mac OS X v10.2 and later.*/

const CFStringRef kCFBundleInfoDictionaryVersionKey;
const CFStringRef kCFBundleExecutableKey;
const CFStringRef kCFBundleIdentifierKey;
const CFStringRef kCFBundleVersionKey;
const CFStringRef kCFBundleDevelopmentRegionKey;
const CFStringRef kCFBundleNameKey;
const CFStringRef kCFBundleLocalizationsKey;


/* CFBundleRef

A reference to a CFBundle object.

typedef struct __CFBundle *CFBundleRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFBundle *CFBundleRef;

/*CFBundleCopyResourceURL

Returns the location of a resource contained in the specified bundle.

CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName
);
Parameters
bundle

The bundle to examine. 
resourceName

The name of the requested resource. 
resourceType

The abstract type of the requested resource. The type is expressed as a filename extension, such as jpg. Pass NULL if you dont need to search by type.
subDirName

The name of the subdirectory of the bundles resources directory to search. Pass NULL to search the standard CFBundle resource locations.
Return Value

A CFURL object describing the location of the requested resource, or NULL if the resource cannot be found. Ownership follows the Create Rule.
Discussion

For example, if a bundle contains a subdirectory WaterSounds that includes a file Water1.aiff, you can retrieve the URL for the file using:CFBundleCopyResourceURL(bundle, CFSTR("Water1"), CFSTR("aiff"), CFSTR("WaterSounds"));

Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName
);

/*CFBundleCopyResourcesDirectoryURL

Returns the location of a bundles Resources directory.

CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundles resources directory, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

In general, you should never need to use this function. Use CFBundleCopyResourceURL and similar functions instead. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);

/*CFBundleCreate

Creates a CFBundle object.

CFBundleRef CFBundleCreate (
   CFAllocatorRef allocator,
   CFURLRef bundleURL
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
bundleURL

The location of the bundle for which to create a CFBundle object.
Return Value

A CFBundle object created from the bundle at bundleURL. Ownership follows the Create Rule.

Returns NULL if there was a memory allocation problem. May return an existing CFBundle object with the reference count incremented. May return NULL if the bundle doesn’t exist at bundleURL (see Discussion). 
Discussion

Once a bundle has been created, it is cached; the bundle cache is flushed only periodically. CFBundleCreate does not check that a cached bundle still exists in the filesystem. If a bundle is deleted from the filesystem, it is therefore possible for CFBundleCreate to return a cached bundle that has actually been deleted.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleCreate (
   CFAllocatorRef allocator,
   CFURLRef bundleURL
);

/*CFBundleGetFunctionPointerForName

Returns a pointer to a function in a bundle’s executable code using the function name as the search key.

void *CFBundleGetFunctionPointerForName (
   CFBundleRef bundle,
   CFStringRef functionName
);
Parameters
bundle

The bundle to examine. 
functionName

The name of the function to locate. 
Return Value

A pointer to a function in a bundle’s executable code, or NULL if functionName cannot be found. Ownership follows the Get Rule.
Discussion

Calling this function will cause the bundle’s code to be loaded if necessary. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void *CFBundleGetFunctionPointerForName (
   CFBundleRef bundle,
   CFStringRef functionName
);

/*CFBundleCopyExecutableURL

Returns the location of a bundle’s main executable code.

CFURLRef CFBundleCopyExecutableURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundle’s executable code, or NULL if none is found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyExecutableURL (
   CFBundleRef bundle
);

/*CFBundleGetMainBundle

Returns an application’s main bundle.

CFBundleRef CFBundleGetMainBundle ();
Return Value

A CFBundle object representing the application’s main bundle, or NULL if it is not possible to create a bundle. Ownership follows the Get Rule.
Discussion

CFBundle creates a main bundle whenever it possibly can, even for unbundled apps. There are a few situations in which it is not possible, so you should check the return value against NULL, but this happens only in exceptional circumstances.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetMainBundle ();

/*CFBundleGetVersionNumber

Returns a bundle’s version number.

UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. The bundle’s version number can be number or a string of the standard form “2.5.3d5”. 
Return Value

A Mac OS vers resource style version number. If the bundle’s version number is a number, it is interpreted as the unsigned long integer format defined by the vers resource on Mac OS 9. If it is a string, it is automatically converted to the numeric representation, where the major version number is restricted to 2 BCD digits (in other words, it must be in the range 0-99) and the minor and bug fix version numbers are each restricted to a single BCD digit (0-9). See Technical Note TN1132 for more details.
Discussion

This function is only supported for the Mac OS vers resource style version numbers. Where other version number styles—namely X, or X.Y, or X.Y.Z—are used, you can use CFBundleGetValueForInfoDictionaryKey with the key kCFBundleVersionKey to extract the version number as a string from the bundle’s information dictionary.

Some version numbers of the form X, X.Y, and X.Y.Z may work with this function, if X <= 99, Y <= 9, and Z <= 9. Thus a version number 76.5.4 will work, but 76.12 will not work.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
UInt32 CFBundleGetVersionNumber (
   CFBundleRef bundle
);

/*CFBundleCopyBundleURL

Returns the location of a bundle.

CFURLRef CFBundleCopyBundleURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundle, or NULL if the specified bundle does not exist. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyBundleURL (
   CFBundleRef bundle
);

/*CFBundleGetBundleWithIdentifier

Locate a bundle given its program-defined identifier.

CFBundleRef CFBundleGetBundleWithIdentifier (
   CFStringRef bundleID
);
Parameters
bundleID

The identifier of the bundle to locate. Note that identifier names are case-sensitive.
Return Value

A CFBundle object, or NULL if the bundle was not found. Ownership follows the Get Rule.
Discussion

For a bundle to be located using its identifier, the bundle object must have already been created. The principal intended purpose for locating bundles by identifier is so that code (in frameworks, plugins, etc.) can find its own bundle. If a bundle is created, then the bundle deleted from the filesystem and this function invoked afterwards, it will still return the original bundle.

Bundle identifiers are created by entering a value for the key CFBundleIdentifier in the bundle’s Info.plist file. 

To guarantee uniqueness, bundle identifiers take the form of Java style package names, such as com.myCompany.foo.bar.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFBundleRef CFBundleGetBundleWithIdentifier (
   CFStringRef bundleID
);

/*CFBundleLoadExecutable

Loads a bundle’s main executable code into memory and dynamically links it into the running application.

Boolean CFBundleLoadExecutable (
   CFBundleRef bundle
);
Parameters
bundle

The bundle whose main executable you want to load. 
Return Value

true if the executable was successfully loaded, otherwise false. 
Discussion

You should typically try to avoid using this function, but instead use CFBundleGetFunctionPointerForName and related functions since these make memory management of the bundle easier.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBundleLoadExecutable (
   CFBundleRef bundle
);

/*CFCopyLocalizedString

Searches the default strings file Localizable.strings for the string associated with the specified key.

CFStringRef CFCopyLocalizedString (
   CFStringRef key,
   const char *comment
);
Parameters
key

The development language version of the string. This string is used as the search key to locate the localized version of the string. 
comment

A comment to provide the translators with contextual information necessary for proper translation.
Return Value

The localized version of the requested string. Returns key if no value corresponding to key is found. Ownership follows the Create Rule.
Discussion

This is a macro variant of CFBundleCopyLocalizedString for use with the genstrings tool. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFStringRef CFCopyLocalizedString (
   CFStringRef key,
   const char *comment
);


/*CFBundleGetIdentifier

Returns the bundle identifier from a bundle’s information property list.

CFStringRef CFBundleGetIdentifier (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFString object containing the bundle’s identifier, or NULL if none was specified in the information property list. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFStringRef CFBundleGetIdentifier (
   CFBundleRef bundle
);


/*CFBundleGetValueForInfoDictionaryKey

Returns a value in a bundle’s information dictionary.

CFTypeRef CFBundleGetValueForInfoDictionaryKey (
   CFBundleRef bundle,
   CFStringRef key
);
Parameters
bundle

The bundle to examine. 
key

The key for the value to return. 
Return Value

A value corresponding to key in bundle’s information dictionary. If available, a localized value is returned, otherwise the global value is returned. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeRef CFBundleGetValueForInfoDictionaryKey (
   CFBundleRef bundle,
   CFStringRef key
);

/*CFBundleGetInfoDictionary

Returns a bundle’s information dictionary.

CFDictionaryRef CFBundleGetInfoDictionary (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFDictionary object containing the data stored in the bundle’s information property list. This is a global information dictionary. CFBundle may add extra keys to this dictionary for its own use. Ownership follows the Get Rule.
Discussion

You should typically use CFBundleGetValueForInfoDictionaryKey rather than retrieving values directly from the info dictionary because the function will return localized values if any are available. UseCFBundleGetInfoDictionary only if you know that the key you are interested in will not be localized.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDictionaryRef CFBundleGetInfoDictionary (
   CFBundleRef bundle
);

/*CFBundleCopyAuxiliaryExecutableURL

Returns the location of a bundle’s auxiliary executable code.

CFURLRef CFBundleCopyAuxiliaryExecutableURL (
   CFBundleRef bundle,
   CFStringRef executableName
);
Parameters
bundle

The bundle to examine. 
executableName

The name of bundle’s auxiliary executable code. 
Return Value

The URL location of the specified bundle’s auxiliary executable code, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

This function can be used to find executables other than your main executable. This is useful, for instance, for applications that have some command line tool that is packaged with and used by the application. The tool can be packaged in the various platform executable directories in the bundle and can be located with this function. This allows an application to ship versions of the tool for each platform as it does for the main application executable. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyAuxiliaryExecutableURL (
   CFBundleRef bundle,
   CFStringRef executableName
);

/*CFBundleCopySharedSupportURL

Returns the location of a bundle’s shared support files directory.

CFURLRef CFBundleCopySharedSupportURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object containing the location of bundle’s shared support files directory, or NULL if it could not be found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/

CFURLRef CFBundleCopySharedSupportURL (
   CFBundleRef bundle
);

/*CFBundleCopyBuiltInPlugInsURL

Returns the location of a bundle’s built in plug-in.

CFURLRef CFBundleCopyBuiltInPlugInsURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine.
Return Value

A CFURL object describing the location of bundle’s built in plug-ins, or NULL if it could not be found. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/

CFURLRef CFBundleCopyBuiltInPlugInsURL (
   CFBundleRef bundle
);

/*CFBundleUnloadExecutable

Unloads the main executable for the specified bundle.

void CFBundleUnloadExecutable (
   CFBundleRef bundle
);
Parameters
bundle

The bundle whose main executable you want to unload. 
Discussion

You should typically try to avoid using this function, but instead use CFBundleGetFunctionPointerForName and related functions since these make management of the bundle easier (when the last reference to the CFBundle object is released, and it is finally deallocated, then the code will be unloaded if it is still loaded, and if the executable is of a type that supports unloading).
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFBundleUnloadExecutable (
   CFBundleRef bundle
);

/*CFBundleGetValueForInfoDictionaryKey

Returns a value in a bundle’s information dictionary.

CFTypeRef CFBundleGetValueForInfoDictionaryKey (
   CFBundleRef bundle,
   CFStringRef key
);
Parameters
bundle

The bundle to examine. 
key

The key for the value to return. 
Return Value

A value corresponding to key in bundle’s information dictionary. If available, a localized value is returned, otherwise the global value is returned. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeRef CFBundleGetValueForInfoDictionaryKey (
   CFBundleRef bundle,
   CFStringRef key
);

#ifdef __cplusplus
}
#endif
#endif 