#ifndef STRINGCOMPARE_H
#define STRINGCOMPARE_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef TEXTCOMMON_H
#include <CarbonCore/TextCommon.h>
#endif

#ifndef SCRIPT_H
#include <CarbonCore/Script.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*EqualString

Compares two Pascal strings for equality, using the comparison rules of the Macintosh file system. (Deprecated in Mac OS X v10.4. Use CFStringCompare instead.)

Boolean EqualString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
);
Parameters
str1

One of the Pascal strings to be compared. 
str2

The other Pascal string to be compared.
caseSensitive

A flag that indicates how to handle case-sensitive information during the comparison. If the value of caseSens is TRUE, uppercase characters are distinguished from the corresponding lowercase characters. If it is FALSE, case information is ignored. 
diacSensitive

A flag that indicates how to handle information about diacritical marks during the string comparison. If the value of diacSens is TRUE, characters with diacritical marks are distinguished from the corresponding characters without diacritical marks during the comparison. If it is FALSE, diacritical marks are ignored.
Return Value

TRUE if the two strings are equal and FALSE if they are not equal. If its value is TRUE, EqualString distinguishes uppercase characters from the corresponding lowercase characters. If its value is FALSE, EqualString ignores diacritical marks during the comparison. 
Discussion

The comparison is a simple, character-by-character value comparison. This function does not make use of any script or language information (i.e., is not localizable); it assumes the use of a Roman script system. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
StringCompare.h*/

Boolean EqualString (
   ConstStr255Param str1,
   ConstStr255Param str2,
   Boolean caseSensitive,
   Boolean diacSensitive
);



#ifdef __cplusplus
}
#endif

#endif