#ifndef RESOURCES_H
#define RESOURCES_H



#ifndef __MACTYPES__
#include <CarbonCore/MacTypes.h>
#endif

#ifndef __MIXEDMODE__
#include <CarbonCore/MixedMode.h>
#endif

#ifndef __FILES__
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Reference Number Constants

enum {
   kResFileNotOpened = -1,
   kSystemResFile = 0
};
Constants
kResFileNotOpened

Indicates the reference number returned as error when opening a resource file.

Available in Mac OS X v10.0 and later.
kSystemResFile

Indicates the default reference number to the system file.

Available in Mac OS X v10.0 and later.*/
enum {
   kResFileNotOpened = -1,
   kSystemResFile = 0
};


/*LoadResource

Gets resource data after you’ve called the SetResLoad function with the load parameter set to FALSE or when the resource is purgeable.
Special Considerations

LoadResource is another name for MacLoadResource. See the MacLoadResource documentation.*/
#define  LoadResource MacLoadResource

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);

/*CloseResFile

Closes a resource fork before your application terminates.

void CloseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork to close. If this parameter does not contain a file reference number for a file whose resource fork is open, the function does nothing, and the ResError function returns the result code resFNotFound. If the value of this parameter is 0, it represents the System file and is ignored. You cannot close the System file’s resource fork. 
Discussion

This function performs four tasks. First, it updates the file by calling the UpdateResFile function. Second, it releases the memory occupied by each resource in the resource fork by calling the DisposeHandle function. Third, it releases the memory occupied by the resource map. The fourth task is to close the resource fork.

When your application terminates, the Resource Manager automatically closes every resource fork open to your application except the System file’s resource fork. You need to call this function only if you want to close a resource fork before your application terminates.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void CloseResFile (
   short refNum
);

/*Get1IndResource

Returns a handle to a resource of a given type in the current resource file.

Handle Get1IndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type.
index

An integer ranging from 1 to the number of resources of a given type returned by the Count1Resources function, which is the number of resources of that type in the current resource file.
Return Value

A handle to a resource of the given type. If you call Get1IndResource repeatedly over the entire range of the index, it returns handles to all resources of the given type in the current resource file. If you provide an index that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by Count1Resources, Get1IndResource returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code.
Discussion

The function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE. If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, Get1IndResource returns an empty handle (that is, a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the Get1IndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1IndResource (
   ResType theType,
   short index
);

/*DetachResource

Sets the value of a resource’s handle in the resource map in memory to NULL while keeping the resource data in memory.

void DetachResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If this parameter doesn’t contain a handle to a resource or if the resource’s resChanged attribute is set, the function does nothing. To determine whether either of these errors occurred, call the ResError function. 
Discussion

After this call, the Resource Manager no longer recognizes the handle as a handle to a resource. However, this function does not release the memory used for the resource data, and the master pointer is still valid. Thus, you can access the resource data directly by using the handle.

If your application subsequently calls a Resource Manager function to get the released resource, the Resource Manager assigns a new handle.You can use DetachResource if you want to access the resource data directly without using Resource Manager functions. You can also use the DetachResource function to keep resource data in memory after closing a resource fork.

To copy a resource and install an entry for the duplicate in the resource map, call DetachResource, then call the AddResource function using a different resource ID. 
Special Considerations

Do not use this function to detach a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void DetachResource (
   Handle theResource
);

/*Get1Resource

Gets resource data for a resource in the current resource file.

Handle Get1Resource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data.
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds an entry for the resource in the current resource file’s resource map and the entry contains a valid handle, it returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, Get1Resource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and ResError returns the result code resNotFound. The Get1Resource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code.

If you call this function with a resource type that can’t be found in the resource map of the current resource file, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the current resource file’s resource map in memory for the specified resource.

You can change the resource map search order by calling the UseResFile function before Get1Resource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps for open resource forks, use the RGetResource function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1Resource (
   ResType theType,
   short theID
);

/*ResError

Determines what error occurred, if any, after calling a Resource Manager function. 

OSErr ResError ();
Return Value

A result code. See “Resource Manager Result Codes”. If no error occurred, the function returns noErr. If an error occurs at the Resource Manager level, the function returns one of the result codes specific to the Resource Manager. If an error occurs at the Operating System level, the function returns an Operating System result code. In certain cases, the ResError function returns noErr even though a Resource Manager function was unable to perform the requested operation. See the individual function descriptions for details about the circumstances under which this happens.
Discussion

Resource Manager functions do not report error information directly. Instead, after calling a Resource Manager function, your application should call this function to determine whether an error occurred. You also can use this function to check for an error after application startup (system software opens the resource fork of your application during application startup).

Resource Manager functions usually return NULL or –1 as the function result when there’s an error. For Resource Manager functions that return –1, your application can call the ResError function to determine the specific error that occurred. For Resource Manager functions that return handles, your application should always check whether the value of the returned handle is NULL. If it is, your application can use this function to obtain specific information about the nature of the error. Note, however, that in some cases ResError returns noErr even though the value of the returned handle is NULL.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
OSErr ResError ();


/*AddResource

Adds a resource to the current resource file’s resource map in memory.

void AddResource (
   Handle theData,
   ResType theType,
   short theID,
   ConstStr255Param name
);
Parameters
theData

A handle to data in memory to be added as a resource to the current resource file (not a handle to an existing resource). If the value of this parameter is an empty handle (that is, a handle whose master pointer is set to NULL), the Resource Manager writes zero-length resource data to disk when it updates the resource. If its value is either NULL or a handle to an existing resource, the function does nothing, and the ResError function returns the result code addResFailed. If the resource map becomes too large to fit in memory, the function does nothing, and ResError returns an appropriate result code. The same is true if the resource data in memory can’t be written to the resource fork (for example, because the disk is full).
theType

The resource type of the resource to be added.
theID

The resource ID of the resource to be added.
name

The name of the resource to be added.
Discussion

This function sets the resChanged attribute to 1 it does not set any of the resource’s other attributes—that is, all other attributes are set to 0. If the resChanged attribute of a resource has been set and your application calls the UpdateResFile function or quits, the Resource Manager writes both the resource map and the resource data for that resource to the resource fork of the corresponding file on disk. If the resChanged attribute for a resource has been set and your application calls the WriteResource function, the Resource Manager writes only the resource data for that resource to disk.

If you add a resource to the current resource file, the Resource Manager writes the entire resource map to disk when it updates the file. If you want any of your changes to the resource map or resource data to be temporary, you must restore the original information before the Resource Manager updates the file on disk.

The function doesn’t verify whether the resource ID you pass in the parameter theID is already assigned to another resource of the same type. You should call the UniqueID or Unique1ID function to get a unique resource ID before adding a resource with this function.

When your application calls this function, the Resource Manager attempts to reserve disk space for the new resource. If the new resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call UpdateResFile or WriteResource, the Resource Manager won’t know that resource data has been added. Thus, the function won’t write the new resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to AddResource. 

To copy an existing resource, get a handle to the resource you want to copy, call the DetachResource function, then call AddResource. To add the same resource data to several different resource forks, call the Memory Manager function HandToHand to duplicate the handle for each resource. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void AddResource (
   Handle theData,
   ResType theType,
   short theID,
   ConstStr255Param name
);

/*RemoveResource

Removes a resource’s entry from the current resource file’s resource map in memory. 

void RemoveResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If the resProtected attribute for the resource is set or if this parameter doesn’t contain a handle to a resource, the function does nothing, and the ResError function returns the result code rmvResFailed. 
Discussion

The RemoveResource function does not dispose of the handle you pass into it; to do so you must call the Memory Manager function DisposeHandle after calling RemoveResource. You should dispose the handle if you want to release the memory before updating or closing the resource fork.

If you’ve removed a resource, the Resource Manager writes the entire resource map when it updates the resource fork, and all changes made to the resource map become permanent. If you want any of the changes to be temporary, you should restore the original information before the Resource Manager updates the resource fork.

The RemoveResource function is also available as the RmveResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void RemoveResource (
   Handle theResource
);

/*UseResFile

Sets the current resource file.

void UseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork which you wish to set as the current resource fork.
Return Value

The function searches the list of files whose resource forks have been opened for the file specified here. If the specified file is found, the Resource Manager sets the current resource file to the specified file. If there’s no resource fork open for a file with that reference number, the function does nothing. To set the current resource file to the System file, use 0 here.
Discussion

Open resource forks are arranged as a linked list with the most recently opened resource fork at the beginning. When searching open resource forks, the Resource Manager starts with the most recently opened file. You can call this function to set the current resource file to a file opened earlier, and thereby start subsequent searches with the specified file. In this way, you can cause any files higher in the resource chain to be left out of subsequent searches.

When a new resource fork is opened, this action overrides previous calls to this function and the entire list is searched. For example, if five resource forks are opened in the order R0, R1, R2, R3, and R4, the search order is R4-R3-R2-R1-R0. Calling UseResFile(R2) changes the search order to R2-R1-R0; R4 and R3 are not searched. When the resource fork of a new file (R5) is opened, the search order becomes R5-R4-R3-R2-R1-R0.

You typically call the CurResFile function to get and save the current resource file, UseResFile to set the current resource file to the desired file, then (after you are finished using the resource) UseResFile to restore the current resource file to its previous value. Calling UseResFile(0) causes the Resource Manager to search only the System file’s resource map. This is useful if you no longer wish to override a system resource with one by the same name in your application’s resource fork.

Most of the Resource Manager functions assume that the current resource file is the file on whose resource fork they should operate or, in the case of a search, the file where they should begin. In general, the current resource file is the last one whose resource fork your application opened unless you specify otherwise.

The FSpOpenResFile, HOpenResFile, and OpenResFile functions, which also set the current resource file, override previous calls to UseResFile.

To check for errors, call the ResError function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void UseResFile (
   short refNum
);

/*FSpOpenResFile

Opens a file’s resource fork using a file system specification (FSSpec) record.

short FSpOpenResFile (
   const FSSpec * spec,
   SignedByte permission
);
Parameters
spec

A pointer to a file system specification record specifying the name and location of the file whose resource fork is to be opened. The file system specification record for files and directories is defined by the FSSpec data type and is a standard format in System 7 and later versions for identifying a file or directory.

This function also makes this file the current resource file.

See the File Manager documentation for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the resource fork. For a description of the types of access you can request, see the section File Access Permission Constants in File Manager Reference.
Return Value

The file reference number for the resource fork. If the file reference number returned is greater than 0, you can use this number to refer to the resource fork in some other Resource Manager functions.

If you attempt to use this function to open a resource fork that is already open, it returns the existing file reference number or a new one, depending on the access permission for the existing access path. For example, your application receives a new file reference number after a successful request for read-only access to a file previously opened with write access, whereas it receives the same file reference number in response to a second request for write access to the same file. In this case, the function doesn’t make that file the current resource file.

If the function fails to open the specified file’s resource fork (for instance, because there’s no file with the given file system specification record or because there are permission problems), it returns –1 as the file reference number. Use the ResError function to determine what kind of error occurred. 

If an application attempts to open a second access path with write access and the application is different from the one that originally opened the resource fork, FSpOpenResFile returns –1, and the ResError function returns the result code opWrErr.
Discussion

This function is available only in System 7 and later versions of system software. You can determine whether FSpOpenResFile is available by calling the Gestalt function with the gestaltFSAttr selector code. If this function is not available to your application, you can use HOpenResFile, OpenRFPerm, or OpenResFile instead. The HOpenResFile function is preferred if FSpOpenResFile is not available. The OpenRFPerm and OpenResFile functions are earlier versions of HOpenResFile that are still supported but are more restricted in their capabilities.

The Resource Manager reads the resource map from the specified file’s resource fork into memory. It also reads into memory every resource in the resource fork whose resPreload attribute is set.

You don’t have to call this function to open the System file’s resource fork or an application file’s resource fork. These resource forks are opened automatically when the system and the application start up, respectively. To get the file reference number for your application, call the CurResFile function after your application starts up and before you open any other resource forks.

The FSpOpenResFile function checks that the information in the resource map is internally consistent. If it isn’t, ResError returns the result code mapReadErr.

It’s possible to create multiple, unique, read-only access paths to a resource fork using this function however, you should avoid doing so. If a resource fork is opened twice—once with read/write permission and once with read-only permission—two copies of the resource map exist in memory. If you change one of the resources in memory using one of the resource maps, the two resource maps become inconsistent and the file will appear damaged to the second resource map. 

If you must use this technique for read-only access, call this function immediately before your application reads information from the file and close the file immediately afterward. Otherwise, your application may get unexpected results.

If you want to open the resource fork for another application (or any resource fork other than your application’s that includes 'CODE' resources), you must bracket your calls to this function with calls to the SetResLoad function with the load parameter set to FALSE and then to TRUE. You must also avoid making intersegment calls while the other application’s resource fork is open. If you don’t do this, the Segment Loader Manager treats any preloaded 'CODE' resources as your code resources when you make an intersegment call that triggers a call to the LoadSeg function while the other application is first in the resource chain. In this case, your application can begin executing the other application’s code, and severe problems will ensue. If you need to get 'CODE' resources from the other application’s resource fork, you can still prevent the Segment Loader Manager problem by calling the UseResFile function with your application’s file reference number to make your application the current resource file.

To open a resource fork just for block-level operations, such as copying files without reading the resource map into memory, use the File Manager function OpenRF. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSpOpenResFile (
   const FSSpec * spec,
   SignedByte permission
);


/*HCreateResFile

Creates an empty resource fork, when the FSpCreateResFile function is not available.

void HCreateResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

The volume reference number of the volume on which the file is located.
dirID

The directory ID of the directory where the file is located.
fileName

The name of the file whose resource fork is to be created. If no other file with the given name exists in the specified directory, the function creates a resource file—that is, a resource fork, including a resource map. In this case the file has a zero-length data fork. 

If a file with the specified name already exists and includes a resource fork with a resource map, the function does nothing. If the data fork of the specified file already exists but the file has a zero-length resource fork, the function creates an empty resource fork and resource map for the file.
Discussion

Don’t use the resource fork of a file for data that is not in resource format. The Resource Manager assumes that any information in a resource fork can be interpreted according to the standard resource format described in this chapter.

The File Manager assumes that the first block of a file’s resource fork is part of the resource header and puts information there that it uses during scavenging—for example, after the user presses the Reset switch. For this reason, if you copy a resource file, the duplicate may not be exactly like the original.

Before you can work with the newly created file’s resource fork, you must first use the HOpenResFile function or a related function to open it.

To check for errors, call the ResError function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void HCreateResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);

/*WriteResource

Writes resource data in memory immediately to a file’s resource fork. 

void WriteResource (
   Handle theResource
);
Parameters
theResource

A handle to a resource. The function checks the resChanged attribute of this resource. If the resChanged attribute is set to 1, such as after a successful call to the ChangedResource or AddResource function, WriteResource writes the resource data in memory to the resource fork, then clears the resChanged attribute in the resource’s resource map in memory.

If the resource is purgeable and has been purged, the function writes zero-length resource data to the resource fork. If the resource’s resProtected attribute is set to 1, the function does nothing, and the ResError function returns the result code noErr. The same is true if the resChanged attribute is not set (that is, set to 0). If the given handle isn’t a handle to a resource, WriteResource does nothing, and ResError returns the result code resNotFound.
Discussion

Note that this function does not write the resource’s resource map entry to disk.

When your application calls ChangedResource or AddResource, the Resource Manager attempts to reserve disk space for the changed resource. If the modified resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call WriteResource, the Resource Manager won’t know that the resource data has been changed. Thus, the function won’t write the modified resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to ChangedResource or AddResource.

The resource fork is updated automatically when your application quits, when you call the UpdateResFile function, or when you call the CloseResFile function. Thus, you should call WriteResource only if you want to write just one or a few resources immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void WriteResource (
   Handle theResource
);

/*GetResource

Gets resource data for a resource specified by resource type and resource ID.

Handle GetResource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data. 
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds the specified resource entry in one of the resource maps and the entry contains a valid handle, it returns that handle. If the entry contains a a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, GetResource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and the ResError function returns the result code resNotFound. The GetResource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code. If you call GetResource with a resource type that can’t be found in any of the resource maps of the open resource forks, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the resource maps in memory for the specified resource. The resource maps in memory, which represent all the open resource forks, are arranged as a linked list. When searching this list, the function starts with the current resource file and progresses through the list (that is, searching the resource maps in reverse order of opening) until it finds the resource’s entry in one of the resource maps. 

Before reading the resource data into memory, the Resource Manager calls the Memory Manager to allocate a relocatable block for the resource data. The Memory Manager allocates the block, assigns a master pointer to the block, and returns to the Resource Manager a pointer to the master pointer. The Resource Manager then installs this handle in the resource map. 

You can change the resource map search order by calling the UseResFile function before calling GetResource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps of open resource forks, use the RGetResource function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/


Handle GetResource (
   ResType theType,
   short theID
);

/*ReleaseResource

Releases the memory a resource occupies when you have finished using it.

void ReleaseResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to release.The function sets the master pointer of the resource’s handle in the resource map in memory to NULL. If your application previously obtained a handle to that resource, the handle is no longer valid. If your application subsequently calls the Resource Manager to get the released resource, the Resource Manager assigns a new handle. 

If the given resource isn’t a handle to a resource, the function does nothing, and the ResError function returns the result code resNotFound. Be aware that ReleaseResource won’t release a resource whose resChanged attribute has been set, but ResError still returns the result code noErr.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Do not use this function to release a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void ReleaseResource (
   Handle theResource
);


/*FSpCreateResFile

Creates an empty resource fork using a file system specification (FSSpec) record. 

void FSpCreateResFile (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to a file system specification structure that indicates the name and location of the file whose resource fork is to be created. The file system specification record for files and directories is defined by the FSSpec data type.

Certain File Manager functions—those that open a file’s data fork—also take a file system specification record as a parameter. You can use the same FSSpec record in Resource Manager functions that create or open the file’s resource fork. 

If the file specified by the file system specification record doesn’t already exist (that is, if it has neither a data fork nor a resource fork), the function creates a resource file—that is, a resource fork, including a resource map. In this case the file has a zero-length data fork. The function also sets the creator, type, and script code fields of the file’s catalog information record to the specified values. 

If the file specified by the file system specification record already exists and includes a resource fork with a resource map, the function does nothing. If the data fork of the file specified by the file system specification record already exists but the file has a zero-length resource fork, the function creates an empty resource fork and resource map for the file; it also changes the creator, type, and script code fields of the catalog information record of the file to the specified values.

If your application uses Standard File Package functions, note that the StandardPutFile function returns a standard file reply record that contains a file system specification record in the sfFile field.

See the File Manager documentation for a description of the FSSpec data type.
creator

The signature of the application creating the file. Whenever your application creates a document, it assigns a creator and a file type to that document. Typically your application sets its signature as the document’s creator. 
fileType

The file type of the new file. You can set the file type to a type especially defined for your application or one of the existing general types, such as 'TEXT' for text (a stream of ASCII characters), or 'pref' for a preferences file.

The file type should be as descriptive of the file’s data format as possible. You should not use 'TEXT' as a file type unless the document contains plain ASCII characters.
scriptTag

The script code of the script system in which the Finder and standard file dialog boxes display the file’s name. For example, to specify the Roman script system, specify the constant smRoman in the scriptTag parameter. 
Discussion

Don’t use the resource fork of a file for data that is not in resource format. The Resource Manager assumes that any information in a resource fork can be interpreted according to the standard resource format described in this chapter. 

The File Manager assumes that the first block of a file’s resource fork is part of the resource header and puts information there that it uses during scavenging—for example, after the user presses the Reset switch. For this reason, if you copy a resource file, the duplicate may not be exactly like the original. 

This function is available only in System 7 and later versions of system software. If FSpCreateResFile is not available to your application, you can use the CreateResFile function or the HCreateResFile function. The HCreateResFile function is preferred over CreateResFile, which is an earlier version of HCreateResFile that is still supported but has more restricted capabilities.

Before you can work with the newly created file’s resource fork, you must use the FSpOpenResFile function to open it.

To check for errors, call the ResError function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void FSpCreateResFile (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);

/*CurResFile

Gets the file reference number of the current resource file.

short CurResFile ();
Return Value

The file reference number associated with the current resource file. You can call this function when your application starts up (before opening the resource fork of any other file) to get the file reference number of your application’s resource fork. If the current resource file is the System file, the function returns the actual file reference number. You can use this number or 0 with functions that take a file reference number for the System file. All Resource Manager functions recognize both 0 and the actual file reference number as referring to the System file.
Discussion

Most of the Resource Manager functions assume that the current resource file is the file on whose resource fork they should operate or, in the case of a search, the file where they should begin. In general, the current resource file is the last one whose resource fork your application opened unless you specify otherwise.

To check for errors, call the ResError function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short CurResFile ();

/*MacLoadResource

Gets resource data after you’ve called the SetResLoad function with the load parameter set to FALSE or when the resource is purgeable.

void MacLoadResource (
   Handle theResource
);
Parameters
theResource

A handle to a resource. Given this handle, the function reads the resource data into memory. If the resource is already in memory, or if the this parameter doesn’t contain a handle to a resource, then the function does nothing. To determine whether either of these situations occurred, call the ResError function. If the resource is already in memory, ResError returns noErr; if the handle is not a handle to a resource, ResError returns resNotFound.
Discussion

If you’ve changed the resource data for a purgeable resource and the resource is purged before being written to the file, the changes will be lost. In this case, this function rereads the original resource from the file’s resource fork. You should use the ChangedResource or SetResPurge function before calling LoadResource to ensure that changes made to purgeable resources are written to the resource fork.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void MacLoadResource (
   Handle theResource
);

/*Count1Resources

Returns the total number of resources of a given type in the current resource file.

short Count1Resources (
   ResType theType
);
Parameters
theType

A resource type.
Return Value

The total number of resources of the given type in the current resource file only.
Discussion

To check for errors, call the ResError function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

short Count1Resources (
   ResType theType
);

/*Unique1ID

Gets a resource ID that’s unique with respect to resources in the current resource file.

short Unique1ID (
   ResType theType
);
Parameters
theType

A resource type.
Return Value

A resource ID greater than 0 that isn’t currently assigned to any resource of the specified type in the current resource file.
Discussion

You should use this function before adding a new resource to ensure that you don’t duplicate a resource ID and override an existing resource. 

To check for errors, call the ResError function.

For more information about restrictions on resource IDs for specific resource types, see ResID.

In versions of system software earlier than System 7, this function may return a resource ID in the range 0 through 127, which is generally reserved for system resources. You should check that the resource ID returned is not in this range. If it is, call Unique1ID again, and continue doing so until you get a resource ID greater than 127.

In System 7 and later versions, this function won’t return a resource ID of less than 128. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short Unique1ID (
   ResType theType
);

/*UpdateResFile

Updates the resource map and resource data for a resource fork without closing it.

void UpdateResFile (
   short refNum
);
Parameters
refNum

A file reference number for a resource fork. If there’s no open resource fork with the given reference number, the function does nothing, and the ResError function returns the result code resNotFound. If the value of the refNum parameter is 0, it represents the System file’s resource fork. If you call this function but the mapReadOnly attribute of the resource fork is set, the function does nothing, and the ResError function returns the result code resAttrErr. 
Discussion

Given the reference number of a file whose resource fork is open, this function performs three tasks. The first task is to change, add, or remove resource data in the file’s resource fork to match the resource map in memory. Changed resource data for each resource is written only if that resource’s resChanged bit has been set by a successful call to the ChangedResource or AddResource function. The UpdateResFile function calls the WriteResource function to write changed or added resources to the resource fork.

The second task is to compact the resource fork, closing up any empty space created when a resource was removed, made smaller, or made larger. If a resource is made larger, the Resource Manager writes it at the end of the resource fork rather than at its original location. It then compacts the space occupied by the original resource data. The actual size of the resource fork is adjusted when a resource is removed or made larger, but not when a resource is made smaller.

The third task is to write the resource map in memory to the resource fork if your application has called the ChangedResource function for any resource listed in the resource map or if it has added or removed a resource. All changes to resource information in the resource map become permanent at this time; if you want any of these changes to be temporary, you must restore the original information before calling UpdateResFile.

Because the CloseResFile function calls UpdateResFile before it closes the resource fork, you need to call UpdateResFile directly only if you want to update the file without closing it.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void UpdateResFile (
   short refNum
);

/*SetResLoad

Enables and disables automatic loading of resource data into memory for functions that return handles to resources.

void SetResLoad (
   Boolean load
);
Parameters
load

Determines whether Resource Manager functions should read resource data into memory. If you set this parameter to TRUE, Resource Manager functions that return handles will, during subsequent calls, automatically read resource data into memory if it is not already in memory; if you set this parameter to FALSE, Resource Manager functions will not automatically read resource data into memory. Instead, such functions return a handle whose master pointer is set to NULL unless the resource is already in memory. In addition, when first opening a resource fork the Resource Manager won’t load into memory resources whose resPreload attribute is set. The default setting is TRUE.

If you call the function with this parameter set to FALSE, be sure to call SetResLoad with this parameter set to TRUE as soon as possible. Other parts of system software that call the Resource Manager expect this value to be TRUE, and some functions won’t work if resources are not loaded automatically.
Discussion

You can use the SetResLoad function when you want to read from the resource map without reading the resource data into memory. To read the resource data into memory after a call t this function, call the LoadResource function.

To check for errors, call the ResError function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void SetResLoad (
   Boolean load
);

/*ChangedResource

Sets a flag in the resource’s resource map entry in memory to show that you’ve made changes to a resource’s data or to an entry in a resource map. 

void ChangedResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource whose data you’ve changed. The function sets the resChanged attribute for that resource in the resource map in memory. If the resChanged attribute for a resource has been set and your application calls the UpdateResFile function or quits, the Resource Manager writes the resource data for that resource (and for all other resources whose resChanged attribute is set) and the entire resource map to the resource fork of the corresponding file on disk. If the resChanged attribute for a resource has been set and your application calls the WriteResource function, the Resource Manager writes only the resource data for that resource to disk.

If the given handle isn’t a handle to a resource, if the modified resource data can’t be written to the resource fork, or if the resProtected attribute is set for the modified resource, the function does nothing. To find out whether any of these errors occurred, call the ResError function.
Discussion

If you change information in the resource map with a call to the SetResInfo or SetResAttrs function and then call ChangedResource and UpdateResFile, the Resource Manager still writes both the resource map and the resource data to disk. If you want any of your changes to the resource map or resource data to be temporary, you must restore the original information before the Resource Manager updates the resource fork on disk.

After writing a resource to disk, the Resource Manager clears the resource’s resChanged attribute in the appropriate entry of the resource map in memory.

When your application calls this function, the Resource Manager attempts to reserve enough disk space to contain the changed resource. The function reserves space every time you call it, but the resource is not actually written until you call WriteResource or UpdateResFile. Thus, if you call ChangedResource several times before the resource is actually written, the function reserves much more space than is needed. If the resource is large, you may unexpectedly run out of disk space. When the resource is actually written, the file’s end-of-file (EOF) is set correctly, and the next call to ChangedResource will work as expected.

If the modified resource data can’t be written to the resource fork (for example, if there’s not enough room on disk), the resChanged attribute is not set to 1. If this is the case and you call UpdateResFile or WriteResource, the Resource Manager won’t know that the resource data has been changed. Thus, the function won’t write the modified resource data to the resource fork and won’t return an error. For this reason, always make sure that the ResError function returns the result code noErr after a call to ChangedResource.

If your application frequently changes the contents of resources (especially large resources), you should call WriteResource or UpdateResFile immediately after calling ChangedResource. 

If you need to make changes to a purgeable resource using functions that may cause the Memory Manager to purge the resource, you should make the resource temporarily not purgeable. To do so, use the Memory Manager functions HGetState, HNoPurge, and HSetState to make sure the resource data remains in memory while you change it and until the resource data is written to disk. (You can’t use the SetResAttrs function for this purpose, because the changes don’t take effect immediately.) First call HGetState and HNoPurge, then change the resource as necessary. To make a change to a resource permanent, use ChangedResource and UpdateResFile or WriteResource; then call HSetState when you’re finished. Or, instead of calling WriteResource to write the resource data immediately, you can call the SetResPurge function with the install parameter set to TRUE before making changes to purgeable resource data.

If your application doesn’t make its resources purgeable, or if the changes you are making to a purgeable resource don’t involve functions that may cause the resource to be purged, you don’t need to take these precautions 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

void ChangedResource (
   Handle theResource
);

/*HomeResFile

Gets the file reference number associated with a particular resource.

short HomeResFile (
   Handle theResource
);
Parameters
theResource

A handle to the resource for which you wish to get the associated file reference number.
Return Value

The file reference number for the resource fork containing the specified resource. If the given handle isn’t a handle to a resource, the function returns –1, and the ResError function returns the result code resNotFound. If HomeResFile returns 0, the resource is in the System file’s resource fork. If it returns 1, the resource is ROM-resident.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short HomeResFile (
   Handle theResource
);

/*Get1NamedResource

Gets a named resource in the current resource file.

Handle Get1NamedResource (
   ResType theType,
   ConstStr255Param name
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data.
name

A name that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds an entry for the resource in the current resource file’s resource map and the entry contains a valid handle, the function returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, Get1NamedResource attempts to read the resource into memory. If it can’t find the resource data, the function returns NULL, and the ResError function returns the result code resNotFound. The Get1NamedResource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code. 

If you call this function with a resource type that can’t be found in the resource map of the current resource file, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the current resource file’s resource map in memory for the specified resource. You can change the search order by calling the UseResFile function before Get1NamedResource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps for open resource forks, use the RGetResource function. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1NamedResource (
   ResType theType,
   ConstStr255Param name
);

/*HOpenResFile

Opens a file’s resource fork, when the FSpOpenResFile function is not available. 

short HOpenResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   SInt8 permission
);
Parameters
vRefNum

The volume reference number of the volume on which the file is located.
dirID

The directory ID of the directory where the file is located.
fileName

The name of the file whose resource fork is to be opened.
permission

A constant indicating the type of access with which to open the resource fork. For a description of the types of access you can request, see the section File Access Permission Constants in File Manager Reference.
Return Value

The file reference number for the file. You can use this file reference number to refer to the file in other Resource Manager functions. The function also makes this file the current resource file. If the file’s resource fork is already open, the function returns the file reference number but does not make that file the current resource file. If the function fails to open the specified file’s resource fork (because there’s no file with the specified name or because there are permission problems), it returns –1 as the file reference number. Use the ResError function to determine what kind of error occurred.

Versions of system software before System 7 do not allow you to use this function to open a second access path, with write access, to a resource fork. In this case, the function returns the reference number already assigned to the file.
Discussion

The Resource Manager reads the resource map from the resource fork of the specified file into memory. It also reads into memory every resource whose resPreload attribute is set.

You don’t have to call this function to open the System file’s resource fork or an application file’s resource fork. These files are opened automatically when the system and the application start up, respectively. To get the file reference number for your application, call the CurResFile function after the application starts up and before you open the resource forks for any other files.

The HOpenResFile function checks that the information in the resource map is internally consistent. If it isn’t, ResError returns the result code mapReadErr. It’s possible to create multiple, unique, read-only access paths to a resource fork using HOpenResFile; however, you should avoid doing so, to prevent inconsistencies between multiple copies of the resource map. See the discussion of this issue in relation to FSpOpenResFile. The HOpenResFile function works the same way. 

To open a resource fork just for block-level operations, such as copying files without reading the resource map into memory, use the File Manager function OpenRF.

If you want to open the resource fork for another application (or any resource fork other than your application’s that includes 'CODE' resources), you must bracket your calls to HOpenResFile with calls to the SetResLoad function with the load parameter set to FALSE and then to TRUE. You must also avoid making intersegment calls while the other application’s resource fork is open. The discussion of this issue in relation to FSpOpenResFile also applies to HOpenResFile. 
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/

short HOpenResFile (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   SInt8 permission
);



#ifdef __cplusplus
}
#endif

#endif