#ifndef MIXEDMODE_H
#define MIXEDMODE_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif


#include <HYS/CarbonCore/MixedMode.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*Procedure Information Size Constants

Specify the size (in bytes) of a value encoded in the procedure information for a routine.

enum {
   kNoByteCode = 0,
   kOneByteCode = 1,
   kTwoByteCode = 2,
   kFourByteCode = 3
};
Constants
kNoByteCode

The value occupies no bytes.

Available in Mac OS X v10.0 and later.
kOneByteCode

The value occupies 1 byte.

Available in Mac OS X v10.0 and later.
kTwoByteCode

The value occupies 2 bytes.

Available in Mac OS X v10.0 and later.
kFourByteCode

The value occupies 4 bytes.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used by the ProcInfoType to specify the size (in bytes) of a value encoded in a routine’s procedure information.*/

enum {
   kNoByteCode = 0,
   kOneByteCode = 1,
   kTwoByteCode = 2,
   kFourByteCode = 3
};


/*Calling Convention Constants

Specify a routine’s calling conventions.

typedef unsigned short CallingConventionType;
enum {
   kPascalStackBased = 0,
   kCStackBased = 1,
   kRegisterBased = 2,
   kD0DispatchedPascalStackBased = 8,
   kD1DispatchedPascalStackBased = 12,
   kD0DispatchedCStackBased = 9,
   kStackDispatchedPascalStackBased = 14,
   kThinkCStackBased = 5
};
Constants
kPascalStackBased

The routine follows normal Pascal calling conventions.

Available in Mac OS X v10.0 and later.
kCStackBased

The routine follows the C calling conventions employed by the MPW development environment.

Available in Mac OS X v10.0 and later.
kRegisterBased

The parameters are passed in registers.

Available in Mac OS X v10.0 and later.
kD0DispatchedPascalStackBased

The parameters are passed on the stack according to Pascal conventions, and the routine selector is passed in register D0.

Available in Mac OS X v10.0 and later.
kD1DispatchedPascalStackBased

The parameters are passed on the stack according to Pascal conventions, and the routine selector is passed in register D1.

Available in Mac OS X v10.0 and later.
kD0DispatchedCStackBased

The parameters are passed on the stack according to C conventions, and the routine selector is passed in register D0.

Available in Mac OS X v10.0 and later.
kStackDispatchedPascalStackBased

The routine selector and the parameters are passed on the stack.

Available in Mac OS X v10.0 and later.
kThinkCStackBased

The routine follows the C calling conventions employed by the THINK C software development environment. Arguments are passed on the stack from right to left, and a result is returned in register D0. All arguments occupy an even number of bytes on the stack. An argument having the size of a char is passed in the high-order byte. You should always provide function prototypes; failure to do so may cause THINK C to generate code that is incompatible with this parameter-passing convention.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used by the ProcInfoType type to specify a routine’s calling conventions.*/

typedef unsigned short CallingConventionType;
enum {
   kPascalStackBased = 0,
   kCStackBased = 1,
   kRegisterBased = 2,
   kD0DispatchedPascalStackBased = 8,
   kD1DispatchedPascalStackBased = 12,
   kD0DispatchedCStackBased = 9,
   kStackDispatchedPascalStackBased = 14,
   kThinkCStackBased = 5
};


/*ProcInfo Field Offset And Width Constants

Specify offsets to fields and the widths of the fields within a value.

enum {
   kCallingConventionWidth = 4,
   kCallingConventionPhase = 0,
   kCallingConventionMask = 0x0F,
   kResultSizeWidth = 2,
   kResultSizePhase = kCallingConventionWidth,
   kResultSizeMask = 0x30,
   kStackParameterWidth = 2,
   kStackParameterPhase = (kCallingConventionWidth + kResultSizeWidth),
   kStackParameterMask = 0xFFFFFFC0,
   kRegisterResultLocationWidth = 5,
   kRegisterResultLocationPhase = (kCallingConventionWidth + kResultSizeWidth),
   kRegisterParameterWidth = 5,
   kRegisterParameterPhase = (kCallingConventionWidth + kResultSizeWidth
+ kRegisterResultLocationWidth),
   kRegisterParameterMask = 0x7FFFF800,
   kRegisterParameterSizePhase = 0,
   kRegisterParameterSizeWidth = 2,
   kRegisterParameterWhichPhase = kRegisterParameterSizeWidth,
   kRegisterParameterWhichWidth = 3,
   kDispatchedSelectorSizeWidth = 2,
   kDispatchedSelectorSizePhase = (kCallingConventionWidth + kResultSizeWidth),
   kDispatchedParameterPhase = (kCallingConventionWidth + kResultSizeWidth
+ kDispatchedSelectorSizeWidth),
   kSpecialCaseSelectorWidth = 6,
   kSpecialCaseSelectorPhase = kCallingConventionWidth,
   kSpecialCaseSelectorMask = 0x03F0
};
Constants
kCallingConventionWidth

The number of bits in the procedure information that encode the calling convention information.

Available in Mac OS X v10.0 and later.
kCallingConventionPhase

The offset from the least significant bit in the procedure information to the calling convention information.

Available in Mac OS X v10.0 and later.
kCallingConventionMask

Available in Mac OS X v10.0 and later.
kResultSizeWidth

The number of bits in the procedure information that encode the function result size information.

Available in Mac OS X v10.0 and later.
kResultSizePhase

The offset from the least significant bit in the procedure information to the function result size information.

Available in Mac OS X v10.0 and later.
kResultSizeMask

A mask for the bits in the procedure information that encode the function result size information.

Available in Mac OS X v10.0 and later.
kStackParameterWidth

The number of bits in the procedure information that encode the size of a stack-based parameter.

Available in Mac OS X v10.0 and later.
kStackParameterPhase

The offset from the least significant bit in the procedure information to the stack parameter information.

Available in Mac OS X v10.0 and later.
kStackParameterMask

Available in Mac OS X v10.0 and later.
kRegisterResultLocationWidth

The number of bits in the procedure information that encode which register the result will be stored in.

Available in Mac OS X v10.0 and later.
kRegisterResultLocationPhase

The offset from the least significant bit in the procedure information to the result register information.

Available in Mac OS X v10.0 and later.
kRegisterParameterWidth

The number of bits in the procedure information that encode the information about a register-based parameter.

Available in Mac OS X v10.0 and later.
kRegisterParameterPhase

The offset from the least significant bit in the procedure information to the register parameter information.

Available in Mac OS X v10.0 and later.
kRegisterParameterMask

Available in Mac OS X v10.0 and later.
kRegisterParameterSizePhase

The offset from the beginning of a register parameter information field to the encoded size of the parameter.

Available in Mac OS X v10.0 and later.
kRegisterParameterSizeWidth

Available in Mac OS X v10.0 and later.
kRegisterParameterWhichPhase

The offset from the beginning of a register parameter information field to the encoded register.

Available in Mac OS X v10.0 and later.
kRegisterParameterWhichWidth

Available in Mac OS X v10.0 and later.
kDispatchedSelectorSizeWidth

The number of bits in the procedure information that encode the size of a routine-dispatching selector.

Available in Mac OS X v10.0 and later.
kDispatchedSelectorSizePhase

The offset from the least significant bit in the procedure information to the selector size information of a routine that is dispatched though a selector.

Available in Mac OS X v10.0 and later.
kDispatchedParameterPhase

The offset from the least significant bit in the procedure information to the parameter information of a routine that is dispatched though a selector.

Available in Mac OS X v10.0 and later.
kSpecialCaseSelectorWidth

Available in Mac OS X v10.0 and later.
kSpecialCaseSelectorPhase

Available in Mac OS X v10.0 and later.
kSpecialCaseSelectorMask

Available in Mac OS X v10.0 and later.
Discussion

The offsets to fields and the widths of the fields within a value of type ProcInfoType are defined by constants.*/

enum {
   kCallingConventionWidth = 4,
   kCallingConventionPhase = 0,
   kCallingConventionMask = 0x0F,
   kResultSizeWidth = 2,
   kResultSizePhase = kCallingConventionWidth,
   kResultSizeMask = 0x30,
   kStackParameterWidth = 2,
   kStackParameterPhase = (kCallingConventionWidth + kResultSizeWidth),
   kStackParameterMask = 0xFFFFFFC0,
   kRegisterResultLocationWidth = 5,
   kRegisterResultLocationPhase = (kCallingConventionWidth + kResultSizeWidth),
   kRegisterParameterWidth = 5,
   kRegisterParameterPhase = (kCallingConventionWidth + kResultSizeWidth
+ kRegisterResultLocationWidth),
   kRegisterParameterMask = 0x7FFFF800,
   kRegisterParameterSizePhase = 0,
   kRegisterParameterSizeWidth = 2,
   kRegisterParameterWhichPhase = kRegisterParameterSizeWidth,
   kRegisterParameterWhichWidth = 3,
   kDispatchedSelectorSizeWidth = 2,
   kDispatchedSelectorSizePhase = (kCallingConventionWidth + kResultSizeWidth),
   kDispatchedParameterPhase = (kCallingConventionWidth + kResultSizeWidth
+ kDispatchedSelectorSizeWidth),
   kSpecialCaseSelectorWidth = 6,
   kSpecialCaseSelectorPhase = kCallingConventionWidth,
   kSpecialCaseSelectorMask = 0x03F0
};


/*ProcInfoType

Defines a data type used to encode a routine’s procedure information.

typedef unsigned long ProcInfoType;
Discussion

The Mixed Mode Manager uses a long word of type ProcInfoType to encode a routine’s procedure information, which contains essential information about the calling conventions and other features of a routine. These values specify
the routine’s calling conventions 
the sizes and locations of the routine’s parameters, if any 
the size and location of the routine’s result, if any 

The Mixed Mode Manager provides a number of constants that you can use to specify the procedure information. See “Procedure Information Size Constants” , “ProcInfo Field Offset And Width Constants” , “Calling Convention Constants” , “Special Case Calling Convention Constants” , and “Register Constants”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long ProcInfoType;

#endif