#ifndef MACMEMORY_H
#define MACMEMORY_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif


#include <HYS/CarbonCore/MacMemory.h>



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*  NewPtrSysClear
There is no System in Mac OS X. Use the function NewPtrClear instead. Not available in CarbonLib. Not available in Mac OS X.*/
#define  NewPtrSysClear NewPtrClear

/*GrowZoneProcPtr

Deprecated.

typedef long (*GrowZoneProcPtr) (
   Size cbNeeded
);

If you name your function MyGrowZoneProc, you would declare it like this:

long MyGrowZoneProc (
   Size cbNeeded
);
Parameters
cbNeeded

The physical size, in bytes, of the needed block, including the block header. The grow-zone function should attempt to create a free block of at least this size. 
Return Value

The number of bytes of memory the function has freed. 
Discussion

User-defined function that creates free space in the heap.

Whenever the Memory Manager has exhausted all available means of creating space within your application heap—including purging, compacting, and (if possible) expanding the heap—it calls your application-defined grow-zone function. The grow-zone function can do whatever is necessary to create free space in the heap. Typically, a grow-zone function marks some unneeded blocks as purgeable or releases an emergency memory reserve maintained by your application.

The grow-zone function should return a nonzero value equal to the number of bytes of memory it has freed, or zero if it is unable to free any. When the function returns a nonzero value, the Memory Manager once again purges and compacts the heap zone and tries to reallocate memory. If there is still insufficient memory, the Memory Manager calls the grow-zone function again (but only if the function returned a nonzero value the previous time it was called). This mechanism allows your grow-zone function to release just a little bit of memory at a time. If the amount it releases at any time is not enough, the Memory Manager calls it again and gives it the opportunity to take more drastic measures.

The Memory Manager might designate a particular relocatable block in the heap as protected; your grow-zone function should not move or purge that block. You can determine which block, if any, the Memory Manager has protected by calling the GZSaveHnd function in your grow-zone function.

Remember that the Memory Manager calls a grow-zone function while attempting to allocate memory. As a result, your grow-zone function should not allocate memory itself or perform any other actions that might indirectly cause memory allocation (such as calling functions in unloaded code segments or displaying dialog boxes).

You install a grow-zone function by passing its address to the InitZone function when you create a new heap zone or by calling the SetGrowZone function at any other time.

Your grow-zone function might be called at a time when the system is attempting to allocate memory and the value in the A5 register is not correct. If your function accesses your application’s A5 world or makes any trap calls, you need to set up and later restore the A5 register by calling SetCurrentA5 and SetA5. See the chapter “Memory Management Utilities” in this book for a description of these two functions.

Because of the optimizations performed by some compilers, the actual work of the grow-zone function and the setting and restoring of the A5 register might have to be placed in separate functions.

See the chapter “Introduction to Memory Management” for a definition of a sample grow-zone function.*/

typedef long (*GrowZoneProcPtr) (
   Size cbNeeded
);


/*GrowZoneUPP

Deprecated.

typedef GrowZoneProcPtr GrowZoneUPP;
Discussion

For more information, see the description of the GrowZoneUPP () callback function.*/
typedef GrowZoneProcPtr GrowZoneUPP;

/*Data Types
typedef char SignedByte;               /arbitrary byte of memory/
typedef unsigned char Byte;            /unsigned, arbitrary byte/
typedef char Ptr;                     /pointer to nonrelocatable block/
typedef Ptr Handle;                   /handle to relocatable block/
typedef unsigned char Str255[256];     /Pascal string/
typedef unsigned char StringPtr;
typedef unsigned char StringHandle;
typedef long (ProcPtr)();             /procedure pointer/
typedef long Size;                     /size in bytes of block/
struct Zone {
   Ptr               bkLim;            /first usable byte after zone/
   Ptr               purgePtr;         /used internally/
   Ptr               hFstFree;         /first free master pointer/
   long              zcbFree;          /number of free bytes/
   GrowZoneProcPtr   gzProc;           /grow-zone function/
   short             moreMast;         /number of master ptrs to allocate/
   short             flags;            /used internally/
   short             cntRel;           /reserved/
   short             maxRel;           /reserved/
   short             cntNRel;          /reserved/
   short             maxNRel;          /reserved/
   short             cntEmpty;         /reserved/
   short             cntHandles;       /reserved/
   long              minCBFree;        /reserved/
   ProcPtr           purgeProc;        /purge-warning procedure/
   Ptr               sparePtr;         /used internally/
   Ptr               allocPtr;         /used internally/
   short             heapData;         /first usable byte in zone/
};
typedef struct Zone Zone;
typedef Zone THz;                     /zone pointer/
*/





typedef unsigned char *StringPtr;


typedef long Size;                     /*size in bytes of block*/
struct Zone {
   Ptr               bkLim;            /*first usable byte after zone*/
   Ptr               purgePtr;         /*used internally*/
   Ptr               hFstFree;         /*first free master pointer*/
   long              zcbFree;          /*number of free bytes*/
   GrowZoneProcPtr   gzProc;           /*grow-zone function*/
   short             moreMast;         /*number of master ptrs to allocate*/
   short             flags;            /*used internally*/
   short             cntRel;           /*reserved*/
   short             maxRel;           /*reserved*/
   short             cntNRel;          /*reserved*/
   short             maxNRel;          /*reserved*/
   short             cntEmpty;         /*reserved*/
   short             cntHandles;       /*reserved*/
   long              minCBFree;        /*reserved*/
   ProcPtr           purgeProc;        /*purge-warning procedure*/
   Ptr               sparePtr;         /*used internally*/
   Ptr               allocPtr;         /*used internally*/
   short             heapData;         /*first usable byte in zone*/
};
typedef struct Zone Zone;
typedef Zone *THz;                     /*zone pointer*/


//function

/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h
);

/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount
);

/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (
   Size byteCount
);

/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (
   Handle h
);

/*BlockMove

Copies a sequence of bytes from one location in memory to another.

void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr

The address of the first byte to copy. 
destPtr

The destination address.
byteCount

The number of bytes to copy. If the value of byteCount is 0, BlockMove does nothing. 
Discussion

The BlockMove function copies the specified number of bytes from the address designated by srcPtr to that designated by destPtr. It updates no pointers.

The BlockMove function works correctly even if the source and destination blocks overlap.

You can safely call BlockMove at interrupt time. Even though it moves memory, BlockMove does not move relocatable blocks, but simply copies bytes.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

The BlockMove function currently flushes the processor caches whenever it moves more than 12 bytes. This behavior can adversely affect your application’s performance. You might want to avoid calling BlockMove to move small amounts of data in memory if there is no possibility of moving stale data or instructions. For more information about stale data and instructions, see the discussion of the processor caches in the chapter “Memory Management Utilities” in Inside Macintosh: Memory. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMove function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);

/*BlockMoveData


void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr
destPtr
byteCount
Discussion

You should not make any assumptions about the state of the destination memory while BlockMoveData is executing. In the intermediate state, values may be present that are neither the original nor the final ones. For example, this function may use the 'dcbz' instruction. If the underlying memory is not cacheable, if the memory is write-through instead of copy-back, or if the cache block is flushed for some reason, the 'dcbz' instruction will write zeros to the destination. You can avoid the use of the 'dcbz' instruction by calling BlockMoveDataUncached, but even that function makes no other guarantees about the memory block's intermediate state. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMoveData function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);

/*MemError

Determines if an application’s last direct call to a Memory Manager function executed successfully.

OSErr MemError (void);
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

For each thread, MemError yields the result code produced by the last Memory Manager function your application called directly.

MemError is useful during application debugging. You might also use MemError as one part of a memory-management scheme to identify instances in which the Memory Manager rejects overly large memory requests by returning the error code memFullErr.

To view the result codes that MemError can produce, see “Memory Manager Result Codes”.

Do not rely on MemError as the only component of a memory-management scheme. For example, suppose you call NewHandle or NewPtr and receive the result code noErr, indicating that the Memory Manager was able to allocate sufficient memory. In this case, you have no guarantee that the allocation did not deplete your application’s memory reserves to levels so low that simple operations might cause your application to crash. Instead of relying on MemError, check before making a memory request that there is enough memory both to fulfill the request and to support essential operations. 
Version Notes

Starting with Mac OS X v10.3, the MemError function provides error codes on a per-thread basis.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr MemError (void);

/*NewHandleClear

Allocates a relocatable block of memory of a specified size with all its bytes set to 0.

Handle NewHandleClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the relocatable block. The NewHandleClear function sets each of these bytes to 0. 
Return Value

A handle to the new block. If NewHandleClear cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandleClear function works like the NewHandle function, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandleClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandleClear (
   Size byteCount
);

/*PtrToHand

Copies data referenced by a pointer to a new relocatable block.

OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);
Parameters
srcPtr

The address of the first byte to copy. 
dstHndl

A handle for which you have not yet allocated any memory. The PtrToHand function allocates memory for the handle and copies the specified number of bytes beginning at srcPtr into it. The dstHndl parameter is an output parameter that will hold the result. Its value on entry is ignored. If no error occurs, on exit it points to an unlocked, non-purgeable Handle of the requested size. 
size

The number of bytes to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

If you dereference and lock a handle, the PtrToHand function can copy its data to a new handle. However, for copying data from one handle to another, the HandToHand function is more efficient.

Because PtrToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);

/*PtrAndHand

Concatenates part or all of a memory block to the end of a relocatable block.

OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);
Parameters
ptr1

A pointer to the beginning of the data that the Memory Manager is to concatenate onto the end of the relocatable block. 
hand2

A handle to the relocatable block, whose size the Memory Manager expands so that it can concatenate the information from ptr1 onto the end of this block. 
size

The number of bytes of the block referenced by ptr1 to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The PtrAndHand function takes the number of bytes specified by the size parameter, beginning at the location specified by ptr1, and concatenates them onto the end of the relocatable block to which hand2 is a handle. The contents of the source block remain unchanged.

Because PtrAndHand allocates memory, you should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);

/*HLock

Prevents a relocatable block from moving within its heap zone.

void HLock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

If you plan to dereference a handle and then allocate, move, or purge memory (or call a function that does so), then you should lock the handle before using the dereferenced handle.

If the block is already locked, HLock does nothing.

If you plan to lock a relocatable block for long periods of time, you can prevent fragmentation by ensuring that the block is as low as possible in the heap zone. To do this, see the description of the ReserveMem function.

If you plan to lock a relocatable block for short periods of time, you can prevent heap fragmentation by moving the block to the top of the heap zone before locking. For more information, see the description of the MoveHHi function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void HLock (
   Handle h
);

/*DisposePtr

Releases memory occupied by a nonrelocatable block.

void DisposePtr (
   Ptr p
);
Parameters
p

A pointer to the nonrelocatable block you want to dispose of. 
Discussion

When you no longer need a nonrelocatable block, call the DisposePtr function to free it for other uses.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

After a call to DisposePtr, all pointers to the released block become invalid and should not be used again. Any subsequent use of a pointer to the released block might cause a system error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposePtr (
   Ptr p
);


/*NewPtrClear

Allocates a nonrelocatable block of memory of a specified size with all its bytes set to 0.

Ptr NewPtrClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the nonrelocatable block. 
Return Value

A pointer to the new block. If NewPtrClear fails to allocate a block of the requested size, it returns NULL. 
Discussion

The NewPtrClear function works much as the NewPtr function does, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewPtrClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Ptr NewPtrClear (
   Size byteCount
);

/*HUnlock

Allows a relocatable block to move in its heap zone.

void HUnlock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HUnlock function unlocks the relocatable block to which h is a handle, allowing the block to move within its heap zone. If the block is already unlocked, HUnlock does nothing.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HUnlock (
   Handle h
);

/*NewPtr

Allocates a nonrelocatable block of memory of a specified size.

Ptr NewPtr (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the nonrelocatable block. In Mac OS X, if you pass a value of zero, this function returns NULL, and MemError is set to paramErr. In Mac OS 9 and earlier, if you pass a value of zero, this function returns a valid zero length pointer. 
Return Value

A pointer to the new block. If NewPtr fails to allocate a block of the requested size, it returns NULL. 
Discussion

The NewPtr function attempts to reserve space as low in the heap zone as possible for the new block. If it is able to reserve the requested amount of space, NewPtr allocates the nonrelocatable block in the gap ReserveMem creates. Otherwise, NewPtr returns NULL and generates a memFullErr error.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewPtr allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Ptr NewPtr (
   Size byteCount
);

/*SetHandleSize

Changes the logical size of the relocatable block corresponding to the specified handle.

void SetHandleSize (
   Handle h,
   Size newSize
);
Parameters
h

A handle to a relocatable block. 
newSize

The desired new logical size, in bytes, of the relocatable block. 
Discussion

SetHandleSize might need to move the relocatable block to obtain enough space for the resized block. Thus, for best results you should unlock a block before resizing it.

An attempt to increase the size of a locked block might fail, because of blocks above and below it that are either nonrelocatable or locked. You should be prepared for this possibility.

Instead of using the SetHandleSize function to set the size of a handle to 0, you can use the EmptyHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because SetHandleSize allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void SetHandleSize (
   Handle h,
   Size newSize
);

/*GetPtrSize

Returns the logical size of the nonrelocatable block corresponding to a pointer.

Size GetPtrSize (
   Ptr p
);
Parameters
p

A pointer to a nonrelocatable block. 
Return Value

The logical size, in bytes, of the nonrelocatable block pointed to by p. In case of error, the function returns 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Size GetPtrSize (
   Ptr p
);

/*HGetState

Returns a signed byte representing the current properties of a relocatable block.

SInt8 HGetState (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

A signed byte (char) containing the flags of the master pointer for the given handle. In case of error, the value returned is meaningless. 
Discussion

The HGetState function returns a signed byte (char) containing the flags of the master pointer for the given handle. You can save this byte, change the state of any of the flags using the functions described in this section, and then restore their original states by passing the byte to the HSetState function.

You can use bit-manipulation functions on the returned signed byte to determine the value of a given attribute. Currently the following bits are used:

If an error occurs during an attempt to get the state flags of the specified relocatable block, HGetState returns the low-order byte of the result code as its function result. For example, if the handle h points to a master pointer whose value is NULL, then the signed byte returned by HGetState will contain the value –109.

You may also call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

SInt8 HGetState (
   Handle h
);

/*HSetState

Restores the properties of a relocatable block.

void HSetState (
   Handle h,
   SInt8 flags
);
Parameters
h

A handle to a relocatable block. 
flags

A signed byte (char) specifying the properties to which you want to set the relocatable block. 
Discussion

You can use HSetState to restore properties of a block after a call to HGetState. See the description of the HGetState function for a list of the currently used bits in the flags byte. Because additional bits of the flags byte could become significant in future versions of system software, use HSetState only with a byte returned by HGetState. If you need to set two or three properties of a relocatable block at once, it is better to use the functions that set individual properties than to manipulate the bits returned by HGetState and then call HSetState.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HSetState (
   Handle h,
   SInt8 flags
);

/*MoreMasters

Allocates a block of master pointers in the current heap zone. (Deprecated in Mac OS X v10.4. There is no replacement function; master pointers do not need to be pre-allocated in Mac OS X.)

void MoreMasters ();
Discussion

In the application heap, a block of master pointers consists of 64 master pointers, and in the system heap, a block consists of 32 master pointers. (These values are likely to increase in future versions of system software.) When you initialize additional heap zones, you can specify the number of master pointers you want to have in a block of master pointers.

The Memory Manager automatically calls the MoreMasters function once for every new heap zone, including the application heap zone.

Call MoreMasters several times at the beginning of your program to prevent the Memory Manager from running out of master pointers in the middle of application execution. If it does run out, it allocates more, possibly causing heap fragmentation.

You should call MoreMasters at the beginning of your program enough times to ensure that the Memory Manager never needs to call it for you. For example, if your application never allocates more than 300 relocatable blocks in its heap zone, then five calls to the MoreMasters should be enough. It’s better to call MoreMasters too many times than too few. For instance, if your application usually allocates about 100 relocatable blocks but might allocate 1000 in a particularly busy session, call MoreMasters enough times to accommodate the largest amount.

If you initialize a new zone, you can specify the number of master pointers that a master pointer block should contain.

Call the MemError function to get the result code. See “Memory Manager Result Codes”.

Because MoreMasters allocates memory, you should not call it at interrupt time.

The calls to MoreMasters at the beginning of your application should be in the main code segment of your application or in a segment that the main segment never unloads. 
Carbon Porting Notes

You should instead use MoreMasterPointers.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void MoreMasters ();

/*TempNewHandle

Allocates a new relocatable block of temporary memory.

Handle TempNewHandle (
   Size logicalSize,
   OSErr * resultCode
);
Parameters
logicalSize

The requested logical size, in bytes, of the new temporary block of memory. 
resultCode

On return, the result code from the function call. See “Memory Manager Result Codes”. 
Return Value

A handle to a block of size logicalSize. If it cannot allocate a block of that size, the function returns NULL. 
Discussion

Before calling TempNewHandle, you should call TempFreeMem or TempMaxMem to make sure that there is enough free space to satisfy the request.

Because TempNewHandle might allocate memory, you should not call it at interrupt time. 
Carbon Porting Notes

Temporary memory allocations will actually come from the applications’s address space in Mac OS X. However, Carbon applications running under Mac OS 8.x will be able to get true temporary memory.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle TempNewHandle (
   Size logicalSize,
   OSErr * resultCode
);

/*MoveHHi

Moves a relocatable block as high in memory as possible. (Deprecated in Mac OS X v10.4. There is no replacement function; there is no benefit to moving handles high in memory in Mac OS X.)

void MoveHHi (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

This function moves a relocatable block as high in memory as possible to help prevent heap fragmentation. The MoveHHi function attempts to move the relocatable block referenced by the handle h upward until it reaches a nonrelocatable block, a locked relocatable block, or the top of the heap.

If you plan to lock a relocatable block for a short period of time, use the MoveHHi function, which moves the block to the top of the heap and thus helps prevent heap fragmentation.

If you call MoveHHi to move a handle to a resource that has its resChanged bit set, the Resource Manager updates the resource by using the WriteResource function to write the contents of the block to disk. If you want to avoid this behavior, call the Resource Manager function SetResPurge(FALSE) before you call MoveHHi, and then call SetResPurge(TRUE) to restore the default setting.

By using the MoveHHi function on relocatable blocks you plan to allocate for short periods of time, you help prevent islands of immovable memory from accumulating in (and thus fragmenting) the heap.

Do not use the MoveHHi function to move blocks you plan to lock for long periods of time. The MoveHHi function moves such blocks to the top of the heap, perhaps preventing other blocks already at the top of the heap from moving down once they are unlocked. Instead, use the ReserveMem function before allocating such blocks, thus keeping them in the bottom partition of the heap, where they do not prevent relocatable blocks from moving.

If you frequently lock a block for short periods of time and find that calling MoveHHi each time slows down your application, you might consider leaving the block always locked and calling the ReserveMem function before allocating it.

Once you move a block to the top of the heap, be sure to lock it if you do not want the Memory Manager to move it back to the middle partition as soon as it can. (The MoveHHi function cannot move locked blocks; be sure to lock blocks after, not before, calling MoveHHi.)

Using the MoveHHi function without taking other precautionary measures to prevent heap fragmentation is useless, because even one small nonrelocatable or locked relocatable block in the middle of the heap might prevent MoveHHi from moving blocks to the top of the heap.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void MoveHHi (
   Handle h
);

/*HLockHi

Sets the lock bit on the block.

void HLockHi (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HLockHi function is an alternative to using the two functions MoveHHi (deprecated in Mac OS X) and HLock. Because the MoveHHi function does not move memory in Mac OS X, there is no benefit to using this function.

This function will not return a meaningful error code. If you call HLockHi on a locked handle, it will return noErr (not memLockedErr) because it is not an error to call HLock on a locked handle. 

Do not call HLockHi on blocks in the system heap. Do not call HLockHi from a desk accessory. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void HLockHi (
   Handle h
);

/*SetPtrSize

Changes the logical size of the nonrelocatable block corresponding to a pointer.

void SetPtrSize (
   Ptr p,
   Size newSize
);
Parameters
p

A pointer to a nonrelocatable block. 
newSize

The desired new logical size, in bytes, of the nonrelocatable block. 
Discussion

An attempt to increase the size of a nonrelocatable block might fail because of a block above it that is either nonrelocatable or locked. You should be prepared for this possibility.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because SetPtrSize allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void SetPtrSize (
   Ptr p,
   Size newSize
);

/*GZSaveHnd

Returns a relocatable block to be protected during grow-zone operations. (Deprecated in Mac OS X v10.4. There is no replacement; this function does nothing in Mac OS X.)

Handle GZSaveHnd ();
Return Value

A handle to a block of memory that the Memory Manager reserves during grow-zone operations. Your grow-zone function must not move, purge, or delete this block. This function returns NULL if there is no such block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
Handle GZSaveHnd ();

/*EmptyHandle

Purges a relocatable block and sets the corresponding handle’s master pointer to NULL.

void EmptyHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The EmptyHandle function purges the relocatable block whose handle is h and sets the handle’s master pointer to NULL. The EmptyHandle function allows you to free memory taken by a relocatable block without freeing the relocatable block’s master pointer for other uses. The block whose handle is h must be unlocked but need not be purgeable.

Note that if there are multiple handles to the relocatable block, then calling the EmptyHandle function empties them all, because all of the handles share a common master pointer. When you later use ReallocateHandle to reallocate space for the block, the master pointer is updated, and all of the handles reference the new block correctly.

To purge all of the blocks in a heap zone that are marked purgeable, use the PurgeMem function.

To free the memory taken up by a relocatable block and release the block’s master pointer for other uses, use the DisposeHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void EmptyHandle (
   Handle h
);

/*DisposeGrowZoneUPP

(Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

void DisposeGrowZoneUPP (
   GrowZoneUPP userUPP
);
Parameters
userUPP
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void DisposeGrowZoneUPP (
   GrowZoneUPP userUPP
);

/*HandToHand

Copies all of the data from one relocatable block to a new relocatable block.

OSErr HandToHand (
   Handle * theHndl
);
Parameters
theHndl

A handle to the relocatable block whose data HandToHand will copy. On return, theHndl contains a handle to a new relocatable block whose data duplicates the original. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The HandToHand function attempts to copy the information in the relocatable block to which theHndl is a handle; if successful, HandToHand sets theHndl to a handle pointing to the new relocatable block.

If successful in creating a new relocatable block, the HandToHand function does not duplicate the properties of the original block. The new block is unlocked, unpurgeable, and not a resource. Call HLock, HPurge, or HSetRBit (or the combination of HGetState and HSetState) to adjust the properties of the new block.

To copy only part of a relocatable block into a new relocatable block, use the PtrToHand function. Before calling PtrToHand, lock and dereference the handle pointing to the relocatable block you want to copy.

Because HandToHand replaces its parameter with the new handle, you should retain the original parameter value somewhere else, otherwise you will not be able to access it. Here is an example:Handle original, copy;
OSErr myErr;
...
copy = original;
        /both handles access same block*
myErr = HandToHand(copy);
        /copy now points to copy of block*


Because HandToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr HandToHand (
   Handle * theHndl
);

/*HPurge

Marks a relocatable block as purgeable. (Deprecated in Mac OS X v10.4. There is no replacement function; heaps are never purged in Mac OS X.)

void HPurge (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HPurge function marks the relocatable block, to which h is a handle, as purgeable. If the block is already purgeable, HPurge does nothing.

The Memory Manager might purge the block when it needs to purge the heap zone containing the block to satisfy a memory request. A direct call to the MaxMem function would also purge blocks marked as purgeable.

Once you mark a relocatable block as purgeable, you should make sure that handles to the block are not empty before you access the block. If they are empty, you must reallocate space for the block and recopy the block’s data from another source, such as a resource file, before using the information in the block.

If the block to which h is a handle is locked, HPurge does not unlock the block but does mark it as purgeable. If you later call HUnlock on h, the block is subject to purging.

If the Memory Manager has purged a block, you can reallocate space for it by using the ReallocateHandle function.

You can immediately free the space taken by a handle without disposing of it by calling the function EmptyHandle. This function does not require that the block be purgeable.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
void HPurge (
   Handle h
);

/*HNoPurge

Marks a relocatable block as unpurgeable. (Deprecated in Mac OS X v10.4. There is no replacement function; heaps are never purged in Mac OS X.)

void HNoPurge (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The HNoPurge function marks the relocatable block, to which h is a handle, as unpurgeable. If the block is already unpurgeable, HNoPurge does nothing.

The HNoPurge function does not reallocate memory for a handle if it has already been purged.

If you want to reallocate memory for a relocatable block that has already been purged, you can use the ReallocateHandle function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void HNoPurge (
   Handle h
);

/*NewGrowZoneUPP

(Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

GrowZoneUPP NewGrowZoneUPP (
   GrowZoneProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the GrowZoneUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

GrowZoneUPP NewGrowZoneUPP (
   GrowZoneProcPtr userRoutine
);

/*SetGrowZone

Specifies the current heap zone’s grow-zone function. (Deprecated in Mac OS X v10.4. There is no replacement function; heaps never grow in Mac OS X, so the grow-zone function is never called.)

void SetGrowZone (
   GrowZoneUPP growZone
);
Parameters
growZone

A pointer to the grow-zone function. A NULL value removes any previous grow-zone function from the zone. 
Discussion

To specify a grow-zone function for the current heap zone, pass a pointer to that function to the SetGrowZone function. Usually you call this function early in the execution of your application.

If you initialize your own heap zones besides the application and system zones, you can alternatively specify a grow-zone function as a parameter to the InitZone function.

The Memory Manager calls the grow-zone function only after exhausting all other avenues of satisfying a memory request, including compacting the zone, increasing its size (if it is the original application zone and is not yet at its maximum size), and purging blocks from it.

See “Grow-Zone Operations” for a complete description of a grow-zone function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/

void SetGrowZone (
   GrowZoneUPP growZone
);

/*ReallocateHandle

Allocates a new relocatable block of a specified size and sets a handle’s master pointer to point to the new block.

void ReallocateHandle (
   Handle h,
   Size byteCount
);
Parameters
h

A handle to a relocatable block. 
byteCount

The desired new logical size (in bytes) of the relocatable block. The new block is unlocked and unpurgeable. 
Discussion

Usually you use ReallocateHandle to reallocate space for a block that you have emptied or the Memory Manager has purged. If the handle references an existing block, ReallocateHandle releases that block before creating a new one.

If many handles reference a single purged, relocatable block, you need to call ReallocateHandle on just one of them.

To reallocate space for a resource that has been purged, you should call LoadResource, not ReallocateHandle. To resize relocatable blocks, you should call the SetHandleSize function.

Currently in Mac OS 8 and 9, the ReallocateHandle function releases any existing relocatable block referenced by the handle h before allocating a new one. This behavior means that if an error occurs when calling ReallocateHandle, the handle h will be set to NULL. This behavior does not occur in the Mac OS X implementation. 

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because ReallocateHandle might purge and allocate memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

void ReallocateHandle (
   Handle h,
   Size byteCount
);

/*Accessing Heap Zones
pascal THz GetZone		(void);
pascal void SetZone		(THz hz);
#define ApplicationZone() 	(* (THz*) 0x02AA)
#define SystemZone() 		(* (THz*) 0x02A6)
pascal THz HandleZone		(Handle h);
pascal THz PtrZone		(Ptr p);*/
pascal THz GetZone		(void);
pascal void SetZone		(THz hz);
#define ApplicationZone() 	(* (THz*) 0x02AA)
#define SystemZone() 		(* (THz*) 0x02A6)
pascal THz HandleZone		(Handle h);
pascal THz PtrZone		(Ptr p);


/*Allocating and Releasing Relocatable Blocks of Memory
pascal Handle NewHandle		(Size byteCount);
pascal Handle NewHandleSys	(Size byteCount);
pascal Handle NewHandleClear	(Size byteCount);
pascal Handle NewHandleSysClear
   				(Size byteCount);
pascal Handle NewEmptyHandle	(void);
pascal Handle NewEmptyHandleSys
   				(void);
pascal void DisposeHandle	(Handle h);*/

pascal Handle NewHandleSys	(Size byteCount);
pascal Handle NewEmptyHandleSys		(void);

/*MaxMem

Returns the size, in bytes, of the largest contiguous free block in the current heap zone. (Deprecated. There is no replacement function; you can assume that any reasonable memory allocation will succeed.)

Size MaxMem (
   Size * grow
);
Parameters
grow

On return, the maximum number of bytes by which the current heap zone can grow. After a call to MaxApplZone, MaxMem always sets this parameter to 0. 
Return Value

The size, in bytes, of the largest contiguous free block in the zone after the compacting and purging.
Discussion

In Mac OS 8 and 9, the MaxMem function compacts the current heap zone and purges all relocatable, unlocked, and purgeable blocks from the zone. If the current zone is the original application zone, the grow parameter is set to the maximum number of bytes by which the zone can grow. For any other heap zone, grow is set to 0. MaxMem does not actually expand the zone or call the zone’s grow-zone function.

In Mac OS X, the MaxMem function returns a large fixed value because applications run in a large, protected memory space.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/

Size MaxMem (
   Size * grow
);

/*Manipulating Memory Addresses
pascal Ptr StripAddress		(Ptr address);
pascal Ptr Translate24To32	(Ptr addr24);*/
pascal Ptr StripAddress		(Ptr address);

/*Allocating and Releasing Nonrelocatable Blocks of Memory
pascal Ptr NewPtr		(Size byteCount);
pascal Ptr NewPtrSys		(Size byteCount);
pascal Ptr NewPtrClear		(Size byteCount);
pascal Ptr NewPtrSysClear	(Size byteCount);
pascal void DisposePtr		(Ptr p);*/
pascal Ptr NewPtrSys		(Size byteCount);

/*FreeMem

Returns the total amount of free space in the current heap zone. (Deprecated. There is no replacement function; you can assume that any reasonable memory allocation will succeed.)

long FreeMem ();
Return Value

Returns a fixed value for heap size that is compatible with most applications.
Discussion

In Mac OS 8 and 9, this function returns the total amount of free space in the current heap zone. In Mac OS X, this function always returns a large fixed value because applications run in a large, protected memory space.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Special Considerations

Even though FreeMem does not move or purge memory, you should not call it at interrupt time because the heap might be in an inconsistent state.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
long FreeMem ();

/*MaxBlock

Returns a fixed value for block size that is compatible with most applications. (Deprecated. There is no replacement function; you can assume that any reasonable memory allocation will succeed.)

long MaxBlock ();
Return Value

The maximum contiguous space, in bytes, that you could obtain after compacting the current heap zone. MaxBlock does not actually do the compaction. 
Discussion

In Mac OS X, this function always returns a large value because virtual memory is always available to fulfill any request for memory.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
long MaxBlock ();

/*LMGetApplZone

(Deprecated in Mac OS X v10.4. There is no replacement; this function was included to facilitate porting legacy applications to Carbon, but it serves no useful purpose in Mac OS X.)

THz LMGetApplZone (void);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacMemory.h*/
THz LMGetApplZone (void);

#ifdef __cplusplus
}
#endif

#endif